/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift.internal;

public class FPSCounter {
    long thisFrameTime;
    long frameTime;
    long frameStart;
    long lastLoop;
    long time;
    double smoothing = 1.0;
    public double fps;
    public long duration;
    public double[] fpsHistory;
    public long[] durationHistory;

    public FPSCounter(int historySize) {
        this.fpsHistory = new double[historySize];
        this.durationHistory = new long[historySize];
    }

    private long getTime() {
        return System.currentTimeMillis();
    }

    public void tickStart() {
        this.frameStart = this.getTime();
    }

    public void tick() {
        this.time = this.getTime();
        this.thisFrameTime = this.time - this.lastLoop;
        this.frameTime = (long)((double)this.frameTime + (double)(this.thisFrameTime - this.frameTime) / this.smoothing);
        this.fps = this.frameTime == 0L ? 0.0 : (double)(1000L / this.frameTime);
        this.duration = this.frameStart < this.lastLoop ? this.frameTime : this.time - this.frameStart;
        this.lastLoop = this.time;
    }

    public void historyTick() {
        for (int i = this.fpsHistory.length - 1; i >= 0; --i) {
            this.fpsHistory[i] = i == 0 ? this.fps : this.fpsHistory[i - 1];
            this.durationHistory[i] = i == 0 ? this.duration : this.durationHistory[i - 1];
        }
    }
}

