/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift.internal.backend;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.eclipse.fx.drift.SwapchainConfig;
import org.eclipse.fx.drift.internal.backend.Backend;
import org.eclipse.fx.drift.internal.backend.BackendSwapchain;
import org.eclipse.fx.drift.internal.backend.SimpleSwapchain;
import org.eclipse.fx.drift.internal.transport.Command;
import org.eclipse.fx.drift.internal.transport.command.CreateSwapchainCommand;
import org.eclipse.fx.drift.internal.transport.command.ReleaseCommand;

public class BackendImpl
implements Backend {
    private Map<UUID, BackendSwapchain> swapChains = new HashMap<UUID, BackendSwapchain>();
    private BackendSwapchain swapChain;
    private Consumer<Command> commandChannel;

    @Override
    public BackendSwapchain createSwapchain(SwapchainConfig config) {
        UUID id = UUID.randomUUID();
        this.swapChain = new SimpleSwapchain(this, id, config);
        this.swapChain.allocate();
        this.swapChains.put(id, this.swapChain);
        this.sendCommand(new CreateSwapchainCommand(id, this.swapChain.getImages(), config.presentationMode));
        return this.swapChain;
    }

    @Override
    public void setCommandChannel(Consumer<Command> commandChannel) {
        this.commandChannel = commandChannel;
    }

    @Override
    public void receiveCommand(Command command) {
        if (command instanceof ReleaseCommand) {
            ReleaseCommand cmd = (ReleaseCommand)command;
            this.swapChains.get(cmd.getSwapChainId()).release(cmd.getImageData());
        }
    }

    @Override
    public void sendCommand(Command command) {
        this.commandChannel.accept(command);
    }
}

