/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift.impl;

import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.prism.Graphics;
import com.sun.prism.Texture;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Paint;
import java.util.Optional;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.util.Duration;
import org.eclipse.fx.drift.BaseDriftFXSurface;
import org.eclipse.fx.drift.impl.DriftDebug;
import org.eclipse.fx.drift.impl.NGRenderUtil;
import org.eclipse.fx.drift.internal.FPSCounter;
import org.eclipse.fx.drift.internal.Log;
import org.eclipse.fx.drift.internal.Placement;
import org.eclipse.fx.drift.internal.SurfaceData;
import org.eclipse.fx.drift.internal.frontend.FrontSwapChain;
import org.eclipse.fx.drift.internal.frontend.FxImage;
import org.eclipse.fx.drift.internal.frontend.SimpleFrontSwapChain;

public class NGDriftFXSurface
extends NGNode {
    private static final boolean showFPS = Boolean.getBoolean("driftfx.showfps");
    private static final boolean profile = Boolean.getBoolean("driftfx.profile");
    private SurfaceData surfaceData;
    private FrontSwapChain nextSwapChain;
    private FrontSwapChain swapChain;
    private BaseDriftFXSurface node;
    private FxImage<?> curImage;
    private FPSCounter fxFpsCounter = new FPSCounter(100);

    public void setSwapChain(FrontSwapChain swapChain) {
        this.nextSwapChain = swapChain;
    }

    public NGDriftFXSurface(BaseDriftFXSurface node) {
        this.node = node;
        Timeline historyTick = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)100.0), (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                NGDriftFXSurface.this.fxFpsCounter.historyTick();
                if (NGDriftFXSurface.this.swapChain != null) {
                    ((SimpleFrontSwapChain)((NGDriftFXSurface)NGDriftFXSurface.this).swapChain).fpsCounter.historyTick();
                }
            }
        }, new KeyValue[0])});
        historyTick.setCycleCount(-1);
        historyTick.play();
    }

    public void destroy() {
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }

    private float center(float dst, float src) {
        return (dst - src) / 2.0f;
    }

    private float end(float dst, float src) {
        return dst - src;
    }

    private Pos computeCover(float dstWidth, float dstHeight, float srcWidth, float srcHeight) {
        float height;
        float width;
        float dstRatio = dstWidth / dstHeight;
        float srcRatio = srcWidth / srcHeight;
        if (dstRatio > srcRatio) {
            width = dstWidth;
            height = width / srcRatio;
        } else {
            height = dstHeight;
            width = height * srcRatio;
        }
        return new Pos(this.center(dstWidth, width), width, this.center(dstHeight, height), height);
    }

    private Pos computeContain(float dstWidth, float dstHeight, float srcWidth, float srcHeight) {
        float width;
        float height;
        float srcRatio = srcWidth / srcHeight;
        float dstRatio = dstWidth / dstHeight;
        if (srcRatio <= dstRatio) {
            height = dstHeight;
            width = height * srcRatio;
        } else {
            width = dstWidth;
            height = width / srcRatio;
        }
        return new Pos(this.center(dstWidth, width), width, this.center(dstHeight, height), height);
    }

    private Pos computeCenter(float dstWidth, float dstHeight, float srcWidth, float srcHeight) {
        return new Pos(this.center(dstWidth, srcWidth), srcWidth, this.center(dstHeight, srcHeight), srcHeight);
    }

    private Pos computeTopLeft(float dstWidth, float dstHeight, float srcWidth, float srcHeight) {
        return new Pos(0.0f, srcWidth, 0.0f, srcHeight);
    }

    private Pos computeTopCenter(float dstWidth, float dstHeight, float srcWidth, float srcHeight) {
        return new Pos(this.center(dstWidth, srcWidth), srcWidth, 0.0f, srcHeight);
    }

    private Pos computeTopRight(float dstWidth, float dstHeight, float srcWidth, float srcHeight) {
        return new Pos(this.end(dstWidth, srcWidth), srcWidth, 0.0f, srcHeight);
    }

    private Pos computeCenterLeft(float dstWidth, float dstHeight, float srcWidth, float srcHeight) {
        return new Pos(0.0f, srcWidth, this.center(dstHeight, srcHeight), srcHeight);
    }

    private Pos computeCenterRight(float dstWidth, float dstHeight, float srcWidth, float srcHeight) {
        return new Pos(this.end(dstWidth, srcWidth), srcWidth, this.center(dstHeight, srcHeight), srcHeight);
    }

    private Pos computeBottomLeft(float dstWidth, float dstHeight, float srcWidth, float srcHeight) {
        return new Pos(0.0f, srcWidth, this.end(dstHeight, srcHeight), srcHeight);
    }

    private Pos computeBottomCenter(float dstWidth, float dstHeight, float srcWidth, float srcHeight) {
        return new Pos(this.center(dstWidth, srcWidth), srcWidth, this.end(dstHeight, srcHeight), srcHeight);
    }

    private Pos computeBottomRight(float dstWidth, float dstHeight, float srcWidth, float srcHeight) {
        return new Pos(this.end(dstWidth, srcWidth), srcWidth, this.end(dstHeight, srcHeight), srcHeight);
    }

    private Pos computePlacement(Placement placement, float dstWidth, float dstHeight, float srcWidth, float srcHeight) {
        switch (placement) {
            case COVER: {
                return this.computeCover(dstWidth, dstHeight, srcWidth, srcHeight);
            }
            case CONTAIN: {
                return this.computeContain(dstWidth, dstHeight, srcWidth, srcHeight);
            }
            case TOP_LEFT: {
                return this.computeTopLeft(dstWidth, dstHeight, srcWidth, srcHeight);
            }
            case TOP_CENTER: {
                return this.computeTopCenter(dstWidth, dstHeight, srcWidth, srcHeight);
            }
            case TOP_RIGHT: {
                return this.computeTopRight(dstWidth, dstHeight, srcWidth, srcHeight);
            }
            case CENTER_LEFT: {
                return this.computeCenterLeft(dstWidth, dstHeight, srcWidth, srcHeight);
            }
            case CENTER_RIGHT: {
                return this.computeCenterRight(dstWidth, dstHeight, srcWidth, srcHeight);
            }
            case BOTTOM_LEFT: {
                return this.computeBottomLeft(dstWidth, dstHeight, srcWidth, srcHeight);
            }
            case BOTTOM_CENTER: {
                return this.computeBottomCenter(dstWidth, dstHeight, srcWidth, srcHeight);
            }
            case BOTTOM_RIGHT: {
                return this.computeBottomRight(dstWidth, dstHeight, srcWidth, srcHeight);
            }
        }
        return this.computeCenter(dstWidth, dstHeight, srcWidth, srcHeight);
    }

    private Placement toPlacement(int placement) {
        if (placement < 0 || placement >= Placement.values().length) {
            return Placement.CENTER;
        }
        return Placement.values()[placement];
    }

    private void drawStats(Graphics g) {
        DriftDebug.assertQuantumRenderer();
        if (this.swapChain != null) {
            g.setPaint((Paint)new Color(0.0f, 0.0f, 0.0f, 0.5f));
            g.fillRect(155.0f, 0.0f, 150.0f, 85.0f);
            String info = "Texture: " + this.swapChain.getSize().x + "x" + this.swapChain.getSize().y;
            info = info + "\nTransfer: " + this.swapChain.getTransferType().id;
            NGRenderUtil.writeText(g, -155.0f, 0.0f, 12, info, Color.WHITE, false);
        }
        NGRenderUtil.drawFPSGraph(g, 0.0f, 0.0f, 150.0f, 40.0f, "JavaFX", this.fxFpsCounter);
        if (this.swapChain != null) {
            FPSCounter c = ((SimpleFrontSwapChain)this.swapChain).fpsCounter;
            NGRenderUtil.drawFPSGraph(g, 0.0f, 45.0f, 150.0f, 40.0f, "Renderer", c);
        }
    }

    private void drawTexture(Graphics g, Texture t) {
        float frameContainerWidth = this.surfaceData.width;
        float frameContainerHeight = this.surfaceData.height;
        Placement placement = Placement.CENTER;
        float textureRatio = (float)t.getContentWidth() / (float)t.getContentHeight();
        float frameRatio = this.surfaceData.width / this.surfaceData.height;
        Pos framePos = new Pos(0.0f, frameContainerWidth, 0.0f, frameContainerHeight);
        if (Math.abs(textureRatio - frameRatio) > 0.001f) {
            framePos = this.computeContain(frameContainerWidth, frameContainerHeight, t.getContentWidth(), t.getContentHeight());
        }
        int frameTextureWidth = t.getContentWidth();
        int frameTextureHeight = t.getContentHeight();
        float currentContainerWidth = this.surfaceData.width;
        float currentContainerHeight = this.surfaceData.height;
        Pos pos = this.computePlacement(placement, currentContainerWidth, currentContainerHeight, framePos.width, framePos.height);
        g.scale(1.0f, -1.0f);
        g.translate(0.0f, -currentContainerHeight);
        pos.y = currentContainerHeight - pos.y - pos.height;
        g.drawTexture(t, pos.x, pos.y, pos.x + pos.width, pos.y + pos.height, 0.0f, 0.0f, (float)frameTextureWidth, (float)frameTextureHeight);
    }

    protected void renderContent(Graphics g) {
        DriftDebug.assertQuantumRenderer();
        this.fxFpsCounter.tickStart();
        if (this.nextSwapChain != null) {
            try {
                if (this.swapChain != null) {
                    if (this.curImage != null) {
                        this.swapChain.release(this.curImage);
                        this.curImage = null;
                    }
                    this.swapChain.release();
                }
                this.nextSwapChain.allocate(g.getResourceFactory());
                this.swapChain = this.nextSwapChain;
                this.nextSwapChain = null;
            }
            catch (Exception e) {
                Log.error("ERROR during swapchain recreation");
            }
        }
        if (this.swapChain != null && this.swapChain.isDisposeScheduled()) {
            Optional<FxImage<?>> next;
            if (this.curImage != null) {
                this.swapChain.release(this.curImage);
                this.curImage = null;
            }
            if ((next = this.swapChain.getNext()).isPresent()) {
                this.swapChain.release(next.get());
            }
            this.swapChain.release();
            this.swapChain = null;
        }
        BaseTransform saved = g.getTransformNoClone().copy();
        if (this.swapChain != null) {
            Optional<FxImage<?>> nextImage = this.swapChain.getNext();
            if (nextImage.isPresent()) {
                if (this.curImage != null) {
                    this.swapChain.release(this.curImage);
                }
                this.curImage = nextImage.get();
                this.curImage.update();
            }
            if (this.curImage != null) {
                this.drawTexture(g, this.curImage.getTexture());
            }
        }
        g.setTransform(saved);
        this.fxFpsCounter.tick();
        if (showFPS) {
            this.drawStats(g);
        }
    }

    public void updateSurface(SurfaceData surfaceData) {
        Log.debug("[J] NativeSurface updateSurface(" + surfaceData + ")");
        if (this.isValid(surfaceData)) {
            this.surfaceData = surfaceData;
        }
    }

    private boolean isValid(SurfaceData data) {
        return true;
    }

    protected boolean hasOverlappingContents() {
        return false;
    }

    static class Pos {
        float x;
        float width;
        float y;
        float height;

        Pos(float x, float width, float y, float height) {
            this.x = x;
            this.width = width;
            this.y = y;
            this.height = height;
        }
    }
}

