/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift.internal;

import java.util.Optional;
import java.util.function.Function;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.stage.Screen;
import javafx.stage.Window;
import org.eclipse.fx.drift.internal.DriftUtil;

public class ScreenObserver {
    private final ReadOnlyObjectWrapper<Screen> currentScreen = new ReadOnlyObjectWrapper();
    private final ReadOnlyDoubleWrapper currentRenderScale = new ReadOnlyDoubleWrapper(1.0);

    public ReadOnlyObjectProperty<Screen> currentScreenProperty() {
        return this.currentScreen.getReadOnlyProperty();
    }

    public Screen getCurrentScreen() {
        return (Screen)this.currentScreenProperty().get();
    }

    public final ReadOnlyDoubleProperty currentRenderScaleProperty() {
        return this.currentRenderScale.getReadOnlyProperty();
    }

    public double getCurrentRenderScale() {
        return this.currentRenderScaleProperty().get();
    }

    private static <T, V> ObjectBinding<V> flatMap(final ObservableValue<T> obs, final Function<T, ObservableValue<V>> map) {
        return new ObjectBinding<V>(){
            private T oldCurrent;
            private V oldValue;
            {
                this.bind(new Observable[]{obs});
            }

            protected V computeValue() {
                Object current = obs.getValue();
                if (this.oldCurrent != current) {
                    if (this.oldCurrent != null) {
                        this.unbind(new Observable[]{(Observable)map.apply(this.oldCurrent)});
                        this.oldCurrent = null;
                    }
                    if (current != null) {
                        this.bind(new Observable[]{(Observable)map.apply(current)});
                        this.oldCurrent = current;
                    }
                }
                if (current != null) {
                    return ((ObservableValue)map.apply(current)).getValue();
                }
                return null;
            }
        };
    }

    public ScreenObserver(Node node) {
        ObjectBinding bWindow = ScreenObserver.flatMap(node.sceneProperty(), Scene::windowProperty);
        ObjectBinding windowX = ScreenObserver.flatMap(bWindow, Window::xProperty);
        ObjectBinding windowY = ScreenObserver.flatMap(bWindow, Window::yProperty);
        this.currentScreen.bind((ObservableValue)Bindings.createObjectBinding(() -> {
            Point2D screenPoint = node.localToScreen(0.0, 0.0);
            Optional<Screen> currentScreen = Screen.getScreens().stream().filter(s -> s.getBounds().contains(screenPoint)).findFirst();
            return currentScreen.orElse(Screen.getPrimary());
        }, (Observable[])new Observable[]{windowX, windowY, node.boundsInParentProperty(), node.boundsInLocalProperty(), node.layoutBoundsProperty(), node.sceneProperty(), Screen.getScreens()}));
        this.currentRenderScale.bind((ObservableValue)Bindings.createDoubleBinding(() -> DriftUtil.getRenderScale(this.getCurrentScreen()), (Observable[])new Observable[]{this.currentScreen}));
    }
}

