/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.imagebrowser.repositories;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.views.imagebrowser.IImageTarget;
import org.eclipse.pde.internal.ui.views.imagebrowser.ImageElement;
import org.eclipse.pde.internal.ui.views.imagebrowser.repositories.AbstractRepository;

public class WorkspaceRepository
extends AbstractRepository {
    private List<IProject> fProjects = null;

    public WorkspaceRepository(IImageTarget target) {
        super(target);
    }

    @Override
    protected boolean populateCache(IProgressMonitor monitor) {
        if (this.fProjects == null) {
            this.initialize(monitor);
        }
        if (!this.fProjects.isEmpty()) {
            IProject project = this.fProjects.remove(0);
            IFile manifest = project.getFile("META-INF/MANIFEST.MF");
            if (manifest.exists()) {
                try {
                    Optional<String> name = this.getPluginName(manifest.getContents());
                    if (!name.isPresent()) {
                        return !this.fProjects.isEmpty();
                    }
                    String pluginName = name.get();
                    project.accept(proxy -> {
                        switch (proxy.getType()) {
                            case 2: 
                            case 4: {
                                return true;
                            }
                            case 1: {
                                if (!this.isImageName(proxy.getName())) break;
                                try {
                                    IFile resource = (IFile)proxy.requestResource();
                                    this.addImageElement(new ImageElement(this.createImageData(resource), pluginName, resource.getProjectRelativePath().toPortableString()));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (!monitor.isCanceled()) break;
                                throw new OperationCanceledException();
                            }
                        }
                        return false;
                    }, 2, 10);
                }
                catch (IOException | CoreException e) {
                    PDEPlugin.log(e);
                }
            }
            return true;
        }
        return false;
    }

    private void initialize(IProgressMonitor monitor) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        this.fProjects = projects != null ? new ArrayList<IProject>(Arrays.asList(projects)) : Collections.emptyList();
    }

    @Override
    protected synchronized IStatus run(IProgressMonitor monitor) {
        super.run(monitor);
        if (this.fProjects != null) {
            this.fProjects.clear();
            this.fProjects = null;
        }
        if (this.mElementsCache != null) {
            this.mElementsCache.clear();
        }
        return Status.OK_STATUS;
    }

    public String toString() {
        return "Workspace";
    }
}

