/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.contentassist;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.contentassist.IFollowElementAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.PrefixMatcher;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocumentUtil;
import org.eclipse.xtext.util.ITextRegion;

public class ContentAssistContext {
    private static final ContentAssistContext[] EMPTY_ARRAY = new ContentAssistContext[0];
    private String prefix;
    private String selectedText;
    private EObject rootModel;
    private ICompositeNode rootNode;
    private EObject currentModel;
    private EObject previousModel;
    private INode currentNode;
    private INode lastCompleteNode;
    private int offset;
    private XtextResource resource;
    private ITextViewer viewer;
    private Region replaceRegion;
    private Integer replaceContextLength;
    private PrefixMatcher matcher;
    private ImmutableList<AbstractElement> firstSetGrammarElements;
    private List<AbstractElement> mutableFirstSetGrammarElements = Lists.newArrayList();
    @Inject
    private Provider<Builder> builderProvider;
    @Inject
    private XtextDocumentUtil xtextDocumentUtil;

    protected ContentAssistContext() {
    }

    public Builder copy() {
        Builder result = (Builder)this.builderProvider.get();
        result.copyFrom(this);
        return result;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public EObject getRootModel() {
        return this.rootModel;
    }

    public ICompositeNode getRootNode() {
        return this.rootNode;
    }

    public INode getCurrentNode() {
        return this.currentNode;
    }

    public int getOffset() {
        return this.offset;
    }

    public ITextViewer getViewer() {
        return this.viewer;
    }

    public IXtextDocument getDocument() {
        return this.xtextDocumentUtil.getXtextDocument(this.viewer);
    }

    public INode getLastCompleteNode() {
        return this.lastCompleteNode;
    }

    public EObject getCurrentModel() {
        return this.currentModel;
    }

    public EObject getPreviousModel() {
        return this.previousModel;
    }

    public Region getReplaceRegion() {
        return this.replaceRegion;
    }

    public String getSelectedText() {
        return this.selectedText;
    }

    public ImmutableList<AbstractElement> getFirstSetGrammarElements() {
        if (this.firstSetGrammarElements == null) {
            this.firstSetGrammarElements = ImmutableList.copyOf(this.mutableFirstSetGrammarElements);
        }
        return this.firstSetGrammarElements;
    }

    public PrefixMatcher getMatcher() {
        return this.matcher;
    }

    public int getReplaceContextLength() {
        if (this.replaceContextLength == null) {
            int replacementOffset = this.getReplaceRegion().getOffset();
            ITextRegion currentRegion = this.getCurrentNode().getTextRegion();
            int replaceContextLength = currentRegion.getLength() - (replacementOffset - currentRegion.getOffset());
            this.replaceContextLength = replaceContextLength;
            return replaceContextLength;
        }
        return this.replaceContextLength;
    }

    public XtextResource getResource() {
        return this.resource;
    }

    public static class Builder
    implements IFollowElementAcceptor {
        @Inject
        private ContentAssistContext context;
        private boolean contextQueried = false;

        protected void assertCanModify() {
            if (this.contextQueried) {
                throw new IllegalStateException("Cannot modify externally visible context. Use this.toContext().copy() instead.");
            }
        }

        protected ContentAssistContext get() {
            return this.context;
        }

        public ContentAssistContext toContext() {
            this.contextQueried = true;
            return this.context;
        }

        public Builder setPrefix(String prefix) {
            this.assertCanModify();
            this.context.prefix = prefix;
            return this;
        }

        public Builder setRootModel(EObject rootModel) {
            this.assertCanModify();
            this.context.rootModel = rootModel;
            return this;
        }

        public Builder setRootNode(ICompositeNode rootNode) {
            this.assertCanModify();
            this.context.rootNode = rootNode;
            return this;
        }

        public Builder setCurrentNode(INode currentNode) {
            this.assertCanModify();
            this.context.currentNode = currentNode;
            this.context.replaceContextLength = null;
            return this;
        }

        public Builder setOffset(int offset) {
            this.assertCanModify();
            this.context.offset = offset;
            return this;
        }

        public Builder setViewer(ITextViewer viewer) {
            this.assertCanModify();
            this.context.viewer = viewer;
            return this;
        }

        @Override
        public void accept(AbstractElement element) {
            if (element == null) {
                throw new NullPointerException("element may not be null");
            }
            this.assertCanModify();
            this.context.firstSetGrammarElements = null;
            this.context.mutableFirstSetGrammarElements.add(element);
        }

        public Builder setLastCompleteNode(INode lastCompleteNode) {
            this.assertCanModify();
            this.context.lastCompleteNode = lastCompleteNode;
            return this;
        }

        public Builder setCurrentModel(EObject currentModel) {
            this.assertCanModify();
            this.context.currentModel = currentModel;
            return this;
        }

        public Builder setPreviousModel(EObject previousModel) {
            this.assertCanModify();
            this.context.previousModel = previousModel;
            return this;
        }

        public Builder setReplaceRegion(Region replaceRegion) {
            this.assertCanModify();
            this.context.replaceRegion = replaceRegion;
            this.context.replaceContextLength = null;
            return this;
        }

        public Builder setSelectedText(String selectedText) {
            this.assertCanModify();
            this.context.selectedText = selectedText;
            return this;
        }

        public Builder setMatcher(PrefixMatcher matcher) {
            this.assertCanModify();
            this.context.matcher = matcher;
            return this;
        }

        public Builder setResource(XtextResource resource) {
            this.assertCanModify();
            this.context.resource = resource;
            return this;
        }

        protected void copyFrom(ContentAssistContext original) {
            this.context.prefix = original.prefix;
            this.context.selectedText = original.selectedText;
            this.context.rootModel = original.rootModel;
            this.context.rootNode = original.rootNode;
            this.context.currentModel = original.currentModel;
            this.context.previousModel = original.previousModel;
            this.context.currentNode = original.currentNode;
            this.context.lastCompleteNode = original.lastCompleteNode;
            this.context.offset = original.offset;
            this.context.resource = original.resource;
            this.context.viewer = original.viewer;
            this.context.replaceRegion = original.replaceRegion;
            this.context.replaceContextLength = original.replaceContextLength;
            this.context.matcher = original.matcher;
            this.context.mutableFirstSetGrammarElements.addAll(original.mutableFirstSetGrammarElements);
        }
    }

    @ImplementedBy(value=Null.class)
    public static interface Factory {
        public ContentAssistContext[] create(ITextViewer var1, int var2, XtextResource var3);

        public static class Null
        implements Factory {
            @Override
            public ContentAssistContext[] create(ITextViewer viewer, int offset, XtextResource resource) {
                return EMPTY_ARRAY;
            }
        }
    }
}

