/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.jaxrs21.api.client.invocationbuilder;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.webclient.TestFailureException;
import ee.jakarta.tck.ws.rs.jaxrs21.api.client.invocationbuilder.TCKRxInvoker;
import ee.jakarta.tck.ws.rs.jaxrs21.api.client.invocationbuilder.TCKRxInvokerProvider;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 21L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs21_api_client_invocationbuilder_web/resource");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs21_api_client_invocationbuilder_web.war");
        archive.addClasses(new Class[]{TCKRxInvoker.class, TCKRxInvokerProvider.class, JAXRSCommonClient.class, TestFailureException.class});
        return archive;
    }

    @Test
    public void testRxClassGetsClassInstance() throws JAXRSCommonClient.Fault {
        TCKRxInvoker invoker = (TCKRxInvoker)((Client)ClientBuilder.newClient().register(TCKRxInvokerProvider.class)).target("somewhere").request().rx(TCKRxInvoker.class);
        JAXRSClientIT.assertNotNull(invoker, "rx did not instantiated the invoker");
        JAXRSClientIT.assertEquals(invoker.getClass(), TCKRxInvoker.class, "Custom rxInvoker has not been created");
        invoker = (TCKRxInvoker)((WebTarget)ClientBuilder.newClient().target("somewhere").register(TCKRxInvokerProvider.class)).request().rx(TCKRxInvoker.class);
        JAXRSClientIT.assertNotNull(invoker, "rx did not instantiated the invoker");
        JAXRSClientIT.assertEquals(invoker.getClass(), TCKRxInvoker.class, "Custom rxInvoker has not been created");
        System.out.println("Custom rxInvoker has been created as expected");
    }

    @Test
    public void testRxClassThrowsWhenNotRegistered() throws JAXRSCommonClient.Fault {
        try {
            ClientBuilder.newClient().target("somewhere").request().rx(TCKRxInvoker.class);
            System.out.println("Illegal state exception has not been thrown when no provider is registered");
        }
        catch (IllegalStateException e) {
            System.out.println("Illegal state exception has been thrown when no provider is registered as expected");
        }
    }

    @Test
    public void testRxClassExceutorServiceGetsClassInstance() throws JAXRSCommonClient.Fault {
        TCKRxInvoker invoker = (TCKRxInvoker)((Client)ClientBuilder.newClient().register(TCKRxInvokerProvider.class)).target("somewhere").request().rx(TCKRxInvoker.class);
        JAXRSClientIT.assertNotNull(invoker, "rx did not instantiated the invoker");
        JAXRSClientIT.assertEquals(invoker.getClass(), TCKRxInvoker.class, "Custom rxInvoker has not been created");
        invoker = (TCKRxInvoker)((WebTarget)ClientBuilder.newClient().target("somewhere").register(TCKRxInvokerProvider.class)).request().rx(TCKRxInvoker.class);
        JAXRSClientIT.assertNotNull(invoker, "rx did not instantiated the invoker");
        JAXRSClientIT.assertEquals(invoker.getClass(), TCKRxInvoker.class, "Custom rxInvoker has not been created");
        System.out.println("Custom rxInvoker has been created as expected");
    }

    @Test
    public void testRxClassExecutorServiceThrowsWhenNotRegistered() throws JAXRSCommonClient.Fault {
        try {
            ClientBuilder.newClient().target("somewhere").request().rx(TCKRxInvoker.class);
            System.out.println("Illegal state exception has not been thrown when no provider is registered");
        }
        catch (IllegalStateException e) {
            System.out.println("Illegal state exception has been thrown when no provider is registered as expected");
        }
    }
}

