/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.notallowedexception;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.NotAllowedException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 6905238461163637999L;
    private static final Response.Status STATUS = Response.Status.METHOD_NOT_ALLOWED;
    protected static final String MESSAGE = "TCK NotAllowedException description";
    protected static final String HOST = "www.jcp.org";

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void constructorStringTest() throws JAXRSCommonClient.Fault {
        NotAllowedException e = new NotAllowedException(JAXRSCommonClient.Request.OPTIONS.name(), new String[]{JAXRSCommonClient.Request.HEAD.name()});
        this.assertResponse(e);
    }

    @Test
    public void constructorStringThrowsNPETest() throws JAXRSCommonClient.Fault {
        try {
            NotAllowedException e = new NotAllowedException((String)null, new String[]{JAXRSCommonClient.Request.HEAD.name()});
            JAXRSClientIT.fault("NullPointerException has not been thrown for null method, built exception", e);
        }
        catch (NullPointerException e) {
            JAXRSClientIT.logMsg("NullPointerException has been thrown as expected, for null method");
        }
    }

    @Test
    public void constructorResponseTest() throws JAXRSCommonClient.Fault {
        NotAllowedException e = new NotAllowedException(this.buildResponse(STATUS));
        this.assertResponse(e, HOST);
    }

    @Test
    public void constructorResponseThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (status == STATUS) continue;
            try {
                NotAllowedException e = new NotAllowedException(this.buildResponse(status));
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorResponseDoesNotThrowWhenNoAllowHeaderTest() throws JAXRSCommonClient.Fault {
        Response response = Response.status((Response.Status)STATUS).header("Host", (Object)HOST).build();
        NotAllowedException e = new NotAllowedException(response);
        this.assertResponse(e, HOST);
    }

    @Test
    public void constructorThrowableStringTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables;
        for (Throwable t : throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()}) {
            NotAllowedException e = new NotAllowedException(t, new String[]{JAXRSCommonClient.Request.DELETE.name()});
            this.assertResponse(e);
            this.assertCause((WebApplicationException)e, t);
        }
    }

    @Test
    public void constructorThrowableStringThrowsIAETest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables;
        for (Throwable t : throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()}) {
            try {
                NotAllowedException e = new NotAllowedException(t, (String[])null);
                JAXRSClientIT.fault("IllegalArgumentException has NOT been thrown for null methods; exception", e);
            }
            catch (IllegalArgumentException iae) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for null methods");
            }
        }
    }

    @Test
    public void constructorResponseThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables;
        for (Throwable t : throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()}) {
            NotAllowedException e = new NotAllowedException(this.buildResponse(STATUS), t);
            this.assertResponse(e, HOST);
            this.assertCause((WebApplicationException)e, t);
        }
    }

    @Test
    public void constructorResponseThrowableThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (status == STATUS) continue;
            try {
                NotAllowedException e = new NotAllowedException(this.buildResponse(status), new Throwable());
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorResponseThrowableThrowsIAEWhenNoAllowHeaderTest() throws JAXRSCommonClient.Fault {
        try {
            Response response = Response.status((Response.Status)STATUS).build();
            NotAllowedException e = new NotAllowedException(response, new Throwable());
            JAXRSClientIT.fault("IllegalArgumentException has not been thrown when no allow header exception", e);
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for when no allow http header");
        }
    }

    @Test
    public void constructorStringStringStringsTest() throws JAXRSCommonClient.Fault {
        NotAllowedException e = new NotAllowedException(MESSAGE, JAXRSCommonClient.Request.OPTIONS.name(), new String[]{JAXRSCommonClient.Request.HEAD.name()});
        this.assertResponse(e);
        this.assertMessage(e);
    }

    @Test
    public void constructorStringStringStringsThrowsNPETest() throws JAXRSCommonClient.Fault {
        try {
            NotAllowedException e = new NotAllowedException(MESSAGE, (String)null, new String[]{JAXRSCommonClient.Request.HEAD.name()});
            JAXRSClientIT.fault("NullPointerException has not been thrown for null method, built exception", e);
        }
        catch (NullPointerException e) {
            JAXRSClientIT.logMsg("NullPointerException has been thrown as expected, for null method");
        }
    }

    @Test
    public void constructorStringResponseTest() throws JAXRSCommonClient.Fault {
        NotAllowedException e = new NotAllowedException(MESSAGE, this.buildResponse(STATUS));
        this.assertResponse(e, HOST);
        this.assertMessage(e);
    }

    @Test
    public void constructorStringResponseThrowsIAETest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (status == STATUS) continue;
            try {
                NotAllowedException e = new NotAllowedException(this.buildResponse(status));
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorStringResponseDoesNotThrowWhenNoAllowHeaderTest() throws JAXRSCommonClient.Fault {
        Response response = Response.status((Response.Status)STATUS).header("Host", (Object)HOST).build();
        NotAllowedException e = new NotAllowedException(MESSAGE, response);
        this.assertResponse(e, HOST);
        this.assertMessage(e);
    }

    @Test
    public void constructorStringThrowableStringsTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables;
        for (Throwable t : throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()}) {
            NotAllowedException e = new NotAllowedException(MESSAGE, t, new String[]{JAXRSCommonClient.Request.DELETE.name()});
            this.assertResponse(e);
            this.assertCause((WebApplicationException)e, t);
            this.assertMessage(e);
        }
    }

    @Test
    public void constructorStringThrowableStringsThrowsIAETest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables;
        for (Throwable t : throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()}) {
            try {
                NotAllowedException e = new NotAllowedException(MESSAGE, t, (String[])null);
                JAXRSClientIT.fault("IllegalArgumentException has NOT been thrown for null methods; exception", e);
            }
            catch (IllegalArgumentException iae) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for null methods");
            }
        }
    }

    @Test
    public void constructorStringResponseThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables;
        for (Throwable t : throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()}) {
            NotAllowedException e = new NotAllowedException(MESSAGE, this.buildResponse(STATUS), t);
            this.assertResponse(e, HOST);
            this.assertCause((WebApplicationException)e, t);
            this.assertMessage(e);
        }
    }

    @Test
    public void constructorStringResponseThrowableThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (status == STATUS) continue;
            try {
                NotAllowedException e = new NotAllowedException(MESSAGE, this.buildResponse(status), new Throwable());
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorStringResponseThrowableThrowsIAEWhenNoAllowHeaderTest() throws JAXRSCommonClient.Fault {
        try {
            Response response = Response.status((Response.Status)STATUS).build();
            NotAllowedException e = new NotAllowedException(MESSAGE, response, new Throwable());
            JAXRSClientIT.fault("IllegalArgumentException has not been thrown when no allow header exception", e);
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for when no allow http header");
        }
    }

    protected Response buildResponse(Response.Status status) {
        return Response.status((Response.Status)status).header("allow", (Object)JAXRSCommonClient.Request.OPTIONS).header("allow", (Object)JAXRSCommonClient.Request.HEAD).header("Host", (Object)HOST).build();
    }

    protected void assertResponse(NotAllowedException e, String host) throws JAXRSCommonClient.Fault {
        this.assertResponse(e);
        String header = e.getResponse().getHeaderString("Host");
        JAXRSClientIT.assertNotNull(header, "http header", "Host", " of response is null");
        JAXRSClientIT.assertEquals(host, header, "Found unexpected http", "Host", "header", header);
        JAXRSClientIT.logMsg("Found expected http", "Host", "header");
    }

    protected void assertResponse(NotAllowedException e) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertNotNull(e.getResponse(), "#getResponse is null");
        Response response = e.getResponse();
        JAXRSClientIT.assertEqualsInt(response.getStatus(), STATUS.getStatusCode(), "response cobtains unexpected status", response.getStatus());
        JAXRSClientIT.logMsg("response contains expected", STATUS, "status");
    }

    protected void assertCause(WebApplicationException e, Throwable expected) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertEquals(e.getCause(), expected, "#getCause does not contain expected", expected, "but", e.getCause());
        JAXRSClientIT.logMsg("getCause contains expected", expected);
    }

    protected void assertMessage(NotAllowedException e) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertNotNull(e.getMessage(), "getMessage() is null");
        JAXRSClientIT.assertContains(e.getMessage(), MESSAGE, new Object[]{"Unexpected getMessage()", e.getMessage()});
        JAXRSClientIT.logMsg("found expected getMessage()=", e.getMessage());
    }
}

