/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.Extensible;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.ArrayList;

@Extensible
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class IntermediateResponse
implements Serializable,
LDAPResponse {
    protected static final byte TYPE_INTERMEDIATE_RESPONSE_OID = -128;
    protected static final byte TYPE_INTERMEDIATE_RESPONSE_VALUE = -127;
    private static final Control[] NO_CONTROLS = new Control[0];
    private static final long serialVersionUID = 218434694212935869L;
    private final ASN1OctetString value;
    private final Control[] controls;
    private final int messageID;
    private final String oid;

    public IntermediateResponse(String oid, ASN1OctetString value) {
        this(-1, oid, value, NO_CONTROLS);
    }

    public IntermediateResponse(int messageID, String oid, ASN1OctetString value) {
        this(messageID, oid, value, NO_CONTROLS);
    }

    public IntermediateResponse(String oid, ASN1OctetString value, Control[] controls) {
        this(-1, oid, value, controls);
    }

    public IntermediateResponse(int messageID, String oid, ASN1OctetString value, Control[] controls) {
        this.messageID = messageID;
        this.oid = oid;
        this.value = value;
        this.controls = controls == null ? NO_CONTROLS : controls;
    }

    protected IntermediateResponse(IntermediateResponse intermediateResponse) {
        this.messageID = intermediateResponse.messageID;
        this.oid = intermediateResponse.oid;
        this.value = intermediateResponse.value;
        this.controls = intermediateResponse.controls;
    }

    static IntermediateResponse readFrom(int messageID, ASN1StreamReaderSequence messageSequence, ASN1StreamReader reader) throws LDAPException {
        try {
            Control[] controls;
            String oid = null;
            ASN1OctetString value = null;
            ASN1StreamReaderSequence opSequence = reader.beginSequence();
            block7: while (opSequence.hasMoreElements()) {
                byte type = (byte)reader.peek();
                switch (type) {
                    case -128: {
                        oid = reader.readString();
                        continue block7;
                    }
                    case -127: {
                        value = new ASN1OctetString(type, reader.readBytes());
                        continue block7;
                    }
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_INTERMEDIATE_RESPONSE_INVALID_ELEMENT.get(StaticUtils.toHex(type)));
            }
            if (messageSequence.hasMoreElements()) {
                ArrayList<Control> controlList = new ArrayList<Control>(1);
                ASN1StreamReaderSequence controlSequence = reader.beginSequence();
                while (controlSequence.hasMoreElements()) {
                    controlList.add(Control.readFrom(reader));
                }
                controls = new Control[controlList.size()];
                controlList.toArray(controls);
            } else {
                controls = NO_CONTROLS;
            }
            return new IntermediateResponse(messageID, oid, value, controls);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_INTERMEDIATE_RESPONSE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Override
    public int getMessageID() {
        return this.messageID;
    }

    public final String getOID() {
        return this.oid;
    }

    public final ASN1OctetString getValue() {
        return this.value;
    }

    public final Control[] getControls() {
        return this.controls;
    }

    public final Control getControl(String oid) {
        for (Control c : this.controls) {
            if (!c.getOID().equals(oid)) continue;
            return c;
        }
        return null;
    }

    public String getIntermediateResponseName() {
        return this.oid;
    }

    public String valueToString() {
        return null;
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("IntermediateResponse(");
        boolean added = false;
        if (this.messageID >= 0) {
            buffer.append("messageID=");
            buffer.append(this.messageID);
            added = true;
        }
        if (this.oid != null) {
            if (added) {
                buffer.append(", ");
            }
            buffer.append("oid='");
            buffer.append(this.oid);
            buffer.append('\'');
            added = true;
        }
        if (this.controls.length > 0) {
            if (added) {
                buffer.append(", ");
            }
            buffer.append("controls={");
            for (int i = 0; i < this.controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(this.controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

