/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.common;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;

public class DDCreator
extends MatchingTask {
    protected File descriptorDirectory;
    protected File generatedFilesDirectory;
    protected String classpath;

    public void execute() throws BuildException {
        if (this.descriptorDirectory == null || !this.descriptorDirectory.isDirectory()) {
            throw new BuildException("descriptors directory " + this.descriptorDirectory.getPath() + " is not valid");
        }
        if (this.generatedFilesDirectory == null || !this.generatedFilesDirectory.isDirectory()) {
            throw new BuildException("dest directory " + this.generatedFilesDirectory.getPath() + " is not valid");
        }
        String args = this.descriptorDirectory + " " + this.generatedFilesDirectory;
        DirectoryScanner ds = super.getDirectoryScanner(this.descriptorDirectory);
        String[] files = ds.getIncludedFiles();
        for (int i = 0; i < files.length; ++i) {
            args = args + " " + files[i];
        }
        String systemClassPath = System.getProperty("java.class.path");
        String execClassPath = Project.translatePath((String)(systemClassPath + ":" + this.classpath));
        Java ddCreatorTask = (Java)this.project.createTask("java");
        ddCreatorTask.setTaskName(this.getTaskName());
        ddCreatorTask.setFork(true);
        ddCreatorTask.setClassname("org.apache.tools.ant.taskdefs.optional.ejb.DDCreatorHelper");
        Commandline.Argument arguments = ddCreatorTask.createArg();
        arguments.setLine(args);
        ddCreatorTask.setClasspath(new Path(this.project, execClassPath));
        if (ddCreatorTask.executeJava() != 0) {
            throw new BuildException("Execution of ddcreator helper failed");
        }
    }

    public void setDescriptors(String dirName) {
        this.descriptorDirectory = new File(dirName);
    }

    public void setDest(String dirName) {
        this.generatedFilesDirectory = new File(dirName);
    }

    public void setClasspath(String s) {
        this.classpath = Project.translatePath((String)s);
    }
}

