/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.LDAPSDKRuntimeException;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LDAPRuntimeException
extends LDAPSDKRuntimeException {
    private static final long serialVersionUID = 6201514484547092642L;
    private final LDAPException ldapException;

    public LDAPRuntimeException(LDAPException ldapException) {
        super(ldapException.getMessage(), ldapException.getCause());
        this.ldapException = ldapException;
    }

    public LDAPException getLDAPException() {
        return this.ldapException;
    }

    public void throwLDAPException() throws LDAPException {
        throw this.ldapException;
    }

    public ResultCode getResultCode() {
        return this.ldapException.getResultCode();
    }

    public String getMatchedDN() {
        return this.ldapException.getMatchedDN();
    }

    public String getDiagnosticMessage() {
        return this.ldapException.getDiagnosticMessage();
    }

    public String[] getReferralURLs() {
        return this.ldapException.getReferralURLs();
    }

    public boolean hasResponseControl() {
        return this.ldapException.hasResponseControl();
    }

    public boolean hasResponseControl(String oid) {
        return this.ldapException.hasResponseControl(oid);
    }

    public Control[] getResponseControls() {
        return this.ldapException.getResponseControls();
    }

    public Control getResponseControl(String oid) {
        return this.ldapException.getResponseControl(oid);
    }

    public LDAPResult toLDAPResult() {
        return this.ldapException.toLDAPResult();
    }

    @Override
    public void toString(StringBuilder buffer) {
        this.ldapException.toString(buffer);
    }

    @Override
    public String getExceptionMessage() {
        return this.ldapException.getExceptionMessage();
    }
}

