/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.controls.AuthorizationIdentityResponseControl;
import com.unboundid.ldap.sdk.controls.ContentSyncDoneControl;
import com.unboundid.ldap.sdk.controls.ContentSyncStateControl;
import com.unboundid.ldap.sdk.controls.EntryChangeNotificationControl;
import com.unboundid.ldap.sdk.controls.PasswordExpiredControl;
import com.unboundid.ldap.sdk.controls.PasswordExpiringControl;
import com.unboundid.ldap.sdk.controls.PersistentSearchChangeType;
import com.unboundid.ldap.sdk.controls.PostReadResponseControl;
import com.unboundid.ldap.sdk.controls.PreReadResponseControl;
import com.unboundid.ldap.sdk.controls.ServerSideSortResponseControl;
import com.unboundid.ldap.sdk.controls.SimplePagedResultsControl;
import com.unboundid.ldap.sdk.controls.VirtualListViewResponseControl;
import com.unboundid.ldap.sdk.extensions.AbortedTransactionExtendedResult;
import com.unboundid.ldap.sdk.extensions.EndTransactionExtendedResult;
import com.unboundid.ldap.sdk.extensions.PasswordModifyExtendedResult;
import com.unboundid.ldap.sdk.extensions.StartTransactionExtendedResult;
import com.unboundid.ldap.sdk.unboundidds.controls.AccountUsableResponseControl;
import com.unboundid.ldap.sdk.unboundidds.controls.AssuredReplicationLocalLevel;
import com.unboundid.ldap.sdk.unboundidds.controls.AssuredReplicationRemoteLevel;
import com.unboundid.ldap.sdk.unboundidds.controls.AssuredReplicationResponseControl;
import com.unboundid.ldap.sdk.unboundidds.controls.AssuredReplicationServerResult;
import com.unboundid.ldap.sdk.unboundidds.controls.AssuredReplicationServerResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.AuthenticationFailureReason;
import com.unboundid.ldap.sdk.unboundidds.controls.GetAuthorizationEntryResponseControl;
import com.unboundid.ldap.sdk.unboundidds.controls.GetBackendSetIDResponseControl;
import com.unboundid.ldap.sdk.unboundidds.controls.GetPasswordPolicyStateIssuesResponseControl;
import com.unboundid.ldap.sdk.unboundidds.controls.GetServerIDResponseControl;
import com.unboundid.ldap.sdk.unboundidds.controls.GetUserResourceLimitsResponseControl;
import com.unboundid.ldap.sdk.unboundidds.controls.IntermediateClientResponseControl;
import com.unboundid.ldap.sdk.unboundidds.controls.IntermediateClientResponseValue;
import com.unboundid.ldap.sdk.unboundidds.controls.JoinResultControl;
import com.unboundid.ldap.sdk.unboundidds.controls.JoinedEntry;
import com.unboundid.ldap.sdk.unboundidds.controls.MatchingEntryCountResponseControl;
import com.unboundid.ldap.sdk.unboundidds.controls.PasswordPolicyErrorType;
import com.unboundid.ldap.sdk.unboundidds.controls.PasswordPolicyResponseControl;
import com.unboundid.ldap.sdk.unboundidds.controls.PasswordPolicyWarningType;
import com.unboundid.ldap.sdk.unboundidds.controls.PasswordQualityRequirementValidationResult;
import com.unboundid.ldap.sdk.unboundidds.controls.PasswordValidationDetailsResponseControl;
import com.unboundid.ldap.sdk.unboundidds.controls.SoftDeleteResponseControl;
import com.unboundid.ldap.sdk.unboundidds.controls.TransactionSettingsResponseControl;
import com.unboundid.ldap.sdk.unboundidds.extensions.MultiUpdateChangesApplied;
import com.unboundid.ldap.sdk.unboundidds.extensions.MultiUpdateExtendedResult;
import com.unboundid.ldap.sdk.unboundidds.extensions.PasswordPolicyStateAccountUsabilityError;
import com.unboundid.ldap.sdk.unboundidds.extensions.PasswordPolicyStateAccountUsabilityNotice;
import com.unboundid.ldap.sdk.unboundidds.extensions.PasswordPolicyStateAccountUsabilityWarning;
import com.unboundid.ldap.sdk.unboundidds.extensions.PasswordQualityRequirement;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ResultUtils {
    private ResultUtils() {
    }

    public static List<String> formatResult(LDAPResult result, boolean comment, int indent, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>(10);
        ResultUtils.formatResult(lines, result, comment, false, indent, maxWidth);
        return lines;
    }

    public static List<String> formatResult(LDAPException ldapException, boolean comment, int indent, int maxWidth) {
        return ResultUtils.formatResult(ldapException.toLDAPResult(), comment, indent, maxWidth);
    }

    public static void formatResult(List<String> lines, LDAPResult result, boolean comment, boolean inTxn, int indent, int maxWidth) {
        ResultUtils.formatResult(lines, result, inTxn, ResultUtils.createPrefix(comment, indent), maxWidth);
    }

    private static void formatResult(List<String> lines, LDAPResult result, boolean inTxn, String prefix, int maxWidth) {
        String[] referralURLs;
        String matchedDN;
        String diagnosticMessage;
        ResultCode resultCode = result.getResultCode();
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_RESULT_CODE.get(String.valueOf(resultCode)), prefix, maxWidth);
        if (inTxn && resultCode == ResultCode.SUCCESS) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_SUCCESS_WITH_TXN.get(), prefix, maxWidth);
        }
        if ((diagnosticMessage = result.getDiagnosticMessage()) != null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_DIAGNOSTIC_MESSAGE.get(diagnosticMessage), prefix, maxWidth);
        }
        if ((matchedDN = result.getMatchedDN()) != null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_MATCHED_DN.get(matchedDN), prefix, maxWidth);
        }
        if ((referralURLs = result.getReferralURLs()) != null) {
            for (String referralURL : referralURLs) {
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_REFERRAL_URL.get(referralURL), prefix, maxWidth);
            }
        }
        if (result instanceof SearchResult) {
            int numReferences;
            SearchResult searchResult = (SearchResult)result;
            int numEntries = searchResult.getEntryCount();
            if (numEntries >= 0) {
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_NUM_SEARCH_ENTRIES.get(numEntries), prefix, maxWidth);
            }
            if ((numReferences = searchResult.getReferenceCount()) > 0) {
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_NUM_SEARCH_REFERENCES.get(numReferences), prefix, maxWidth);
            }
        } else if (result instanceof StartTransactionExtendedResult) {
            StartTransactionExtendedResult startTxnResult = (StartTransactionExtendedResult)result;
            ASN1OctetString txnID = startTxnResult.getTransactionID();
            if (txnID != null) {
                if (StaticUtils.isPrintableString(txnID.getValue())) {
                    ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_START_TXN_RESULT_TXN_ID.get(txnID.stringValue()), prefix, maxWidth);
                } else {
                    ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_START_TXN_RESULT_TXN_ID.get("0x" + StaticUtils.toHex(txnID.getValue())), prefix, maxWidth);
                }
            }
        } else if (result instanceof EndTransactionExtendedResult) {
            Map<Integer, Control[]> controls;
            EndTransactionExtendedResult endTxnResult = (EndTransactionExtendedResult)result;
            int failedOpMessageID = endTxnResult.getFailedOpMessageID();
            if (failedOpMessageID > 0) {
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_END_TXN_RESULT_FAILED_MSG_ID.get(failedOpMessageID), prefix, maxWidth);
            }
            if ((controls = endTxnResult.getOperationResponseControls()) != null) {
                for (Map.Entry entry : controls.entrySet()) {
                    for (Control c : (Control[])entry.getValue()) {
                        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_END_TXN_RESULT_OP_CONTROL.get(entry.getKey()), prefix, maxWidth);
                        ResultUtils.formatResponseControl(lines, c, prefix + "     ", maxWidth);
                    }
                }
            }
        } else if (result instanceof MultiUpdateExtendedResult) {
            List<ObjectPair<OperationType, LDAPResult>> multiUpdateResults;
            MultiUpdateExtendedResult multiUpdateResult = (MultiUpdateExtendedResult)result;
            MultiUpdateChangesApplied changesApplied = multiUpdateResult.getChangesApplied();
            if (changesApplied != null) {
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_MULTI_UPDATE_CHANGES_APPLIED.get(changesApplied.name()), prefix, maxWidth);
            }
            if ((multiUpdateResults = multiUpdateResult.getResults()) != null) {
                for (ObjectPair objectPair : multiUpdateResults) {
                    ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_MULTI_UPDATE_RESULT_HEADER.get(((OperationType)((Object)objectPair.getFirst())).name()), prefix, maxWidth);
                    ResultUtils.formatResult(lines, (LDAPResult)objectPair.getSecond(), false, prefix + "     ", maxWidth);
                }
            }
        } else if (result instanceof PasswordModifyExtendedResult) {
            PasswordModifyExtendedResult passwordModifyResult = (PasswordModifyExtendedResult)result;
            String generatedPassword = passwordModifyResult.getGeneratedPassword();
            if (generatedPassword != null) {
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_PASSWORD_MODIFY_RESULT_GENERATED_PW.get(generatedPassword), prefix, maxWidth);
            }
        } else if (result instanceof ExtendedResult) {
            ASN1OctetString value;
            ExtendedResult extendedResult = (ExtendedResult)result;
            String oid = ((ExtendedResult)result).getOID();
            if (oid != null) {
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_RESPONSE_EXTOP_OID.get(oid), prefix, maxWidth);
            }
            if ((value = extendedResult.getValue()) != null && value.getValueLength() > 0) {
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_RESPONSE_EXTOP_RAW_VALUE_HEADER.get(), prefix, maxWidth);
                for (String string : StaticUtils.stringToLines(StaticUtils.toHexPlusASCII(value.getValue(), 0))) {
                    lines.add(prefix + "     " + string);
                }
            }
        }
        Control[] controls = result.getResponseControls();
        if (controls != null) {
            for (Control control : controls) {
                ResultUtils.formatResponseControl(lines, control, prefix, maxWidth);
            }
        }
    }

    public static void formatSearchResultEntry(List<String> lines, SearchResultEntry entry, int maxWidth) {
        for (Control c : entry.getControls()) {
            ResultUtils.formatResponseControl(lines, c, true, 0, maxWidth);
        }
        lines.addAll(Arrays.asList(entry.toLDIF(maxWidth)));
    }

    public static void formatSearchResultReference(List<String> lines, SearchResultReference reference, int maxWidth) {
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_SEARCH_REFERENCE_HEADER.get(), "# ", maxWidth);
        for (String url : reference.getReferralURLs()) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_REFERRAL_URL.get(url), "#      ", maxWidth);
        }
        for (Control c : reference.getControls()) {
            ResultUtils.formatResponseControl(lines, c, "#      ", maxWidth);
        }
    }

    public static void formatUnsolicitedNotification(List<String> lines, ExtendedResult notification, boolean comment, int indent, int maxWidth) {
        Control[] controls;
        ASN1OctetString value;
        String[] referralURLs;
        String matchedDN;
        String prefix = ResultUtils.createPrefix(comment, indent);
        String indentPrefix = prefix + "     ";
        boolean includeRawValue = true;
        String oid = notification.getOID();
        if (oid != null) {
            if (oid.equals("1.3.6.1.4.1.1466.20036")) {
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_NOTICE_OF_DISCONNECTION_HEADER.get(), prefix, maxWidth);
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_RESPONSE_EXTOP_OID.get(oid), indentPrefix, maxWidth);
            } else if (oid.equals("1.3.6.1.1.21.4")) {
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_ABORTED_TXN_HEADER.get(), prefix, maxWidth);
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_RESPONSE_EXTOP_OID.get(oid), indentPrefix, maxWidth);
                try {
                    AbortedTransactionExtendedResult r = new AbortedTransactionExtendedResult(notification);
                    String txnID = StaticUtils.isPrintableString(r.getTransactionID().getValue()) ? r.getTransactionID().stringValue() : "0x" + StaticUtils.toHex(r.getTransactionID().getValue());
                    ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_TXN_ID_HEADER.get(txnID), indentPrefix, maxWidth);
                    includeRawValue = false;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            } else {
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_UNSOLICITED_NOTIFICATION_HEADER.get(), prefix, maxWidth);
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_RESPONSE_EXTOP_OID.get(oid), indentPrefix, maxWidth);
            }
        } else {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_UNSOLICITED_NOTIFICATION_HEADER.get(), prefix, maxWidth);
        }
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_RESULT_CODE.get(String.valueOf(notification.getResultCode())), indentPrefix, maxWidth);
        String diagnosticMessage = notification.getDiagnosticMessage();
        if (diagnosticMessage != null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_DIAGNOSTIC_MESSAGE.get(diagnosticMessage), indentPrefix, maxWidth);
        }
        if ((matchedDN = notification.getMatchedDN()) != null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_MATCHED_DN.get(matchedDN), indentPrefix, maxWidth);
        }
        if ((referralURLs = notification.getReferralURLs()) != null) {
            for (String referralURL : referralURLs) {
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_REFERRAL_URL.get(referralURL), indentPrefix, maxWidth);
            }
        }
        if (includeRawValue && (value = notification.getValue()) != null && value.getValueLength() > 0) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_RESPONSE_EXTOP_RAW_VALUE_HEADER.get(), indentPrefix, maxWidth);
            for (String line : StaticUtils.stringToLines(StaticUtils.toHexPlusASCII(value.getValue(), 0))) {
                lines.add(prefix + "          " + line);
            }
        }
        if ((controls = notification.getResponseControls()) != null) {
            for (Control c : controls) {
                ResultUtils.formatResponseControl(lines, c, comment, indent + 5, maxWidth);
            }
        }
    }

    public static void formatResponseControl(List<String> lines, Control c, boolean comment, int indent, int maxWidth) {
        StringBuilder buffer = new StringBuilder(indent + 2);
        if (comment) {
            buffer.append("# ");
        }
        for (int i = 0; i < indent; ++i) {
            buffer.append(' ');
        }
        String prefix = buffer.toString();
        ResultUtils.formatResponseControl(lines, c, prefix, maxWidth);
    }

    private static void formatResponseControl(List<String> lines, Control c, String prefix, int maxWidth) {
        String oid = c.getOID();
        if (oid.equals("2.16.840.1.113730.3.4.15")) {
            ResultUtils.addAuthorizationIdentityResponseControl(lines, c, prefix, maxWidth);
        } else if (oid.equals("1.3.6.1.4.1.4203.1.9.1.3")) {
            ResultUtils.addContentSyncDoneControl(lines, c, prefix, maxWidth);
        } else if (oid.equals("1.3.6.1.4.1.4203.1.9.1.2")) {
            ResultUtils.addContentSyncStateControl(lines, c, prefix, maxWidth);
        } else if (oid.equals("2.16.840.1.113730.3.4.7")) {
            ResultUtils.addEntryChangeNotificationControl(lines, c, prefix, maxWidth);
        } else if (oid.equals("2.16.840.1.113730.3.4.4")) {
            ResultUtils.addPasswordExpiredControl(lines, c, prefix, maxWidth);
        } else if (oid.equals("2.16.840.1.113730.3.4.5")) {
            ResultUtils.addPasswordExpiringControl(lines, c, prefix, maxWidth);
        } else if (oid.equals("1.3.6.1.1.13.2")) {
            ResultUtils.addPostReadResponseControl(lines, c, prefix, maxWidth);
        } else if (oid.equals("1.3.6.1.1.13.1")) {
            ResultUtils.addPreReadResponseControl(lines, c, prefix, maxWidth);
        } else if (oid.equals("1.2.840.113556.1.4.474")) {
            ResultUtils.addServerSideSortResponseControl(lines, c, prefix, maxWidth);
        } else if (oid.equals("1.2.840.113556.1.4.319")) {
            ResultUtils.addSimplePagedResultsControl(lines, c, prefix, maxWidth);
        } else if (oid.equals("2.16.840.1.113730.3.4.10")) {
            ResultUtils.addVirtualListViewResponseControl(lines, c, prefix, maxWidth);
        } else if (oid.equals("1.3.6.1.4.1.42.2.27.9.5.8")) {
            ResultUtils.addAccountUsableResponseControl(lines, c, prefix, maxWidth);
        } else if (oid.equals("1.3.6.1.4.1.30221.2.5.29")) {
            ResultUtils.addAssuredReplicationResponseControl(lines, c, prefix, maxWidth);
        } else if (oid.equals("1.3.6.1.4.1.30221.2.5.6")) {
            ResultUtils.addGetAuthorizationEntryResponseControl(lines, c, prefix, maxWidth);
        } else if (oid.equals("1.3.6.1.4.1.30221.2.5.34")) {
            ResultUtils.addGetBackendSetIDResponseControl(lines, c, prefix, maxWidth);
        } else if (oid.equals("1.3.6.1.4.1.30221.2.5.47")) {
            ResultUtils.addGetPasswordPolicyStateIssuesResponseControl(lines, c, prefix, maxWidth);
        } else if (oid.equals("1.3.6.1.4.1.30221.2.5.15")) {
            ResultUtils.addGetServerIDResponseControl(lines, c, prefix, maxWidth);
        } else if (oid.equals("1.3.6.1.4.1.30221.2.5.26")) {
            ResultUtils.addGetUserResourceLimitsResponseControl(lines, c, prefix, maxWidth);
        } else if (oid.equals("1.3.6.1.4.1.30221.2.5.2")) {
            ResultUtils.addIntermediateClientResponseControl(lines, c, prefix, maxWidth);
        } else if (oid.equals("1.3.6.1.4.1.30221.2.5.9")) {
            ResultUtils.addJoinResultControl(lines, c, prefix, maxWidth);
        } else if (oid.equals("1.3.6.1.4.1.30221.2.5.37")) {
            ResultUtils.addMatchingEntryCountResponseControl(lines, c, prefix, maxWidth);
        } else if (oid.equals("1.3.6.1.4.1.42.2.27.8.5.1")) {
            ResultUtils.addPasswordPolicyResponseControl(lines, c, prefix, maxWidth);
        } else if (oid.equals("1.3.6.1.4.1.30221.2.5.41")) {
            ResultUtils.addPasswordValidationDetailsResponseControl(lines, c, prefix, maxWidth);
        } else if (oid.equals("1.3.6.1.4.1.30221.2.5.21")) {
            ResultUtils.addSoftDeleteResponseControl(lines, c, prefix, maxWidth);
        } else if (oid.equals("1.3.6.1.4.1.30221.2.5.39")) {
            ResultUtils.addTransactionSettingsResponseControl(lines, c, prefix, maxWidth);
        } else {
            ResultUtils.addGenericResponseControl(lines, c, prefix, maxWidth);
        }
    }

    private static void addGenericResponseControl(List<String> lines, Control c, String prefix, int maxWidth) {
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_GENERIC_RESPONSE_CONTROL_HEADER.get(), prefix, maxWidth);
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_RESPONSE_CONTROL_OID.get(c.getOID()), prefix + "     ", maxWidth);
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_RESPONSE_CONTROL_IS_CRITICAL.get(c.isCritical()), prefix + "     ", maxWidth);
        ASN1OctetString value = c.getValue();
        if (value != null && value.getValue().length > 0) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_RESPONSE_CONTROL_RAW_VALUE_HEADER.get(), prefix + "     ", maxWidth);
            for (String line : StaticUtils.stringToLines(StaticUtils.toHexPlusASCII(value.getValue(), 0))) {
                lines.add(prefix + "          " + line);
            }
        }
    }

    private static void addAuthorizationIdentityResponseControl(List<String> lines, Control c, String prefix, int maxWidth) {
        AuthorizationIdentityResponseControl decoded;
        try {
            decoded = new AuthorizationIdentityResponseControl(c.getOID(), c.isCritical(), c.getValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            ResultUtils.addGenericResponseControl(lines, c, prefix, maxWidth);
            return;
        }
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_AUTHZ_ID_RESPONSE_HEADER.get(), prefix, maxWidth);
        String indentPrefix = prefix + "     ";
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_RESPONSE_CONTROL_OID.get(c.getOID()), indentPrefix, maxWidth);
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_AUTHZ_ID_RESPONSE_ID.get(decoded.getAuthorizationID()), indentPrefix, maxWidth);
    }

    private static void addContentSyncDoneControl(List<String> lines, Control c, String prefix, int maxWidth) {
        ContentSyncDoneControl decoded;
        try {
            decoded = new ContentSyncDoneControl(c.getOID(), c.isCritical(), c.getValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            ResultUtils.addGenericResponseControl(lines, c, prefix, maxWidth);
            return;
        }
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_CONTENT_SYNC_DONE_RESPONSE_HEADER.get(), prefix, maxWidth);
        String indentPrefix = prefix + "     ";
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_RESPONSE_CONTROL_OID.get(c.getOID()), indentPrefix, maxWidth);
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_CONTENT_SYNC_DONE_REFRESH_DELETES.get(decoded.refreshDeletes()), indentPrefix, maxWidth);
        ASN1OctetString cookie = decoded.getCookie();
        if (cookie != null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_CONTENT_SYNC_DONE_COOKIE_HEADER.get(), indentPrefix, maxWidth);
            for (String line : StaticUtils.stringToLines(StaticUtils.toHexPlusASCII(cookie.getValue(), 0))) {
                lines.add(indentPrefix + "     " + line);
            }
        }
    }

    private static void addContentSyncStateControl(List<String> lines, Control c, String prefix, int maxWidth) {
        ContentSyncStateControl decoded;
        try {
            decoded = new ContentSyncStateControl(c.getOID(), c.isCritical(), c.getValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            ResultUtils.addGenericResponseControl(lines, c, prefix, maxWidth);
            return;
        }
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_CONTENT_SYNC_STATE_RESPONSE_HEADER.get(), prefix, maxWidth);
        String indentPrefix = prefix + "     ";
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_RESPONSE_CONTROL_OID.get(c.getOID()), indentPrefix, maxWidth);
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_CONTENT_SYNC_STATE_ENTRY_UUID.get(decoded.getEntryUUID()), indentPrefix, maxWidth);
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_CONTENT_SYNC_STATE_NAME.get(decoded.getState().name()), indentPrefix, maxWidth);
        ASN1OctetString cookie = decoded.getCookie();
        if (cookie != null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_CONTENT_SYNC_STATE_COOKIE_HEADER.get(), indentPrefix, maxWidth);
            for (String line : StaticUtils.stringToLines(StaticUtils.toHexPlusASCII(cookie.getValue(), 0))) {
                lines.add(indentPrefix + "     " + line);
            }
        }
    }

    private static void addEntryChangeNotificationControl(List<String> lines, Control c, String prefix, int maxWidth) {
        String previousDN;
        long changeNumber;
        EntryChangeNotificationControl decoded;
        try {
            decoded = new EntryChangeNotificationControl(c.getOID(), c.isCritical(), c.getValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            ResultUtils.addGenericResponseControl(lines, c, prefix, maxWidth);
            return;
        }
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_ECN_HEADER.get(), prefix, maxWidth);
        String indentPrefix = prefix + "     ";
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_RESPONSE_CONTROL_OID.get(c.getOID()), indentPrefix, maxWidth);
        PersistentSearchChangeType changeType = decoded.getChangeType();
        if (changeType != null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_ECN_CHANGE_TYPE.get(changeType.getName()), indentPrefix, maxWidth);
        }
        if ((changeNumber = decoded.getChangeNumber()) >= 0L) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_ECN_CHANGE_NUMBER.get(changeNumber), indentPrefix, maxWidth);
        }
        if ((previousDN = decoded.getPreviousDN()) != null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_ECN_PREVIOUS_DN.get(previousDN), indentPrefix, maxWidth);
        }
    }

    private static void addPasswordExpiredControl(List<String> lines, Control c, String prefix, int maxWidth) {
        PasswordExpiredControl decoded;
        try {
            decoded = new PasswordExpiredControl(c.getOID(), c.isCritical(), c.getValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            ResultUtils.addGenericResponseControl(lines, c, prefix, maxWidth);
            return;
        }
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_PASSWORD_EXPIRED_HEADER.get(), prefix, maxWidth);
        String indentPrefix = prefix + "     ";
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_RESPONSE_CONTROL_OID.get(decoded.getOID()), indentPrefix, maxWidth);
    }

    private static void addPasswordExpiringControl(List<String> lines, Control c, String prefix, int maxWidth) {
        PasswordExpiringControl decoded;
        try {
            decoded = new PasswordExpiringControl(c.getOID(), c.isCritical(), c.getValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            ResultUtils.addGenericResponseControl(lines, c, prefix, maxWidth);
            return;
        }
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_PASSWORD_EXPIRING_HEADER.get(), prefix, maxWidth);
        String indentPrefix = prefix + "     ";
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_RESPONSE_CONTROL_OID.get(c.getOID()), indentPrefix, maxWidth);
        int secondsUntilExpiration = decoded.getSecondsUntilExpiration();
        if (secondsUntilExpiration >= 0) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_PASSWORD_EXPIRING_SECONDS_UNTIL_EXPIRATION.get(secondsUntilExpiration), indentPrefix, maxWidth);
        }
    }

    private static void addPostReadResponseControl(List<String> lines, Control c, String prefix, int maxWidth) {
        PostReadResponseControl decoded;
        try {
            decoded = new PostReadResponseControl(c.getOID(), c.isCritical(), c.getValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            ResultUtils.addGenericResponseControl(lines, c, prefix, maxWidth);
            return;
        }
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_POST_READ_HEADER.get(), prefix, maxWidth);
        String indentPrefix = prefix + "     ";
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_RESPONSE_CONTROL_OID.get(c.getOID()), indentPrefix, maxWidth);
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_POST_READ_ENTRY_HEADER.get(c.getOID()), indentPrefix, maxWidth);
        ResultUtils.addLDIF(lines, decoded.getEntry(), true, indentPrefix + "     ", maxWidth);
    }

    private static void addPreReadResponseControl(List<String> lines, Control c, String prefix, int maxWidth) {
        PreReadResponseControl decoded;
        try {
            decoded = new PreReadResponseControl(c.getOID(), c.isCritical(), c.getValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            ResultUtils.addGenericResponseControl(lines, c, prefix, maxWidth);
            return;
        }
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_PRE_READ_HEADER.get(), prefix, maxWidth);
        String indentPrefix = prefix + "     ";
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_RESPONSE_CONTROL_OID.get(c.getOID()), indentPrefix, maxWidth);
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_PRE_READ_ENTRY_HEADER.get(c.getOID()), indentPrefix, maxWidth);
        ResultUtils.addLDIF(lines, decoded.getEntry(), true, indentPrefix + "     ", maxWidth);
    }

    private static void addServerSideSortResponseControl(List<String> lines, Control c, String prefix, int maxWidth) {
        String attributeName;
        ServerSideSortResponseControl decoded;
        try {
            decoded = new ServerSideSortResponseControl(c.getOID(), c.isCritical(), c.getValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            ResultUtils.addGenericResponseControl(lines, c, prefix, maxWidth);
            return;
        }
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_SORT_HEADER.get(), prefix, maxWidth);
        String indentPrefix = prefix + "     ";
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_RESPONSE_CONTROL_OID.get(c.getOID()), indentPrefix, maxWidth);
        ResultCode resultCode = decoded.getResultCode();
        if (resultCode != null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_SORT_RESULT_CODE.get(String.valueOf(resultCode)), indentPrefix, maxWidth);
        }
        if ((attributeName = decoded.getAttributeName()) != null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_SORT_ATTRIBUTE_NAME.get(attributeName), indentPrefix, maxWidth);
        }
    }

    private static void addSimplePagedResultsControl(List<String> lines, Control c, String prefix, int maxWidth) {
        ASN1OctetString cookie;
        SimplePagedResultsControl decoded;
        try {
            decoded = new SimplePagedResultsControl(c.getOID(), c.isCritical(), c.getValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            ResultUtils.addGenericResponseControl(lines, c, prefix, maxWidth);
            return;
        }
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_PAGED_RESULTS_HEADER.get(), prefix, maxWidth);
        String indentPrefix = prefix + "     ";
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_RESPONSE_CONTROL_OID.get(c.getOID()), indentPrefix, maxWidth);
        int estimatedCount = decoded.getSize();
        if (estimatedCount >= 0) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_PAGED_RESULTS_COUNT.get(estimatedCount), indentPrefix, maxWidth);
        }
        if ((cookie = decoded.getCookie()) != null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_PAGED_RESULTS_COOKIE_HEADER.get(), indentPrefix, maxWidth);
            for (String line : StaticUtils.stringToLines(StaticUtils.toHexPlusASCII(cookie.getValue(), 0))) {
                lines.add(indentPrefix + "     " + line);
            }
        }
    }

    private static void addVirtualListViewResponseControl(List<String> lines, Control c, String prefix, int maxWidth) {
        ASN1OctetString contextID;
        int targetPosition;
        int contentCount;
        VirtualListViewResponseControl decoded;
        try {
            decoded = new VirtualListViewResponseControl(c.getOID(), c.isCritical(), c.getValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            ResultUtils.addGenericResponseControl(lines, c, prefix, maxWidth);
            return;
        }
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_VLV_HEADER.get(), prefix, maxWidth);
        String indentPrefix = prefix + "     ";
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_RESPONSE_CONTROL_OID.get(c.getOID()), indentPrefix, maxWidth);
        ResultCode resultCode = decoded.getResultCode();
        if (resultCode != null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_VLV_RESULT_CODE.get(String.valueOf(resultCode)), indentPrefix, maxWidth);
        }
        if ((contentCount = decoded.getContentCount()) >= 0) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_VLV_CONTENT_COUNT.get(contentCount), indentPrefix, maxWidth);
        }
        if ((targetPosition = decoded.getTargetPosition()) >= 0) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_VLV_TARGET_POSITION.get(targetPosition), indentPrefix, maxWidth);
        }
        if ((contextID = decoded.getContextID()) != null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_VLV_CONTEXT_ID_HEADER.get(), indentPrefix, maxWidth);
            for (String line : StaticUtils.stringToLines(StaticUtils.toHexPlusASCII(contextID.getValue(), 0))) {
                lines.add(indentPrefix + "     " + line);
            }
        }
    }

    private static void addAccountUsableResponseControl(List<String> lines, Control c, String prefix, int maxWidth) {
        int secondsUntilUnlock;
        int secondsUntilExpiration;
        AccountUsableResponseControl decoded;
        try {
            decoded = new AccountUsableResponseControl(c.getOID(), c.isCritical(), c.getValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            ResultUtils.addGenericResponseControl(lines, c, prefix, maxWidth);
            return;
        }
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_ACCOUNT_USABLE_HEADER.get(), prefix, maxWidth);
        String indentPrefix = prefix + "     ";
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_RESPONSE_CONTROL_OID.get(c.getOID()), indentPrefix, maxWidth);
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_ACCOUNT_USABLE_IS_USABLE.get(decoded.isUsable()), indentPrefix, maxWidth);
        List<String> unusableReasons = decoded.getUnusableReasons();
        if (unusableReasons != null && !unusableReasons.isEmpty()) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_ACCOUNT_USABLE_UNUSABLE_REASONS_HEADER.get(), indentPrefix, maxWidth);
            for (String reason : unusableReasons) {
                ResultUtils.wrap(lines, reason, indentPrefix + "     ", maxWidth);
            }
        }
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_ACCOUNT_USABLE_PW_EXPIRED.get(decoded.passwordIsExpired()), indentPrefix, maxWidth);
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_ACCOUNT_USABLE_MUST_CHANGE_PW.get(decoded.mustChangePassword()), indentPrefix, maxWidth);
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_ACCOUNT_USABLE_IS_INACTIVE.get(decoded.isInactive()), indentPrefix, maxWidth);
        int remainingGraceLogins = decoded.getRemainingGraceLogins();
        if (remainingGraceLogins >= 0) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_ACCOUNT_USABLE_REMAINING_GRACE.get(remainingGraceLogins), indentPrefix, maxWidth);
        }
        if ((secondsUntilExpiration = decoded.getSecondsUntilExpiration()) >= 0) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_ACCOUNT_USABLE_SECONDS_UNTIL_EXPIRATION.get(secondsUntilExpiration), indentPrefix, maxWidth);
        }
        if ((secondsUntilUnlock = decoded.getSecondsUntilUnlock()) >= 0) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_ACCOUNT_USABLE_SECONDS_UNTIL_UNLOCK.get(secondsUntilUnlock), indentPrefix, maxWidth);
        }
    }

    private static void addAssuredReplicationResponseControl(List<String> lines, Control c, String prefix, int maxWidth) {
        List<AssuredReplicationServerResult> serverResults;
        AssuredReplicationRemoteLevel remoteLevel;
        AssuredReplicationLocalLevel localLevel;
        AssuredReplicationResponseControl decoded;
        try {
            decoded = new AssuredReplicationResponseControl(c.getOID(), c.isCritical(), c.getValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            ResultUtils.addGenericResponseControl(lines, c, prefix, maxWidth);
            return;
        }
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_ASSURED_REPL_HEADER.get(), prefix, maxWidth);
        String indentPrefix = prefix + "     ";
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_RESPONSE_CONTROL_OID.get(c.getOID()), indentPrefix, maxWidth);
        String csn = decoded.getCSN();
        if (csn != null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_ASSURED_REPL_CSN.get(csn), indentPrefix, maxWidth);
        }
        if ((localLevel = decoded.getLocalLevel()) != null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_ASSURED_REPL_LOCAL_LEVEL.get(localLevel.name()), indentPrefix, maxWidth);
        }
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_ASSURED_REPL_LOCAL_SATISFIED.get(decoded.localAssuranceSatisfied()), indentPrefix, maxWidth);
        String localMessage = decoded.getLocalAssuranceMessage();
        if (localMessage != null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_ASSURED_REPL_LOCAL_MESSAGE.get(localMessage), indentPrefix, maxWidth);
        }
        if ((remoteLevel = decoded.getRemoteLevel()) != null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_ASSURED_REPL_REMOTE_LEVEL.get(remoteLevel.name()), indentPrefix, maxWidth);
        }
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_ASSURED_REPL_REMOTE_SATISFIED.get(decoded.remoteAssuranceSatisfied()), indentPrefix, maxWidth);
        String remoteMessage = decoded.getRemoteAssuranceMessage();
        if (remoteMessage != null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_ASSURED_REPL_REMOTE_MESSAGE.get(remoteMessage), indentPrefix, maxWidth);
        }
        if ((serverResults = decoded.getServerResults()) != null) {
            for (AssuredReplicationServerResult r : serverResults) {
                Short replicaID;
                Short replicationServerID;
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_ASSURED_REPL_SERVER_RESULT_HEADER.get(), indentPrefix, maxWidth);
                AssuredReplicationServerResultCode rc = r.getResultCode();
                if (rc != null) {
                    ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_ASSURED_REPL_SERVER_RESULT_CODE.get(rc.name()), indentPrefix + "     ", maxWidth);
                }
                if ((replicationServerID = r.getReplicationServerID()) != null) {
                    ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_ASSURED_REPL_SERVER_RESULT_REPL_SERVER_ID.get(replicationServerID), indentPrefix + "     ", maxWidth);
                }
                if ((replicaID = r.getReplicaID()) == null) continue;
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_ASSURED_REPL_SERVER_RESULT_REPL_ID.get(replicaID), indentPrefix + "     ", maxWidth);
            }
        }
    }

    private static void addGetAuthorizationEntryResponseControl(List<String> lines, Control c, String prefix, int maxWidth) {
        ReadOnlyEntry authZEntry;
        ReadOnlyEntry authNEntry;
        GetAuthorizationEntryResponseControl decoded;
        try {
            decoded = new GetAuthorizationEntryResponseControl(c.getOID(), c.isCritical(), c.getValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            ResultUtils.addGenericResponseControl(lines, c, prefix, maxWidth);
            return;
        }
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_GET_AUTHZ_ENTRY_HEADER.get(), prefix, maxWidth);
        String indentPrefix = prefix + "     ";
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_RESPONSE_CONTROL_OID.get(c.getOID()), indentPrefix, maxWidth);
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_GET_AUTHZ_ENTRY_IS_AUTHENTICATED.get(decoded.isAuthenticated()), indentPrefix, maxWidth);
        if (!decoded.isAuthenticated()) {
            return;
        }
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_GET_AUTHZ_ENTRY_IDS_MATCH.get(decoded.identitiesMatch()), indentPrefix, maxWidth);
        String authNID = decoded.getAuthNID();
        if (authNID != null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_GET_AUTHZ_ENTRY_AUTHN_ID.get(authNID), indentPrefix, maxWidth);
        }
        if ((authNEntry = decoded.getAuthNEntry()) != null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_GET_AUTHZ_ENTRY_AUTHN_ENTRY_HEADER.get(), indentPrefix, maxWidth);
            ResultUtils.addLDIF(lines, authNEntry, true, indentPrefix + "     ", maxWidth);
        }
        if (decoded.identitiesMatch()) {
            return;
        }
        String authZID = decoded.getAuthZID();
        if (authZID != null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_GET_AUTHZ_ENTRY_AUTHZ_ID.get(authZID), indentPrefix, maxWidth);
        }
        if ((authZEntry = decoded.getAuthZEntry()) != null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_GET_AUTHZ_ENTRY_AUTHZ_ENTRY_HEADER.get(), indentPrefix, maxWidth);
            ResultUtils.addLDIF(lines, authZEntry, true, indentPrefix + "     ", maxWidth);
        }
    }

    private static void addGetBackendSetIDResponseControl(List<String> lines, Control c, String prefix, int maxWidth) {
        GetBackendSetIDResponseControl decoded;
        try {
            decoded = new GetBackendSetIDResponseControl(c.getOID(), c.isCritical(), c.getValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            ResultUtils.addGenericResponseControl(lines, c, prefix, maxWidth);
            return;
        }
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_GET_BACKEND_SET_ID_HEADER.get(), prefix, maxWidth);
        String indentPrefix = prefix + "     ";
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_RESPONSE_CONTROL_OID.get(c.getOID()), indentPrefix, maxWidth);
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_GET_BACKEND_SET_ID_EB_RP_ID.get(decoded.getEntryBalancingRequestProcessorID()), indentPrefix, maxWidth);
        for (String id : decoded.getBackendSetIDs()) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_GET_BACKEND_SET_ID.get(id), indentPrefix, maxWidth);
        }
    }

    private static void addGetPasswordPolicyStateIssuesResponseControl(List<String> lines, Control c, String prefix, int maxWidth) {
        List<PasswordPolicyStateAccountUsabilityNotice> notices;
        List<PasswordPolicyStateAccountUsabilityWarning> warnings;
        List<PasswordPolicyStateAccountUsabilityError> errors;
        GetPasswordPolicyStateIssuesResponseControl decoded;
        try {
            decoded = new GetPasswordPolicyStateIssuesResponseControl(c.getOID(), c.isCritical(), c.getValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            ResultUtils.addGenericResponseControl(lines, c, prefix, maxWidth);
            return;
        }
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_GET_PW_STATE_ISSUES_HEADER.get(), prefix, maxWidth);
        String indentPrefix = prefix + "     ";
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_RESPONSE_CONTROL_OID.get(c.getOID()), indentPrefix, maxWidth);
        String doubleIndentPrefix = indentPrefix + "     ";
        AuthenticationFailureReason authFailureReason = decoded.getAuthenticationFailureReason();
        if (authFailureReason != null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_GET_PW_STATE_ISSUES_FAILURE_REASON_HEADER.get(), indentPrefix, maxWidth);
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_GET_PW_STATE_ISSUES_FAILURE_TYPE.get(authFailureReason.getName()), doubleIndentPrefix, maxWidth);
            String message = authFailureReason.getMessage();
            if (message != null) {
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_GET_PW_STATE_ISSUES_FAILURE_MESSAGE.get(message), doubleIndentPrefix, maxWidth);
            }
        }
        if ((errors = decoded.getErrors()) != null) {
            for (PasswordPolicyStateAccountUsabilityError e : errors) {
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_GET_PW_STATE_ISSUES_ERROR_HEADER.get(), indentPrefix, maxWidth);
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_GET_PW_STATE_ISSUES_ERROR_NAME.get(e.getName()), doubleIndentPrefix, maxWidth);
                String message = e.getMessage();
                if (message == null) continue;
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_GET_PW_STATE_ISSUES_ERROR_MESSAGE.get(message), doubleIndentPrefix, maxWidth);
            }
        }
        if ((warnings = decoded.getWarnings()) != null) {
            for (PasswordPolicyStateAccountUsabilityWarning w : warnings) {
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_GET_PW_STATE_ISSUES_WARNING_HEADER.get(), indentPrefix, maxWidth);
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_GET_PW_STATE_ISSUES_WARNING_NAME.get(w.getName()), doubleIndentPrefix, maxWidth);
                String message = w.getMessage();
                if (message == null) continue;
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_GET_PW_STATE_ISSUES_WARNING_MESSAGE.get(message), doubleIndentPrefix, maxWidth);
            }
        }
        if ((notices = decoded.getNotices()) != null) {
            for (PasswordPolicyStateAccountUsabilityNotice n : notices) {
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_GET_PW_STATE_ISSUES_NOTICE_HEADER.get(), indentPrefix, maxWidth);
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_GET_PW_STATE_ISSUES_NOTICE_NAME.get(n.getName()), doubleIndentPrefix, maxWidth);
                String message = n.getMessage();
                if (message == null) continue;
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_GET_PW_STATE_ISSUES_NOTICE_MESSAGE.get(message), doubleIndentPrefix, maxWidth);
            }
        }
    }

    private static void addGetServerIDResponseControl(List<String> lines, Control c, String prefix, int maxWidth) {
        GetServerIDResponseControl decoded;
        try {
            decoded = new GetServerIDResponseControl(c.getOID(), c.isCritical(), c.getValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            ResultUtils.addGenericResponseControl(lines, c, prefix, maxWidth);
            return;
        }
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_GET_SERVER_ID_HEADER.get(), prefix, maxWidth);
        String indentPrefix = prefix + "     ";
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_RESPONSE_CONTROL_OID.get(c.getOID()), indentPrefix, maxWidth);
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_GET_SERVER_ID.get(decoded.getServerID()), indentPrefix, maxWidth);
    }

    private static void addGetUserResourceLimitsResponseControl(List<String> lines, Control c, String prefix, int maxWidth) {
        List<Attribute> otherAttrs;
        List<String> privilegeNames;
        String ccpName;
        String equivalentUserDN;
        Long lookthroughLimit;
        Long idleTimeLimit;
        Long timeLimit;
        GetUserResourceLimitsResponseControl decoded;
        try {
            decoded = new GetUserResourceLimitsResponseControl(c.getOID(), c.isCritical(), c.getValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            ResultUtils.addGenericResponseControl(lines, c, prefix, maxWidth);
            return;
        }
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_GET_USER_RLIM_HEADER.get(), prefix, maxWidth);
        String indentPrefix = prefix + "     ";
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_RESPONSE_CONTROL_OID.get(c.getOID()), indentPrefix, maxWidth);
        Long sizeLimit = decoded.getSizeLimit();
        if (sizeLimit != null) {
            String value = sizeLimit > 0L ? String.valueOf(sizeLimit) : ToolMessages.INFO_RESULT_UTILS_GET_USER_RLIM_VALUE_UNLIMITED.get();
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_GET_USER_RLIM_SIZE_LIMIT.get(value), indentPrefix, maxWidth);
        }
        if ((timeLimit = decoded.getTimeLimitSeconds()) != null) {
            String value = timeLimit > 0L ? timeLimit + " " + ToolMessages.INFO_RESULT_UTILS_GET_USER_RLIM_UNIT_SECONDS.get() : ToolMessages.INFO_RESULT_UTILS_GET_USER_RLIM_VALUE_UNLIMITED.get();
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_GET_USER_RLIM_TIME_LIMIT.get(value), indentPrefix, maxWidth);
        }
        if ((idleTimeLimit = decoded.getIdleTimeLimitSeconds()) != null) {
            String value = idleTimeLimit > 0L ? idleTimeLimit + " " + ToolMessages.INFO_RESULT_UTILS_GET_USER_RLIM_UNIT_SECONDS.get() : ToolMessages.INFO_RESULT_UTILS_GET_USER_RLIM_VALUE_UNLIMITED.get();
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_GET_USER_RLIM_IDLE_TIME_LIMIT.get(value), indentPrefix, maxWidth);
        }
        if ((lookthroughLimit = decoded.getLookthroughLimit()) != null) {
            String value = lookthroughLimit > 0L ? String.valueOf(lookthroughLimit) : ToolMessages.INFO_RESULT_UTILS_GET_USER_RLIM_VALUE_UNLIMITED.get();
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_GET_USER_RLIM_LOOKTHROUGH_LIMIT.get(value), indentPrefix, maxWidth);
        }
        if ((equivalentUserDN = decoded.getEquivalentAuthzUserDN()) != null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_GET_USER_RLIM_EQUIVALENT_AUTHZ_USER_DN.get(equivalentUserDN), indentPrefix, maxWidth);
        }
        if ((ccpName = decoded.getClientConnectionPolicyName()) != null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_GET_USER_RLIM_CCP_NAME.get(ccpName), indentPrefix, maxWidth);
        }
        String doubleIndentPrefix = indentPrefix + "     ";
        List<String> groupDNs = decoded.getGroupDNs();
        if (groupDNs != null && !groupDNs.isEmpty()) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_GET_USER_RLIM_GROUP_DNS_HEADER.get(), indentPrefix, maxWidth);
            for (String groupDN : groupDNs) {
                ResultUtils.wrap(lines, groupDN, doubleIndentPrefix, maxWidth);
            }
        }
        if ((privilegeNames = decoded.getPrivilegeNames()) != null && !privilegeNames.isEmpty()) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_GET_USER_RLIM_PRIVILEGES_HEADER.get(), indentPrefix, maxWidth);
            for (String privilegeName : privilegeNames) {
                ResultUtils.wrap(lines, privilegeName, doubleIndentPrefix, maxWidth);
            }
        }
        if ((otherAttrs = decoded.getOtherAttributes()) != null && !otherAttrs.isEmpty()) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_GET_USER_RLIM_OTHER_ATTIBUTES_HEADER.get(), indentPrefix, maxWidth);
            ResultUtils.addLDIF(lines, new Entry("", otherAttrs), false, doubleIndentPrefix, maxWidth);
        }
    }

    private static void addIntermediateClientResponseControl(List<String> lines, Control c, String prefix, int maxWidth) {
        IntermediateClientResponseControl decoded;
        try {
            decoded = new IntermediateClientResponseControl(c.getOID(), c.isCritical(), c.getValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            ResultUtils.addGenericResponseControl(lines, c, prefix, maxWidth);
            return;
        }
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_INTERMEDIATE_CLIENT_HEADER.get(), prefix, maxWidth);
        String indentPrefix = prefix + "     ";
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_RESPONSE_CONTROL_OID.get(c.getOID()), indentPrefix, maxWidth);
        ResultUtils.addIntermediateResponseValue(lines, decoded.getResponseValue(), indentPrefix, maxWidth);
    }

    private static void addIntermediateResponseValue(List<String> lines, IntermediateClientResponseValue v, String prefix, int maxWidth) {
        IntermediateClientResponseValue upstreamResponse;
        String responseID;
        String sessionID;
        String serverName;
        Boolean secure;
        String address = v.getUpstreamServerAddress();
        if (address != null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_INTERMEDIATE_CLIENT_UPSTREAM_ADDRESS.get(address), prefix, maxWidth);
        }
        if ((secure = v.upstreamServerSecure()) != null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_INTERMEDIATE_CLIENT_UPSTREAM_SECURE.get(String.valueOf(secure)), prefix, maxWidth);
        }
        if ((serverName = v.getServerName()) != null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_INTERMEDIATE_CLIENT_SERVER_NAME.get(serverName), prefix, maxWidth);
        }
        if ((sessionID = v.getServerSessionID()) != null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_INTERMEDIATE_CLIENT_SESSION_ID.get(sessionID), prefix, maxWidth);
        }
        if ((responseID = v.getServerResponseID()) != null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_INTERMEDIATE_CLIENT_RESPONSE_ID.get(responseID), prefix, maxWidth);
        }
        if ((upstreamResponse = v.getUpstreamResponse()) != null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_INTERMEDIATE_CLIENT_UPSTREAM_RESPONSE_HEADER.get(), prefix, maxWidth);
            ResultUtils.addIntermediateResponseValue(lines, upstreamResponse, prefix + "     ", maxWidth);
        }
    }

    private static void addJoinResultControl(List<String> lines, Control c, String prefix, int maxWidth) {
        List<JoinedEntry> joinedEntries;
        List<String> referralURLs;
        String matchedDN;
        String diagnosticMessage;
        JoinResultControl decoded;
        try {
            decoded = new JoinResultControl(c.getOID(), c.isCritical(), c.getValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            ResultUtils.addGenericResponseControl(lines, c, prefix, maxWidth);
            return;
        }
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_JOIN_HEADER.get(), prefix, maxWidth);
        String indentPrefix = prefix + "     ";
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_RESPONSE_CONTROL_OID.get(c.getOID()), indentPrefix, maxWidth);
        ResultCode resultCode = decoded.getResultCode();
        if (resultCode != null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_JOIN_RESULT_CODE.get(String.valueOf(resultCode)), indentPrefix, maxWidth);
        }
        if ((diagnosticMessage = decoded.getDiagnosticMessage()) != null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_JOIN_DIAGNOSTIC_MESSAGE.get(diagnosticMessage), indentPrefix, maxWidth);
        }
        if ((matchedDN = decoded.getMatchedDN()) != null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_JOIN_MATCHED_DN.get(matchedDN), indentPrefix, maxWidth);
        }
        if ((referralURLs = decoded.getReferralURLs()) != null) {
            for (String referralURL : referralURLs) {
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_JOIN_REFERRAL_URL.get(referralURL), indentPrefix, maxWidth);
            }
        }
        if ((joinedEntries = decoded.getJoinResults()) != null) {
            for (JoinedEntry e : joinedEntries) {
                ResultUtils.addJoinedEntry(lines, e, indentPrefix, maxWidth);
            }
        }
    }

    private static void addJoinedEntry(List<String> lines, JoinedEntry joinedEntry, String prefix, int maxWidth) {
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_JOINED_WITH_ENTRY_HEADER.get(), prefix, maxWidth);
        ResultUtils.addLDIF(lines, joinedEntry, true, prefix + "     ", maxWidth);
        List<JoinedEntry> nestedJoinResults = joinedEntry.getNestedJoinResults();
        if (nestedJoinResults != null) {
            for (JoinedEntry e : nestedJoinResults) {
                ResultUtils.addJoinedEntry(lines, e, prefix + "          ", maxWidth);
            }
        }
    }

    private static void addMatchingEntryCountResponseControl(List<String> lines, Control c, String prefix, int maxWidth) {
        MatchingEntryCountResponseControl decoded;
        try {
            decoded = new MatchingEntryCountResponseControl(c.getOID(), c.isCritical(), c.getValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            ResultUtils.addGenericResponseControl(lines, c, prefix, maxWidth);
            return;
        }
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_MATCHING_ENTRY_COUNT_HEADER.get(), prefix, maxWidth);
        String indentPrefix = prefix + "     ";
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_RESPONSE_CONTROL_OID.get(c.getOID()), indentPrefix, maxWidth);
        switch (decoded.getCountType()) {
            case EXAMINED_COUNT: {
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_MATCHING_ENTRY_COUNT_TYPE_EXAMINED.get(), indentPrefix, maxWidth);
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_MATCHING_ENTRY_COUNT_VALUE.get(decoded.getCountValue()), indentPrefix, maxWidth);
                break;
            }
            case UNEXAMINED_COUNT: {
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_MATCHING_ENTRY_COUNT_TYPE_UNEXAMINED.get(), indentPrefix, maxWidth);
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_MATCHING_ENTRY_COUNT_VALUE.get(decoded.getCountValue()), indentPrefix, maxWidth);
                break;
            }
            case UPPER_BOUND: {
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_MATCHING_ENTRY_COUNT_TYPE_UPPER_BOUND.get(), indentPrefix, maxWidth);
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_MATCHING_ENTRY_COUNT_VALUE.get(decoded.getCountValue()), indentPrefix, maxWidth);
                break;
            }
            default: {
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_MATCHING_ENTRY_COUNT_TYPE_UNKNOWN.get(), indentPrefix, maxWidth);
            }
        }
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_MATCHING_ENTRY_COUNT_INDEXED.get(decoded.searchIndexed()), indentPrefix, maxWidth);
        List<String> debugInfo = decoded.getDebugInfo();
        if (debugInfo != null && !debugInfo.isEmpty()) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_MATCHING_ENTRY_COUNT_DEBUG_HEADER.get(), indentPrefix, maxWidth);
            for (String s : debugInfo) {
                ResultUtils.wrap(lines, s, indentPrefix + "     ", maxWidth);
            }
        }
    }

    private static void addPasswordPolicyResponseControl(List<String> lines, Control c, String prefix, int maxWidth) {
        PasswordPolicyResponseControl decoded;
        try {
            decoded = new PasswordPolicyResponseControl(c.getOID(), c.isCritical(), c.getValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            ResultUtils.addGenericResponseControl(lines, c, prefix, maxWidth);
            return;
        }
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_PW_POLICY_HEADER.get(), prefix, maxWidth);
        String indentPrefix = prefix + "     ";
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_RESPONSE_CONTROL_OID.get(c.getOID()), indentPrefix, maxWidth);
        PasswordPolicyErrorType errorType = decoded.getErrorType();
        if (errorType == null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_PW_POLICY_ERROR_TYPE_NONE.get(), indentPrefix, maxWidth);
        } else {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_PW_POLICY_ERROR_TYPE.get(errorType.getName()), indentPrefix, maxWidth);
        }
        PasswordPolicyWarningType warningType = decoded.getWarningType();
        if (warningType == null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_PW_POLICY_WARNING_TYPE_NONE.get(), indentPrefix, maxWidth);
        } else {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_PW_POLICY_WARNING_TYPE.get(warningType.getName()), indentPrefix, maxWidth);
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_PW_POLICY_WARNING_VALUE.get(decoded.getWarningValue()), indentPrefix, maxWidth);
        }
    }

    private static void addPasswordValidationDetailsResponseControl(List<String> lines, Control c, String prefix, int maxWidth) {
        PasswordValidationDetailsResponseControl decoded;
        try {
            decoded = new PasswordValidationDetailsResponseControl(c.getOID(), c.isCritical(), c.getValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            ResultUtils.addGenericResponseControl(lines, c, prefix, maxWidth);
            return;
        }
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_PW_VALIDATION_DETAILS_HEADER.get(), prefix, maxWidth);
        String indentPrefix = prefix + "     ";
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_RESPONSE_CONTROL_OID.get(c.getOID()), indentPrefix, maxWidth);
        switch (decoded.getResponseType()) {
            case VALIDATION_DETAILS: {
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_PW_VALIDATION_DETAILS_RESULT_TYPE_RESULT.get(), indentPrefix, maxWidth);
                List<PasswordQualityRequirementValidationResult> results = decoded.getValidationResults();
                if (results == null) break;
                for (PasswordQualityRequirementValidationResult r : results) {
                    Map<String, String> properties;
                    String clientSideType;
                    ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_PW_VALIDATION_DETAILS_PQR_HEADER.get(), indentPrefix + "     ", maxWidth);
                    String tripleIndentPrefix = indentPrefix + "          ";
                    PasswordQualityRequirement pqr = r.getPasswordRequirement();
                    String description = pqr.getDescription();
                    if (description != null) {
                        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_PW_VALIDATION_DETAILS_PQR_DESC.get(description), tripleIndentPrefix, maxWidth);
                    }
                    if ((clientSideType = pqr.getClientSideValidationType()) != null) {
                        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_PW_VALIDATION_DETAILS_PQR_TYPE.get(clientSideType), tripleIndentPrefix, maxWidth);
                    }
                    if ((properties = pqr.getClientSideValidationProperties()) != null) {
                        for (Map.Entry<String, String> e : properties.entrySet()) {
                            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_PW_VALIDATION_DETAILS_PQR_PROP.get(e.getKey(), e.getValue()), tripleIndentPrefix, maxWidth);
                        }
                    }
                    ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_PW_VALIDATION_DETAILS_PQR_SATISFIED.get(r.requirementSatisfied()), tripleIndentPrefix, maxWidth);
                    String additionalInfo = r.getAdditionalInfo();
                    if (additionalInfo == null) continue;
                    ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_PW_VALIDATION_DETAILS_PQR_INFO.get(additionalInfo), tripleIndentPrefix, maxWidth);
                }
                break;
            }
            case NO_PASSWORD_PROVIDED: {
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_PW_VALIDATION_DETAILS_RESULT_TYPE_NO_PW.get(), indentPrefix, maxWidth);
                break;
            }
            case MULTIPLE_PASSWORDS_PROVIDED: {
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_PW_VALIDATION_DETAILS_RESULT_TYPE_MULTIPLE_PW.get(), indentPrefix, maxWidth);
                break;
            }
            case NO_VALIDATION_ATTEMPTED: {
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_PW_VALIDATION_DETAILS_RESULT_TYPE_NO_VALIDATION.get(), indentPrefix, maxWidth);
                break;
            }
            default: {
                ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_PW_VALIDATION_DETAILS_RESULT_TYPE_DEFAULT.get(decoded.getResponseType().name()), indentPrefix, maxWidth);
            }
        }
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_PW_VALIDATION_DETAILS_MISSING_CURRENT.get(decoded.missingCurrentPassword()), indentPrefix, maxWidth);
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_PW_VALIDATION_DETAILS_MUST_CHANGE.get(decoded.mustChangePassword()), indentPrefix, maxWidth);
        Integer secondsUntilExpiration = decoded.getSecondsUntilExpiration();
        if (secondsUntilExpiration != null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_PW_VALIDATION_DETAILS_SECONDS_TO_EXP.get(secondsUntilExpiration), indentPrefix, maxWidth);
        }
    }

    private static void addSoftDeleteResponseControl(List<String> lines, Control c, String prefix, int maxWidth) {
        SoftDeleteResponseControl decoded;
        try {
            decoded = new SoftDeleteResponseControl(c.getOID(), c.isCritical(), c.getValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            ResultUtils.addGenericResponseControl(lines, c, prefix, maxWidth);
            return;
        }
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_SOFT_DELETE_HEADER.get(), prefix, maxWidth);
        String indentPrefix = prefix + "     ";
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_RESPONSE_CONTROL_OID.get(c.getOID()), indentPrefix, maxWidth);
        String dn = decoded.getSoftDeletedEntryDN();
        if (dn != null) {
            ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_SOFT_DELETED_DN.get(dn), indentPrefix, maxWidth);
        }
    }

    private static void addTransactionSettingsResponseControl(List<String> lines, Control c, String prefix, int maxWidth) {
        TransactionSettingsResponseControl decoded;
        try {
            decoded = new TransactionSettingsResponseControl(c.getOID(), c.isCritical(), c.getValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            ResultUtils.addGenericResponseControl(lines, c, prefix, maxWidth);
            return;
        }
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_TXN_SETTINGS_HEADER.get(), prefix, maxWidth);
        String indentPrefix = prefix + "     ";
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_RESPONSE_CONTROL_OID.get(c.getOID()), indentPrefix, maxWidth);
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_TXN_SETTINGS_NUM_CONFLICTS.get(decoded.getNumLockConflicts()), indentPrefix, maxWidth);
        ResultUtils.wrap(lines, ToolMessages.INFO_RESULT_UTILS_TXN_SETTINGS_BACKEND_LOCK_ACQUIRED.get(decoded.backendLockAcquired()), indentPrefix, maxWidth);
    }

    private static String createPrefix(boolean comment, int indent) {
        StringBuilder buffer = new StringBuilder(indent + 2);
        if (comment) {
            buffer.append("# ");
        }
        for (int i = 0; i < indent; ++i) {
            buffer.append(' ');
        }
        return buffer.toString();
    }

    private static void wrap(List<String> lines, String s, String prefix, int maxWidth) {
        int minimumMaxWidth = prefix.length() + 20;
        int effectiveMaxWidth = Math.max(minimumMaxWidth, maxWidth);
        if (prefix.length() + s.length() <= effectiveMaxWidth) {
            lines.add(prefix + s);
            return;
        }
        List<String> wrappedLines = StaticUtils.wrapLine(s, maxWidth - prefix.length(), maxWidth - prefix.length() - 5);
        for (int i = 0; i < wrappedLines.size(); ++i) {
            if (i > 0) {
                lines.add(prefix + "     " + wrappedLines.get(i));
                continue;
            }
            lines.add(prefix + wrappedLines.get(i));
        }
    }

    private static void addLDIF(List<String> lines, Entry entry, boolean includeDN, String prefix, int maxWidth) {
        int wrapColumn = Math.max(maxWidth - prefix.length(), 20);
        if (includeDN) {
            for (String s : entry.toLDIF(wrapColumn)) {
                lines.add(prefix + s);
            }
        } else {
            String[] ldifLinesWithDN;
            if (entry.getDN().length() > 10) {
                Entry dup = entry.duplicate();
                dup.setDN("");
                ldifLinesWithDN = dup.toLDIF(wrapColumn);
            } else {
                ldifLinesWithDN = entry.toLDIF(wrapColumn);
            }
            for (int i = 1; i < ldifLinesWithDN.length; ++i) {
                lines.add(prefix + ldifLinesWithDN[i]);
            }
        }
    }
}

