/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest;

import com.sun.tdk.signaturetest.Result;
import com.sun.tdk.signaturetest.Version;
import com.sun.tdk.signaturetest.classpath.ClasspathImpl;
import com.sun.tdk.signaturetest.core.ClassDescriptionLoader;
import com.sun.tdk.signaturetest.core.ClassHierarchy;
import com.sun.tdk.signaturetest.core.Log;
import com.sun.tdk.signaturetest.core.MemberCollectionBuilder;
import com.sun.tdk.signaturetest.core.PackageGroup;
import com.sun.tdk.signaturetest.core.ThrowsNormalizer;
import com.sun.tdk.signaturetest.errors.ErrorFormatter;
import com.sun.tdk.signaturetest.model.AnnotationItem;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.plugin.Context;
import com.sun.tdk.signaturetest.plugin.Filter;
import com.sun.tdk.signaturetest.plugin.MessageTransformer;
import com.sun.tdk.signaturetest.plugin.Plugin;
import com.sun.tdk.signaturetest.plugin.PluginAPI;
import com.sun.tdk.signaturetest.plugin.Transformer;
import com.sun.tdk.signaturetest.sigfile.AnnotationParser;
import com.sun.tdk.signaturetest.sigfile.FileManager;
import com.sun.tdk.signaturetest.sigfile.Format;
import com.sun.tdk.signaturetest.util.CommandLineParser;
import com.sun.tdk.signaturetest.util.CommandLineParserException;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import com.sun.tdk.signaturetest.util.SwissKnife;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class SigTest
extends Result
implements PluginAPI,
Log {
    public static final String ALLPUBLIC_OPTION = "-AllPublic";
    public static final String CLASSPATH_OPTION = "-Classpath";
    public static final String PACKAGE_OPTION = "-Package";
    public static final String WITHOUTSUBPACKAGES_OPTION = "-PackageWithoutSubpackages";
    public static final String EXCLUDE_OPTION = "-Exclude";
    public static final String STATIC_OPTION = "-Static";
    public static final String APIVERSION_OPTION = "-ApiVersion";
    public static final String VERSION_OPTION = "-Version";
    public static final String DEBUG_OPTION = "-Debug";
    public static final String HELP_OPTION = "-Help";
    public static final String QUESTIONMARK = "-?";
    public static final String CLASSCACHESIZE_OPTION = "-ClassCacheSize";
    public static final String VERBOSE_OPTION = "-Verbose";
    public static final String XVERBOSE_OPTION = "-Xverbose";
    public static final String XNOTIGER_OPTION = "-XnoTiger";
    public static final String OUT_OPTION = "-Out";
    public static final String FORMATPLAIN_OPTION = "-FormatPlain";
    public static final String FORMATHUMAN_OPTION = "-FormatHuman";
    public static final String FORMATHUMAN_ALT_OPTION = "-H";
    public static final String BACKWARD_OPTION = "-Backward";
    public static final String BACKWARD_ALT_OPTION = "-B";
    public static final String EXTENSIBLE_INTERFACES_OPTION = "-ExtensibleInterfaces";
    public static final String FILENAME_OPTION = "-FileName";
    public static final String TESTURL_OPTION = "-TestURL";
    public static final String PLUGIN_OPTION = "-Plugin";
    public static final String ERRORALL_OPTION = "-ErrorAll";
    public static final String NOWARN = "nowarn";
    private static I18NResourceBundle i18n;
    protected String testURL = "";
    protected String sigFileNameList = null;
    protected String sigFileName = null;
    private FileManager fm = new FileManager();
    protected int trackMode;
    protected PackageGroup packages = new PackageGroup(true);
    protected PackageGroup purePackages = new PackageGroup(false);
    protected PackageGroup excludedPackages = new PackageGroup(true);
    protected String classpathStr = null;
    private ErrorFormatter errorManager;
    protected String apiVersion = "";
    protected MemberCollectionBuilder testableMCBuilder;
    protected ThrowsNormalizer normalizer = new ThrowsNormalizer();
    protected boolean isStatic = false;
    protected boolean nowarnings = false;
    private boolean isConstantValuesTracked = true;
    public static final int DefaultCacheSize = 1024;
    protected int cacheSize = 1024;
    private PrintWriter log;
    public static boolean debug;
    protected ClasspathImpl classpath;
    public static boolean isTigerFeaturesTracked;
    private static boolean isJava8;
    protected Plugin pluginClass = null;
    protected boolean isVerbose = false;
    static boolean Xverbose;
    protected ClassHierarchy testableHierarchy;
    protected Set errorMessages = new HashSet();
    private ClassDescriptionLoader loader;
    protected boolean reportWarningAsError = false;
    protected int errors;
    static /* synthetic */ Class class$com$sun$tdk$signaturetest$SigTest;
    static /* synthetic */ Class class$com$sun$tdk$signaturetest$classpath$Classpath;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$io$PrintWriter;

    protected void setErrorManager(ErrorFormatter em) {
        this.errorManager = em;
    }

    protected ErrorFormatter getErrorManager() {
        return this.errorManager;
    }

    protected boolean isConstantValuesTracked() {
        return this.isConstantValuesTracked;
    }

    protected void setConstantValuesTracked(boolean t) {
        this.isConstantValuesTracked = t;
    }

    public void initErrors() {
        this.errorMessages.clear();
    }

    public void storeError(String s, Logger utilLogger) {
        if (utilLogger != null && utilLogger.isLoggable(Level.SEVERE)) {
            utilLogger.severe(s);
        }
        this.errorMessages.add(s);
    }

    public void storeWarning(String s, Logger utilLogger) {
        if (this.reportWarningAsError) {
            this.storeError(s, utilLogger);
            return;
        }
        if (utilLogger != null && utilLogger.isLoggable(Level.WARNING)) {
            utilLogger.warning(s);
        }
        if (!this.nowarnings) {
            this.log.println(i18n.getString("SigTest.warning", s));
        }
    }

    public void printErrors() {
        Iterator it = this.errorMessages.iterator();
        while (it.hasNext()) {
            this.setupProblem((String)it.next());
        }
        this.initErrors();
    }

    protected void setupProblem(String msg) {
        this.log.println(msg);
        ++this.errors;
    }

    protected void setLog(PrintWriter w) {
        this.log = w;
    }

    public PrintWriter getLog() {
        return this.log;
    }

    protected void decodeCommonOptions(String optionName, String[] args) throws CommandLineParserException {
        if (optionName.equalsIgnoreCase(TESTURL_OPTION)) {
            this.testURL = args[0];
        } else if (optionName.equalsIgnoreCase(FILENAME_OPTION)) {
            this.sigFileName = args[0];
        } else if (optionName.equalsIgnoreCase(PACKAGE_OPTION)) {
            this.packages.addPackages(CommandLineParser.parseListOption(args));
        } else if (optionName.equalsIgnoreCase(WITHOUTSUBPACKAGES_OPTION)) {
            this.purePackages.addPackages(CommandLineParser.parseListOption(args));
        } else if (optionName.equalsIgnoreCase(EXCLUDE_OPTION)) {
            this.excludedPackages.addPackages(CommandLineParser.parseListOption(args));
        } else if (optionName.equalsIgnoreCase(CLASSPATH_OPTION)) {
            this.classpathStr = args[0];
        } else if (optionName.equalsIgnoreCase(APIVERSION_OPTION)) {
            this.apiVersion = args[0];
        } else if (optionName.equalsIgnoreCase(STATIC_OPTION)) {
            this.isStatic = true;
        } else if (optionName.equalsIgnoreCase(CLASSCACHESIZE_OPTION)) {
            this.cacheSize = 0;
            try {
                this.cacheSize = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException ex) {
                if (debug) {
                    SwissKnife.reportThrowable(ex);
                }
                this.cacheSize = 0;
            }
            if (this.cacheSize <= 0) {
                throw new CommandLineParserException(i18n.getString("SigTest.error.arg.invalid", optionName));
            }
        } else if (optionName.equalsIgnoreCase(ALLPUBLIC_OPTION)) {
            this.trackMode = 2;
        } else if (optionName.equalsIgnoreCase(DEBUG_OPTION)) {
            debug = true;
        } else if (optionName.equalsIgnoreCase(ERRORALL_OPTION)) {
            this.reportWarningAsError = true;
        } else if (optionName.equalsIgnoreCase(XNOTIGER_OPTION)) {
            isTigerFeaturesTracked = false;
        } else if (optionName.equalsIgnoreCase(XVERBOSE_OPTION)) {
            Xverbose = true;
        } else if (optionName.equalsIgnoreCase(VERBOSE_OPTION)) {
            if (args.length > 0) {
                if (args[0].equalsIgnoreCase(NOWARN)) {
                    this.nowarnings = true;
                }
            } else {
                this.isVerbose = true;
            }
        } else if (optionName.equalsIgnoreCase(PLUGIN_OPTION)) {
            this.pluginClass = this.loadPlugin(args[0]);
            if (this.pluginClass == null) {
                throw new CommandLineParserException(i18n.getString("SigTest.error.cant_load.plugin", args[0]));
            }
        } else if (optionName.equalsIgnoreCase(HELP_OPTION) || optionName.equalsIgnoreCase(QUESTIONMARK)) {
            this.usage();
        } else if (optionName.equalsIgnoreCase(VERSION_OPTION)) {
            System.err.println(Version.getVersionInfo());
        }
    }

    public int getNumErrors() {
        return this.errorManager.getNumErrors();
    }

    public int getNumWarnings() {
        return this.errorManager.getNumWarnings();
    }

    protected boolean isPackageMember(String name) {
        return !this.excludedPackages.checkName(name) && (this.packages.checkName(name) || this.purePackages.checkName(name));
    }

    public void setClassDescrLoader(ClassDescriptionLoader loader) {
        this.loader = loader;
    }

    protected ClassDescriptionLoader getClassDescrLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        if (this.isStatic) {
            this.loader = SigTest.getLoader("com.sun.tdk.signaturetest.loaders.BinaryClassDescrLoader", new Class[]{class$com$sun$tdk$signaturetest$classpath$Classpath == null ? (class$com$sun$tdk$signaturetest$classpath$Classpath = SigTest.class$("com.sun.tdk.signaturetest.classpath.Classpath")) : class$com$sun$tdk$signaturetest$classpath$Classpath, class$java$lang$Integer == null ? (class$java$lang$Integer = SigTest.class$("java.lang.Integer")) : class$java$lang$Integer}, new Object[]{this.classpath, new Integer(this.cacheSize)}, this.getLog());
            if (this.loader == null) {
                throw new LinkageError(i18n.getString("SigTest.error.mgr.linkerr.loadstatic"));
            }
        } else {
            if (isJava8) {
                this.loader = SigTest.getLoader("com.sun.tdk.signaturetest.loaders.J8RefLoader", new Class[0], new Object[0], this.getLog());
                if (this.loader != null) {
                    return this.loader;
                }
            }
            if (isTigerFeaturesTracked) {
                this.loader = SigTest.getLoader("com.sun.tdk.signaturetest.loaders.TigerRefgClassDescrLoader", new Class[0], new Object[0], this.getLog());
                if (this.loader != null) {
                    return this.loader;
                }
                isTigerFeaturesTracked = false;
            }
            this.loader = SigTest.getLoader("com.sun.tdk.signaturetest.loaders.ReflClassDescrLoader", new Class[0], new Object[0], this.getLog());
            if (this.loader == null) {
                throw new LinkageError(i18n.getString("SigTest.error.mgr.linkerr.loadreflect"));
            }
        }
        return this.loader;
    }

    protected ClassDescription load(String name) {
        try {
            return this.testableHierarchy.load(name);
        }
        catch (ClassNotFoundException e) {
            if (debug) {
                SwissKnife.reportThrowable(e);
            }
            this.storeError(i18n.getString("SigTest.error.class.missing", name), null);
        }
        catch (LinkageError e) {
            if (debug) {
                SwissKnife.reportThrowable(e);
            }
            this.storeError(i18n.getString("SigTest.error.class.notlinked", e.getMessage()), null);
        }
        return null;
    }

    private static ClassDescriptionLoader getLoader(String name, Class[] pars, Object[] args, PrintWriter log) {
        try {
            Constructor<?> ctor = Class.forName(name).getConstructor(pars);
            ClassDescriptionLoader cl = (ClassDescriptionLoader)ctor.newInstance(args);
            try {
                Method setLog = cl.getClass().getDeclaredMethod("setLog", class$java$io$PrintWriter == null ? (class$java$io$PrintWriter = SigTest.class$("java.io.PrintWriter")) : class$java$io$PrintWriter);
                setLog.invoke((Object)cl, log);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            return cl;
        }
        catch (Throwable t) {
            if (debug) {
                SwissKnife.reportThrowable(t);
            }
            return null;
        }
    }

    public boolean useErasurator() {
        return !isTigerFeaturesTracked;
    }

    protected abstract void usage();

    protected abstract String getComponentName();

    protected Plugin loadPlugin(String pluginClassName) {
        try {
            Constructor<?> ctor = Class.forName(pluginClassName).getConstructor(new Class[0]);
            return (Plugin)ctor.newInstance(new Object[0]);
        }
        catch (Throwable t) {
            if (debug) {
                SwissKnife.reportThrowable(t);
            }
            return null;
        }
    }

    public Filter getFilter(PluginAPI.InjectionPoint injectionPoint) {
        return injectionPoint.getFilter();
    }

    public void setFilter(PluginAPI.InjectionPoint injectionPoint, Filter filter) {
        injectionPoint.setFilter(filter);
    }

    public Transformer getTransformer(PluginAPI.InjectionPoint injectionPoint) {
        return injectionPoint.getTransformer();
    }

    public void setTransformer(PluginAPI.InjectionPoint injectionPoint, Transformer transformer) {
        injectionPoint.setTransformer(transformer);
    }

    public void setMessageTransformer(PluginAPI.InjectionPoint injectionPoint, MessageTransformer messageTransformer) {
        injectionPoint.setMessageTransformer(messageTransformer);
    }

    protected boolean addInherited() {
        return true;
    }

    public Context getContext() {
        throw new UnsupportedOperationException("This method is not implemented");
    }

    public void addFormat(Format format, boolean useByDefault) {
        this.getFileManager().addFormat(format, useByDefault);
    }

    public void setFormat(Format format) {
        this.getFileManager().setFormat(format);
    }

    protected AnnotationItem[] removeUndocumentedAnnotations(AnnotationItem[] annotations, ClassHierarchy h) {
        if (annotations == null) {
            return AnnotationItem.EMPTY_ANNOTATIONITEM_ARRAY;
        }
        int len = annotations.length;
        AnnotationItem[] tempStorage = new AnnotationItem[len];
        if (len == 0) {
            return annotations;
        }
        int count = 0;
        int i = 0;
        while (i < len) {
            boolean documented = true;
            try {
                documented = h.isDocumentedAnnotation(annotations[i].getName());
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (documented) {
                tempStorage[count++] = annotations[i];
            }
            ++i;
        }
        if (count == len) {
            return annotations;
        }
        AnnotationItem[] documentedAnnotations = AnnotationItem.EMPTY_ANNOTATIONITEM_ARRAY;
        if (count != 0) {
            documentedAnnotations = new AnnotationItem[count];
            System.arraycopy(tempStorage, 0, documentedAnnotations, 0, count);
        }
        return documentedAnnotations;
    }

    protected AnnotationItem[] unpackContainerAnnotations(AnnotationItem[] annotations, ClassHierarchy ch) {
        ArrayList<AnnotationItem> unpackedAnnotations = new ArrayList<AnnotationItem>();
        ArrayList<AnnotationItem> toRemove = new ArrayList<AnnotationItem>();
        AnnotationParser ap = new AnnotationParser();
        int i = 0;
        while (i < annotations.length) {
            try {
                List newAnns;
                AnnotationItem.Member memval;
                AnnotationItem ai = annotations[i];
                unpackedAnnotations.add(ai);
                if (ch.isContainerAnnotation(ai.getName()) && (memval = ai.findByName("value")) != null && (newAnns = ap.unpack(memval.value)) != null && newAnns.size() > 0) {
                    unpackedAnnotations.addAll(newAnns);
                    toRemove.add(ai);
                }
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
            ++i;
        }
        unpackedAnnotations.removeAll(toRemove);
        return unpackedAnnotations.toArray(new AnnotationItem[0]);
    }

    protected AnnotationItem[] normalizeArrayParaemeters(AnnotationItem[] annotations, Set exclusions, ClassHierarchy ch) {
        int i = 0;
        while (i < annotations.length) {
            try {
                if (!ch.isContainerAnnotation(annotations[i].getName())) {
                    AnnotationItem.normaliazeAnnotation(annotations[i], exclusions);
                }
            }
            catch (ClassNotFoundException ex) {
                AnnotationItem.normaliazeAnnotation(annotations[i], exclusions);
            }
            ++i;
        }
        return annotations;
    }

    protected FileManager getFileManager() {
        return this.fm;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ALLPUBLIC_OPTION = ALLPUBLIC_OPTION;
        CLASSPATH_OPTION = CLASSPATH_OPTION;
        PACKAGE_OPTION = PACKAGE_OPTION;
        WITHOUTSUBPACKAGES_OPTION = WITHOUTSUBPACKAGES_OPTION;
        EXCLUDE_OPTION = EXCLUDE_OPTION;
        STATIC_OPTION = STATIC_OPTION;
        APIVERSION_OPTION = APIVERSION_OPTION;
        VERSION_OPTION = VERSION_OPTION;
        DEBUG_OPTION = DEBUG_OPTION;
        HELP_OPTION = HELP_OPTION;
        QUESTIONMARK = QUESTIONMARK;
        CLASSCACHESIZE_OPTION = CLASSCACHESIZE_OPTION;
        VERBOSE_OPTION = VERBOSE_OPTION;
        XVERBOSE_OPTION = XVERBOSE_OPTION;
        XNOTIGER_OPTION = XNOTIGER_OPTION;
        OUT_OPTION = OUT_OPTION;
        FORMATPLAIN_OPTION = FORMATPLAIN_OPTION;
        FORMATHUMAN_OPTION = FORMATHUMAN_OPTION;
        FORMATHUMAN_ALT_OPTION = FORMATHUMAN_ALT_OPTION;
        BACKWARD_OPTION = BACKWARD_OPTION;
        BACKWARD_ALT_OPTION = BACKWARD_ALT_OPTION;
        EXTENSIBLE_INTERFACES_OPTION = EXTENSIBLE_INTERFACES_OPTION;
        FILENAME_OPTION = FILENAME_OPTION;
        TESTURL_OPTION = TESTURL_OPTION;
        PLUGIN_OPTION = PLUGIN_OPTION;
        ERRORALL_OPTION = ERRORALL_OPTION;
        NOWARN = NOWARN;
        i18n = I18NResourceBundle.getBundleForClass(class$com$sun$tdk$signaturetest$SigTest == null ? (class$com$sun$tdk$signaturetest$SigTest = SigTest.class$("com.sun.tdk.signaturetest.SigTest")) : class$com$sun$tdk$signaturetest$SigTest);
        DefaultCacheSize = 1024;
        debug = false;
        isTigerFeaturesTracked = false;
        isJava8 = false;
        try {
            String specVersion = System.getProperty("java.specification.version");
            if ("1.5".compareTo(specVersion) <= 0) {
                isTigerFeaturesTracked = true;
            }
            if ("1.8".compareTo(specVersion) <= 0) {
                isTigerFeaturesTracked = true;
                isJava8 = true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        Xverbose = false;
    }
}

