/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.page;

import jakarta.data.page.PageRequestCursor;
import jakarta.data.page.Pagination;
import java.util.List;
import java.util.Optional;

public interface PageRequest {
    public static PageRequest ofPage(long pageNumber) {
        return new Pagination(pageNumber, 10, Mode.OFFSET, null, true);
    }

    public static PageRequest ofPage(long pageNumber, int maxPageSize, boolean requestTotal) {
        return new Pagination(pageNumber, maxPageSize, Mode.OFFSET, null, requestTotal);
    }

    public static PageRequest ofSize(int maxPageSize) {
        return new Pagination(1L, maxPageSize, Mode.OFFSET, null, true);
    }

    public static PageRequest afterCursor(Cursor cursor, long pageNumber, int maxPageSize, boolean requestTotal) {
        return new Pagination(pageNumber, maxPageSize, Mode.CURSOR_NEXT, cursor, requestTotal);
    }

    public static PageRequest beforeCursor(Cursor cursor, long pageNumber, int maxPageSize, boolean requestTotal) {
        return new Pagination(pageNumber, maxPageSize, Mode.CURSOR_PREVIOUS, cursor, requestTotal);
    }

    public PageRequest afterCursor(Cursor var1);

    public PageRequest beforeCursor(Cursor var1);

    public boolean equals(Object var1);

    public Optional<Cursor> cursor();

    public Mode mode();

    public long page();

    public int size();

    public boolean requestTotal();

    public PageRequest size(int var1);

    public PageRequest withoutTotal();

    public PageRequest withTotal();

    public static enum Mode {
        CURSOR_NEXT,
        CURSOR_PREVIOUS,
        OFFSET;

    }

    public static interface Cursor {
        public boolean equals(Object var1);

        public Object get(int var1);

        public int hashCode();

        public int size();

        public List<?> elements();

        public String toString();

        public static Cursor forKey(Object ... key) {
            return new PageRequestCursor(key);
        }
    }
}

