/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class EnvironmentVariableAliases {
    private static final Pattern DISALLOWED_CHARS = Pattern.compile("[^a-zA-Z0-9_]");
    private static final Pattern DISALLOWED_CHARS_ALLOW_DASH = Pattern.compile("[^a-zA-Z0-9_\\-]");
    private static final Pattern DASH_PATTERN = Pattern.compile("-", 16);
    private static final String DASH_ENCODING = "_dash_";
    private static final String UNDERSCORE = "_";
    private static final char DASH_CHAR = '-';

    public static List<String> aliasesOf(String key) {
        if (key != null && !key.isEmpty()) {
            if (key.indexOf(45) < 0) {
                String alias = DISALLOWED_CHARS.matcher(key).replaceAll(UNDERSCORE);
                if (alias.equals(key)) {
                    return Collections.singletonList(alias.toUpperCase());
                }
                return Arrays.asList(alias, alias.toUpperCase());
            }
            String baseAlias = DISALLOWED_CHARS_ALLOW_DASH.matcher(key).replaceAll(UNDERSCORE);
            String aliasLowerDash = DASH_PATTERN.matcher(baseAlias).replaceAll(DASH_ENCODING);
            String upperBaseAlias = baseAlias.toUpperCase();
            String upperAliasLowerDash = DASH_PATTERN.matcher(upperBaseAlias).replaceAll(DASH_ENCODING);
            String upperAliasUpperDash = upperAliasLowerDash.toUpperCase();
            return Arrays.asList(aliasLowerDash, upperAliasLowerDash, upperAliasUpperDash);
        }
        return Collections.emptyList();
    }

    private EnvironmentVariableAliases() {
    }
}

