/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.security;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.mvc.Controller;
import jakarta.mvc.security.CsrfProtected;
import jakarta.mvc.security.CsrfValidationException;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.krazo.KrazoConfig;
import org.eclipse.krazo.core.Messages;
import org.eclipse.krazo.security.CsrfToken;
import org.eclipse.krazo.security.CsrfTokenManager;
import org.eclipse.krazo.security.FormEntityProvider;
import org.eclipse.krazo.util.AnnotationUtils;
import org.eclipse.krazo.util.ServiceLoaders;

@Controller
@Priority(value=3000)
public class CsrfValidateFilter
implements ContainerRequestFilter {
    @Inject
    private CsrfTokenManager csrfTokenManager;
    @Inject
    private KrazoConfig krazoConfig;
    @Context
    private ResourceInfo resourceInfo;
    @Inject
    private Messages messages;
    private final FormEntityProvider formEntityProvider = ServiceLoaders.list(FormEntityProvider.class).get(0);

    public void filter(ContainerRequestContext context) throws IOException {
        Method controller = this.resourceInfo.getResourceMethod();
        if (this.needsValidation(controller)) {
            CsrfToken token = this.csrfTokenManager.getToken().orElseThrow(() -> new CsrfValidationException(this.messages.get("CsrfFailed", "missing token")));
            String csrfToken = (String)context.getHeaders().getFirst((Object)token.getHeaderName());
            if (token.getValue().equals(csrfToken)) {
                return;
            }
            MediaType contentType = context.getMediaType();
            if (!CsrfValidateFilter.isSupportedMediaType(contentType) || !context.hasEntity()) {
                throw new CsrfValidationException(this.messages.get("UnableValidateCsrf", context.getMediaType()));
            }
            Form form = this.formEntityProvider.getForm(context);
            List tokenValues = (List)form.asMap().get((Object)token.getParamName());
            if (tokenValues == null || tokenValues.isEmpty()) {
                throw new CsrfValidationException(this.messages.get("CsrfFailed", "missing field"));
            }
            if (!token.getValue().equals(tokenValues.get(0))) {
                throw new CsrfValidationException(this.messages.get("CsrfFailed", "mismatching tokens"));
            }
        }
    }

    protected static boolean isSupportedMediaType(MediaType contentType) {
        return contentType != null && contentType.isCompatible(MediaType.APPLICATION_FORM_URLENCODED_TYPE);
    }

    private boolean needsValidation(Method controller) {
        if (controller == null || !this.performsWriteAccess(controller)) {
            return false;
        }
        switch (this.krazoConfig.getCsrfOptions()) {
            case OFF: {
                return false;
            }
            case IMPLICIT: {
                return true;
            }
            case EXPLICIT: {
                return AnnotationUtils.hasAnnotation(controller, CsrfProtected.class) || AnnotationUtils.hasAnnotation(controller.getDeclaringClass(), CsrfProtected.class);
            }
        }
        return false;
    }

    private boolean performsWriteAccess(Method controller) {
        return AnnotationUtils.hasAnnotation(controller, POST.class) || AnnotationUtils.hasAnnotation(controller, PATCH.class) || AnnotationUtils.hasAnnotation(controller, PUT.class) || AnnotationUtils.hasAnnotation(controller, DELETE.class);
    }
}

