/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.microprofile.restclient;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.ws.rs.ext.ParamConverterProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.microprofile.rest.client.ext.AsyncInvocationInterceptorFactory;
import org.eclipse.microprofile.rest.client.ext.ResponseExceptionMapper;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.microprofile.restclient.InboundHeadersProvider;

class RestClientContext {
    private final Class<?> restClientClass;
    private final Set<ResponseExceptionMapper<?>> responseExceptionMappers;
    private final Set<ParamConverterProvider> paramConverterProviders;
    private final Set<InboundHeadersProvider> inboundHeadersProviders;
    private final List<AsyncInvocationInterceptorFactory> asyncInterceptorFactories;
    private final InjectionManager injectionManager;
    private final BeanManager beanManager;

    RestClientContext(Builder builder) {
        this.restClientClass = builder.restClientClass;
        this.responseExceptionMappers = builder.responseExceptionMappers;
        this.paramConverterProviders = builder.paramConverterProviders;
        this.inboundHeadersProviders = builder.inboundHeadersProviders;
        this.asyncInterceptorFactories = builder.asyncInterceptorFactories;
        this.injectionManager = builder.injectionManager;
        this.beanManager = builder.beanManager;
    }

    static Builder builder(Class<?> restClientClass) {
        return new Builder(restClientClass);
    }

    Class<?> restClientClass() {
        return this.restClientClass;
    }

    Set<ResponseExceptionMapper<?>> responseExceptionMappers() {
        return this.responseExceptionMappers;
    }

    Set<ParamConverterProvider> paramConverterProviders() {
        return this.paramConverterProviders;
    }

    Set<InboundHeadersProvider> inboundHeadersProviders() {
        return this.inboundHeadersProviders;
    }

    List<AsyncInvocationInterceptorFactory> asyncInterceptorFactories() {
        return this.asyncInterceptorFactories;
    }

    InjectionManager injectionManager() {
        return this.injectionManager;
    }

    BeanManager beanManager() {
        return this.beanManager;
    }

    static class Builder {
        private final Class<?> restClientClass;
        private Set<ResponseExceptionMapper<?>> responseExceptionMappers = Collections.emptySet();
        private Set<ParamConverterProvider> paramConverterProviders = Collections.emptySet();
        private Set<InboundHeadersProvider> inboundHeadersProviders = Collections.emptySet();
        private List<AsyncInvocationInterceptorFactory> asyncInterceptorFactories = Collections.emptyList();
        private InjectionManager injectionManager;
        private BeanManager beanManager;

        private Builder(Class<?> restClientClass) {
            this.restClientClass = Objects.requireNonNull(restClientClass);
        }

        Builder copyFrom(RestClientContext context) {
            this.responseExceptionMappers = context.responseExceptionMappers;
            this.paramConverterProviders = context.paramConverterProviders;
            this.inboundHeadersProviders = context.inboundHeadersProviders;
            this.asyncInterceptorFactories = context.asyncInterceptorFactories;
            this.injectionManager = context.injectionManager;
            this.beanManager = context.beanManager;
            return this;
        }

        Builder responseExceptionMappers(Set<ResponseExceptionMapper<?>> responseExceptionMappers) {
            this.responseExceptionMappers = new HashSet(responseExceptionMappers);
            return this;
        }

        Builder paramConverterProviders(Set<ParamConverterProvider> paramConverterProviders) {
            this.paramConverterProviders = new HashSet<ParamConverterProvider>(paramConverterProviders);
            return this;
        }

        Builder inboundHeadersProviders(Set<InboundHeadersProvider> inboundHeadersProviders) {
            this.inboundHeadersProviders = new HashSet<InboundHeadersProvider>(inboundHeadersProviders);
            return this;
        }

        Builder asyncInterceptorFactories(List<AsyncInvocationInterceptorFactory> asyncInterceptorFactories) {
            this.asyncInterceptorFactories = new ArrayList<AsyncInvocationInterceptorFactory>(asyncInterceptorFactories);
            return this;
        }

        Builder injectionManager(InjectionManager injectionManager) {
            this.injectionManager = injectionManager;
            return this;
        }

        Builder beanManager(BeanManager beanManager) {
            this.beanManager = beanManager;
            return this;
        }

        RestClientContext build() {
            return new RestClientContext(this);
        }
    }
}

