/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee.authentication.jakarta.callback;

import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.ssl.SSLUtils;
import com.sun.enterprise.security.store.PasswordAdapter;
import com.sun.enterprise.server.pluggable.SecuritySupport;
import com.sun.logging.LogDomains;
import jakarta.security.auth.message.callback.SecretKeyCallback;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import org.glassfish.epicyro.config.helper.BaseCallbackHandler;
import org.glassfish.internal.api.Globals;
import org.glassfish.security.common.MasterPassword;

public abstract class GlassFishBaseCallbackHandler
extends BaseCallbackHandler {
    private static final Logger LOG = LogDomains.getLogger(GlassFishBaseCallbackHandler.class, (String)"jakarta.enterprise.system.core.security", (boolean)false);
    private static final String CLIENT_SECRET_KEYSTORE = "com.sun.appserv.client.secretKeyStore";
    private static final String CLIENT_SECRET_KEYSTORE_PASSWORD = "com.sun.appserv.client.secretKeyStorePassword";
    protected final SSLUtils sslUtils = (SSLUtils)Globals.get(SSLUtils.class);
    protected final SecuritySupport securitySupport = (SecuritySupport)Globals.get(SecuritySupport.class);
    protected final MasterPassword masterPasswordHelper = (MasterPassword)Globals.getDefaultHabitat().getService(MasterPassword.class, "Security SSL Password Provider Service", new Annotation[0]);

    protected GlassFishBaseCallbackHandler() {
    }

    protected KeyStore getTrustStore() {
        return this.sslUtils.getMergedTrustStore();
    }

    protected KeyStore[] getKeyStores() {
        return this.securitySupport.getKeyStores();
    }

    protected PrivateKey getPrivateKeyForAlias(String alias, int keystoreIndex) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.securitySupport.getPrivateKeyForAlias(alias, keystoreIndex);
    }

    protected KeyStore.PrivateKeyEntry getPrivateKeyEntryFromTokenAlias(String certNickname) throws Exception {
        return this.sslUtils.getPrivateKeyEntryFromTokenAlias(certNickname);
    }

    protected SecretKey getPasswordSecretKeyForAlias(String alias) throws GeneralSecurityException {
        PasswordAdapter passwordAdapter = null;
        try {
            passwordAdapter = SecurityServicesUtil.getInstance().isACC() ? new PasswordAdapter(System.getProperty(CLIENT_SECRET_KEYSTORE), System.getProperty(CLIENT_SECRET_KEYSTORE_PASSWORD).toCharArray()) : this.masterPasswordHelper.getMasterPasswordAdapter();
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
        return passwordAdapter.getPasswordSecretKeyForAlias(alias);
    }

    protected void processSecretKey(SecretKeyCallback secretKeyCallback) {
        LOG.log(Level.FINE, "Jakarta Authentication: In SecretKeyCallback Processor");
        String alias = ((SecretKeyCallback.AliasRequest)secretKeyCallback.getRequest()).getAlias();
        if (alias != null) {
            try {
                PasswordAdapter passwordAdapter = null;
                passwordAdapter = SecurityServicesUtil.getInstance().isACC() ? new PasswordAdapter(System.getProperty(CLIENT_SECRET_KEYSTORE), System.getProperty(CLIENT_SECRET_KEYSTORE_PASSWORD).toCharArray()) : this.masterPasswordHelper.getMasterPasswordAdapter();
                secretKeyCallback.setKey(passwordAdapter.getPasswordSecretKeyForAlias(alias));
            }
            catch (Exception e) {
                LOG.log(Level.FINE, e, () -> "Jakarta Authentication: In SecretKeyCallback Processor:  Error reading key ! for alias " + alias);
                secretKeyCallback.setKey(null);
            }
        } else {
            secretKeyCallback.setKey(null);
            LOG.log(Level.WARNING, "No support to read Principals in SecretKeyCallback.");
        }
    }
}

