/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.event;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.api.event.EventListener;

public final class EventTypes<T> {
    private static final Map<String, EventTypes<?>> EVENTS = new ConcurrentHashMap();
    public static final String SERVER_STARTUP_NAME = "server_startup";
    public static final String SERVER_READY_NAME = "server_ready";
    public static final String PREPARE_SHUTDOWN_NAME = "prepare_shutdown";
    public static final String SERVER_SHUTDOWN_NAME = "server_shutdown";
    public static final EventTypes<?> SERVER_STARTUP = EventTypes.create("server_startup");
    public static final EventTypes<?> SERVER_READY = EventTypes.create("server_ready");
    public static final EventTypes<?> SERVER_SHUTDOWN = EventTypes.create("server_shutdown");
    public static final EventTypes<?> PREPARE_SHUTDOWN = EventTypes.create("prepare_shutdown");
    private final String name;
    private final Class<T> hookType;

    private EventTypes(String name, Class<T> hookType) {
        this.name = name;
        this.hookType = hookType;
    }

    public static EventTypes<?> create(String name) {
        return EventTypes.create(name, null);
    }

    public static <T> EventTypes<T> create(String name, Class<T> hookType) {
        return EVENTS.computeIfAbsent(name, key -> new EventTypes((String)key, hookType));
    }

    public String type() {
        return this.name;
    }

    public Class<T> getHookType() {
        return this.hookType;
    }

    public T getHook(EventListener.Event<T> event) {
        if (event.is(this)) {
            return event.hook();
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EventTypes)) {
            return false;
        }
        return this.name.equals(((EventTypes)obj).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

