/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.services;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.glassfish.epicyro.config.helper.Caller;
import org.glassfish.epicyro.config.helper.CallerPrincipal;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class InMemoryStore {
    private static final System.Logger LOG = System.getLogger(InMemoryStore.class.getName());
    private static final Map<String, Credential> CALLER_TO_CREDENTIALS = new ConcurrentHashMap<String, Credential>();

    public static void initFromString(String callersAsXml) {
        if (InMemoryStore.isEmpty(callersAsXml)) {
            return;
        }
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            NodeList nodes = (NodeList)xPath.evaluate("//caller", DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(callersAsXml.getBytes())), XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                NamedNodeMap callerAttributes = nodes.item(i).getAttributes();
                String caller = callerAttributes.getNamedItem("callername").getNodeValue();
                String password = callerAttributes.getNamedItem("password").getNodeValue();
                String groups = callerAttributes.getNamedItem("groups").getNodeValue();
                InMemoryStore.addCredential(caller, password, Arrays.asList(groups.split(",")));
            }
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            LOG.log(System.Logger.Level.WARNING, "Unable to get caller credentials", (Throwable)e);
        }
    }

    public static Map<String, Credential> getCALLER_TO_CREDENTIALS() {
        return CALLER_TO_CREDENTIALS;
    }

    public static void addCredential(String callerName, String password, List<String> groups) {
        InMemoryStore.addCredential(new Credential(callerName, password, groups));
    }

    public static void addCredential(Credential credential) {
        CALLER_TO_CREDENTIALS.put(credential.getCallerName(), credential);
    }

    public static Caller validate(String callerName, String password) {
        if (callerName == null) {
            return null;
        }
        Credential credential = CALLER_TO_CREDENTIALS.get(callerName);
        if (credential != null && password != null && password.equals(credential.getPassword())) {
            return new Caller(new CallerPrincipal(credential.getCallerName()), new HashSet<String>(credential.getGroups()));
        }
        return null;
    }

    public static Set<String> getCallerGroups(String callerName) {
        Credential credentials = CALLER_TO_CREDENTIALS.get(callerName);
        return credentials != null ? new HashSet<String>(credentials.getGroups()) : Collections.emptySet();
    }

    private static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static class Credential {
        private final String callerName;
        private final String password;
        private final List<String> groups;

        public Credential(String callerName, String password, List<String> groups) {
            this.callerName = callerName;
            this.password = password;
            this.groups = groups;
        }

        public String getCallerName() {
            return this.callerName;
        }

        public String getPassword() {
            return this.password;
        }

        public List<String> getGroups() {
            return this.groups;
        }
    }
}

