/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.EventMetadata;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import org.jboss.weld.util.collections.ImmutableSet;

public final class EventMetadataImpl
implements EventMetadata {
    private final Type type;
    private final InjectionPoint injectionPoint;
    private final Set<Annotation> qualifiers;
    private final Annotation[] qualifierArray;

    public EventMetadataImpl(Type type, InjectionPoint injectionPoint, Set<Annotation> qualifiers) {
        this(type, injectionPoint, qualifiers, null);
    }

    public EventMetadataImpl(Type type, InjectionPoint injectionPoint, Annotation[] qualifiers) {
        this(type, injectionPoint, null, qualifiers);
    }

    private EventMetadataImpl(Type type, InjectionPoint injectionPoint, Set<Annotation> qualifiers, Annotation[] qualifierArray) {
        this.type = type;
        this.injectionPoint = injectionPoint;
        this.qualifiers = qualifiers;
        this.qualifierArray = qualifierArray;
    }

    public Set<Annotation> getQualifiers() {
        ImmutableSet.Builder<Object> builder = ImmutableSet.builder();
        builder.add(Any.Literal.INSTANCE);
        if (this.qualifiers != null && this.qualifiers.isEmpty() || this.qualifierArray != null && this.qualifierArray.length == 0) {
            builder.add(Default.Literal.INSTANCE);
        }
        if (this.qualifiers != null) {
            return builder.addAll((Iterable<Object>)this.qualifiers).build();
        }
        if (this.qualifierArray != null) {
            return builder.addAll(this.qualifierArray).build();
        }
        throw new IllegalStateException();
    }

    public InjectionPoint getInjectionPoint() {
        return this.injectionPoint;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return "EventMetadataImpl [type=" + String.valueOf(this.type) + ", qualifiers=" + String.valueOf(this.qualifiers) + ", injectionPoint=" + String.valueOf(this.injectionPoint) + "]";
    }
}

