/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.mgmt.transport.buffers;

import com.sun.enterprise.mgmt.transport.buffers.Buffer;
import java.io.IOException;
import java.io.InputStream;

public class BufferInputStream
extends InputStream {
    private final Buffer buffer;

    public BufferInputStream(Buffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public int read() throws IOException {
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int length = Math.min(len, this.available());
        this.buffer.get(b, off, length);
        return length;
    }

    @Override
    public int available() throws IOException {
        return this.buffer.remaining();
    }

    @Override
    public long skip(long n) throws IOException {
        int skipped = (int)Math.min(n, (long)this.available());
        this.buffer.position(this.buffer.position() + skipped);
        return skipped;
    }
}

