/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;

public class ReEncodedInputStream
extends InputStream {
    private static final int BUFFERED_CHAR_LEN = 1024;
    private Reader reader_;
    private char[] decodedBuffer_;
    private OutputStreamWriter encodedStreamWriter_;
    private PublicBufferOutputStream encodedOutputStream_;
    private ByteArrayInputStream encodedInputStream_;

    public ReEncodedInputStream(Reader reader) throws IOException {
        this.reader_ = reader;
        this.decodedBuffer_ = new char[1024];
        this.encodedOutputStream_ = new PublicBufferOutputStream(3072);
        this.encodedStreamWriter_ = new OutputStreamWriter((OutputStream)this.encodedOutputStream_, "UTF8");
        this.encodedInputStream_ = this.reEncode(this.reader_);
    }

    private ByteArrayInputStream reEncode(Reader reader) throws IOException {
        int n;
        while ((n = reader.read(this.decodedBuffer_, 0, 1024)) == 0) {
        }
        if (n < 0) {
            return null;
        }
        this.encodedOutputStream_.reset();
        this.encodedStreamWriter_.write(this.decodedBuffer_, 0, n);
        this.encodedStreamWriter_.flush();
        int n2 = this.encodedOutputStream_.size();
        return new ByteArrayInputStream(this.encodedOutputStream_.getBuffer(), 0, n2);
    }

    @Override
    public int available() throws IOException {
        if (this.encodedInputStream_ == null) {
            return 0;
        }
        return this.encodedInputStream_.available();
    }

    @Override
    public void close() throws IOException {
        if (this.encodedInputStream_ != null) {
            this.encodedInputStream_.close();
            this.encodedInputStream_ = null;
        }
        if (this.reader_ != null) {
            this.reader_.close();
            this.reader_ = null;
        }
        if (this.encodedStreamWriter_ != null) {
            this.encodedStreamWriter_.close();
            this.encodedStreamWriter_ = null;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.encodedInputStream_ == null) {
            return -1;
        }
        int n = this.encodedInputStream_.read();
        if (n > -1) {
            return n;
        }
        this.encodedInputStream_ = this.reEncode(this.reader_);
        if (this.encodedInputStream_ == null) {
            return -1;
        }
        return this.encodedInputStream_.read();
    }

    protected void finalize() throws IOException {
        this.close();
    }

    private static class PublicBufferOutputStream
    extends ByteArrayOutputStream {
        PublicBufferOutputStream(int n) {
            super(n);
        }

        public byte[] getBuffer() {
            return this.buf;
        }
    }
}

