/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.accesslog;

import com.sun.enterprise.web.accesslog.AccessLogFormatter;
import com.sun.enterprise.web.accesslog.AccessLogPattern;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.nio.CharBuffer;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Request;
import org.apache.catalina.Response;

public class CommonAccessLogFormatterImpl
extends AccessLogFormatter {
    protected static final String NULL_VALUE = "-";

    public CommonAccessLogFormatterImpl() {
        super(CommonAccessLogFormatterImpl.getAccessLogPattern());
    }

    @Override
    public void appendLogEntry(Request request, Response response, CharBuffer charBuffer) {
        ServletRequest req = request.getRequest();
        HttpServletRequest hreq = (HttpServletRequest)req;
        this.appendClientName(charBuffer, req);
        charBuffer.put(' ');
        this.appendClientId(charBuffer, req);
        charBuffer.put(' ');
        this.appendAuthUserName(charBuffer, hreq);
        charBuffer.put(' ');
        this.appendCurrentDate(charBuffer);
        charBuffer.put(' ');
        this.appendRequestInfo(charBuffer, hreq);
        charBuffer.put(' ');
        this.appendResponseStatus(charBuffer, response);
        charBuffer.put(' ');
        this.appendResponseLength(charBuffer, response);
        charBuffer.put(' ');
    }

    private static AccessLogPattern getAccessLogPattern() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("dd/LLL/uuuu:HH:mm:ss Z", Locale.ENGLISH).withZone(ZoneId.systemDefault());
        AccessLogPattern pattern = new AccessLogPattern(dateTimeFormatter, false, null);
        return pattern;
    }

    private void appendClientName(CharBuffer cb, ServletRequest req) {
        String value = req.getRemoteHost();
        if (value == null) {
            value = NULL_VALUE;
        }
        cb.put(value);
    }

    private void appendClientId(CharBuffer cb, ServletRequest req) {
        cb.put(NULL_VALUE);
    }

    private void appendAuthUserName(CharBuffer cb, HttpServletRequest hreq) {
        String user = hreq.getRemoteUser();
        if (user == null) {
            user = NULL_VALUE;
        }
        cb.put(user);
    }

    private void appendCurrentDate(CharBuffer cb) {
        cb.put("[");
        cb.put(this.getPattern().getDateTimeFormatter().format(this.getTimestamp()));
        cb.put("]");
    }

    private void appendRequestInfo(CharBuffer cb, HttpServletRequest hreq) {
        cb.put('\"');
        cb.put(hreq.getMethod());
        cb.put(' ');
        String uri = hreq.getRequestURI();
        if (uri == null) {
            uri = "NULL-HTTP-URI";
        }
        cb.put(uri);
        if (hreq.getQueryString() != null) {
            cb.put('?');
            cb.put(hreq.getQueryString());
        }
        cb.put(' ');
        cb.put(hreq.getProtocol());
        cb.put('\"');
    }

    private void appendResponseStatus(CharBuffer cb, Response response) {
        cb.put(String.valueOf(((HttpResponse)response).getStatus()));
    }

    private void appendResponseLength(CharBuffer cb, Response response) {
        cb.put(Integer.toString(response.getContentCount()));
    }
}

