/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.converters;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.EnumSet;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.sessions.Session;

public class EnumTypeConverter
extends ObjectTypeConverter {
    private Class m_enumClass;
    private String m_enumClassName;
    private boolean m_useOrdinalValues;

    public EnumTypeConverter(DatabaseMapping mapping, Class<?> enumClass, boolean useOrdinalValues) {
        super(mapping);
        this.m_enumClass = enumClass;
        this.m_enumClassName = enumClass.getName();
        this.m_useOrdinalValues = useOrdinalValues;
        this.initializeConversions(this.m_enumClass);
    }

    public EnumTypeConverter(DatabaseMapping mapping, String enumClassName, boolean useOrdinalValues) {
        this(mapping, enumClassName);
        this.m_useOrdinalValues = useOrdinalValues;
    }

    public EnumTypeConverter(DatabaseMapping mapping, String enumClassName) {
        super(mapping);
        this.m_enumClassName = enumClassName;
    }

    protected void initializeConversions(Class enumClass) {
        if (this.getFieldToAttributeValues().isEmpty()) {
            EnumSet<Enum> theEnums = EnumSet.allOf(enumClass);
            for (Enum theEnum : theEnums) {
                if (this.m_useOrdinalValues) {
                    this.addConversionValue(theEnum.ordinal(), theEnum.name());
                    continue;
                }
                this.addConversionValue(theEnum.name(), theEnum.name());
            }
        }
    }

    public Class<?> getEnumClass() {
        return this.m_enumClass;
    }

    public String getEnumClassName() {
        return this.m_enumClassName;
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        block6: {
            super.convertClassNamesToClasses(classLoader);
            if (this.m_enumClass == null || !this.m_enumClass.getClassLoader().equals(classLoader)) {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            this.m_enumClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.m_enumClassName, true, classLoader));
                            break block6;
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.m_enumClassName, exception.getException());
                        }
                    }
                    this.m_enumClass = PrivilegedAccessHelper.getClassForName(this.m_enumClassName, true, classLoader);
                }
                catch (ClassNotFoundException exception) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.m_enumClassName, exception);
                }
            }
        }
        this.initializeConversions(this.m_enumClass);
    }

    @Override
    public Object convertDataValueToObjectValue(Object fieldValue, Session session) {
        Object obj = super.convertDataValueToObjectValue(fieldValue, session);
        if (fieldValue == null || obj == null) {
            return obj;
        }
        return Enum.valueOf(this.m_enumClass, (String)obj);
    }

    @Override
    public Object convertObjectValueToDataValue(Object attributeValue, Session session) {
        if (attributeValue == null) {
            return super.convertObjectValueToDataValue((Object)null, session);
        }
        return super.convertObjectValueToDataValue((Object)((Enum)attributeValue).name(), session);
    }
}

