/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli.internal;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.config.serverbeans.Resources;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="_get-built-in-custom-resources")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@RestEndpoints(value={@RestEndpoint(configBean=Resources.class, opType=RestEndpoint.OpType.GET, path="get-built-in-custom-resources", description="Get Built-in Custom Resources")})
public class GetBuiltInCustomResources
implements AdminCommand {
    @Inject
    private ConnectorRuntime connectorRuntime;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            Map builtInCustomResources = this.connectorRuntime.getBuiltInCustomResources();
            Properties extraProperties = new Properties();
            extraProperties.put("builtInCustomResources", builtInCustomResources);
            report.setExtraProperties(extraProperties);
        }
        catch (Exception e) {
            report.setMessage("_get-built-in-custom-resources failed : " + e.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        report.setActionExitCode(ec);
    }
}

