/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.component;

import com.sun.jsftemplating.component.ChildManager;
import com.sun.jsftemplating.el.VariableResolver;
import com.sun.jsftemplating.layout.descriptors.ComponentType;
import com.sun.jsftemplating.layout.descriptors.LayoutComponent;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import com.sun.jsftemplating.util.LogUtil;
import com.sun.jsftemplating.util.TypeConverter;
import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ComponentUtil {
    private static Map<String, Class> _typeCache = new HashMap<String, Class>();
    private Map<String, ComponentType> _types = new HashMap<String, ComponentType>();
    public static final String COMPONENT_UTIL_KEY = "_jsft_COMP_UTIL";

    private ComponentUtil() {
    }

    public static ComponentUtil getInstance(FacesContext ctx) {
        ComponentUtil cu = null;
        if (ctx != null) {
            Map appMap = ctx.getExternalContext().getApplicationMap();
            cu = (ComponentUtil)appMap.get(COMPONENT_UTIL_KEY);
            if (cu == null) {
                cu = new ComponentUtil();
                appMap.put(COMPONENT_UTIL_KEY, cu);
            }
        } else {
            cu = new ComponentUtil();
        }
        return cu;
    }

    public UIComponent getChild(UIComponent parent, String id) {
        return this.findChild(parent, id, id);
    }

    public UIComponent findChild(UIComponent parent, String id, String facetName) {
        if (parent == null) {
            return null;
        }
        UIComponent child2 = null;
        if (facetName != null && (child2 = (UIComponent)parent.getFacets().get(facetName)) != null) {
            return child2;
        }
        if (id != null) {
            for (UIComponent child2 : parent.getChildren()) {
                if (!id.equals(child2.getId())) continue;
                return child2;
            }
        }
        return null;
    }

    public UIComponent getChild(UIComponent parent, String id, String factoryClass) {
        return this.getChild(parent, id, factoryClass, id);
    }

    public UIComponent getChild(UIComponent parent, String id, String factoryClass, String facetName) {
        return this.getChild(parent, id, this.getComponentType(factoryClass), null, facetName);
    }

    public UIComponent getChild(UIComponent parent, String id, String factoryClass, Properties properties) {
        return this.getChild(parent, id, factoryClass, properties, id);
    }

    public UIComponent getChild(UIComponent parent, String id, String factoryClass, Properties properties, String facetName) {
        return this.getChild(parent, id, this.getComponentType(factoryClass), properties, facetName);
    }

    private UIComponent getChild(UIComponent parent, String id, ComponentType type, Properties properties, String facetName) {
        LayoutComponent desc = new LayoutComponent(null, id, type);
        if (properties != null) {
            desc.setOptions(properties);
        }
        if (facetName != null) {
            desc.addOption("_facetName", facetName);
        }
        return this.getChild(parent, desc);
    }

    private ComponentType getComponentType(String factoryClass) {
        ComponentType type = this._types.get(factoryClass);
        if (type == null) {
            type = new ComponentType(factoryClass, factoryClass);
            HashMap<String, ComponentType> newMap = new HashMap<String, ComponentType>(this._types);
            newMap.put(factoryClass, type);
            this._types = newMap;
        }
        return type;
    }

    public UIComponent getChild(UIComponent parent, LayoutComponent descriptor) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (parent instanceof ChildManager) {
            return ((ChildManager)parent).getChild(context, descriptor);
        }
        String childId = descriptor.getId(context, parent);
        UIComponent childComponent = this.findChild(parent, childId, (String)descriptor.getEvaluatedOption(context, "_facetName", null));
        if (childComponent != null) {
            return childComponent;
        }
        return this.createChildComponent(context, descriptor, parent);
    }

    public UIComponent createChildComponent(FacesContext context, LayoutComponent descriptor, UIComponent parent) {
        if (descriptor == null) {
            throw new IllegalArgumentException("'descriptor' cannot be null!");
        }
        return descriptor.getType().getFactory().create(context, descriptor, parent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object setOption(FacesContext context, String key, Object value, LayoutElement desc, UIComponent comp) {
        if ((value = VariableResolver.resolveVariables(context, desc, comp, value)) instanceof ValueExpression) {
            if (comp == null) return value;
            comp.setValueExpression(key, (ValueExpression)value);
            return value;
        }
        if (value instanceof String && this.isValueReference((String)value)) {
            ValueExpression ve = context.getApplication().getExpressionFactory().createValueExpression(context.getELContext(), (String)value, Object.class);
            if (comp == null) return ve;
            comp.setValueExpression(key, ve);
            return ve;
        }
        if (comp == null) return value;
        Map attributes = comp.getAttributes();
        if (value == null) {
            try {
                attributes.remove(key);
                return value;
            }
            catch (Exception ex) {
                try {
                    attributes.put(key, null);
                    return value;
                }
                catch (Exception iae) {
                    if (!LogUtil.infoEnabled()) return value;
                    LogUtil.info("JSFT0006", key, comp.getId(), comp.getClass().getName());
                    if (!LogUtil.fineEnabled()) return value;
                    LogUtil.fine("Unable to set (" + key + ").", iae);
                }
            }
            return value;
        }
        try {
            attributes.put(key, value);
            return value;
        }
        catch (Exception ex) {
            Class type = this.findPropertyType(comp, key);
            if (type == null) throw new IllegalArgumentException("Failed to set property (" + key + ") with value (" + value + "), which is of type (" + value.getClass().getName() + ").  This occured on the component named (" + comp.getId() + ") of type (" + comp.getClass().getName() + ").", ex);
            try {
                attributes.put(key, TypeConverter.asType(type, value));
                return value;
            }
            catch (Exception ex2) {
                throw new IllegalArgumentException("Failed to set property (" + key + ") with value (" + value + "), which is of type (" + value.getClass().getName() + ").  Expected type (" + type.getName() + ").  This occured on the component named (" + comp.getId() + ") of type (" + comp.getClass().getName() + ").", ex2);
            }
        }
    }

    private Class findPropertyType(UIComponent comp, String key) {
        Class<?> compClass = comp.getClass();
        String cacheKey = compClass.getName() + ';' + key;
        if (_typeCache.containsKey(cacheKey)) {
            return _typeCache.get(cacheKey);
        }
        Class<?> val = null;
        Method meth = null;
        String methodName = this.getGetterName(key);
        try {
            meth = compClass.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            try {
                meth = compClass.getMethod("is" + methodName.substring(3), new Class[0]);
            }
            catch (NoSuchMethodException ex2) {
                ex2.printStackTrace();
            }
        }
        if (meth != null) {
            val = meth.getReturnType();
        } else {
            Object obj = comp.getAttributes().get("key");
            if (val != null) {
                val = obj.getClass();
            }
        }
        HashMap<String, Class> newTypeCache = new HashMap<String, Class>(_typeCache);
        newTypeCache.put(cacheKey, val);
        _typeCache = newTypeCache;
        return val;
    }

    public String getGetterName(String name) {
        return "get" + (char)(name.charAt(0) & 0xFFDF) + name.substring(1);
    }

    public Object resolveValue(FacesContext context, LayoutElement elt, UIComponent parent, Object value) {
        Object result = VariableResolver.resolveVariables(context, elt, parent, value);
        if (result != null && result instanceof String && this.isValueReference((String)result)) {
            ELContext elctx = context.getELContext();
            ValueExpression ve = context.getApplication().getExpressionFactory().createValueExpression(elctx, (String)result, Object.class);
            result = ve.getValue(elctx);
        }
        return result;
    }

    public boolean isValueReference(String value) {
        if (value == null) {
            return false;
        }
        int start = value.indexOf("#{");
        return start != -1 && start < value.indexOf(125, start);
    }
}

