/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld.util;

import java.lang.reflect.InvocationTargetException;
import org.glassfish.weld.ACLSingletonProvider;
import org.jboss.weld.bootstrap.api.SingletonProvider;
import org.jboss.weld.bootstrap.api.helpers.TCCLSingletonProvider;

public class Util {
    public static <T> T newInstance(String className) {
        try {
            return Util.classForName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException("Cannot instantiate instance of " + className + " with no-argument constructor", e);
        }
    }

    public static <T> Class<T> classForName(String name) {
        try {
            Class<?> c;
            if (Thread.currentThread().getContextClassLoader() != null) {
                Class<?> c2;
                Class<?> clazz = c2 = Thread.currentThread().getContextClassLoader().loadClass(name);
                return clazz;
            }
            Class<?> clazz = c = Class.forName(name);
            return clazz;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new IllegalArgumentException("Cannot load class for " + name, e);
        }
    }

    public static void initializeWeldSingletonProvider() {
        boolean earSupport = false;
        try {
            Class.forName("org.glassfish.javaee.full.deployment.EarClassLoader");
            earSupport = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        SingletonProvider.initialize((SingletonProvider)(earSupport ? new ACLSingletonProvider() : new TCCLSingletonProvider()));
    }
}

