/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.view.WriteBehindStateWriter;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import jakarta.faces.FacesException;
import jakarta.faces.FactoryFinder;
import jakarta.faces.application.ViewHandler;
import jakarta.faces.application.ViewVisitOption;
import jakarta.faces.component.UIViewParameter;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.render.ResponseStateManager;
import jakarta.faces.view.ViewDeclarationLanguage;
import jakarta.faces.view.ViewDeclarationLanguageFactory;
import jakarta.faces.view.ViewMetadata;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class MultiViewHandler
extends ViewHandler {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private String[] configuredExtensions;
    private Set<String> protectedViews;
    private boolean extensionsSet;
    private ViewDeclarationLanguageFactory vdlFactory;

    public MultiViewHandler() {
        WebConfiguration config = WebConfiguration.getInstance();
        this.configuredExtensions = config.getConfiguredExtensions();
        this.extensionsSet = config.isSet(WebConfiguration.WebContextInitParameter.DefaultSuffix);
        this.vdlFactory = (ViewDeclarationLanguageFactory)FactoryFinder.getFactory("jakarta.faces.view.ViewDeclarationLanguageFactory");
        this.protectedViews = new CopyOnWriteArraySet<String>();
    }

    @Override
    public void initView(FacesContext context) throws FacesException {
        super.initView(context);
    }

    @Override
    public UIViewRoot restoreView(FacesContext context, String viewId) {
        Util.notNull("context", context);
        String physicalViewId = this.derivePhysicalViewId(context, viewId, false);
        return this.vdlFactory.getViewDeclarationLanguage(physicalViewId).restoreView(context, physicalViewId);
    }

    @Override
    public UIViewRoot createView(FacesContext context, String viewId) {
        Util.notNull("context", context);
        String physicalViewId = this.derivePhysicalViewId(context, viewId, false);
        return this.vdlFactory.getViewDeclarationLanguage(physicalViewId).createView(context, physicalViewId);
    }

    @Override
    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        Util.notNull("context", context);
        Util.notNull("viewToRender", viewToRender);
        this.vdlFactory.getViewDeclarationLanguage(viewToRender.getViewId()).renderView(context, viewToRender);
    }

    @Override
    public Locale calculateLocale(FacesContext context) {
        Locale perf;
        Util.notNull("context", context);
        Locale result = null;
        Iterator<Locale> locales = context.getExternalContext().getRequestLocales();
        while (locales.hasNext() && (result = this.findMatch(context, perf = locales.next())) == null) {
        }
        if (result == null) {
            result = context.getApplication().getDefaultLocale() == null ? Locale.getDefault() : context.getApplication().getDefaultLocale();
        }
        return result;
    }

    @Override
    public String calculateRenderKitId(FacesContext context) {
        Util.notNull("context", context);
        String result = RenderKitUtils.PredefinedPostbackParameter.RENDER_KIT_ID_PARAM.getValue(context);
        if (result == null && null == (result = context.getApplication().getDefaultRenderKitId())) {
            result = "HTML_BASIC";
        }
        return result;
    }

    @Override
    public void writeState(FacesContext context) throws IOException {
        Util.notNull("context", context);
        if (!context.getPartialViewContext().isAjaxRequest()) {
            WriteBehindStateWriter writer;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Begin writing marker for viewId " + context.getViewRoot().getViewId());
            }
            if ((writer = WriteBehindStateWriter.getCurrentInstance()) != null) {
                writer.writingState();
            }
            context.getResponseWriter().write("~com.sun.faces.saveStateFieldMarker~");
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("End writing marker for viewId " + context.getViewRoot().getViewId());
            }
        }
    }

    @Override
    public String getActionURL(FacesContext context, String viewId) {
        String result = this.getActionURLWithoutViewProtection(context, viewId);
        ViewHandler viewHandler = context.getApplication().getViewHandler();
        Set<String> urlPatterns = viewHandler.getProtectedViewsUnmodifiable();
        boolean viewIdIsProtected = false;
        for (String urlPattern : urlPatterns) {
            if (urlPattern.equals(viewId)) {
                viewIdIsProtected = true;
            }
            if (!viewIdIsProtected) continue;
            break;
        }
        if (viewIdIsProtected) {
            StringBuilder builder = new StringBuilder(result);
            if (result.contains("?")) {
                builder.append("&");
            } else {
                builder.append("?");
            }
            String rkId = viewHandler.calculateRenderKitId(context);
            ResponseStateManager rsm = RenderKitUtils.getResponseStateManager(context, rkId);
            String tokenValue = rsm.getCryptographicallyStrongTokenFromSession(context);
            builder.append("jakarta.faces.Token").append("=").append(tokenValue);
            result = builder.toString();
        }
        return result;
    }

    @Override
    public String getResourceURL(FacesContext context, String path) {
        if (context == null || path == null) {
            throw new NullPointerException();
        }
        if (path.charAt(0) == '/') {
            return context.getExternalContext().getRequestContextPath() + path;
        }
        return path;
    }

    @Override
    public String getWebsocketURL(FacesContext context, String channel) {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(channel, "channel");
        ExternalContext externalContext = context.getExternalContext();
        String contextPath = externalContext.getRequestContextPath();
        return externalContext.encodeWebsocketURL(contextPath + "/jakarta.faces.push" + "/" + channel);
    }

    @Override
    public String getBookmarkableURL(FacesContext context, String viewId, Map<String, List<String>> parameters, boolean includeViewParams) {
        Map<String, List<String>> params = includeViewParams ? this.getFullParameterList(context, viewId, parameters) : parameters;
        ExternalContext ectx = context.getExternalContext();
        return ectx.encodeActionURL(ectx.encodeBookmarkableURL(Util.getViewHandler(context).getActionURL(context, viewId), params));
    }

    @Override
    public void addProtectedView(String urlPattern) {
        this.protectedViews.add(urlPattern);
    }

    @Override
    public Set<String> getProtectedViewsUnmodifiable() {
        return Collections.unmodifiableSet(this.protectedViews);
    }

    @Override
    public boolean removeProtectedView(String urlPattern) {
        return this.protectedViews.remove(urlPattern);
    }

    @Override
    public String getRedirectURL(FacesContext context, String viewId, Map<String, List<String>> parameters, boolean includeViewParams) {
        String responseEncoding;
        String encodingFromContext = (String)context.getAttributes().get("facelets.Encoding");
        if (encodingFromContext == null) {
            encodingFromContext = (String)context.getViewRoot().getAttributes().get("facelets.Encoding");
        }
        if (encodingFromContext == null) {
            try {
                responseEncoding = context.getExternalContext().getResponseCharacterEncoding();
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    Object message = "Unable to obtain response character encoding from ExternalContext {0}.  Using UTF-8.";
                    message = MessageFormat.format((String)message, context.getExternalContext());
                    LOGGER.log(Level.FINE, (String)message, e);
                }
                responseEncoding = "UTF-8";
            }
        } else {
            responseEncoding = encodingFromContext;
        }
        if (parameters != null) {
            HashMap<String, List<String>> decodedParameters = new HashMap<String, List<String>>();
            for (Map.Entry entry : parameters.entrySet()) {
                String string = (String)entry.getKey();
                List list = (List)entry.getValue();
                ArrayList<String> values = new ArrayList<String>();
                for (String value : list) {
                    try {
                        value = URLDecoder.decode(value, responseEncoding);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException("Unable to decode");
                    }
                    values.add(value);
                }
                decodedParameters.put(string, values);
            }
            parameters = decodedParameters;
        }
        Map<String, List<String>> params = includeViewParams ? this.getFullParameterList(context, viewId, parameters) : parameters;
        ExternalContext ectx = context.getExternalContext();
        return ectx.encodeActionURL(ectx.encodeRedirectURL(Util.getViewHandler(context).getActionURL(context, viewId), params));
    }

    @Override
    public ViewDeclarationLanguage getViewDeclarationLanguage(FacesContext context, String viewId) {
        return this.vdlFactory.getViewDeclarationLanguage(viewId);
    }

    @Override
    public Stream<String> getViews(FacesContext context, String path, ViewVisitOption ... options) {
        return this.vdlFactory.getAllViewDeclarationLanguages().stream().flatMap(vdl -> vdl.getViews(context, path, options));
    }

    @Override
    public Stream<String> getViews(FacesContext context, String path, int maxDepth, ViewVisitOption ... options) {
        return this.vdlFactory.getAllViewDeclarationLanguages().stream().flatMap(vdl -> vdl.getViews(context, path, maxDepth, options));
    }

    @Override
    public String deriveViewId(FacesContext context, String requestViewId) {
        return this.derivePhysicalViewId(context, requestViewId, true);
    }

    @Override
    public String deriveLogicalViewId(FacesContext context, String requestViewId) {
        return this.derivePhysicalViewId(context, requestViewId, false);
    }

    protected String normalizeRequestURI(String uri, String mapping) {
        if (mapping == null || !Util.isPrefixMapped(mapping)) {
            return uri;
        }
        int length = mapping.length() + 1;
        StringBuilder builder = new StringBuilder(length);
        builder.append(mapping).append('/');
        String mappingMod = builder.toString();
        boolean logged = false;
        while (uri.startsWith(mappingMod)) {
            if (!logged && LOGGER.isLoggable(Level.WARNING)) {
                logged = true;
                LOGGER.log(Level.WARNING, "jsf.viewhandler.requestpath.recursion", new Object[]{uri, mapping});
            }
            uri = uri.substring(length - 1);
        }
        return uri;
    }

    protected String convertViewId(FacesContext context, String viewId) {
        int extIdx = viewId.lastIndexOf(46);
        int length = viewId.length();
        StringBuilder buffer = new StringBuilder(length);
        for (String ext : this.configuredExtensions) {
            if (viewId.endsWith(ext)) {
                return viewId;
            }
            this.appendOrReplaceExtension(viewId, ext, length, extIdx, buffer);
            String convertedViewId = buffer.toString();
            ViewDeclarationLanguage vdl = this.getViewDeclarationLanguage(context, convertedViewId);
            if (!vdl.viewExists(context, convertedViewId)) continue;
            return convertedViewId;
        }
        return this.legacyConvertViewId(viewId, length, extIdx, buffer);
    }

    protected String derivePhysicalViewId(FacesContext ctx, String requestViewId, boolean checkPhysical) {
        String mapping;
        if (requestViewId != null && (mapping = Util.getFacesMapping(ctx)) != null) {
            String physicalViewId;
            if (Util.isExactMapped(mapping)) {
                physicalViewId = this.convertViewId(ctx, requestViewId);
            } else if (!Util.isPrefixMapped(mapping)) {
                physicalViewId = this.convertViewId(ctx, requestViewId);
            } else {
                physicalViewId = this.normalizeRequestURI(requestViewId, mapping);
                if (physicalViewId.equals(mapping)) {
                    this.send404Error(ctx);
                }
            }
            if (checkPhysical) {
                ViewDeclarationLanguage vdl = this.getViewDeclarationLanguage(ctx, physicalViewId);
                return vdl.viewExists(ctx, physicalViewId) ? physicalViewId : null;
            }
            return physicalViewId;
        }
        return requestViewId;
    }

    protected Map<String, List<String>> getFullParameterList(FacesContext ctx, String viewId, Map<String, List<String>> existingParameters) {
        LinkedHashMap<Object, Object> copy = existingParameters == null || existingParameters.isEmpty() ? new LinkedHashMap(4) : new LinkedHashMap<String, List<String>>(existingParameters);
        this.addViewParameters(ctx, viewId, copy);
        return copy;
    }

    protected void addViewParameters(FacesContext ctx, String viewId, Map<String, List<String>> existingParameters) {
        UIViewRoot currentRoot = ctx.getViewRoot();
        String currentViewId = currentRoot.getViewId();
        Collection<Object> toViewParams = Collections.emptyList();
        boolean currentIsSameAsNew = false;
        Collection<UIViewParameter> currentViewParams = ViewMetadata.getViewParameters(currentRoot);
        if (currentViewId.equals(viewId)) {
            currentIsSameAsNew = true;
            toViewParams = currentViewParams;
        } else {
            ViewDeclarationLanguage pdl = this.getViewDeclarationLanguage(ctx, viewId);
            ViewMetadata viewMetadata = pdl.getViewMetadata(ctx, viewId);
            if (null != viewMetadata) {
                UIViewRoot root = viewMetadata.createMetadataView(ctx);
                toViewParams = ViewMetadata.getViewParameters(root);
            }
        }
        if (toViewParams.isEmpty()) {
            return;
        }
        for (UIViewParameter uIViewParameter : toViewParams) {
            String value = null;
            if (existingParameters.containsKey(uIViewParameter.getName())) continue;
            if (MultiViewHandler.paramHasValueExpression(uIViewParameter)) {
                value = uIViewParameter.getStringValueFromModel(ctx);
            }
            if (value == null) {
                value = currentIsSameAsNew ? uIViewParameter.getStringValue(ctx) : MultiViewHandler.getStringValueToTransfer(ctx, uIViewParameter, currentViewParams);
            }
            if (value == null) continue;
            List<String> existing = existingParameters.get(uIViewParameter.getName());
            if (existing == null) {
                existing = new ArrayList<String>(4);
                existingParameters.put(uIViewParameter.getName(), existing);
            }
            existing.add(value);
        }
    }

    protected Locale findMatch(FacesContext context, Locale pref) {
        Locale defaultLocale;
        Locale result = null;
        Iterator<Locale> it = context.getApplication().getSupportedLocales();
        while (it.hasNext()) {
            Locale supportedLocale = it.next();
            if (pref.equals(supportedLocale)) {
                result = supportedLocale;
                break;
            }
            if (!pref.getLanguage().equals(supportedLocale.getLanguage()) || supportedLocale.getCountry().length() != 0) continue;
            result = supportedLocale;
        }
        if (result == null && (defaultLocale = context.getApplication().getDefaultLocale()) != null) {
            if (pref.equals(defaultLocale)) {
                result = defaultLocale;
            } else if (pref.getLanguage().equals(defaultLocale.getLanguage()) && defaultLocale.getCountry().length() == 0) {
                result = defaultLocale;
            }
        }
        return result;
    }

    protected void send404Error(FacesContext context) {
        try {
            context.responseComplete();
            context.getExternalContext().responseSendError(404, "");
        }
        catch (IOException ioe) {
            throw new FacesException(ioe);
        }
    }

    private String getActionURLWithoutViewProtection(FacesContext context, String viewId) {
        Util.notNull("context", context);
        Util.notNull("viewId", viewId);
        if (viewId.length() == 0 || viewId.charAt(0) != '/') {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "jsf.illegal_view_id_error", viewId);
            }
            throw new IllegalArgumentException(MessageUtils.getExceptionMessageString("com.sun.faces.ILLEGAL_VIEW_ID", viewId));
        }
        ExternalContext extContext = context.getExternalContext();
        String contextPath = extContext.getRequestContextPath();
        String mapping = Util.getFacesMapping(context);
        if (mapping == null) {
            return contextPath + viewId;
        }
        if (Util.isExactMapped(mapping)) {
            String servletMapping;
            if (viewId.contains(".")) {
                for (String extension : this.configuredExtensions) {
                    String exactViewId;
                    if (!viewId.endsWith(extension) || !Util.isViewIdExactMappedToFacesServlet(exactViewId = viewId.substring(0, viewId.lastIndexOf(extension)))) continue;
                    return contextPath + exactViewId;
                }
            } else if (Util.isViewIdExactMappedToFacesServlet(viewId)) {
                return contextPath + viewId;
            }
            if ((servletMapping = Util.getFirstWildCardMappingToFacesServlet(context.getExternalContext())) == null) {
                throw new IllegalStateException("No suitable mapping for FacesServlet found. To serve views that are not exact mapped FacesServlet should have at least one prefix or suffix mapping.");
            }
            mapping = servletMapping.replace("*", "");
        }
        if (Util.isPrefixMapped(mapping)) {
            if (mapping.equals("/*")) {
                return contextPath + viewId;
            }
            return contextPath + mapping + viewId;
        }
        int period = viewId.lastIndexOf(46);
        if (period < 0) {
            return contextPath + viewId + mapping;
        }
        if (!viewId.endsWith(mapping)) {
            for (String extension : this.configuredExtensions) {
                if (!viewId.endsWith(extension)) continue;
                return contextPath + viewId.substring(0, viewId.indexOf(extension)) + mapping;
            }
            return contextPath + viewId.substring(0, period) + mapping;
        }
        return contextPath + viewId;
    }

    private static boolean paramHasValueExpression(UIViewParameter param) {
        return param.getValueExpression("value") != null;
    }

    private static String getStringValueToTransfer(FacesContext context, UIViewParameter param, Collection<UIViewParameter> viewParams) {
        if (viewParams != null && !viewParams.isEmpty()) {
            for (UIViewParameter candidate : viewParams) {
                if (candidate.getName() == null || param.getName() == null || !candidate.getName().equals(param.getName())) continue;
                return candidate.getStringValue(context);
            }
        }
        return param.getStringValue(context);
    }

    private void appendOrReplaceExtension(String viewId, String extension, int length, int extensionIndex, StringBuilder buffer) {
        buffer.setLength(0);
        buffer.append(viewId);
        if (extensionIndex != -1) {
            buffer.replace(extensionIndex, length, extension);
        } else {
            buffer.append(extension);
        }
    }

    private String legacyConvertViewId(String viewId, int length, int extensionIndex, StringBuilder buffer) {
        String extension;
        String string = extension = this.extensionsSet && this.configuredExtensions.length != 0 ? this.configuredExtensions[0] : ".jsp";
        if (viewId.endsWith(extension)) {
            return viewId;
        }
        this.appendOrReplaceExtension(viewId, extension, length, extensionIndex, buffer);
        return buffer.toString();
    }
}

