/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.remote.RemoteCLICommand;
import com.sun.enterprise.admin.servermgmt.cli.LocalDomainCommand;
import com.sun.enterprise.admin.servermgmt.cli.Strings;
import com.sun.enterprise.security.store.PasswordAdapter;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.process.Jps;
import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.enterprise.universal.xml.MiniXmlParser;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import com.sun.enterprise.util.HostAndPort;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.io.ServerDirs;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.util.List;
import java.util.logging.Level;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandException;

public abstract class LocalServerCommand
extends CLICommand {
    private ServerDirs serverDirs;
    private static final LocalStringsImpl strings = new LocalStringsImpl(LocalDomainCommand.class);

    protected boolean checkForSpecialFiles() {
        return true;
    }

    protected final HostAndPort getAdminAddress() throws CommandException {
        return this.getAdminAddress("server");
    }

    protected final HostAndPort getAdminAddress(String serverName) throws CommandException {
        try {
            MiniXmlParser parser = new MiniXmlParser(this.getDomainXml(), serverName);
            List addrSet = parser.getAdminAddresses();
            if (addrSet.size() > 0) {
                return (HostAndPort)addrSet.get(0);
            }
            throw new CommandException(strings.get("NoAdminPort"));
        }
        catch (MiniXmlParserException ex) {
            throw new CommandException(strings.get("NoAdminPortEx", new Object[]{ex}), (Throwable)ex);
        }
    }

    protected final void setServerDirs(ServerDirs sd) {
        this.serverDirs = sd;
    }

    protected final boolean isLocal() {
        return this.serverDirs != null && this.serverDirs.getServerName() != null;
    }

    protected final boolean isRemote() {
        return !this.isLocal();
    }

    private final void resetLocalPassword() throws IOException {
        this.resetServerDirs();
        this.setLocalPassword();
    }

    protected final void setLocalPassword() {
        String pw;
        String string = pw = this.serverDirs == null ? null : this.serverDirs.getLocalPassword();
        if (LocalServerCommand.ok((String)pw)) {
            this.programOpts.setPassword(pw != null ? pw.toCharArray() : null, ProgramOptions.PasswordLocation.LOCAL_PASSWORD);
            logger.finer("Using local password");
        } else {
            logger.finer("Not using local password");
        }
    }

    protected final void unsetLocalPassword() {
        this.programOpts.setPassword(null, ProgramOptions.PasswordLocation.LOCAL_PASSWORD);
    }

    protected final void resetServerDirs() throws IOException {
        if (this.serverDirs == null) {
            throw new RuntimeException(Strings.get("NoServerDirs"));
        }
        this.serverDirs = this.serverDirs.refresh();
    }

    protected final ServerDirs getServerDirs() {
        return this.serverDirs;
    }

    protected final File getDomainXml() {
        if (this.serverDirs == null) {
            throw new RuntimeException(Strings.get("NoServerDirs"));
        }
        return this.serverDirs.getDomainXml();
    }

    protected final String readFromMasterPasswordFile() {
        File mpf = this.getMasterPasswordFile();
        if (mpf == null) {
            return null;
        }
        try {
            PasswordAdapter pw = new PasswordAdapter(mpf.getAbsolutePath(), "master-password".toCharArray());
            return pw.getPasswordForAlias("master-password");
        }
        catch (Exception e) {
            logger.log(Level.FINER, "master password file reading error: {0}", e.getMessage());
            return null;
        }
    }

    protected final boolean verifyMasterPassword(String mpv) {
        return this.loadAndVerifyKeystore(this.getJKS(), mpv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean loadAndVerifyKeystore(File jks, String mpv) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(jks);
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(fis, mpv.toCharArray());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(e.getMessage());
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected final String getMasterPassword() throws CommandException {
        int RETRIES = 3;
        long t0 = this.now();
        String mpv = (String)this.passwords.get("AS_ADMIN_MASTERPASSWORD");
        if (mpv == null) {
            mpv = "changeit";
            if (!this.verifyMasterPassword(mpv) && !this.verifyMasterPassword(mpv = this.readFromMasterPasswordFile())) {
                mpv = this.retry(3);
            }
        } else if (!this.verifyMasterPassword(mpv)) {
            mpv = this.retry(3);
        }
        long t1 = this.now();
        logger.log(Level.FINER, "Time spent in master password extraction: {0} msec", t1 - t0);
        return mpv;
    }

    protected final boolean isThisServer(File ourDir, String directoryKey) {
        if (!LocalServerCommand.ok((String)directoryKey)) {
            throw new NullPointerException();
        }
        ourDir = this.getUniquePath(ourDir);
        logger.log(Level.FINER, "Check if server is at location {0}", ourDir);
        try {
            RemoteCLICommand cmd = new RemoteCLICommand("__locations", this.programOpts, this.env);
            ActionReport report = cmd.executeAndReturnActionReport(new String[]{"__locations"});
            String theirDirPath = report.findProperty(directoryKey);
            logger.log(Level.FINER, "Remote server has root directory {0}", theirDirPath);
            if (LocalServerCommand.ok((String)theirDirPath)) {
                File theirDir = this.getUniquePath(new File(theirDirPath));
                return theirDir.equals(ourDir);
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected final int getServerPid() {
        try {
            return Integer.parseInt(new RemoteCLICommand("__locations", this.programOpts, this.env).executeAndReturnActionReport(new String[]{"__locations"}).findProperty("Pid"));
        }
        catch (Exception e) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isRunning(String host, int port) {
        Socket server = null;
        try {
            server = new Socket(host, port);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            logger.log(Level.FINER, "\nisRunning got exception: {0}", ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (server != null) {
                try {
                    server.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected boolean isRunning() {
        int pp = this.getPrevPid();
        if (pp < 0) {
            return this.isRunningByCheckingForPidFile();
        }
        Boolean b = ProcessUtils.isProcessRunning((int)pp);
        if (b == null) {
            return this.isRunningUsingJps();
        }
        return b;
    }

    protected final void waitForRestart(int oldServerPid) throws CommandException {
        long end = this.getEndTime();
        while (this.now() < end) {
            try {
                int newServerPid;
                if (this.isLocal()) {
                    this.resetLocalPassword();
                }
                if ((newServerPid = this.getServerPid()) > 0 && newServerPid != oldServerPid) {
                    logger.log(Level.FINER, "oldserver-pid, newserver-pid = {0} --- {1}", new Object[]{oldServerPid, newServerPid});
                    return;
                }
                Thread.sleep(300L);
            }
            catch (Exception exception) {}
        }
        throw new CommandException(strings.get("restartDomain.noGFStart"));
    }

    protected final int getPrevPid() {
        try {
            File prevPidFile = new File(this.getServerDirs().getPidFile().getPath() + ".prev");
            if (!prevPidFile.canRead()) {
                return -1;
            }
            String pids = FileUtils.readSmallFile((File)prevPidFile).trim();
            return Integer.parseInt(pids);
        }
        catch (Exception ex) {
            return -1;
        }
    }

    private boolean isRunningUsingJps() {
        int pp = this.getPrevPid();
        if (pp < 0) {
            return this.isRunningByCheckingForPidFile();
        }
        return Jps.isPid((int)pp);
    }

    private boolean isRunningByCheckingForPidFile() {
        File pf = this.getServerDirs().getPidFile();
        if (pf != null) {
            return pf.exists();
        }
        return this.isRunning(this.programOpts.getHost(), this.programOpts.getPort());
    }

    protected final long getUptime() throws CommandException {
        RemoteCLICommand cmd = new RemoteCLICommand("uptime", this.programOpts, this.env);
        String up = cmd.executeAndReturnOutput(new String[]{"uptime", "--milliseconds"}).trim();
        long up_ms = this.parseUptime(up);
        if (up_ms <= 0L) {
            throw new CommandException(strings.get("restart.dasNotRunning"));
        }
        logger.log(Level.FINER, "server uptime: {0}", up_ms);
        return up_ms;
    }

    protected final boolean isRestartable() throws CommandException {
        String val;
        RemoteCLICommand cmd = new RemoteCLICommand("_get-runtime-info", this.programOpts, this.env);
        ActionReport report = cmd.executeAndReturnActionReport(new String[]{"_get-runtime-info"});
        return report == null || !LocalServerCommand.ok((String)(val = report.findProperty("restartable_value"))) || !val.equals("false");
    }

    private long parseUptime(String up) {
        try {
            return Long.parseLong(up);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private File getJKS() {
        if (this.serverDirs == null) {
            return null;
        }
        File mp = new File(new File(this.serverDirs.getServerDir(), "config"), "cacerts.jks");
        if (!mp.canRead()) {
            return null;
        }
        return mp;
    }

    protected File getMasterPasswordFile() {
        if (this.serverDirs == null) {
            return null;
        }
        File mp = new File(this.serverDirs.getServerDir(), "master-password");
        if (!mp.canRead()) {
            return null;
        }
        return mp;
    }

    private String retry(int times) throws CommandException {
        for (int i = 0; i < times; ++i) {
            String mpv;
            String prompt = strings.get("mp.prompt", new Object[]{times - i});
            char[] mpvArr = super.readPassword(prompt);
            String string = mpv = mpvArr != null ? new String(mpvArr) : null;
            if (mpv == null) {
                throw new CommandException(strings.get("no.console"));
            }
            if (this.verifyMasterPassword(mpv)) {
                return mpv;
            }
            if (i >= times - 1) continue;
            logger.info(strings.get("retry.mp"));
        }
        throw new CommandException(strings.get("mp.giveup", new Object[]{times}));
    }

    private File getUniquePath(File f) {
        try {
            f = f.getCanonicalFile();
        }
        catch (IOException ioex) {
            f = SmartFile.sanitize((File)f);
        }
        return f;
    }

    private long now() {
        return System.currentTimeMillis();
    }

    private long getEndTime() {
        return 600000L + this.now();
    }
}

