/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.deployment.ContextServiceDefinitionDescriptor;
import com.sun.enterprise.deployment.ResourceDescriptor;
import com.sun.enterprise.deployment.annotation.handlers.ContextServiceDefinitionData;
import com.sun.enterprise.deployment.types.StandardContextType;
import jakarta.inject.Inject;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.concurrent.runtime.ConcurrentRuntime;
import org.glassfish.concurrent.runtime.LogFacade;
import org.glassfish.concurrent.runtime.deployer.cfg.ContextServiceCfg;
import org.glassfish.concurro.ContextServiceImpl;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.glassfish.resourcebase.resources.api.GenericResourceInfo;
import org.glassfish.resourcebase.resources.api.ResourceConflictException;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resourcebase.resources.naming.ResourceNamingService;
import org.jvnet.hk2.annotations.Service;

@Service
@ResourceDeployerInfo(value=ContextServiceDefinitionDescriptor.class)
public class ContextServiceDefinitionDeployer
implements ResourceDeployer<ContextServiceDefinitionDescriptor> {
    private static final Logger LOG = LogFacade.getLogger();
    @Inject
    private ResourceNamingService namingService;
    @Inject
    private ConcurrentRuntime runtime;
    @Inject
    private InvocationManager invocationManager;

    public void deployResource(ContextServiceDefinitionDescriptor resource) throws Exception {
        ResourceInfo resourceInfo = this.toResourceInfo((ResourceDescriptor)resource);
        ContextServiceImpl contextService = this.createContextService(resource.getData());
        this.namingService.publishObject((GenericResourceInfo)resourceInfo, (Object)contextService, true);
    }

    public void deployResource(ContextServiceDefinitionDescriptor resource, String applicationName, String moduleName) throws Exception {
        ResourceInfo resourceInfo = this.toResourceInfo((ResourceDescriptor)resource);
        ContextServiceImpl contextService = this.createContextService(resource.getData());
        this.namingService.publishObject((GenericResourceInfo)resourceInfo, (Object)contextService, true);
    }

    public void undeployResource(ContextServiceDefinitionDescriptor resource) throws Exception {
        ResourceInfo resourceInfo = this.toResourceInfo((ResourceDescriptor)resource);
        this.namingService.unpublishObject((GenericResourceInfo)resourceInfo);
        this.runtime.shutdownContextService(resourceInfo.getName());
    }

    public void undeployResource(ContextServiceDefinitionDescriptor resource, String applicationName, String moduleName) throws Exception {
        ResourceInfo resourceInfo = this.toResourceInfo((ResourceDescriptor)resource);
        this.namingService.unpublishObject((GenericResourceInfo)resourceInfo);
        this.runtime.shutdownContextService(resourceInfo.getName());
    }

    public void redeployResource(ContextServiceDefinitionDescriptor resource) throws Exception {
        this.undeployResource(resource);
        this.deployResource(resource);
    }

    public void enableResource(ContextServiceDefinitionDescriptor resource) throws Exception {
        this.deployResource(resource);
    }

    public void disableResource(ContextServiceDefinitionDescriptor resource) throws Exception {
        this.undeployResource(resource);
    }

    public boolean handles(Object resource) {
        return resource instanceof ContextServiceDefinitionDescriptor;
    }

    public boolean supportsDynamicReconfiguration() {
        return false;
    }

    public Class<?>[] getProxyClassesForDynamicReconfiguration() {
        return new Class[0];
    }

    public void validatePreservedResource(Application oldApp, Application newApp, Resource resource, Resources allResources) throws ResourceConflictException {
    }

    private ResourceInfo toResourceInfo(ResourceDescriptor descriptor) {
        SimpleJndiName jndiName = ConnectorsUtil.deriveResourceName((String)descriptor.getResourceId(), (SimpleJndiName)descriptor.getJndiName(), (JavaEEResourceType)descriptor.getResourceType());
        ComponentInvocation invocation = this.invocationManager.getCurrentInvocation();
        return new ResourceInfo(jndiName, invocation.getAppName(), invocation.getModuleName());
    }

    private ContextServiceImpl createContextService(ContextServiceDefinitionData data) throws Exception {
        LOG.log(Level.FINEST, "createContextService(data={0})", data);
        if (data.getCleared() == null || data.getCleared().isEmpty()) {
            data.addCleared(StandardContextType.WorkArea.name());
        }
        if (data.getPropagated() == null || data.getPropagated().isEmpty()) {
            data.addPropagated(StandardContextType.Remaining.name());
        }
        return this.runtime.createContextService(new ContextServiceCfg(data));
    }
}

