/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.util.AdminLoggerInfo;
import com.sun.enterprise.admin.util.ServerDirsSelector;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecureAdmin;
import com.sun.enterprise.security.store.AsadminSecurityUtil;
import com.sun.enterprise.util.io.ServerDirs;
import java.io.File;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;

public class SecureAdminClientManager {
    private static final Logger logger = AdminLoggerInfo.getLogger();
    private static SecureAdminClientManager instance;
    private boolean isEnabled;
    private KeyManager[] keyManagers;
    private String configuredAdminIndicator;
    private Domain domain;
    private SecureAdmin secureAdmin;
    private String instanceAlias;

    public static KeyManager[] getKeyManagers() {
        return instance == null ? null : instance.keyManagers();
    }

    public static synchronized void initClientAuthentication(char[] commandMasterPassword, boolean isInteractive, String serverName, String nodeDir, String node, File nodeDirRoot) {
        if (instance == null) {
            instance = new SecureAdminClientManager(commandMasterPassword, isInteractive, serverName, nodeDir, node, nodeDirRoot);
        }
    }

    private SecureAdminClientManager(char[] commandMasterPassword, boolean isInteractive, String serverName, String nodeDir, String node, File nodeDirRoot) {
        this.domain = this.prepareDomain(serverName, nodeDir, node, nodeDirRoot);
        if (this.domain == null) {
            return;
        }
        this.secureAdmin = this.domain.getSecureAdmin();
        this.isEnabled = SecureAdmin.isEnabled((SecureAdmin)this.secureAdmin);
        this.configuredAdminIndicator = SecureAdmin.configuredAdminIndicator((SecureAdmin)this.secureAdmin);
        if (this.isEnabled) {
            this.instanceAlias = SecureAdmin.instanceAlias((SecureAdmin)this.secureAdmin);
            logger.fine("SecureAdminClientManager: secure admin is enabled");
        } else {
            logger.fine("SecureAdminClientManager: secure admin is disabled");
        }
        this.configuredAdminIndicator = SecureAdmin.configuredAdminIndicator((SecureAdmin)this.secureAdmin);
        if (this.isEnabled) {
            try {
                this.keyManagers = this.prepareKeyManagers(commandMasterPassword, isInteractive);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public KeyManager[] keyManagers() {
        return this.keyManagers;
    }

    public String configuredAdminIndicatorValue() {
        return this.configuredAdminIndicator;
    }

    private Domain prepareDomain(String serverName, String nodeDir, String node, File nodeDirRoot) {
        ServerDirsSelector selector;
        if (serverName == null && nodeDir == null && node == null) {
            return null;
        }
        try {
            String nodeDirToUse = nodeDir != null ? nodeDir : nodeDirRoot.getAbsolutePath();
            selector = ServerDirsSelector.getInstance(null, serverName, nodeDirToUse, node);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        ServerDirs dirs = selector.dirs();
        if (dirs == null) {
            return null;
        }
        File domainXMLFile = dirs.getDomainXml();
        if (!domainXMLFile.exists()) {
            return null;
        }
        try {
            ServiceLocator habitat = Globals.getStaticHabitat();
            ConfigParser parser = new ConfigParser(habitat);
            URL domainURL = domainXMLFile.toURI().toURL();
            DomDocument doc = parser.parse(domainURL);
            Dom domDomain = doc.getRoot();
            Domain d = (Domain)domDomain.createProxy(Domain.class);
            return d;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private KeyManager[] prepareKeyManagers(char[] commandMasterPassword, boolean isPromptable) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        Certificate instanceCert = this.getCertForConfiguredAlias(commandMasterPassword, isPromptable);
        KeyStore ks = this.instanceCertOnlyKS(instanceCert);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(ks, new char[0]);
        return kmf.getKeyManagers();
    }

    private KeyStore instanceCertOnlyKS(Certificate instanceCert) throws KeyStoreException {
        KeyStore ks = KeyStore.getInstance("PKCS12");
        ks.setCertificateEntry(this.instanceAlias, instanceCert);
        return ks;
    }

    private Certificate getCertForConfiguredAlias(char[] commandMasterPassword, boolean isPromptable) throws KeyStoreException {
        KeyStore permanentKS = AsadminSecurityUtil.getInstance((char[])commandMasterPassword, (boolean)isPromptable).getAsadminKeystore();
        Certificate cert = permanentKS.getCertificate(this.instanceAlias);
        if (cert == null) {
            logger.log(Level.FINER, "Could not find matching cert in keystore for instance alias {0}", this.instanceAlias);
        } else {
            logger.log(Level.FINER, "Found matching cert in keystore for instance alias {0}", this.instanceAlias);
        }
        return cert;
    }
}

