/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client;

import com.sun.enterprise.container.common.spi.util.InjectionException;
import com.sun.enterprise.deployment.node.SaxParserHandlerBundled;
import com.sun.enterprise.universal.glassfish.TokenResolver;
import com.sun.enterprise.util.LocalStringManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEvent;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.util.ValidationEventCollector;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.glassfish.appclient.client.acc.ACCClassLoader;
import org.glassfish.appclient.client.acc.ACCLogger;
import org.glassfish.appclient.client.acc.AgentArguments;
import org.glassfish.appclient.client.acc.AppClientContainer;
import org.glassfish.appclient.client.acc.AppclientCommandArguments;
import org.glassfish.appclient.client.acc.CommandLaunchInfo;
import org.glassfish.appclient.client.acc.TargetServerHelper;
import org.glassfish.appclient.client.acc.UserError;
import org.glassfish.appclient.client.acc.Util;
import org.glassfish.appclient.client.acc.config.AuthRealm;
import org.glassfish.appclient.client.acc.config.ClientContainer;
import org.glassfish.appclient.client.acc.config.ClientCredential;
import org.glassfish.appclient.client.acc.config.TargetServer;
import org.glassfish.common.util.GlassfishUrlClassLoader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class AppClientFacade {
    private static final String ACC_CONFIG_CONTENT_PROPERTY_NAME = "glassfish-acc.xml.content";
    private static final String MAN_PAGE_PATH = "/org/glassfish/appclient/client/acc/appclient.1m";
    private static final String LINE_SEP = System.lineSeparator();
    private static final Class<?> stringsAnchor = ACCClassLoader.class;
    private static LocalStringManager localStrings = new LocalStringManagerImpl(stringsAnchor);
    private static CommandLaunchInfo launchInfo;
    private static AppclientCommandArguments appClientCommandArgs;
    private static AppClientContainer appClientContainer;

    public static void main(String[] args) {
        try {
            if (appClientContainer == null) {
                AppClientFacade.prepareACC(null, null);
            }
            appClientContainer.launch(args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (UserError ue) {
            ue.displayAndExit();
        }
    }

    public static AppClientContainer acc() {
        return appClientContainer;
    }

    public static void launch(String[] args) throws NoSuchMethodException, ClassNotFoundException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException, SAXException, InjectionException, UserError {
        appClientContainer.launch(args);
    }

    public static void prepareACC(String agentArgsText, Instrumentation inst) throws UserError, MalformedURLException, URISyntaxException, JAXBException, FileNotFoundException, ParserConfigurationException, SAXException, IOException, Exception {
        int version = Runtime.version().feature();
        if (version < 11) {
            throw new UserError(localStrings.getLocalString(stringsAnchor, "main.badVersion", "Current Java version {0} is too low; {1} or later required", new Object[]{System.getProperty("java.version"), "11"}));
        }
        AgentArguments agentArgs = AgentArguments.newInstance(agentArgsText);
        appClientCommandArgs = AppclientCommandArguments.newInstance(agentArgs.namedValues("arg"));
        if (appClientCommandArgs.isUsage()) {
            AppClientFacade.usage(0);
        } else if (appClientCommandArgs.isHelp()) {
            AppClientFacade.help();
        }
        launchInfo = CommandLaunchInfo.newInstance(agentArgs);
        if (launchInfo.getClientLaunchType() == CommandLaunchInfo.ClientLaunchType.UNKNOWN) {
            AppClientFacade.usage(1);
        }
        ACCClassLoader loader = AppClientFacade.initClassLoader(inst == null);
        Thread.currentThread().setContextClassLoader((ClassLoader)((Object)loader));
        ClientContainer clientContainer = AppClientFacade.readConfig(appClientCommandArgs.getConfigFilePath(), (ClassLoader)((Object)loader));
        TargetServer[] targetServers = TargetServerHelper.targetServers(clientContainer, appClientCommandArgs.getTargetServer());
        AppClientContainer.Builder builder = AppClientFacade.createBuilder(targetServers, clientContainer, appClientCommandArgs);
        AppClientContainer newACC = AppClientFacade.createContainer(builder, launchInfo, appClientCommandArgs);
        newACC.prepare(inst);
        appClientContainer = newACC;
    }

    private static void usage(int exitStatus) {
        System.err.println(AppClientFacade.getUsage());
        System.exit(exitStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void help() throws IOException {
        InputStream is = AppClientFacade.class.getResourceAsStream(MAN_PAGE_PATH);
        if (is == null) {
            AppClientFacade.usage(0);
        }
        try (BufferedReader helpReader = new BufferedReader(new InputStreamReader(is));){
            String line;
            while ((line = helpReader.readLine()) != null) {
                System.err.println(line);
            }
        }
        finally {
            System.exit(0);
        }
    }

    private static String getUsage() {
        return localStrings.getLocalString(stringsAnchor, "main.usage", "appclient [ <classfile> | -client <appjar> ] [-mainclass <appClass-name>|-name <display-name>] [-xml <xml>] [-textauth] [-user <username>] [-password <password>|-passwordfile <password-file>] [-targetserver host[:port][,host[:port]...] [app-args]") + System.lineSeparator() + localStrings.getLocalString(stringsAnchor, "main.usage.1", "  or  :\n\tappclient [ <valid JVM options and valid ACC options> ] [ <appClass-name> | -jar <appjar> ] [app args]");
    }

    private static ACCClassLoader initClassLoader(boolean loaderShouldTransform) throws MalformedURLException {
        ACCClassLoader loader = ACCClassLoader.instance();
        if (loader == null) {
            loader = ACCClassLoader.newInstance(Thread.currentThread().getContextClassLoader(), loaderShouldTransform);
        }
        return loader;
    }

    private static AppClientContainer.Builder createBuilder(TargetServer[] targetServers, ClientContainer clientContainer, AppclientCommandArguments appClientCommandArgs) throws IOException {
        List property;
        AppClientContainer.Builder builder = AppClientContainer.newBuilder(targetServers);
        AppClientFacade.updateClientCredentials(builder, appClientCommandArgs);
        List msc = clientContainer.getMessageSecurityConfig();
        if (msc != null) {
            builder.getMessageSecurityConfig().addAll(clientContainer.getMessageSecurityConfig());
        }
        builder.logger((Logger)((Object)new ACCLogger(clientContainer.getLogService())));
        AuthRealm authRealm = clientContainer.getAuthRealm();
        if (authRealm != null) {
            builder.authRealm(authRealm.getClassname());
        }
        if ((property = clientContainer.getProperty()) != null) {
            builder.containerProperties(property);
        }
        return builder;
    }

    private static void updateClientCredentials(AppClientContainer.Builder builder, AppclientCommandArguments appClientCommandArgs) {
        char[] commandLinePW;
        ClientCredential clientCredential = builder.getClientCredential();
        String user = clientCredential != null ? clientCredential.getUserName() : null;
        char[] pw = clientCredential != null && clientCredential.getPassword() != null ? clientCredential.getPassword().get() : null;
        String commandLineUser = appClientCommandArgs.getUser();
        if (commandLineUser != null) {
            user = commandLineUser;
        }
        if ((commandLinePW = appClientCommandArgs.getPassword()) != null) {
            pw = commandLinePW;
        }
        builder.clientCredentials(user, pw);
    }

    private static AppClientContainer createContainer(AppClientContainer.Builder builder, CommandLaunchInfo launchInfo, AppclientCommandArguments appClientArgs) throws Exception, UserError {
        AppClientContainer container;
        CommandLaunchInfo.ClientLaunchType launchType = launchInfo.getClientLaunchType();
        switch (launchType) {
            case JAR: 
            case DIR: {
                container = AppClientFacade.createContainerForAppClientArchiveOrDir(builder, launchInfo.getClientName(), appClientArgs.getMainclass(), appClientArgs.getName());
                break;
            }
            case URL: {
                container = AppClientFacade.createContainerForJWSLaunch(builder, launchInfo.getClientName(), appClientArgs.getMainclass(), appClientArgs.getName());
                break;
            }
            case CLASS: {
                container = AppClientFacade.createContainerForClassName(builder, launchInfo.getClientName());
                break;
            }
            case CLASSFILE: {
                container = AppClientFacade.createContainerForClassFile(builder, launchInfo.getClientName());
                break;
            }
            default: {
                container = null;
            }
        }
        if (container == null) {
            throw new IllegalArgumentException("cannot choose app client launch type");
        }
        return container;
    }

    private static AppClientContainer createContainerForAppClientArchiveOrDir(AppClientContainer.Builder builder, String appClientPath, String mainClassName, String clientName) throws Exception, UserError {
        return builder.newContainer(Util.getURI(new File(appClientPath)), null, mainClassName, clientName, appClientCommandArgs.isTextauth());
    }

    private static AppClientContainer createContainerForJWSLaunch(AppClientContainer.Builder builder, String appClientPath, String mainClassName, String clientName) throws Exception, UserError {
        return builder.newContainer(URI.create(appClientPath), null, mainClassName, clientName);
    }

    private static AppClientContainer createContainerForClassName(AppClientContainer.Builder builder, String className) throws Exception, UserError {
        ClassLoader loader = AppClientFacade.prepareLoaderToFindClassFile(Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(loader);
        return builder.newContainer(Class.forName(className, true, loader));
    }

    private static ClassLoader prepareLoaderToFindClassFile(ClassLoader currentLoader) throws MalformedURLException {
        File currentDirPath = new File(System.getProperty("user.dir"));
        GlassfishUrlClassLoader newLoader = new GlassfishUrlClassLoader(new URL[]{currentDirPath.toURI().toURL()}, currentLoader);
        return newLoader;
    }

    private static AppClientContainer createContainerForClassFile(AppClientContainer.Builder builder, String classFilePath) throws MalformedURLException, ClassNotFoundException, FileNotFoundException, IOException, Exception, UserError {
        Util.verifyFilePath(classFilePath);
        String className = classFilePath.substring(0, classFilePath.lastIndexOf(".class")).replace(File.separatorChar, '.');
        return AppClientFacade.createContainerForClassName(builder, className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClientContainer readConfig(String configPath, ClassLoader loader) throws UserError, JAXBException, FileNotFoundException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        ClientContainer result = null;
        String configFileLocationForErrorMessage = "";
        try (Reader configReader = null;){
            String configInProperty = System.getProperty(ACC_CONFIG_CONTENT_PROPERTY_NAME);
            if (configInProperty != null) {
                File securityConfigTempFile = Util.writeTextToTempFile(configInProperty, "wss-client-config", ".xml", false);
                Properties p = new Properties();
                p.setProperty("security.config.path", securityConfigTempFile.getAbsolutePath());
                configInProperty = Util.replaceTokens(configInProperty, p);
                configReader = new StringReader(configInProperty);
            } else {
                File configFile = AppClientFacade.checkXMLFile(configPath);
                AppClientFacade.checkXMLFile(appClientCommandArgs.getConfigFilePath());
                configReader = new FileReader(configFile);
                configFileLocationForErrorMessage = configFile.getAbsolutePath();
            }
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setValidating(true);
            spf.setNamespaceAware(true);
            SAXParser parser = spf.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setEntityResolver((EntityResolver)new SaxParserHandlerBundled());
            InputSource inputSource = AppClientFacade.replaceTokensForParsing(configReader);
            SAXSource saxSource = new SAXSource(reader, inputSource);
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ClientContainer.class});
            ValidationEventCollector vec = new ValidationEventCollector();
            Unmarshaller u = jc.createUnmarshaller();
            u.setEventHandler((ValidationEventHandler)vec);
            result = (ClientContainer)u.unmarshal((Source)saxSource);
            if (vec.hasEvents()) {
                boolean isError = false;
                StringBuilder sb = new StringBuilder();
                for (ValidationEvent ve : vec.getEvents()) {
                    sb.append(ve.getMessage()).append(LINE_SEP);
                    isError |= ve.getSeverity() != 0;
                }
                String messageIntroduction = localStrings.getLocalString(AppClientFacade.class, isError ? "appclient.errParsingConfig" : "appclient.warnParsingConfig", isError ? "Error parsing app client container configuration {0}.  Attempting to continue.  In future releases such parsing errors might become fatal.  Please correct your configuration file." : "Warning(s) parsing app client container configuration {0}.  Continuing.", new Object[]{configFileLocationForErrorMessage});
                System.err.println(messageIntroduction + LINE_SEP + sb.toString());
            }
            ClientContainer clientContainer = result;
            return clientContainer;
        }
    }

    private static InputSource replaceTokensForParsing(Reader reader) throws FileNotFoundException, IOException, URISyntaxException {
        int charsRead;
        char[] buffer = new char[1024];
        CharArrayWriter writer = new CharArrayWriter();
        while ((charsRead = reader.read(buffer)) != -1) {
            writer.write(buffer, 0, charsRead);
        }
        writer.close();
        reader.close();
        HashMap<String, String> mapping = new HashMap<String, String>();
        Properties props = System.getProperties();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            mapping.put(propName, props.getProperty(propName));
        }
        TokenResolver resolver = new TokenResolver(mapping);
        String configWithTokensReplaced = resolver.resolve(writer.toString());
        InputSource inputSource = new InputSource(new StringReader(configWithTokensReplaced));
        return inputSource;
    }

    private static File checkXMLFile(String xmlFullName) throws UserError {
        try {
            File f = new File(xmlFullName);
            if (f.exists() && f.isFile() && f.canRead()) {
                return f;
            }
            AppClientFacade.xmlMessage(xmlFullName);
            return null;
        }
        catch (Exception ex) {
            AppClientFacade.xmlMessage(xmlFullName);
            return null;
        }
    }

    private static void xmlMessage(String xmlFullName) throws UserError {
        UserError ue = new UserError(localStrings.getLocalString(stringsAnchor, "main.cannot_read_clientContainer_xml", "Client Container xml: {0} not found or unable to read.\nYou may want to use the -xml option to locate your configuration xml.", (Object[])new String[]{xmlFullName}));
        ue.setUsage(AppClientFacade.getUsage());
        throw ue;
    }
}

