/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.remote.reader;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.glassfish.api.ActionReport;

public class CliActionReport
extends ActionReport {
    private static final String EOL = System.getProperty("line.separator");
    protected Throwable exception = null;
    protected String actionDescription = null;
    protected List<CliActionReport> subActions = new ArrayList<CliActionReport>();
    protected ActionReport.ExitCode exitCode = ActionReport.ExitCode.SUCCESS;
    protected ActionReport.MessagePart topMessage = new ActionReport.MessagePart();

    public void setFailure() {
        this.setActionExitCode(ActionReport.ExitCode.FAILURE);
    }

    public boolean isFailure() {
        return this.getActionExitCode() == ActionReport.ExitCode.FAILURE;
    }

    public void setWarning() {
        this.setActionExitCode(ActionReport.ExitCode.WARNING);
    }

    public boolean isWarning() {
        return this.getActionExitCode() == ActionReport.ExitCode.WARNING;
    }

    public boolean isSuccess() {
        return this.getActionExitCode() == ActionReport.ExitCode.SUCCESS;
    }

    public void setSuccess() {
        this.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    public void setActionDescription(String message) {
        this.actionDescription = message;
    }

    public String getActionDescription() {
        return this.actionDescription;
    }

    public void setFailureCause(Throwable t) {
        this.exception = t;
    }

    public Throwable getFailureCause() {
        return this.exception;
    }

    public ActionReport.MessagePart getTopMessagePart() {
        return this.topMessage;
    }

    public ActionReport addSubActionsReport() {
        CliActionReport subAction = new CliActionReport();
        this.subActions.add(subAction);
        return subAction;
    }

    public List<CliActionReport> getSubActionsReport() {
        return this.subActions;
    }

    public void setActionExitCode(ActionReport.ExitCode exitCode) {
        this.exitCode = exitCode;
    }

    public ActionReport.ExitCode getActionExitCode() {
        return this.exitCode;
    }

    public void setMessage(String message) {
        this.topMessage.setMessage(message);
    }

    public void appendMessage(String message) {
        this.topMessage.appendMessage(message);
    }

    public String getMessage() {
        return this.topMessage.getMessage();
    }

    public String getContentType() {
        throw new UnsupportedOperationException();
    }

    public boolean hasSuccesses() {
        return CliActionReport.has(this, ActionReport.ExitCode.SUCCESS);
    }

    public boolean hasWarnings() {
        return CliActionReport.has(this, ActionReport.ExitCode.WARNING);
    }

    public boolean hasFailures() {
        return CliActionReport.has(this, ActionReport.ExitCode.FAILURE);
    }

    private static boolean has(CliActionReport ar, ActionReport.ExitCode value) {
        if (null != ar.exitCode && ar.exitCode.equals((Object)value)) {
            return true;
        }
        LinkedList<CliActionReport> q = new LinkedList<CliActionReport>();
        q.addAll(ar.subActions);
        while (!q.isEmpty()) {
            CliActionReport lar = (CliActionReport)((Object)q.remove());
            ActionReport.ExitCode ec = lar.getActionExitCode();
            if (null != ec && ec.equals((Object)value)) {
                return true;
            }
            q.addAll(lar.subActions);
        }
        return false;
    }

    public void writeReport(OutputStream os) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void addIndent(int level, StringBuilder sb) {
        for (int i = 0; i < level; ++i) {
            sb.append("    ");
        }
    }

    private void messageToString(int indentLevel, String id, ActionReport.MessagePart msg, StringBuilder sb) {
        if (msg == null) {
            return;
        }
        this.addIndent(indentLevel, sb);
        sb.append("MESSAGE - ").append(id).append(EOL);
        if (msg.getMessage() != null && !msg.getMessage().isEmpty()) {
            this.addIndent(indentLevel, sb);
            sb.append(" : ").append(msg.getMessage()).append(EOL);
        }
        if (msg.getChildrenType() != null) {
            this.addIndent(indentLevel, sb);
            sb.append(" childrenType: ").append(msg.getChildrenType()).append(EOL);
        }
        for (Map.Entry<Object, Object> entry : msg.getProps().entrySet()) {
            this.addIndent(indentLevel, sb);
            sb.append(" >").append(entry.getKey()).append(" = ").append(entry.getValue());
            sb.append(EOL);
        }
        if (msg.getChildren() != null) {
            int counter = 0;
            for (ActionReport.MessagePart child : msg.getChildren()) {
                this.messageToString(indentLevel + 1, id + ".M" + counter, child, sb);
                ++counter;
            }
        }
    }

    private String toString(int indentLevel, String id, CliActionReport ar) {
        if (id == null) {
            id = "0";
        }
        StringBuilder r = new StringBuilder();
        this.addIndent(indentLevel, r);
        r.append("ACTION REPORT - ").append(id);
        r.append(" [").append(ar.getActionExitCode().name()).append(']').append(EOL);
        if (ar.getActionDescription() != null) {
            this.addIndent(indentLevel, r);
            r.append(" actionDescription: ").append(ar.getActionDescription()).append(EOL);
        }
        if (ar.getFailureCause() != null) {
            this.addIndent(indentLevel, r);
            r.append(" failure: ");
            String msg = ar.getFailureCause().getMessage();
            if (msg != null && !msg.isEmpty()) {
                r.append(msg).append(EOL);
            } else {
                r.append('[').append(ar.getFailureCause().getClass().getName());
                r.append(']').append(EOL);
            }
        }
        if (ar.getExtraProperties() != null) {
            for (Map.Entry entry : ar.getExtraProperties().entrySet()) {
                this.addIndent(indentLevel, r);
                r.append(" >").append(entry.getKey()).append(" = ").append(entry.getValue());
                r.append(EOL);
            }
        }
        this.messageToString(indentLevel + 1, id + ".M0", ar.getTopMessagePart(), r);
        r.append(EOL);
        if (ar.getSubActionsReport() != null) {
            int counter = 0;
            for (CliActionReport sub : ar.getSubActionsReport()) {
                r.append(this.toString(indentLevel + 1, id + "." + counter, sub));
                ++counter;
            }
        }
        return r.toString();
    }

    public String toString() {
        return this.toString(0, "0", this);
    }
}

