/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms.tx.log;

import com.sun.messaging.bridge.service.jms.tx.BranchXid;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class BranchXidDecision
implements Externalizable {
    public static final int COMMIT = 0;
    public static final int ROLLBACK = 1;
    public static final int HEUR_COMMIT = 50;
    public static final int HEUR_ROLLBACK = 51;
    public static final int HEUR_MIXED = 52;
    private BranchXid branchXid = null;
    private int branchDecision = 0;

    public BranchXidDecision() {
    }

    public BranchXidDecision(BranchXid xid, int decision) throws Exception {
        if (decision != 0 && decision != 1 && decision != 50 && decision != 51 && decision != 52) {
            throw new IllegalArgumentException("Invalid decision value: " + decision);
        }
        this.branchXid = xid;
        this.branchDecision = decision;
    }

    public boolean isHeuristic() {
        return this.branchDecision == 50 || this.branchDecision == 51 || this.branchDecision == 52;
    }

    public void setBranchDecision(int d) {
        if (d != 0 && d != 1 && d != 50 && d != 51 && d != 52) {
            throw new IllegalArgumentException("Invalid decision value: " + d);
        }
        this.branchDecision = d;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.branchXid.write(out);
        out.writeInt(this.branchDecision);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.branchXid = BranchXid.read(in);
        this.branchDecision = in.readInt();
    }

    private static String decisionString(int d) {
        switch (d) {
            case 0: {
                return "COMMIT";
            }
            case 1: {
                return "ROLLBACK";
            }
            case 50: {
                return "HEUR_COMMIT";
            }
            case 51: {
                return "HEUR_ROLLBACK";
            }
            case 52: {
                return "HEUR_MIXED";
            }
        }
        return "UNKNOWN";
    }

    public String toString() {
        return this.branchXid.toString() + "(" + BranchXidDecision.decisionString(this.branchDecision) + ")";
    }

    public BranchXid getBranchXid() {
        return this.branchXid;
    }

    public int getBranchDecision() {
        return this.branchDecision;
    }
}

