/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms.tx.log;

import com.sun.messaging.bridge.api.DupKeyException;
import com.sun.messaging.bridge.api.JMSBridgeStore;
import com.sun.messaging.bridge.api.KeyNotFoundException;
import com.sun.messaging.bridge.api.UpdateOpaqueDataCallback;
import com.sun.messaging.bridge.service.jms.JMSBridge;
import com.sun.messaging.bridge.service.jms.resources.JMSBridgeResources;
import com.sun.messaging.bridge.service.jms.tx.BranchXid;
import com.sun.messaging.bridge.service.jms.tx.GlobalXid;
import com.sun.messaging.bridge.service.jms.tx.log.LogRecord;
import com.sun.messaging.bridge.service.jms.tx.log.TxLog;
import com.sun.messaging.jmq.io.disk.ObjectInputStreamCallback;
import com.sun.messaging.jmq.io.disk.PHashMap;
import com.sun.messaging.jmq.io.disk.PHashMapLoadException;
import com.sun.messaging.jmq.io.disk.PHashMapMMF;
import com.sun.messaging.jmq.io.disk.VRFileWarning;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.io.FilteringObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileTxLogImpl
extends TxLog
implements JMSBridgeStore,
ObjectInputStreamCallback {
    private static final String FILENAME_BASE = "txlog";
    private static final String FILENAME_JMSBRIDGES = "jmsbridges.list";
    private static final long DEFAULT_TXLOG_SIZE = 1024000L;
    private long _logsize = 1024000L;
    private String _txlogdir = null;
    private String _txlogdirParent = null;
    private String txlogSuffix = null;
    private File _backFile = null;
    private boolean useMmap = true;
    private PHashMap _gxidMap = null;
    private boolean sync = false;
    private static final int DEFAULT_CLIENTDATA_SIZE = 16;
    private int _clientDataSize = 16;
    private static JMSBridgeResources _jbr = JMSBridge.getJMSBridgeResources();

    public void setMaxBranches(int v) throws Exception {
        if (v < 0) {
            throw new IllegalArgumentException("Invalid maximum branches " + v);
        }
        this._clientDataSize = v;
    }

    public void setTxlogSize(String size) throws Exception {
        SizeString ss = new SizeString(size);
        if (ss.getBytes() <= 0L) {
            throw new IllegalArgumentException("Illegal txlog file size " + size);
        }
        this._logsize = ss.getBytes();
    }

    public void setTxlogDir(String d) throws Exception {
        if (d == null || d.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid txlog directory " + d);
        }
        String dir = d.trim();
        File f = new File(dir);
        if (!f.exists()) {
            throw new IllegalArgumentException("txlog directory " + dir + " not exist");
        }
        if (!f.isDirectory()) {
            throw new IllegalArgumentException(dir + " not a directory for txnlog");
        }
        if (!f.canWrite()) {
            throw new IllegalArgumentException("txlog directory " + dir + " not writable");
        }
        this._txlogdir = dir;
    }

    public void setTxlogDirParent(String d) throws Exception {
        if (d == null || d.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid txlogDirParent directory " + d);
        }
        String dir = d.trim();
        File f = new File(dir);
        if (!f.exists()) {
            throw new IllegalArgumentException("txlogDirParent directory " + dir + " not exist");
        }
        if (!f.isDirectory()) {
            throw new IllegalArgumentException(dir + " not a directory for txnlogDirParent");
        }
        if (!f.canWrite()) {
            throw new IllegalArgumentException("txlogDirParent directory " + dir + " not writable");
        }
        this._txlogdirParent = dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logGlobalDecision(LogRecord lr) throws Exception {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "txlog: log global decision  " + String.valueOf(lr));
        }
        String key = lr.getGlobalXid().toString();
        super.checkClosedAndSetInProgress();
        try {
            Object oldlr = this._gxidMap.putIfAbsent((Object)key, (Object)lr);
            if (oldlr != null) {
                String emsg = key + " already exist in txlog: " + String.valueOf(oldlr);
                this._logger.log(Level.SEVERE, emsg);
                throw new IllegalStateException(emsg);
            }
            if (this.sync) {
                this._gxidMap.force((Object)key);
            }
        }
        finally {
            super.setInProgress(false);
        }
    }

    @Override
    public LogRecord getLogRecord(GlobalXid gxid) throws Exception {
        return this.getLogRecord(gxid.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogRecord getLogRecord(String gxid) throws Exception {
        String key = gxid;
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "txlog: get txlog log record: " + key);
        }
        super.checkClosedAndSetInProgress();
        try {
            LogRecord lr;
            LogRecord logRecord = lr = (LogRecord)this._gxidMap.get((Object)key);
            return logRecord;
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logHeuristicBranch(BranchXid bxid, LogRecord lr) throws Exception {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "txlog: log branch heuristic decision  " + String.valueOf(lr));
        }
        String key = lr.getGlobalXid().toString();
        super.checkClosedAndSetInProgress();
        try {
            LogRecord oldlr = (LogRecord)this._gxidMap.get((Object)key);
            if (oldlr == null) {
                this.logGlobalDecision(lr);
                if (this.sync) {
                    this._gxidMap.force((Object)key);
                }
                return;
            }
            if (oldlr.getBranchDecision(bxid) == lr.getBranchDecision(bxid)) {
                return;
            }
            oldlr.setBranchDecision(bxid, lr.getBranchDecision(bxid));
            if (this.useMmap) {
                if (oldlr.getBranchCount() > this._clientDataSize) {
                    throw new IllegalArgumentException("The number of branches exceeded maximum " + this._clientDataSize + " allowed");
                }
                byte[] oldcd = ((PHashMapMMF)this._gxidMap).getClientData((Object)key);
                oldlr.updateClientDataFromBranch(oldcd, bxid);
                ((PHashMapMMF)this._gxidMap).putClientData((Object)key, oldcd);
            } else {
                this._gxidMap.put((Object)key, (Object)oldlr);
            }
            if (this.sync) {
                this._gxidMap.force((Object)key);
            }
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reap(String gxid) throws Exception {
        String key = gxid;
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "txlog: Remove " + key);
        }
        super.checkClosedAndSetInProgress();
        try {
            Object lr = this._gxidMap.remove((Object)key);
            if (lr == null) {
                String emsg = gxid + " not found in txlog";
                this._logger.log(Level.SEVERE, emsg);
                throw new IllegalArgumentException(emsg);
            }
            if (this.sync) {
                this._gxidMap.force((Object)key);
            }
        }
        finally {
            super.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LogRecord> getAllLogRecords() throws Exception {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "txlog: get all log records");
        }
        super.checkClosedAndSetInProgress();
        try {
            ArrayList<LogRecord> list = new ArrayList<LogRecord>(this._gxidMap.size());
            Iterator itr = this._gxidMap.entrySet().iterator();
            Map.Entry entry = null;
            LogRecord lr = null;
            while (itr.hasNext()) {
                entry = (Map.Entry)itr.next();
                lr = (LogRecord)entry.getValue();
                list.add(lr);
            }
            ArrayList<LogRecord> arrayList = list;
            return arrayList;
        }
        finally {
            super.setInProgress(false);
        }
    }

    public List<String> getAllLogRecordKeys() throws Exception {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "txlog: get all log record keys");
        }
        super.checkClosedAndSetInProgress();
        try {
            ArrayList<String> list;
            ArrayList<String> arrayList = list = new ArrayList<String>(this._gxidMap.keySet());
            return arrayList;
        }
        finally {
            super.setInProgress(false);
        }
    }

    public ObjectInputStream getObjectInputStream(ByteArrayInputStream bis) throws IOException {
        return new FilteringObjectInputStream((InputStream)bis);
    }

    @Override
    public void init(Properties props, boolean reset) throws Exception {
        String fname;
        if (this._logger == null) {
            throw new IllegalStateException("No logger set");
        }
        super.init(props, reset);
        if (props != null) {
            Enumeration<?> en = props.propertyNames();
            String name = null;
            String value = null;
            while (en.hasMoreElements()) {
                name = (String)en.nextElement();
                value = props.getProperty(name);
                this._logger.log(Level.INFO, _jbr.getString("BSJ1058", name + "=" + value, this._tmname));
                this.setProperty(name, value);
            }
        }
        if (this._txlogdir == null) {
            throw new IllegalStateException("Property txlogDir not set");
        }
        String string = fname = this.txlogSuffix == null ? FILENAME_BASE : "txlog." + this.txlogSuffix;
        if (reset) {
            String fn;
            File f;
            this._logger.log(Level.INFO, _jbr.getString("BSJ1059", fname));
            if (this._txlogdirParent != null && (f = new File(fn = this._txlogdirParent + File.separator + FILENAME_JMSBRIDGES)).exists() && !f.delete()) {
                this._logger.log(Level.WARNING, "Failed to delete file " + fn + " on reset");
                File dfn = new File(this._txlogdirParent, "jmsbridges.list.deleted");
                if (!f.renameTo(dfn)) {
                    this._logger.log(Level.WARNING, "Failed rename file " + fn + " to " + String.valueOf(dfn) + " after deletion failure");
                }
            }
        } else {
            this._logger.log(Level.INFO, _jbr.getString("BSJ1060", fname));
        }
        this._backFile = new File(this._txlogdir, fname);
        if (this.useMmap) {
            this._gxidMap = new PHashMapMMF(this._backFile, this._logsize, 1024, false, reset, false, false);
            ((PHashMapMMF)this._gxidMap).intClientData(this._clientDataSize);
        } else {
            this._gxidMap = new PHashMap(this._backFile, this._logsize, 1024, false, reset, false, false);
        }
        try {
            this._gxidMap.load((ObjectInputStreamCallback)this);
            if (this._clientDataSize > 0) {
                this.loadClientData();
            }
        }
        catch (PHashMapLoadException pe) {
            this._logger.log(Level.WARNING, "Exception in loading txlog " + String.valueOf(this._backFile), pe);
            throw pe;
        }
        VRFileWarning w = this._gxidMap.getWarning();
        if (w != null) {
            this._logger.log(Level.WARNING, "Warning in loading txlog, possible loss of record", (Throwable)w);
        }
        this._logger.log(Level.INFO, _jbr.getString("BSJ1061", this._backFile, String.valueOf(this._gxidMap.size())));
    }

    private void setProperty(String key, String value) throws Exception {
        if (key.equals("txlogDir")) {
            this.setTxlogDir(value);
            return;
        }
        if (key.equals("txlogSuffix")) {
            this.setTxlogSuffix(value);
            return;
        }
        if (key.equals("txlogSize")) {
            this.setTxlogSize(value);
            return;
        }
        if (key.equals("txlogSync")) {
            this.setSync(Boolean.parseBoolean(value));
            return;
        }
        if (key.equals("txlogMmap")) {
            this.setUseMmap(Boolean.parseBoolean(value));
            return;
        }
        if (key.equals("txlogMaxBranches")) {
            this.setMaxBranches(Integer.parseInt(value));
            return;
        }
        if (key.equals("txlogDirParent")) {
            this.setTxlogDirParent(value);
            return;
        }
    }

    private void loadClientData() throws PHashMapLoadException {
        if (!this.useMmap) {
            return;
        }
        PHashMapLoadException loadException = null;
        Iterator itr = this._gxidMap.entrySet().iterator();
        while (itr.hasNext()) {
            Throwable ex = null;
            Map.Entry entry = (Map.Entry)itr.next();
            Object key = entry.getKey();
            LogRecord value = (LogRecord)entry.getValue();
            int cnt = value.getBranchCount();
            if (cnt <= 0) continue;
            byte[] cdata = null;
            try {
                cdata = ((PHashMapMMF)this._gxidMap).getClientData(key);
                if (cdata != null && cdata.length > 0) {
                    value.updateBranchFromClientData(cdata);
                }
            }
            catch (Throwable e) {
                ex = e;
            }
            if (ex == null) continue;
            PHashMapLoadException le = new PHashMapLoadException("Failed to load client data [cdata=" + Arrays.toString(cdata) + "]");
            le.setKey(key);
            le.setValue((Object)value);
            le.setNextException(loadException);
            le.initCause(ex);
            loadException = le;
        }
        if (loadException != null) {
            throw loadException;
        }
    }

    @Override
    public void close() throws Exception {
        this._logger.log(Level.INFO, _jbr.getString("BSJ1062", this._backFile, String.valueOf(this._gxidMap.size())));
        super.setClosedAndWait();
        super.close();
        if (this._gxidMap != null) {
            this._gxidMap.close();
        }
    }

    @Override
    public void storeTMLogRecord(String xid, byte[] logRecord, String name, boolean sync, Logger logger_) throws DupKeyException, Exception {
        FilteringObjectInputStream ois = new FilteringObjectInputStream((InputStream)new ByteArrayInputStream(logRecord));
        LogRecord lr = (LogRecord)ois.readObject();
        this.logGlobalDecision(lr);
    }

    @Override
    public void updateTMLogRecord(String xid, byte[] logRecord, String name, UpdateOpaqueDataCallback callback, boolean addIfNotExist, boolean sync, Logger logger_) throws KeyNotFoundException, Exception {
        throw new UnsupportedOperationException("updateTMLogRecord");
    }

    @Override
    public void removeTMLogRecord(String xid, String name, boolean sync, Logger logger_) throws KeyNotFoundException, Exception {
        throw new UnsupportedOperationException("removeTMLogRecord");
    }

    @Override
    public byte[] getTMLogRecord(String xid, String name, Logger logger_) throws Exception {
        LogRecord lr = this.getLogRecord(xid);
        if (lr != null) {
            return lr.toBytes();
        }
        return null;
    }

    @Override
    public long getTMLogRecordUpdatedTime(String xid, String name, Logger logger_) throws KeyNotFoundException, Exception {
        throw new UnsupportedOperationException("getTMLogRecordUpdatedTime");
    }

    @Override
    public long getTMLogRecordCreatedTime(String xid, String name, Logger logger_) throws Exception {
        if (xid == null) {
            throw new IllegalArgumentException("null xid");
        }
        throw new UnsupportedOperationException("getTMLogRecordCreatedTime");
    }

    @Override
    public List getTMLogRecordsByName(String name, Logger logger_) throws Exception {
        throw new UnsupportedOperationException("getTMLogRecordsByName");
    }

    @Override
    public List<String> getTMLogRecordKeysByName(String name, Logger logger_) throws Exception {
        if (!this._jmsbridge.equals(name)) {
            throw new IllegalArgumentException("Unexpected jmsbridge name " + name + " expected " + this._jmsbridge);
        }
        return this.getAllLogRecordKeys();
    }

    @Override
    public void addJMSBridge(String name, boolean sync, Logger logger_) throws DupKeyException, Exception {
        throw new UnsupportedOperationException("addJMSBridge");
    }

    @Override
    public List getJMSBridges(Logger logger_) throws Exception {
        if (this._txlogdirParent == null) {
            throw new UnsupportedOperationException("getJMSBridges: txlogDirParent property not available");
        }
        File dir = new File(this._txlogdirParent);
        if (!dir.exists()) {
            throw new IOException("Unexpected error: " + this._txlogdirParent + " does not exist !");
        }
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IOException("Can't list files in " + this._txlogdirParent);
        }
        if (files.length == 0) {
            return null;
        }
        ArrayList<String> bridges = new ArrayList<String>();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            bridges.add(files[i].getName());
        }
        return bridges;
    }

    @Override
    public long getJMSBridgeUpdatedTime(String name, Logger logger_) throws KeyNotFoundException, Exception {
        throw new UnsupportedOperationException("addJMSBridge");
    }

    @Override
    public long getJMSBridgeCreatedTime(String name, Logger logger_) throws KeyNotFoundException, Exception {
        throw new UnsupportedOperationException("addJMSBridge");
    }

    @Override
    public void closeJMSBridgeStore() throws Exception {
        this.close();
    }

    public void setTxlogSuffix(String txlogSuffix) {
        this.txlogSuffix = txlogSuffix;
    }

    public void setUseMmap(boolean useMmap) {
        this.useMmap = useMmap;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }
}

