/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.io.Status;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.api.FileTransferCallback;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.HAClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ClusterManagerImpl;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.ExclusiveRequest;
import com.sun.messaging.jmq.jmsserver.multibroker.BrokerInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.CallbackDispatcher;
import com.sun.messaging.jmq.jmsserver.multibroker.ChangeRecord;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.multibroker.ClusterBrokerInfoReply;
import com.sun.messaging.jmq.jmsserver.multibroker.ClusterGlobals;
import com.sun.messaging.jmq.jmsserver.multibroker.DestinationUpdateChangeRecord;
import com.sun.messaging.jmq.jmsserver.multibroker.HandshakeInProgressException;
import com.sun.messaging.jmq.jmsserver.multibroker.InterestUpdateChangeRecord;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.Protocol;
import com.sun.messaging.jmq.jmsserver.multibroker.heartbeat.HeartbeatService;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.BroadcastAnyOKReplyWaiter;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterConsumerInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterDestInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterGoodbyeInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterInfoInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterInfoRequestInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterMessageAckInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterMessageInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterNewMasterBrokerInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterNewMasterBrokerPrepareInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterNotifyPartitionArrivalInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterReplicationGroupInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterSubscriptionInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterTakeoverInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterTakeoverMEInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterTakeoverMEPrepareInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterTransferFileRequestInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterTxnInfoInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterTxnInquiryInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.MessageAckReplyWaiter;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ReplyStatus;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ReplyTracker;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.Resource;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.TakeoverCleanupThread;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.TakeoverPendingReplyWaiter;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.TakingoverEntry;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.UnicastReplyWaiter;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.ClientClosedHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.ClusterFlowControlHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.ConfigChangeEventHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.DestinationUpdateHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.FirstInfoHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.GetConfigChangesHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.GetInterestUpdateHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.GoodbyeHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.InfoHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.InterestUpdateHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.LockHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.MessageAckHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.MessageDataHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.NewInterestHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.NewMasterBrokerHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.NotifyPartitionArrivalHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.PingHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.ReloadClusterHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.RemDurableHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.ReplicationGroupInfoHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.TakeoverAbortHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.TakeoverCompleteHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.TakeoverMEHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.TakeoverPendingHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.TransactionInfoHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.TransactionInquiryHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.TransferFileRequestHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.UnknownPacketHandler;
import com.sun.messaging.jmq.jmsserver.persist.api.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.persist.api.MigratableStore;
import com.sun.messaging.jmq.jmsserver.persist.api.PartitionListener;
import com.sun.messaging.jmq.jmsserver.persist.api.ReplicableStore;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.api.StoreSessionReaperListener;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.ServiceRestriction;
import com.sun.messaging.jmq.jmsserver.util.AckEntryNotFoundException;
import com.sun.messaging.jmq.jmsserver.util.BrokerDownException;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.LoggerWrapper;
import com.sun.messaging.jmq.util.MQThreadGroup;
import com.sun.messaging.jmq.util.SupportUtil;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.UniqueID;
import com.sun.messaging.jmq.util.admin.MessageType;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Random;
import java.util.Set;

public class RaptorProtocol
implements Protocol,
PartitionListener,
StoreSessionReaperListener {
    protected static final Logger logger = Globals.getLogger();
    protected static final BrokerResources br = Globals.getBrokerResources();
    private static boolean DEBUG = false;
    protected static final boolean DEBUG_CLUSTER_ALL = Globals.getConfig().getBooleanProperty("imq.cluster.debug.all") || DEBUG;
    protected static final boolean DEBUG_CLUSTER_CONN = Globals.getConfig().getBooleanProperty("imq.cluster.debug.conn") || DEBUG_CLUSTER_ALL;
    protected static final boolean DEBUG_CLUSTER_TXN = Globals.getConfig().getBooleanProperty("imq.cluster.debug.txn") || DEBUG_CLUSTER_ALL;
    protected static final boolean DEBUG_CLUSTER_MSG = Globals.getConfig().getBooleanProperty("imq.cluster.debug.msg") || DEBUG_CLUSTER_TXN || DEBUG_CLUSTER_ALL;
    protected static final boolean DEBUG_CLUSTER_TAKEOVER = Globals.getConfig().getBooleanProperty("imq.cluster.debug.takeover") || DEBUG_CLUSTER_ALL;
    protected MessageBusCallback cb = null;
    protected Cluster c = null;
    protected BrokerAddress selfAddress = null;
    protected BrokerInfo selfInfo = null;
    protected CallbackDispatcher cbDispatcher = null;
    private static final int version = ProtocolGlobals.getCurrentVersion();
    private boolean shutdown = false;
    protected Map brokerList = null;
    private Map<TakingoverEntry, TakingoverEntry> takingoverBrokers = null;
    protected HashMap resTable = null;
    protected Random random = null;
    protected boolean configSyncComplete = false;
    private Map eventLogWaiters = null;
    protected Object cfgSrvWaitObject = null;
    protected int cfgSrvRequestCount = 0;
    protected boolean cfgSrvRequestErr = false;
    protected Store store = null;
    protected GPacketHandler[] handlers;
    protected GPacketHandler unknownPacketHandler;
    protected boolean flowStopped = false;
    private int takeoverPendingReplyTimeout = 60;
    private Map myPretakeovers = null;
    private ThreadGroup takeoverCleanupTG = new MQThreadGroup("TakeoverCleanup", (LoggerWrapper)logger, br.getKString("B2258"));
    private FaultInjection fi = null;
    private HashMap ackCounts = new HashMap();
    private ReplyTracker ackackTracker = null;
    private ReplyTracker broadcastAnyOKReplyTracker = null;
    private ReplyTracker takeoverPendingReplyTracker = null;
    private ReplyTracker newMasterBrokerReplyTracker = null;
    private ReplyTracker takeoverMEReplyTracker = null;
    protected int changeMasterBrokerWaitTimeout = Globals.getConfig().getIntProperty("imq.cluster.changeMasterBrokerWaitTimeout", 180);
    private Object masterBrokerBlockedLock = new Object();
    private Object configOpLock = new Object();
    private int configOpInProgressCount = 0;
    private boolean masterBrokerBlocked = false;
    private Object newMasterBrokerLock = new Object();
    private String newMasterBrokerPreparedUUID = null;
    private BrokerAddress newMasterBrokerPreparedSender = null;
    private DestinationList DL = Globals.getDestinationList();
    private Map<String, ChangeRecord> inDSubToBrokerMap = Collections.synchronizedMap(new HashMap());

    public RaptorProtocol(MessageBusCallback cb, Cluster c, BrokerAddress myaddress, BrokerInfo myinfo) throws BrokerException {
        if (DEBUG_CLUSTER_ALL) {
            DEBUG = DEBUG_CLUSTER_ALL;
        }
        if (DEBUG) {
            logger.log(8, "Initializing RaptorProtocol");
        }
        this.cb = cb;
        this.c = c;
        this.selfAddress = myaddress;
        this.selfInfo = myinfo;
        this.cbDispatcher = new CallbackDispatcher(cb);
        this.store = Globals.getStore();
        this.resTable = new HashMap();
        this.random = new Random();
        this.brokerList = Collections.synchronizedMap(new LinkedHashMap());
        this.takingoverBrokers = Collections.synchronizedMap(new LinkedHashMap());
        this.myPretakeovers = Collections.synchronizedMap(new LinkedHashMap());
        this.cfgSrvWaitObject = new Object();
        this.eventLogWaiters = Collections.synchronizedMap(new LinkedHashMap());
        this.initHandlers();
        String backupFileName = Globals.getConfig().getProperty("imq.cluster.masterbroker.backup");
        String restoreFileName = Globals.getConfig().getProperty("imq.cluster.masterbroker.restore");
        if (backupFileName != null) {
            this.configServerBackup(backupFileName);
        }
        if (restoreFileName != null) {
            this.configServerRestore(restoreFileName);
        }
        this.ackackTracker = new ReplyTracker();
        this.newMasterBrokerReplyTracker = new ReplyTracker();
        this.takeoverMEReplyTracker = new ReplyTracker();
        this.takeoverPendingReplyTracker = new ReplyTracker();
        this.broadcastAnyOKReplyTracker = new ReplyTracker();
        this.fi = FaultInjection.getInjection();
    }

    private void addHandler(int id, GPacketHandler h) {
        if (id > 76) {
            throw new ArrayIndexOutOfBoundsException("Bad ProtocolHandler");
        }
        this.handlers[id] = h;
    }

    private void initHandlers() {
        if (DEBUG) {
            logger.log(8, "Initializing RaptorProtocol handlers");
        }
        this.handlers = new GPacketHandler[77];
        GPacketHandler h = new MessageDataHandler(this);
        this.addHandler(1, h);
        this.addHandler(2, h);
        h = new MessageAckHandler(this);
        this.addHandler(3, h);
        this.addHandler(4, h);
        h = new NewInterestHandler(this);
        this.addHandler(5, h);
        this.addHandler(6, h);
        this.addHandler(35, h);
        this.addHandler(36, h);
        h = new RemDurableHandler(this);
        this.addHandler(7, h);
        this.addHandler(8, h);
        h = new InterestUpdateHandler(this);
        this.addHandler(9, h);
        this.addHandler(10, h);
        h = new LockHandler(this);
        this.addHandler(11, h);
        this.addHandler(12, h);
        h = new DestinationUpdateHandler(this);
        this.addHandler(13, h);
        this.addHandler(14, h);
        this.addHandler(15, h);
        this.addHandler(16, h);
        h = new ConfigChangeEventHandler(this);
        this.addHandler(17, h);
        this.addHandler(18, h);
        h = new GetConfigChangesHandler(this);
        this.addHandler(19, h);
        this.addHandler(20, h);
        h = new ClientClosedHandler(this);
        this.addHandler(21, h);
        this.addHandler(22, h);
        h = new ClusterFlowControlHandler(this);
        this.addHandler(23, h);
        this.addHandler(24, h);
        this.addHandler(25, h);
        this.addHandler(26, h);
        h = new ReloadClusterHandler(this);
        this.addHandler(27, h);
        this.addHandler(28, h);
        h = new GetInterestUpdateHandler(this);
        this.addHandler(29, h);
        this.addHandler(30, h);
        h = new PingHandler(this);
        this.addHandler(33, h);
        this.addHandler(34, h);
        h = new GoodbyeHandler(this);
        this.addHandler(37, h);
        this.addHandler(38, h);
        h = new TakeoverCompleteHandler(this);
        this.addHandler(41, h);
        h = new TakeoverPendingHandler(this);
        this.addHandler(39, h);
        this.addHandler(40, h);
        h = new TakeoverAbortHandler(this);
        this.addHandler(43, h);
        h = new TransactionInquiryHandler(this);
        this.addHandler(47, h);
        h = new TransactionInfoHandler(this);
        this.addHandler(48, h);
        h = new FirstInfoHandler(this);
        this.addHandler(49, h);
        h = new NewMasterBrokerHandler(this);
        this.addHandler(51, h);
        this.addHandler(52, h);
        this.addHandler(53, h);
        this.addHandler(54, h);
        h = new ReplicationGroupInfoHandler(this);
        this.addHandler(55, h);
        h = new TakeoverMEHandler(this);
        this.addHandler(57, h);
        this.addHandler(58, h);
        this.addHandler(59, h);
        this.addHandler(60, h);
        this.addHandler(61, h);
        h = new TransferFileRequestHandler(this);
        this.addHandler(63, h);
        this.addHandler(64, h);
        h = new InfoHandler(this);
        this.addHandler(73, h);
        this.addHandler(74, h);
        h = new NotifyPartitionArrivalHandler(this);
        this.addHandler(75, h);
        this.addHandler(76, h);
        this.unknownPacketHandler = new UnknownPacketHandler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hashtable getDebugState() {
        Hashtable<Object, Object> ht = new Hashtable<Object, Object>();
        ArrayList<Object> l = null;
        Map map = this.brokerList;
        synchronized (map) {
            l = new ArrayList(this.brokerList.keySet());
        }
        ht.put("brokerListCount", l.size());
        for (Object ba : l) {
            BrokerInfoEx brokerInfoEx = (BrokerInfoEx)this.brokerList.get(ba);
            ht.put("[brokerList]" + ba.toString(), brokerInfoEx.toString());
        }
        if (this.cbDispatcher != null) {
            ht.put("callbackDispatcher", this.cbDispatcher.getDebugState());
        }
        if (Globals.getHAEnabled()) {
            Object ba;
            ba = this.takingoverBrokers;
            synchronized (ba) {
                l = new ArrayList<TakingoverEntry>(this.takingoverBrokers.keySet());
            }
            ht.put("takingoverBrokersCount", l.size());
            for (TakingoverEntry takingoverEntry : l) {
                ht.put(takingoverEntry.toString(), takingoverEntry.toLongString());
            }
        }
        return ht;
    }

    @Override
    public int getHighestSupportedVersion() {
        return ProtocolGlobals.getCurrentVersion();
    }

    @Override
    public int getClusterVersion() {
        return version;
    }

    @Override
    public void receiveUnicast(BrokerAddress sender, GPacket pkt) {
        short pktType;
        if (DEBUG) {
            logger.log(2, "RaptorProtocol.receiveUnicast(GPacket) from : " + sender + " Packet :\n" + pkt.toLongString());
        }
        if ((pktType = pkt.getType()) > 76) {
            this.unknownPacketHandler.handle(sender, pkt);
            return;
        }
        switch (pktType) {
            case 4: {
                this.cbDispatcher.processMessageAckReply(sender, pkt, this);
                return;
            }
            case 1: 
            case 6: 
            case 8: 
            case 10: 
            case 22: 
            case 36: {
                this.cbDispatcher.processMessageData(sender, pkt, this);
                return;
            }
            case 5: 
            case 35: {
                if (((NewInterestHandler)this.handlers[pktType]).ignoreNewInterest(null, pkt)) {
                    return;
                }
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 47: 
            case 48: 
            case 73: 
            case 74: {
                this.cbDispatcher.processGPacket(sender, pkt, this);
                return;
            }
        }
        this.handlers[pktType].handle(sender, pkt);
    }

    @Override
    public void receiveBroadcast(BrokerAddress sender, GPacket pkt) {
        short pktType;
        if (DEBUG) {
            logger.log(2, "RaptorProtocol.receiveBroadcast(GPacket) from : " + sender + " Packet :\n" + pkt.toLongString());
        }
        if ((pktType = pkt.getType()) > 76) {
            this.unknownPacketHandler.handle(sender, pkt);
            return;
        }
        switch (pktType) {
            case 5: 
            case 35: {
                if (((NewInterestHandler)this.handlers[pktType]).ignoreNewInterest(null, pkt)) {
                    return;
                }
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 22: 
            case 36: 
            case 47: 
            case 48: 
            case 73: 
            case 74: {
                this.cbDispatcher.processGPacket(sender, pkt, this);
                return;
            }
        }
        this.handlers[pktType].handle(sender, pkt);
    }

    @Override
    public void handleGPacket(MessageBusCallback mbcb, BrokerAddress sender, GPacket pkt) {
        this.handlers[pkt.getType()].handle(mbcb, sender, pkt);
    }

    @Override
    public void receiveUnicast(BrokerAddress sender, int destId, byte[] pkt) {
        logger.log(16, "Protocol Mismatch. sender = " + sender);
        Thread.dumpStack();
    }

    @Override
    public void receiveBroadcast(BrokerAddress sender, int destId, byte[] pkt) {
        logger.log(16, "Protocol Mismatch. sender = " + sender);
        Thread.dumpStack();
    }

    public void receiveBroadcast(BrokerAddress sender, int destId, byte[] pkt, boolean configSyncResponse) {
        logger.log(16, "Protocol Mismatch. sender = " + sender);
        Thread.dumpStack();
    }

    @Override
    public void syncChangeRecordOnJoin(BrokerAddress broker, ChangeRecordInfo cri) throws BrokerException {
        this.cb.syncChangeRecordOnJoin(broker, cri);
    }

    @Override
    public ChangeRecordInfo getLastStoredChangeRecord() {
        return this.cb.getLastStoredChangeRecord();
    }

    @Override
    public BrokerInfo getBrokerInfo() {
        logger.logStack(32, "B3100", (Object)"Unexpected call", (Throwable)new Exception());
        return null;
    }

    @Override
    public ClusterBrokerInfoReply getBrokerInfoReply(BrokerInfo remoteInfo) throws Exception {
        this.checkUIDPrefixClash(remoteInfo);
        int status = 0;
        if (this.isTakeoverTarget(remoteInfo.getBrokerAddr())) {
            status = 1;
        }
        ClusterBrokerInfoReply cbi = ClusterBrokerInfoReply.newInstance(this.selfInfo, status);
        return cbi;
    }

    private void checkUIDPrefixClash(BrokerInfo info) throws BrokerException {
        if (this.c.getConfigServer() == null && UniqueID.getPrefix((long)info.getBrokerAddr().getBrokerSessionUID().longValue()) == UniqueID.getPrefix((long)this.selfInfo.getBrokerAddr().getBrokerSessionUID().longValue())) {
            BrokerAddress remote = info.getBrokerAddr();
            if (this.selfInfo.getStartTime() > info.getStartTime() || this.selfInfo.getStartTime() == info.getStartTime() && this.selfInfo.getBrokerAddr().getMQAddress().toString().compareTo(remote.getMQAddress().toString()) > 0) {
                String msg = br.getKString("B3185", remote);
                BrokerException ex = new BrokerException(msg);
                logger.logStack(32, msg, (Throwable)ex);
                Broker broker = Broker.getBroker();
                Globals.getBrokerStateHandler();
                broker.exit(BrokerStateHandler.getRestartCode(), msg, BrokerEvent.Type.RESTART, null, false, true, false);
            }
        }
    }

    @Override
    public void setMatchProps(Properties matchProps) {
        if (DEBUG) {
            logger.log(8, "RaptorProtocol.setMatchProps :\n" + matchProps);
        }
        this.c.setMatchProps(matchProps);
    }

    @Override
    public void startClusterIO() {
        if (DEBUG) {
            logger.log(8, "RaptorProtocol.startClusterIO");
        }
        try {
            BrokerAddress configServer = this.c.getConfigServer();
            if (configServer == null) {
                this.configSyncComplete = true;
                if (DEBUG) {
                    logger.log(8, "No master broker. configSyncComplete=true");
                }
            } else if (configServer.equals(this.selfAddress)) {
                this.initConfigServer();
                long timestamp = this.getLastRefreshTime();
                this.sendConfigChangesRequest(this.selfAddress, timestamp);
            }
        }
        catch (Exception configServer) {
            // empty catch block
        }
        Globals.getDestinationList();
        DestinationList.addPartitionListener(this);
        try {
            this.store.addPartitionListener(this);
            if (Globals.getHAEnabled()) {
                this.store.addStoreSessionReaperListener(this);
            }
        }
        catch (Exception e) {
            if (DEBUG) {
                logger.logStack(16, "Unable to add store listener: " + e.getMessage(), (Throwable)e);
            }
            logger.log(16, "Unable to add store listener: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void partitionAdded(UID partitionID, Object source) {
        if (!(source instanceof DestinationList)) {
            return;
        }
        ClusterInfoInfo cii = ClusterInfoInfo.newInstance();
        cii.partitionAdded(partitionID);
        GPacket gp = cii.getGPacket();
        BrokerAddress[] addrs = this.getBrokerList(null, Globals.getMyAddress());
        for (int i = 0; i < addrs.length; ++i) {
            logger.log(8, br.getKString("B1172", ProtocolGlobals.getPacketTypeDisplayString(gp.getType()) + "[" + cii + "]", addrs[i]));
            try {
                this.c.unicast(addrs[i], gp);
                continue;
            }
            catch (Exception e) {
                logger.log(16, br.getKString("B2110", ProtocolGlobals.getPacketTypeDisplayString(gp.getType()), addrs[i]) + ": " + e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void partitionRemoved(UID partitionID, Object source, Object destinedTo) {
        if (destinedTo != null) {
            return;
        }
        if (!(source instanceof Store)) {
            return;
        }
        ArrayList<TakingoverEntry> entries = null;
        Map<TakingoverEntry, TakingoverEntry> map = this.takingoverBrokers;
        synchronized (map) {
            entries = new ArrayList<TakingoverEntry>(this.takingoverBrokers.keySet());
        }
        Iterator itr = entries.iterator();
        TakingoverEntry toe = null;
        while (itr.hasNext()) {
            toe = (TakingoverEntry)itr.next();
            if (!toe.storeSession.equals((Object)partitionID)) continue;
            this.takingoverBrokers.remove(toe);
            logger.log(8, br.getKString("B1487", toe.toLongString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runStoreSessionTask() {
        ArrayList<TakingoverEntry> entries = null;
        Map<TakingoverEntry, TakingoverEntry> map = this.takingoverBrokers;
        synchronized (map) {
            entries = new ArrayList<TakingoverEntry>(this.takingoverBrokers.keySet());
        }
        Iterator itr = entries.iterator();
        TakingoverEntry toe = null;
        while (itr.hasNext()) {
            toe = (TakingoverEntry)itr.next();
            try {
                if (this.store.getStoreSessionOwner(toe.storeSession.longValue()) != null) continue;
                this.takingoverBrokers.remove(toe);
                logger.log(8, br.getKString("B1487", toe.toLongString()) + ", (" + this.takingoverBrokers.size() + ")");
            }
            catch (Exception e) {
                logger.logStack(16, e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopClusterIO(boolean requestTakeover, boolean force, BrokerAddress excludedBroker) {
        if (DEBUG) {
            logger.log(8, "RaptorProtocol.shutdown");
        }
        if (excludedBroker == null) {
            Object object = this.brokerList;
            synchronized (object) {
                this.shutdown = true;
            }
            object = this.configOpLock;
            synchronized (object) {
                this.configOpLock.notifyAll();
            }
        }
        this.cbDispatcher.shutdown();
        try {
            if (Globals.getClusterBroadcast().getClusterVersion() < 400) {
                return;
            }
        }
        catch (Exception e) {
            logger.log(4, "Unable to get cluster version on stop cluster IO:" + e.getMessage());
            return;
        }
        ClusterGoodbyeInfo cgi = ClusterGoodbyeInfo.newInstance(requestTakeover, this.c);
        Map map = this.brokerList;
        synchronized (map) {
            for (BrokerInfoEx be : this.brokerList.values()) {
                BrokerAddress ba = be.getBrokerInfo().getBrokerAddr();
                if (excludedBroker != null && ba.equals(excludedBroker)) continue;
                GPacket gp = cgi.getGPacket();
                try {
                    logger.log(8, br.getKString("B1172", ProtocolGlobals.getPacketTypeDisplayString(gp.getType()) + "[" + cgi + "]", ba.toString()));
                    this.c.unicast(ba, gp);
                    be.goodbyeSent();
                }
                catch (IOException e) {
                    logger.log(16, br.getKString("B2110", ProtocolGlobals.getPacketTypeDisplayString(gp.getType()), ba) + ": " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goodbyeReceived(BrokerAddress sender, ClusterGoodbyeInfo cgi) {
        Object[] args = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(37), "[" + cgi + "]", sender};
        logger.log(8, br.getKString("B1173", args));
        Map map = this.brokerList;
        synchronized (map) {
            BrokerInfoEx be = (BrokerInfoEx)this.brokerList.get(sender);
            if (be != null) {
                be.setGoodbyeInfo(cgi);
                be.goodbyeReceived();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goodbyeReplySent(BrokerAddress sender) {
        Map map = this.brokerList;
        synchronized (map) {
            BrokerInfoEx be = (BrokerInfoEx)this.brokerList.get(sender);
            if (be != null) {
                be.goodbyeReplySent();
                if (DEBUG) {
                    logger.log(8, "Sent GOODBYE_REPLY to " + sender);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goodbyeReplyReceived(BrokerAddress sender) {
        Map map = this.brokerList;
        synchronized (map) {
            BrokerInfoEx be = (BrokerInfoEx)this.brokerList.get(sender);
            if (be != null) {
                be.goodbyeReplyReceived();
                if (DEBUG) {
                    logger.log(8, "Received GOODBYE_REPLY from " + sender);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendGoodbye(BrokerAddress remote) {
        try {
            Map map = this.brokerList;
            synchronized (map) {
                BrokerInfoEx be = (BrokerInfoEx)this.brokerList.get(remote);
                if (be != null) {
                    if (be.sentGoodbye()) {
                        return;
                    }
                    be.goodbyeSent();
                }
            }
            this.c.unicast(remote, ClusterGoodbyeInfo.newInstance(this.c).getGPacket());
            if (DEBUG) {
                logger.log(8, "Sent GOODBYE to " + remote);
            }
        }
        catch (Exception e) {
            logger.logStack(16, "Unable to send GOODBYE to " + remote, (Throwable)e);
        }
    }

    private BrokerAddress[] getBrokerList() {
        return this.getBrokerList(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BrokerAddress lookupBrokerAddress(String brokerid) {
        if (!Globals.getHAEnabled() && !Globals.isBDBStore()) {
            return null;
        }
        Map map = this.brokerList;
        synchronized (map) {
            Iterator itr = this.brokerList.keySet().iterator();
            BrokerAddress ba = null;
            while (itr.hasNext()) {
                ba = (BrokerAddress)itr.next();
                if (!ba.getBrokerID().equals(brokerid)) continue;
                return ba;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BrokerAddress lookupBrokerAddress(BrokerMQAddress url) {
        Map map = this.brokerList;
        synchronized (map) {
            Iterator itr = this.brokerList.keySet().iterator();
            BrokerAddress ba = null;
            while (itr.hasNext()) {
                ba = (BrokerAddress)itr.next();
                if (!ba.getMQAddress().equals((Object)url)) continue;
                return ba;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String lookupStoreSessionOwner(UID uid) {
        if (!Globals.isBDBStore()) {
            logger.log(32, "Internal Error: unexpected call:\n", (Object)SupportUtil.getStackTrace((String)"lookupStoreSessionOwner"));
        }
        Map map = this.brokerList;
        synchronized (map) {
            Iterator itr = this.brokerList.keySet().iterator();
            BrokerAddress ba = null;
            while (itr.hasNext()) {
                ba = (BrokerAddress)itr.next();
                if (!ba.getStoreSessionUID().equals((Object)uid)) continue;
                return ba.getBrokerID();
            }
        }
        Object[] addrs = this.getBrokerList(null, Globals.getMyAddress());
        Long xid = this.broadcastAnyOKReplyTracker.addWaiter(new BroadcastAnyOKReplyWaiter((BrokerAddress[])addrs, 74));
        ClusterInfoRequestInfo cir = ClusterInfoRequestInfo.newInstance(xid);
        try {
            cir.storeSessionOwnerRequest(uid.longValue());
        }
        catch (Exception e) {
            logger.log(32, e.toString());
            return null;
        }
        GPacket gp = cir.getGPacket();
        for (int i = 0; i < addrs.length; ++i) {
            try {
                this.c.unicast(addrs[i], gp);
                continue;
            }
            catch (Exception e) {
                logger.log(16, br.getKString("B2110", ProtocolGlobals.getPacketTypeDisplayString(gp.getType()), addrs[i]) + ": " + e.getMessage(), (Throwable)e);
            }
        }
        ReplyStatus reply = null;
        try {
            reply = this.broadcastAnyOKReplyTracker.waitForReply(xid, ProtocolGlobals.getWaitInfoReplyTimeout());
            if (reply != null && reply.getStatus() == 200) {
                gp = reply.getReply();
                return ClusterInfoInfo.newInstance(gp).getStoreSessionOwner();
            }
        }
        catch (BrokerException e) {
            Object[] args;
            String cause = e.getMessage();
            if (e.getStatusCode() == 410) {
                cause = br.getKString("B4341", Arrays.toString(addrs));
            } else if (e.getStatusCode() == 408) {
                args = new String[]{String.valueOf(ProtocolGlobals.getWaitInfoReplyTimeout()), ProtocolGlobals.getPacketTypeDisplayString(74), Arrays.toString(addrs)};
                cause = br.getKString("B4342", args);
            }
            args = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(74), Arrays.toString(addrs), cause};
            logger.log(16, br.getKString("B3301", args));
        }
        return null;
    }

    public void receiveLookupStoreSessionOwnerRequest(BrokerAddress sender, ClusterInfoRequestInfo cir) {
        String owner = null;
        int status = 404;
        String reason = null;
        if (!Globals.isBDBStore()) {
            logger.log(16, "Unexpected protocol " + ProtocolGlobals.getPacketTypeDisplayString(73) + cir.toString() + " from " + sender);
            status = 415;
        }
        try {
            long sid = cir.getStoreSession();
            if (Globals.getStore().ifOwnStoreSession(sid, null)) {
                status = 200;
                owner = Globals.getBrokerID();
            }
        }
        catch (Exception e) {
            status = 500;
            reason = e.getMessage();
            if (e instanceof BrokerException) {
                status = ((BrokerException)e).getStatusCode();
            }
            logger.logStack(16, e.getMessage(), (Throwable)e);
        }
        ClusterInfoInfo cii = cir.getReply(status, reason, owner);
        try {
            this.c.unicast(sender, cii.getGPacket());
        }
        catch (IOException e) {
            logger.logStack(16, br.getKString("B2110", ProtocolGlobals.getPacketTypeDisplayString(74) + cii, sender), (Throwable)e);
        }
    }

    public void receiveStoreSessionOwnerInfo(BrokerAddress sender, ClusterInfoInfo cii, GPacket pkt) {
        Long xid = cii.getXid();
        if (!this.broadcastAnyOKReplyTracker.notifyReply(xid, sender, pkt)) {
            Object[] args = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(74), "[" + cii.toString() + "]", sender};
            logger.log(16, br.getKString("B2114", args));
        }
    }

    public void receivePartitionAddedInfo(BrokerAddress sender, ClusterInfoInfo cii, GPacket pkt) {
        UID pid = cii.getPartition();
        this.sendTransactionInquiries(sender, pid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BrokerAddress[] getBrokerList(BrokerAddress minus, BrokerAddress add) {
        BrokerAddress[] blist = null;
        Map map = this.brokerList;
        synchronized (map) {
            int size = this.brokerList.size();
            if (minus != null && this.brokerList.get(minus) != null) {
                --size;
            }
            if (add != null && this.brokerList.get(add) == null) {
                ++size;
            }
            blist = new BrokerAddress[size];
            int i = 0;
            if (add != null) {
                blist[i++] = add;
            }
            Collection values = this.brokerList.values();
            Iterator itr = values.iterator();
            BrokerAddress ba = null;
            while (itr.hasNext()) {
                BrokerInfoEx binfo = (BrokerInfoEx)itr.next();
                ba = binfo.getBrokerInfo().getBrokerAddr();
                if (minus != null && ba.equals(minus) || ba.equals(add)) continue;
                blist[i++] = ba;
            }
        }
        return blist;
    }

    public boolean isTakeoverTarget(BrokerAddress ba) {
        if (!Globals.getHAEnabled()) {
            return false;
        }
        TakingoverEntry toe = this.takingoverBrokers.get(new TakingoverEntry(ba.getBrokerID(), ba.getStoreSessionUID()));
        if (toe == null) {
            return false;
        }
        return toe.isTakeoverTarget(ba);
    }

    @Override
    public void preTakeover(String brokerID, UID storeSession, String brokerHost, UID brokerSession) throws BrokerException {
        logger.log(8, br.getKString("B1175", "[brokerID=" + brokerID + ", storeSession=" + storeSession + "]"));
        Long xid = UniqueID.generateID((short)UID.getPrefix());
        ClusterTakeoverInfo cti = ClusterTakeoverInfo.newInstance(brokerID, storeSession, brokerHost, brokerSession, xid, true);
        TakingoverEntry toe = TakingoverEntry.addTakingoverEntry(this.takingoverBrokers, cti);
        this.myPretakeovers.put(toe, xid);
        this.takeoverCleanup(toe, false);
        this.takeoverPendingConvergecast(null, cti);
        toe.preTakeoverDone(xid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takeoverPendingConvergecast(BrokerAddress sender, ClusterTakeoverInfo cti) {
        if (!cti.isFromTaker()) {
            return;
        }
        BrokerAddress[] brokers = null;
        Map map = this.brokerList;
        synchronized (map) {
            brokers = this.getBrokerList(sender, null);
            if (brokers.length == 0) {
                this.sendTakeoverPendingReply(sender, cti, 200, null);
                return;
            }
            this.takeoverPendingReplyTracker.addWaiter(cti.getXid(), new TakeoverPendingReplyWaiter(brokers));
        }
        try {
            try {
                for (int i = 0; i < brokers.length; ++i) {
                    this.c.unicast(brokers[i], cti.getGPacket((short)39));
                }
            }
            catch (Exception e) {
                logger.log(16, e.getMessage());
            }
            ReplyStatus reply = null;
            int status = 200;
            String reason = null;
            try {
                reply = this.takeoverPendingReplyTracker.waitForReply(cti.getXid(), this.takeoverPendingReplyTimeout);
                if (reply != null && reply.getStatus() != 200) {
                    status = reply.getStatus();
                    reason = reply.getReason();
                    Object[] args = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(40), cti.toString(), Status.getString((int)status), reason};
                    logger.log(16, br.getKString("B2111", args));
                }
            }
            catch (BrokerException e) {
                status = e.getStatusCode();
                reason = e.getMessage();
                Object[] args = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(40), cti.toString(), Status.getString((int)status), reason};
                logger.log(16, br.getKString("B2112", args));
            }
            this.sendTakeoverPendingReply(sender, cti, status, reason);
        }
        finally {
            this.takeoverPendingReplyTracker.removeWaiter(cti.getXid());
        }
    }

    private void sendTakeoverPendingReply(BrokerAddress sender, ClusterTakeoverInfo cti, int status, String reason) {
        if (sender != null && cti.needReply()) {
            GPacket reply = cti.getReplyGPacket((short)40, status, reason);
            try {
                this.c.unicast(sender, reply);
            }
            catch (IOException e) {
                logger.logStack(16, "Unable send to " + sender + " TAKEOVER_PENDING reply " + ClusterTakeoverInfo.toString(reply), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takeoverCleanup(TakingoverEntry toe, boolean complete) {
        if (toe.isTakeoverTarget(this.selfAddress)) {
            String msg = br.getKString("B3187");
            logger.logStack(32, msg, (Throwable)new BrokerException(msg));
            Broker broker = Broker.getBroker();
            Globals.getBrokerStateHandler();
            broker.exit(BrokerStateHandler.getRestartCode(), msg, BrokerEvent.Type.RESTART, null, true, true, true);
            return;
        }
        BrokerAddress ba = null;
        BrokerInfoEx[] binfos = null;
        Map map = this.brokerList;
        synchronized (map) {
            binfos = this.brokerList.values().toArray(new BrokerInfoEx[this.brokerList.size()]);
        }
        block8: for (int i = 0; i < binfos.length; ++i) {
            Object[] args;
            ba = binfos[i].getBrokerInfo().getBrokerAddr();
            if (this.brokerList.get(ba) == null || !toe.isTakeoverTarget(ba)) continue;
            String logmsg1 = null;
            if (complete) {
                args = new Object[]{ba};
                logmsg1 = br.getKTString("B2282", args);
            } else {
                args = new Object[]{ba};
                logmsg1 = br.getKTString("B2283", args);
            }
            logger.log(16, logmsg1);
            this.c.closeLink(ba, true);
            long totalwaited = 0L;
            while (this.brokerList.get(ba) == binfos[i] && !this.shutdown) {
                BrokerInfoEx brokerInfoEx = binfos[i];
                synchronized (brokerInfoEx) {
                    try {
                        if (binfos[i].deactivated()) {
                            continue block8;
                        }
                        binfos[i].wait(15000L);
                        if ((totalwaited += 15000L) >= this.c.getLinkInitWaitTime()) {
                            logger.log(16, logmsg1);
                            this.c.closeLink(ba, true);
                            continue block8;
                        }
                        Object[] args2 = new Object[]{ba + ", (" + totalwaited + " ms of " + this.c.getLinkInitWaitTime() + ")"};
                        logger.log(16, br.getKTString("B1485", args2));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @Override
    public void postTakeover(String brokerID, UID storeSession, boolean aborted, boolean notify) {
        if (aborted) {
            logger.log(8, br.getKString("B1176", "[brokerID=" + brokerID + ", storeSession=" + storeSession + "]"));
            Long xid = (Long)this.myPretakeovers.get(new TakingoverEntry(brokerID, storeSession));
            if (xid == null) {
                logger.log(16, Globals.getBrokerResources().getKString("B2206", "[brokerID=" + brokerID + ", storeSession=" + storeSession + "]"));
                return;
            }
            ClusterTakeoverInfo cti = ClusterTakeoverInfo.newInstance(brokerID, storeSession, null, null, xid, true);
            GPacket gp = null;
            try {
                gp = cti.getGPacket((short)43);
                this.c.broadcast(gp);
            }
            catch (Exception e) {
                if (gp == null) {
                    logger.logStack(32, "B3100", (Throwable)e);
                }
                logger.logStack(16, "Unable to broadcast TAKEOVER_ABORT " + ClusterTakeoverInfo.newInstance(gp), (Throwable)e);
            }
            this.receivedTakeoverAbort(null, cti);
            return;
        }
        try {
            ClusterTakeoverInfo cti = ClusterTakeoverInfo.newInstance(brokerID, storeSession);
            if (!notify) {
                TakingoverEntry.takeoverComplete(this.takingoverBrokers, cti);
                return;
            }
            logger.log(8, br.getKString("B1177", "[brokerID=" + brokerID + ", storeSession=" + storeSession + "]"));
            this.receivedTakeoverComplete(null, cti);
            this.c.broadcast(cti.getGPacket((short)41));
        }
        catch (Exception e) {
            logger.logStack(16, "Broadcast TAKEOVER_COMPLETE got exception", (Throwable)e);
        }
    }

    public void receivedTakeoverComplete(BrokerAddress sender, ClusterTakeoverInfo cti) {
        TakingoverEntry toe;
        if (sender != null) {
            Object[] args = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(41), "[" + cti + "]", sender};
            logger.log(8, br.getKString("B1178", args));
        }
        if ((toe = TakingoverEntry.takeoverComplete(this.takingoverBrokers, cti)) == null) {
            return;
        }
        TakeoverCleanupThread t = new TakeoverCleanupThread(this.takeoverCleanupTG, this, sender, cti, toe, 41);
        t.start();
    }

    public void receivedTakeoverPending(BrokerAddress sender, ClusterTakeoverInfo cti) {
        TakingoverEntry toe = TakingoverEntry.addTakingoverEntry(this.takingoverBrokers, cti);
        if (toe != null || DEBUG_CLUSTER_ALL || DEBUG_CLUSTER_TAKEOVER) {
            Object[] args = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(39), "[" + cti + "]", sender};
            logger.log(8, br.getKString("B1178", args));
        }
        boolean doconverge = true;
        if (toe == null || this.getBrokerList(sender, null).length == 0) {
            this.sendTakeoverPendingReply(sender, cti, 200, null);
            if (toe == null) {
                return;
            }
            doconverge = false;
        }
        TakeoverCleanupThread t = new TakeoverCleanupThread(this.takeoverCleanupTG, this, sender, cti, toe, 39, doconverge);
        t.start();
    }

    public void receivedTakeoverPendingReply(BrokerAddress sender, GPacket reply) {
        Long xid;
        if (DEBUG_CLUSTER_ALL || DEBUG_CLUSTER_TAKEOVER) {
            Object[] args = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(40), "[" + ClusterTakeoverInfo.toString(reply) + "]", sender};
            logger.log(8, br.getKString("B1173", args));
        }
        if ((xid = ClusterTakeoverInfo.getReplyXid(reply)) == null) {
            logger.log(32, "B3100", (Object)("Received takeover reply without correlation ID from " + sender + " : " + ClusterTakeoverInfo.toString(reply)));
            return;
        }
        if (!this.takeoverPendingReplyTracker.notifyReply(xid, sender, reply)) {
            Object[] args = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(40), "[" + ClusterTakeoverInfo.toString(reply) + "]", sender};
            logger.log(16, br.getKString("B2114", args));
        }
    }

    public void receivedTakeoverAbort(BrokerAddress sender, ClusterTakeoverInfo cti) {
        if (sender != null) {
            Object[] args = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(43), "[" + cti + "]", sender};
            logger.log(8, br.getKString("B1178", args));
        }
        TakingoverEntry.removeTakingoverEntry(this.takingoverBrokers, cti);
        this.takeoverPendingReplyTracker.abortWaiter(cti.getXid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forwardTakeoverBrokers(BrokerAddress ba, boolean all) {
        if (!Globals.getHAEnabled()) {
            return;
        }
        if (all) {
            HashSet<TakingoverEntry> toes = null;
            Map<TakingoverEntry, TakingoverEntry> map = this.takingoverBrokers;
            synchronized (map) {
                toes = new HashSet<TakingoverEntry>(this.takingoverBrokers.keySet());
            }
            if (toes.size() == 0) {
                return;
            }
            logger.log(8, br.getKString("B1474", String.valueOf(toes.size()), ba));
            GPacket[] gps = null;
            TakingoverEntry toe2 = null;
            for (TakingoverEntry toe2 : toes) {
                gps = toe2.getNotificationGPackets();
                for (int i = 0; i < gps.length; ++i) {
                    if (i == 0) {
                        Object[] args = new Object[]{String.valueOf(gps.length), ProtocolGlobals.getPacketTypeDisplayString(gps[i].getType()), ba};
                        logger.log(8, br.getKString("B1475", args));
                    }
                    try {
                        this.c.unicast(ba, gps[i]);
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            return;
        }
        TakingoverEntry toe = this.takingoverBrokers.get(new TakingoverEntry(ba.getBrokerID(), ba.getStoreSessionUID()));
        if (toe == null) {
            return;
        }
        GPacket gp = toe.getNotificationGPacket(ba);
        if (gp == null) {
            return;
        }
        try {
            this.c.unicastAndClose(ba, gp);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void initConfigServer() {
        logger.log(64, "B1069");
        boolean masteripChanged = false;
        BrokerAddress lastConfigServer = this.getLastConfigServer();
        BrokerMQAddress nowMQAddr = this.selfAddress.getMQAddress();
        if (lastConfigServer != null) {
            BrokerMQAddress preMQAddr = lastConfigServer.getMQAddress();
            if (!this.selfAddress.equals(lastConfigServer) && nowMQAddr.getHost().getCanonicalHostName().equals(preMQAddr.getHost().getCanonicalHostName()) && this.selfAddress.getInstanceName().equals(lastConfigServer.getInstanceName())) {
                logger.log(8, br.getKString("B1226", lastConfigServer, this.selfAddress));
                masteripChanged = true;
            }
        }
        try {
            List<ChangeRecordInfo> records = this.store.getAllConfigRecords();
            byte[] resetEvent = RaptorProtocol.prepareResetPersistenceRecord();
            if (records.size() == 0) {
                logger.log(8, "B1068");
                this.store.storeConfigChangeRecord(System.currentTimeMillis(), resetEvent, false);
            } else if (masteripChanged) {
                ArrayList<ChangeRecord> recordList = ChangeRecord.compressRecords(records);
                this.store.clearAllConfigChangeRecords(false);
                long startime = System.currentTimeMillis();
                this.store.storeConfigChangeRecord(startime, resetEvent, false);
                ChangeRecord cr = null;
                for (int i = 0; i < recordList.size(); ++i) {
                    long l;
                    cr = recordList.get(i);
                    if (cr.isDiscard()) continue;
                    if (Globals.isBDBStore()) {
                        long l2 = startime;
                        l = l2;
                        startime = l2 + 1L;
                    } else {
                        l = System.currentTimeMillis();
                    }
                    this.store.storeConfigChangeRecord(l, cr.getBytes(), false);
                }
            }
        }
        catch (Exception e) {
            logger.logStack(16, "B3100", (Object)"Master broker initialization failed.", (Throwable)e);
        }
    }

    @Override
    public void reloadCluster() {
        logger.log(8, "B1074");
        GPacket gp = GPacket.getInstance();
        gp.setType((short)27);
        try {
            this.c.broadcast(gp);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.c.reloadCluster();
    }

    @Override
    public void stopMessageFlow() {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.stopMessageFlow()");
        }
        this.flowStopped = true;
        this.sendFlowControlUpdate(null);
    }

    @Override
    public void resumeMessageFlow() {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.stopMessageFlow()");
        }
        this.flowStopped = false;
        this.sendFlowControlUpdate(null);
    }

    private void sendFlowControlUpdate(BrokerAddress baddr) {
        GPacket gp = GPacket.getInstance();
        if (this.flowStopped) {
            gp.setType((short)23);
        } else {
            gp.setType((short)25);
        }
        try {
            if (baddr == null) {
                this.c.broadcast(gp);
            } else {
                this.c.unicast(baddr, gp);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean waitForConfigSync() {
        BrokerAddress configServer = null;
        try {
            configServer = this.c.getConfigServer();
        }
        catch (Exception e) {
            return true;
        }
        if (configServer == null) {
            return false;
        }
        if (configServer.equals(this.selfAddress)) {
            return false;
        }
        return !this.configSyncComplete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void masterBrokerUnBlock() {
        Object object = this.masterBrokerBlockedLock;
        synchronized (object) {
            this.masterBrokerBlocked = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void masterBrokerBlockWait(int timeout, String opstr) throws BrokerException {
        Object object = this.masterBrokerBlockedLock;
        synchronized (object) {
            if (this.masterBrokerBlocked) {
                throw new BrokerException(br.getKString("B4340", opstr));
            }
            this.masterBrokerBlocked = true;
        }
        long defaultInterval = 60000L;
        long waittime = (long)timeout * 1000L;
        long endtime = System.currentTimeMillis() + waittime;
        if (waittime > defaultInterval) {
            waittime = defaultInterval;
        }
        Object object2 = this.configOpLock;
        synchronized (object2) {
            while (this.configOpInProgressCount > 0 && !this.shutdown) {
                try {
                    logger.log(8, br.getKString("B1377"));
                    this.configOpLock.wait(waittime);
                }
                catch (InterruptedException e) {
                    throw new BrokerException(e.toString());
                }
                long curtime = System.currentTimeMillis();
                if (curtime >= endtime && this.configOpInProgressCount > 0) {
                    throw new BrokerException(br.getKString("B4336", String.valueOf(timeout)));
                }
                waittime = endtime - curtime;
                if (waittime <= defaultInterval) continue;
                waittime = defaultInterval;
            }
        }
        if (this.shutdown) {
            throw new BrokerException(br.getKString("B1378"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setConfigOpInProgressIfNotBlocked() throws BrokerException {
        Object object = this.masterBrokerBlockedLock;
        synchronized (object) {
            if (this.masterBrokerBlocked) {
                String emsg = br.getKString("B4340", "");
                logger.log(32, emsg);
                throw new BrokerException(emsg, 449);
            }
            this.setConfigOpInProgress(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setConfigOpInProgress(boolean flag) {
        Object object = this.configOpLock;
        synchronized (object) {
            this.configOpInProgressCount = flag ? ++this.configOpInProgressCount : --this.configOpInProgressCount;
            if (this.configOpInProgressCount == 0) {
                this.configOpLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeMasterBroker(BrokerMQAddress newmaster, BrokerMQAddress oldmaster) throws BrokerException {
        BrokerMQAddress master;
        if (newmaster == null) {
            String emsg = "null new master broker on change master broker request";
            logger.log(32, emsg);
            throw new BrokerException(emsg, 400);
        }
        if (Globals.getHAEnabled()) {
            String emsg = br.getKString("B3262", br.getString("B0087"));
            logger.log(32, emsg);
            throw new BrokerException(emsg, 412);
        }
        if (Globals.useSharedConfigRecord()) {
            String emsg = br.getKString("B3271", br.getString("B0087"));
            logger.log(32, emsg);
            throw new BrokerException(emsg, 412);
        }
        if (!Globals.dynamicChangeMasterBrokerEnabled()) {
            String emsg = br.getKString("B4356");
            logger.log(32, emsg);
            throw new BrokerException(emsg, 405);
        }
        if (Globals.isMasterBrokerSpecified() && !Globals.isJMSRAManagedBroker()) {
            String emsg = br.getKString("B4351", "imq.cluster.masterbroker");
            logger.log(32, emsg);
            throw new BrokerException(emsg, 405);
        }
        ClusterManager cm = Globals.getClusterManager();
        BrokerMQAddress brokerMQAddress = master = cm.getMasterBroker() == null ? null : (BrokerMQAddress)cm.getMasterBroker().getBrokerURL();
        if (master == null) {
            String emsg = br.getKString("B4333");
            logger.log(32, emsg);
            throw new BrokerException(emsg, 412);
        }
        if (oldmaster != null && !oldmaster.equals((Object)master)) {
            String emsg = br.getKString("B4337", (Object)oldmaster, (Object)master);
            logger.log(32, emsg);
            throw new BrokerException(emsg, 412);
        }
        if (newmaster.equals((Object)master)) {
            logger.log(8, br.getKString("B1379", (Object)newmaster));
            return;
        }
        Exception exp = null;
        BrokerAddress masterb = null;
        try {
            masterb = this.c.getConfigServer();
        }
        catch (Exception e) {
            exp = e;
        }
        if (masterb == null || exp != null) {
            String expmsg = exp instanceof BrokerException ? " - " + exp.getMessage() : "";
            String emsg = br.getKString("B4333") + expmsg;
            logger.log(32, emsg);
            throw new BrokerException(emsg, exp, 503);
        }
        if (!masterb.equals(this.selfAddress)) {
            String emsg = br.getKString("B4339", masterb.toString());
            logger.log(32, emsg);
            throw new BrokerException(emsg, 412);
        }
        if (!this.configSyncComplete) {
            String emsg = br.getKString("B4335", masterb.toString());
            logger.log(32, emsg);
            throw new BrokerException(emsg, 412);
        }
        BrokerAddress newmasterb = this.lookupBrokerAddress(newmaster);
        BrokerInfoEx newmasterbinfo = (BrokerInfoEx)this.brokerList.get(newmasterb);
        if (newmasterb == null || newmasterbinfo == null) {
            String emsg = br.getKString("B4338", newmaster.toString());
            throw new BrokerException(emsg, 412);
        }
        Integer ver = newmasterbinfo.getBrokerInfo().getClusterProtocolVersion();
        if (ver == null || ver < version) {
            Object[] args = new String[]{ver == null ? "null" : String.valueOf(ver), newmasterb.toString(), String.valueOf(version), this.selfAddress.toString()};
            String emsg = br.getKString("B4343", args);
            logger.log(32, emsg);
            throw new BrokerException(emsg, 412);
        }
        try {
            this.masterBrokerBlockWait(this.changeMasterBrokerWaitTimeout, "[CHANGE_MASTER]");
        }
        catch (Exception e) {
            String emsg = br.getKString("B3272", e.getMessage());
            logger.logStack(32, emsg, (Throwable)e);
            if (e instanceof BrokerException) {
                ((BrokerException)e).overrideStatusCode(412);
                throw (BrokerException)e;
            }
            throw new BrokerException(emsg, e, 412);
        }
        String uuid = null;
        try {
            try {
                uuid = this.sendNewMasterBrokerPrepareAndWaitReply(newmasterb);
            }
            catch (Exception e) {
                String emsg = br.getKString("B3272", e.getMessage());
                logger.logStack(32, emsg, (Throwable)e);
                if (e instanceof BrokerException) {
                    ((BrokerException)e).overrideStatusCode(412);
                    throw (BrokerException)e;
                }
                throw new BrokerException(emsg, e, 412);
            }
            this.c.changeMasterBroker(newmasterb, this.selfAddress);
            try {
                this.sendNewMasterBroker(uuid, newmasterb, masterb, newmasterb, true);
            }
            catch (Exception e) {
                String emsg = br.getKString("B3272", e.getMessage());
                logger.logStack(32, emsg, (Throwable)e);
                if (e instanceof BrokerException) {
                    ((BrokerException)e).overrideStatusCode(500);
                    throw (BrokerException)e;
                }
                throw new BrokerException(emsg, e, 500);
            }
            try {
                this.storeLastRefreshTime(-1L);
                this.storeLastConfigServer(newmasterb);
                this.broadcastNewMasterBroker(uuid, newmasterb, masterb);
            }
            catch (Exception e) {
                logger.logStack(16, e.getMessage(), (Throwable)e);
            }
        }
        finally {
            this.masterBrokerUnBlock();
        }
    }

    private void sendMyReplicationGroupInfo(BrokerAddress to) {
        if (this.store.isClosed()) {
            return;
        }
        MQAddress backup = Globals.getClusterManager().getBrokerNextToMe();
        if (backup == null || !backup.equals((Object)to.getMQAddress())) {
            return;
        }
        try {
            ClusterReplicationGroupInfo rgi = ClusterReplicationGroupInfo.newInstance(((ReplicableStore)((Object)this.store)).getMyReplicationGroupName(), ((MigratableStore)((Object)this.store)).getMyEffectiveBrokerID(), ((ReplicableStore)((Object)this.store)).getMyReplicationHostPort(), this.c);
            GPacket gp = rgi.getGPacket();
            logger.log(8, br.getKString("B1172", ProtocolGlobals.getPacketTypeDisplayString(gp.getType()) + "[" + rgi + "]", to));
            this.c.unicast(to, gp);
        }
        catch (Exception e) {
            if (e instanceof BrokerException && ((BrokerException)e).getStatusCode() == 405) {
                logger.log(16, br.getKString("B2110", ProtocolGlobals.getPacketTypeDisplayString(55), to) + ":" + e.getMessage());
            }
            logger.logStack(16, br.getKString("B2110", ProtocolGlobals.getPacketTypeDisplayString(55), to), (Throwable)e);
        }
    }

    public void receivedReplicationGroupInfo(GPacket pkt, BrokerAddress from) throws Exception {
        ClusterReplicationGroupInfo rgi = ClusterReplicationGroupInfo.newInstance(pkt, this.c);
        logger.log(8, "Received replication group info:" + rgi + " from " + from);
        BrokerAddress owner = rgi.getOwnerAddress();
        if (!(Globals.getBDBREPEnabled() && owner.equals(from) && rgi.getClusterId().equals(Globals.getClusterID()))) {
            logger.log(32, "Received unexpected packet " + ProtocolGlobals.getPacketTypeDisplayString(55) + "[" + rgi + "], from " + from);
            return;
        }
        ((ReplicableStore)((Object)this.store)).joinReplicationGroup(rgi.getGroupName(), rgi.getNodeName(), rgi.getMasterHostPort(), null, null, false, null, rgi.getOwnerAddress(), rgi);
    }

    @Override
    public void transferFiles(String[] fileNames, String targetBrokerID, Long syncTimeout, String uuid, String myBrokerID, String module, FileTransferCallback callback) throws BrokerException {
        BrokerAddress master;
        BrokerAddress addr = this.lookupBrokerAddress(targetBrokerID);
        if (addr == null) {
            throw new BrokerException(br.getKString("B4364", targetBrokerID));
        }
        if (module.equals("store") && (master = this.c.getConfigServer()) != null && this.selfAddress.equals(master)) {
            throw new BrokerException(br.getKString("B3286", MessageType.getString((int)98)), 405);
        }
        this.c.transferFiles(fileNames, addr, syncTimeout, uuid, myBrokerID, module, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMigrateStoreRequest(String targetBrokerID, Long syncTimeout, String uuid, String myBrokerID) throws BrokerException {
        BrokerAddress addr = this.lookupBrokerAddress(targetBrokerID);
        if (addr == null) {
            throw new BrokerException(br.getKString("B4364", targetBrokerID));
        }
        BrokerAddress master = this.c.getConfigServer();
        if (master != null && this.selfAddress.equals(master)) {
            throw new BrokerException(br.getKString("B3286", MessageType.getString((int)98)), 405);
        }
        Long xid = this.takeoverMEReplyTracker.addWaiter(new UnicastReplyWaiter(addr, 64));
        try {
            ClusterTransferFileRequestInfo tfr = ClusterTransferFileRequestInfo.newInstance(myBrokerID, uuid, xid);
            try {
                GPacket gp = tfr.getGPacket();
                logger.log(8, br.getKString("B1172", ProtocolGlobals.getPacketTypeDisplayString(gp.getType()) + "[" + tfr + "]", addr));
                this.c.unicast(addr, gp);
            }
            catch (Exception e) {
                String emsg = br.getKString("B2110", ProtocolGlobals.getPacketTypeDisplayString(63) + tfr, addr);
                logger.log(32, emsg);
                throw new BrokerException(emsg);
            }
            int timeout = (int)Math.min(syncTimeout, (long)ProtocolGlobals.getWaitReplyTimeout());
            ReplyStatus reply = null;
            try {
                reply = this.takeoverMEReplyTracker.waitForReply(xid, timeout);
            }
            catch (BrokerException e) {
                BrokerException e1 = e;
                if (e.getStatusCode() == 410) {
                    e1 = new BrokerException(br.getKString("B4341", addr.toString()), 410);
                } else if (e.getStatusCode() == 408) {
                    Object[] args = new String[]{String.valueOf(timeout), ProtocolGlobals.getPacketTypeDisplayString(64), addr.toString()};
                    e1 = new BrokerException(br.getKString("B4342", args), 408);
                }
                throw e1;
            }
            if (reply.getStatus() != 200) {
                Object[] args = new String[]{reply.getReason(), ProtocolGlobals.getPacketTypeDisplayString(63), addr.toString()};
                String emsg = br.getKString("B3270", args);
                throw new BrokerException(emsg, reply.getStatus());
            }
        }
        finally {
            this.takeoverMEReplyTracker.removeWaiter(xid);
        }
    }

    public void receivedTransferFileRequest(BrokerAddress sender, GPacket pkt) throws Exception {
        ClusterTransferFileRequestInfo tfr = ClusterTransferFileRequestInfo.newInstance(pkt);
        Object[] args = new String[]{ProtocolGlobals.getPacketTypeDisplayString(pkt.getType()), tfr.toString(), sender.toString()};
        logger.log(8, br.getKString("B1173", args));
        this.c.receivedFileTransferRequest(sender, tfr.getUUID());
    }

    public void receivedTransferFileRequestReply(BrokerAddress sender, GPacket pkt) {
        ClusterTransferFileRequestInfo tfr = ClusterTransferFileRequestInfo.newInstance(pkt);
        Object[] args = new String[]{ProtocolGlobals.getPacketTypeDisplayString(pkt.getType()), tfr.toString(), sender.toString()};
        logger.log(8, br.getKString("B1173", args));
        Long xid = ClusterTransferFileRequestInfo.getReplyPacketXid(pkt);
        if (!this.takeoverMEReplyTracker.notifyReply(xid, sender, pkt)) {
            args = new String[]{ProtocolGlobals.getPacketTypeDisplayString(64), xid.toString(), sender.toString()};
            logger.log(16, br.getKString("B2114", args));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String sendTakeoverMEPrepare(String brokerID, byte[] commitToken, Long syncTimeout, String uuid) throws BrokerException {
        BrokerAddress addr = this.lookupBrokerAddress(brokerID);
        if (addr == null) {
            throw new BrokerException("Broker not connected " + brokerID);
        }
        BrokerAddress master = this.c.getConfigServer();
        if (master != null && this.selfAddress.equals(master)) {
            throw new BrokerException(br.getKString("B3286", MessageType.getString((int)98)), 405);
        }
        Long xid = this.takeoverMEReplyTracker.addWaiter(new UnicastReplyWaiter(addr, 58));
        try {
            ClusterTakeoverMEPrepareInfo tme = ClusterTakeoverMEPrepareInfo.newInstance(((ReplicableStore)((Object)this.store)).getMyReplicationGroupName(), ((MigratableStore)((Object)this.store)).getMyEffectiveBrokerID(), ((ReplicableStore)((Object)this.store)).getMyReplicationHostPort(), commitToken, syncTimeout, brokerID, uuid, xid, this.c);
            try {
                GPacket gp = tme.getGPacket();
                logger.log(8, br.getKString("B1172", ProtocolGlobals.getPacketTypeDisplayString(gp.getType()) + "[" + tme + "]", addr));
                this.c.unicast(addr, gp);
            }
            catch (Exception e) {
                String emsg = br.getKString("B2110", ProtocolGlobals.getPacketTypeDisplayString(57) + tme, addr);
                logger.log(32, emsg);
                throw new BrokerException(emsg);
            }
            int timeout = (int)syncTimeout.longValue() + ProtocolGlobals.getWaitReplyTimeout();
            ReplyStatus reply = null;
            try {
                reply = this.takeoverMEReplyTracker.waitForReply(xid, timeout);
            }
            catch (BrokerException e) {
                BrokerException e1 = e;
                if (e.getStatusCode() == 410) {
                    e1 = new BrokerException(br.getKString("B4341", addr.toString()), 410);
                } else if (e.getStatusCode() == 408) {
                    Object[] args = new String[]{String.valueOf(timeout), ProtocolGlobals.getPacketTypeDisplayString(58), addr.toString()};
                    e1 = new BrokerException(br.getKString("B4342", args), 408);
                }
                throw e1;
            }
            if (reply.getStatus() != 200) {
                Object[] args = new String[]{reply.getReason(), ProtocolGlobals.getPacketTypeDisplayString(57), addr.toString()};
                String emsg = br.getKString("B3270", args);
                throw new BrokerException(emsg, reply.getStatus());
            }
            String string = tme.getReplyReplicaHostPort(reply.getReply());
            return string;
        }
        finally {
            this.takeoverMEReplyTracker.removeWaiter(xid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedTakeoverMEPrepare(BrokerAddress sender, GPacket pkt, ClusterTakeoverMEPrepareInfo tme) throws Exception {
        BrokerStateHandler.setExclusiveRequestLock(ExclusiveRequest.MIGRATE_STORE);
        try {
            Object[] args = new String[]{ProtocolGlobals.getPacketTypeDisplayString(pkt.getType()), tme.toString(), sender.toString()};
            logger.log(8, br.getKString("B1173", args));
            ((ReplicableStore)((Object)this.store)).joinReplicationGroup(tme.getGroupName(), tme.getNodeName(), tme.getMasterHostPort(), tme.getCommitToken(), tme.getSyncTimeout(), true, tme.getUUID(), tme.getOwnerAddress(), tme);
        }
        finally {
            BrokerStateHandler.unsetExclusiveRequestLock(ExclusiveRequest.MIGRATE_STORE);
        }
    }

    public void receivedTakeoverMEPrepareReply(BrokerAddress sender, GPacket pkt) {
        Long xid = ClusterTakeoverMEPrepareInfo.getReplyPacketXid(pkt);
        Object[] args = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(pkt.getType()), "" + ClusterTakeoverMEPrepareInfo.getReplyPacketXid(pkt), sender.toString()};
        logger.log(8, br.getKString("B1173", args));
        if (!this.takeoverMEReplyTracker.notifyReply(xid, sender, pkt)) {
            args = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(58), xid.toString(), sender};
            logger.log(16, br.getKString("B2114", args));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String sendTakeoverME(String brokerID, String uuid) throws BrokerException {
        BrokerAddress addr;
        if (DEBUG) {
            logger.log(8, "RaptorProtocol.sendTakeoverME, to " + brokerID);
        }
        if ((addr = this.lookupBrokerAddress(brokerID)) == null) {
            throw new BrokerException("Broker not connected " + brokerID);
        }
        Long xid = this.takeoverMEReplyTracker.addWaiter(new UnicastReplyWaiter(addr, 60));
        try {
            ClusterTakeoverMEInfo tme = null;
            tme = Globals.getBDBREPEnabled() ? ClusterTakeoverMEInfo.newInstance(((ReplicableStore)((Object)this.store)).getMyReplicationGroupName(), ((MigratableStore)((Object)this.store)).getMyEffectiveBrokerID(), ((ReplicableStore)((Object)this.store)).getMyReplicationHostPort(), brokerID, uuid, xid, this.c) : ClusterTakeoverMEInfo.newInstance(((MigratableStore)((Object)this.store)).getMyEffectiveBrokerID(), brokerID, uuid, xid, this.c);
            try {
                GPacket gp = tme.getGPacket();
                logger.log(8, br.getKString("B1172", ProtocolGlobals.getPacketTypeDisplayString(gp.getType()) + "[" + tme + "]", addr.toString()));
                this.c.unicast(addr, gp);
            }
            catch (Exception e) {
                String emsg = br.getKString("B2110", ProtocolGlobals.getPacketTypeDisplayString(59) + tme, addr);
                logger.log(32, emsg);
                throw new BrokerException(emsg);
            }
            ReplyStatus reply = null;
            try {
                reply = this.takeoverMEReplyTracker.waitForReply(xid, ProtocolGlobals.getWaitReplyTimeout());
            }
            catch (BrokerException e) {
                BrokerException e1 = e;
                if (e.getStatusCode() == 410) {
                    e1 = new BrokerException(br.getKString("B4341", addr.toString()), 410);
                } else if (e.getStatusCode() == 408) {
                    Object[] args = new String[]{String.valueOf(ProtocolGlobals.getWaitReplyTimeout()), ProtocolGlobals.getPacketTypeDisplayString(60), addr.toString()};
                    e1 = new BrokerException(br.getKString("B4342", args), 408);
                }
                throw e1;
            }
            if (reply.getStatus() != 200) {
                Object[] args = new String[]{reply.getReason(), ProtocolGlobals.getPacketTypeDisplayString(59), addr.toString()};
                String emsg = br.getKString("B3270", args);
                throw new BrokerException(emsg, reply.getStatus());
            }
        }
        finally {
            this.takeoverMEReplyTracker.removeWaiter(xid);
        }
        return addr.getMQAddress().getHostAddressNPort();
    }

    public void receivedTakeoverME(BrokerAddress sender, GPacket pkt, ClusterTakeoverMEInfo tme) throws Exception {
        Object[] args = new String[]{ProtocolGlobals.getPacketTypeDisplayString(pkt.getType()), tme.toString(), sender.toString()};
        logger.log(8, br.getKString("B1173", args));
        tme.setParent(this);
        ((MigratableStore)((Object)this.store)).initTakeoverBrokerStore(tme.getGroupName(), tme.getNodeName(), tme.getMasterHostPort(), tme.getUUID(), tme.getOwnerAddress(), tme);
    }

    protected void sendTakeoverMEReply(ClusterTakeoverMEInfo tme, int status, String reason, BrokerAddress to) {
        GPacket reply = tme.getReplyGPacket(status, reason);
        logger.log(8, br.getKString("B1172", ProtocolGlobals.getPacketTypeDisplayString(reply.getType()) + "[" + tme.getReplyToString(reply) + "]", to.toString()));
        Long xid = (Long)reply.getProp((Object)"X");
        this.takeoverMEReplyTracker.addWaiter(xid, new UnicastReplyWaiter(to, 61));
        try {
            this.c.unicastUrgent(to, reply);
        }
        catch (Exception e) {
            Object[] args = new String[]{ProtocolGlobals.getPacketTypeDisplayString(60), to.toString(), this.toString()};
            logger.logStack(32, br.getKString("B3192", args), (Throwable)e);
            return;
        }
        int timeout = ProtocolGlobals.getWaitReplyTimeout();
        ReplyStatus replyack = null;
        try {
            replyack = this.takeoverMEReplyTracker.waitForReply(xid, timeout);
        }
        catch (BrokerException e) {
            Object[] args;
            String emsg = e.getMessage();
            if (e.getStatusCode() == 410) {
                emsg = br.getKString("B4341", to.toString());
            } else if (e.getStatusCode() == 408) {
                args = new String[]{String.valueOf(timeout), ProtocolGlobals.getPacketTypeDisplayString(61), to.toString()};
                emsg = br.getKString("B4342", args);
            }
            args = new String[]{ProtocolGlobals.getPacketTypeDisplayString(61), to.toString(), emsg};
            logger.log(16, br.getKString("B3301", args));
            return;
        }
        if (replyack.getStatus() != 200) {
            Object[] args = new String[]{replyack.getReason(), ProtocolGlobals.getPacketTypeDisplayString(61), to.toString()};
            String emsg = br.getKString("B3270", args);
            logger.log(16, emsg);
        }
    }

    public void receivedTakeoverMEReply(BrokerAddress sender, GPacket pkt) {
        Long xid = ClusterTakeoverMEInfo.getReplyPacketXid(pkt);
        Object[] args = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(pkt.getType()), "" + xid, sender.toString()};
        logger.log(8, br.getKString("B1173", args));
        if (!this.takeoverMEReplyTracker.notifyReply(xid, sender, pkt)) {
            args = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(60), xid.toString(), sender};
            logger.log(16, br.getKString("B2114", args));
        }
        GPacket replyack = ClusterTakeoverMEInfo.getReplyAckGPacket(pkt);
        logger.log(8, br.getKString("B1172", ProtocolGlobals.getPacketTypeDisplayString(replyack.getType()) + "[" + ClusterTakeoverMEInfo.getReplyAckToString(replyack) + "]", sender.toString()));
        try {
            this.c.unicast(sender, replyack);
        }
        catch (Exception e) {
            String emsg = br.getKString("B2110", ProtocolGlobals.getPacketTypeDisplayString(61), sender);
            logger.log(16, emsg + ": " + e.getMessage());
        }
    }

    public void receivedTakeoverMEReplyAck(BrokerAddress sender, GPacket pkt) {
        Long xid = ClusterTakeoverMEInfo.getReplyPacketXid(pkt);
        Object[] args = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(pkt.getType()), "" + xid, sender.toString()};
        logger.log(8, br.getKString("B1173", args));
        if (!this.takeoverMEReplyTracker.notifyReply(xid, sender, pkt)) {
            args = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(61), xid.toString(), sender};
            logger.log(16, br.getKString("B2114", args));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendNewMasterBrokerPrepareAndWaitReply(BrokerAddress newmaster) throws Exception {
        if (DEBUG) {
            logger.log(8, "RaptorProtocol.sendNewMasterBrokerPrepare, to = " + newmaster);
        }
        String uuid = null;
        List<ChangeRecordInfo> records = this.store.getConfigChangeRecordsSince(-1L);
        ArrayList<ChangeRecord> recordList = ChangeRecord.compressRecords(records);
        records.clear();
        records = new ArrayList<ChangeRecordInfo>();
        records.add(ChangeRecord.makeResetRecord(false));
        ChangeRecord cr = null;
        ChangeRecordInfo cri = null;
        for (int i = 0; i < recordList.size(); ++i) {
            cr = recordList.get(i);
            if (cr.isDiscard()) continue;
            cri = new ChangeRecordInfo();
            cri.setRecord(cr.getBytes());
            records.add(cri);
        }
        Long xid = this.newMasterBrokerReplyTracker.addWaiter(new UnicastReplyWaiter(newmaster, 52));
        try {
            ClusterNewMasterBrokerPrepareInfo nmpi = ClusterNewMasterBrokerPrepareInfo.newInstance(newmaster, records, xid, this.c);
            GPacket gp = nmpi.getGPacket();
            logger.log(8, br.getKString("B1172", ProtocolGlobals.getPacketTypeDisplayString(gp.getType()) + "[" + nmpi + "]", newmaster.toString()));
            uuid = nmpi.getUUID();
            this.c.unicast(newmaster, gp);
            ReplyStatus reply = null;
            try {
                reply = this.newMasterBrokerReplyTracker.waitForReply(xid, this.changeMasterBrokerWaitTimeout);
            }
            catch (BrokerException e) {
                BrokerException e1 = e;
                if (e.getStatusCode() == 410) {
                    e1 = new BrokerException(br.getKString("B4341", newmaster.toString()), 410);
                } else if (e.getStatusCode() == 408) {
                    Object[] args = new String[]{String.valueOf(this.changeMasterBrokerWaitTimeout), ProtocolGlobals.getPacketTypeDisplayString(52), newmaster.toString()};
                    e1 = new BrokerException(br.getKString("B4342", args), 408);
                }
                throw e1;
            }
            if (reply.getStatus() != 200) {
                Object[] args = new String[]{reply.getReason(), ProtocolGlobals.getPacketTypeDisplayString(51), newmaster.toString()};
                String emsg = br.getKString("B3270", args);
                throw new BrokerException(emsg, reply.getStatus());
            }
        }
        finally {
            this.newMasterBrokerReplyTracker.removeWaiter(xid);
        }
        return uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedNewMasterBrokerPrepare(BrokerAddress sender, GPacket pkt) throws Exception {
        if (Globals.isMasterBrokerSpecified() && !Globals.isJMSRAManagedBroker()) {
            throw new BrokerException(br.getKString("B4351", "imq.cluster.masterbroker"));
        }
        BrokerStateHandler.setExclusiveRequestLock(ExclusiveRequest.CHANGE_MASTER_BROKER);
        try {
            Object object = this.newMasterBrokerLock;
            synchronized (object) {
                ClusterNewMasterBrokerPrepareInfo nmpi = ClusterNewMasterBrokerPrepareInfo.newInstance(pkt, this.c);
                Object[] args = new String[]{ProtocolGlobals.getPacketTypeDisplayString(pkt.getType()), nmpi.toString(), sender.toString()};
                logger.log(8, br.getKString("B1173", args));
                BrokerAddress configServer = this.c.getConfigServer();
                if (configServer == null) {
                    throw new Exception("Unexpected: there is no master broker configured");
                }
                if (!configServer.equals(sender)) {
                    args = new String[]{configServer.toString(), sender.toString(), ProtocolGlobals.getPacketTypeDisplayString(pkt.getType())};
                    String emsg = br.getKString("B4345", args);
                    logger.log(16, emsg);
                    throw new BrokerException(emsg);
                }
                if (!this.configSyncComplete) {
                    args = new String[]{configServer.toString(), ProtocolGlobals.getPacketTypeDisplayString(pkt.getType()), sender.toString()};
                    String emsg = br.getKString("B4346", args);
                    logger.log(16, emsg);
                    throw new BrokerException(emsg);
                }
                byte[] buf = nmpi.getRecords();
                if (buf == null) {
                    throw new BrokerException("Unexpected: received no payload for " + nmpi);
                }
                this.store.clearAllConfigChangeRecords(false);
                ByteArrayInputStream bis = new ByteArrayInputStream(buf);
                DataInputStream dis = new DataInputStream(bis);
                int count = nmpi.getRecordCount();
                long startime = System.currentTimeMillis();
                try {
                    for (int i = 0; i < count; ++i) {
                        GPacket gp = GPacket.getInstance();
                        gp.read((InputStream)dis);
                        if (i == 0 && gp.getType() != 31) {
                            throw new BrokerException(br.getKString("B4347", ProtocolGlobals.getPacketTypeDisplayString(pkt.getType()), sender.toString()));
                        }
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        gp.write((OutputStream)bos);
                        bos.flush();
                        byte[] record = bos.toByteArray();
                        bos.close();
                        this.store.storeConfigChangeRecord(startime++, record, true);
                    }
                }
                catch (Exception e) {
                    try {
                        this.store.clearAllConfigChangeRecords(true);
                    }
                    catch (Exception e1) {
                        logger.log(16, br.getKString("B4348", nmpi.toString()));
                    }
                    throw e;
                }
                this.newMasterBrokerPreparedUUID = nmpi.getUUID();
                this.newMasterBrokerPreparedSender = sender;
            }
        }
        finally {
            BrokerStateHandler.unsetExclusiveRequestLock(ExclusiveRequest.CHANGE_MASTER_BROKER);
        }
    }

    public void receivedNewMasterBrokerPrepareReply(BrokerAddress sender, GPacket pkt) {
        Long xid = ClusterNewMasterBrokerPrepareInfo.getReplyPacketXid(pkt);
        if (!this.newMasterBrokerReplyTracker.notifyReply(xid, sender, pkt)) {
            Object[] args = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(52), xid.toString(), sender};
            logger.log(16, br.getKString("B2114", args));
        }
    }

    public void receivedNewMasterBrokerReply(BrokerAddress sender, GPacket pkt) {
        Long xid = ClusterNewMasterBrokerInfo.getReplyPacketXid(pkt);
        if (!this.newMasterBrokerReplyTracker.notifyReply(xid, sender, pkt)) {
            Object[] args = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(54), xid.toString(), sender};
            logger.log(16, br.getKString("B2114", args));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long sendNewMasterBroker(String uuid, BrokerAddress newmaster, BrokerAddress oldmaster, BrokerAddress to, boolean waitReply) throws Exception {
        if (DEBUG) {
            logger.log(8, "RaptorProtocol.sendNewMasterBroker, to = " + to);
        }
        Long xid = this.newMasterBrokerReplyTracker.addWaiter(new UnicastReplyWaiter(to, 54));
        boolean noremove = false;
        try {
            ClusterNewMasterBrokerInfo nmi = ClusterNewMasterBrokerInfo.newInstance(newmaster, oldmaster, uuid, xid, this.c);
            GPacket gp = nmi.getGPacket();
            this.c.unicast(to, gp);
            if (!waitReply) {
                noremove = true;
                Long l = xid;
                return l;
            }
            this.waitNewMasterBrokerReply(xid, newmaster, to);
            Long l = null;
            return l;
        }
        finally {
            if (!noremove) {
                this.newMasterBrokerReplyTracker.removeWaiter(xid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedNewMasterBroker(BrokerAddress sender, GPacket pkt) throws Exception {
        ClusterNewMasterBrokerInfo nmi = ClusterNewMasterBrokerInfo.newInstance(pkt, this.c);
        BrokerAddress newmaster = nmi.getNewMasterBroker();
        Object[] args = new String[]{ProtocolGlobals.getPacketTypeDisplayString(pkt.getType()), nmi.toString(), sender.toString()};
        logger.log(8, br.getKString("B1173", args));
        if (Globals.isMasterBrokerSpecified() && !Globals.isJMSRAManagedBroker()) {
            throw new BrokerException(br.getKString("B4352", "imq.cluster.masterbroker"));
        }
        Object object = this.newMasterBrokerLock;
        synchronized (object) {
            BrokerAddress configServer = this.c.getConfigServer();
            if (!configServer.getMQAddress().equals((Object)sender.getMQAddress()) && !newmaster.getMQAddress().equals((Object)sender.getMQAddress())) {
                args = new String[]{ProtocolGlobals.getPacketTypeDisplayString(pkt.getType()) + nmi, sender.toString(), configServer.toString(), newmaster.toString()};
                String emsg = br.getKString("B4357", args);
                logger.log(16, emsg);
                throw new BrokerException(emsg);
            }
            if (configServer.getMQAddress().equals((Object)newmaster.getMQAddress())) {
                logger.log(8, br.getKString("B1379", newmaster));
                return;
            }
            if (newmaster.equals(this.selfAddress)) {
                if (this.newMasterBrokerPreparedUUID == null) {
                    String emsg = br.getKString("B4349", sender.toString() + nmi);
                    logger.log(32, emsg);
                    throw new BrokerException(emsg);
                }
                if (!this.newMasterBrokerPreparedUUID.equals(nmi.getUUID())) {
                    String emsg = br.getKString("B4350", sender.toString() + nmi, this.newMasterBrokerPreparedUUID + "[" + this.newMasterBrokerPreparedSender + "]");
                    logger.log(32, emsg);
                    throw new BrokerException(emsg);
                }
            }
            if (!this.configSyncComplete) {
                if (newmaster.equals(this.selfAddress)) {
                    args = new String[]{configServer.toString(), ProtocolGlobals.getPacketTypeDisplayString(pkt.getType()), sender.toString()};
                    String emsg = br.getKString("B4346", args);
                    logger.log(32, emsg);
                    throw new BrokerException(emsg);
                }
                String emsg = br.getKString("B4353", configServer.toString());
                logger.log(8, emsg);
                logger.log(16, br.getKString("B2126", configServer.toString(), emsg));
                this.c.closeLink(configServer, true);
            }
            this.c.changeMasterBroker(newmaster, configServer);
            this.storeLastRefreshTime(-1L);
        }
    }

    private void waitNewMasterBrokerReply(Long xid, BrokerAddress newmaster, BrokerAddress from) throws BrokerException {
        ReplyStatus reply = null;
        try {
            reply = this.newMasterBrokerReplyTracker.waitForReply(xid, ProtocolGlobals.getWaitReplyTimeout());
        }
        catch (BrokerException e) {
            BrokerException e1 = e;
            if (e.getStatusCode() == 410) {
                e1 = new BrokerException(br.getKString("B4341", newmaster.toString()), 410);
            } else if (e.getStatusCode() == 408) {
                Object[] args = new String[]{String.valueOf(this.changeMasterBrokerWaitTimeout), ProtocolGlobals.getPacketTypeDisplayString(54), from.toString()};
                e1 = new BrokerException(br.getKString("B4342", args), 408);
            }
            throw e1;
        }
        if (reply.getStatus() != 200) {
            Object[] args = new String[]{reply.getReason(), ProtocolGlobals.getPacketTypeDisplayString(53), from.toString()};
            String emsg = br.getKString("B3270", args);
            throw new BrokerException(emsg, reply.getStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastNewMasterBroker(String uuid, BrokerAddress newmaster, BrokerAddress oldmaster) {
        Long xid2;
        BrokerAddress[] bas = this.getBrokerList(newmaster, null);
        ArrayList<Long> xids = new ArrayList<Long>();
        try {
            xid2 = null;
            for (int i = 0; i < bas.length; ++i) {
                logger.log(8, br.getKString("B1380", bas[i].toString(), newmaster.toString()));
                try {
                    xid2 = this.sendNewMasterBroker(uuid, newmaster, oldmaster, bas[i], false);
                }
                catch (Exception e) {
                    logger.log(16, br.getKString("B2110", ProtocolGlobals.getPacketTypeDisplayString(53), bas[i].toString()));
                }
                xids.add(xid2);
            }
            for (Long xid2 : xids) {
                try {
                    this.waitNewMasterBrokerReply(xid2, newmaster, ((UnicastReplyWaiter)this.newMasterBrokerReplyTracker.getWaiter(xid2)).getToBroker());
                }
                catch (Exception e) {
                    logger.logStack(16, e.getMessage(), (Throwable)e);
                }
            }
        }
        finally {
            xid2 = null;
            for (Long xid2 : xids) {
                this.newMasterBrokerReplyTracker.removeWaiter(xid2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyPartitionArrival(UID partitionID, String brokerID) throws BrokerException {
        BrokerAddress addr;
        if (DEBUG) {
            logger.log(8, "RaptorProtocol.notifyPartitionArrival(" + partitionID + ", " + brokerID + ")");
        }
        if ((addr = this.lookupBrokerAddress(brokerID)) == null) {
            throw new BrokerException(br.getKString("B4364", brokerID), 404);
        }
        Long xid = this.takeoverMEReplyTracker.addWaiter(new UnicastReplyWaiter(addr, 76));
        try {
            ClusterNotifyPartitionArrivalInfo npa = ClusterNotifyPartitionArrivalInfo.newInstance(partitionID, brokerID, xid, this.c);
            try {
                GPacket gp = npa.getGPacket();
                logger.log(8, br.getKString("B1172", ProtocolGlobals.getPacketTypeDisplayString(gp.getType()) + "[" + npa + "]", addr.toString()));
                this.c.unicast(addr, gp);
            }
            catch (Exception e) {
                String emsg = br.getKString("B2110", ProtocolGlobals.getPacketTypeDisplayString(75) + npa, addr);
                logger.log(32, emsg);
                throw new BrokerException(emsg);
            }
            ReplyStatus reply = null;
            try {
                reply = this.takeoverMEReplyTracker.waitForReply(xid, ProtocolGlobals.getWaitReplyTimeout());
            }
            catch (BrokerException e) {
                BrokerException e1 = e;
                if (e.getStatusCode() == 410) {
                    e1 = new BrokerException(br.getKString("B4341", addr.toString()), 410);
                } else if (e.getStatusCode() == 408) {
                    Object[] args = new String[]{String.valueOf(ProtocolGlobals.getWaitReplyTimeout()), ProtocolGlobals.getPacketTypeDisplayString(76), addr.toString()};
                    e1 = new BrokerException(br.getKString("B4342", args), 408);
                }
                throw e1;
            }
            if (reply.getStatus() != 200) {
                Object[] args = new String[]{reply.getReason(), ProtocolGlobals.getPacketTypeDisplayString(75), addr.toString()};
                String emsg = br.getKString("B3270", args);
                throw new BrokerException(emsg, reply.getStatus());
            }
        }
        finally {
            this.takeoverMEReplyTracker.removeWaiter(xid);
        }
    }

    public void receivedNotifyPartitionArrival(BrokerAddress sender, GPacket pkt, ClusterNotifyPartitionArrivalInfo npa) throws Exception {
        Object[] args = new String[]{ProtocolGlobals.getPacketTypeDisplayString(pkt.getType()), npa.toString(), sender.toString()};
        logger.log(8, br.getKString("B1173", args));
        Globals.getDestinationList();
        DestinationList.registerPartitionArrivedEvent(npa.getPartitionID(), sender.getBrokerID());
    }

    public void receivedNotifyPartitionArrivalReply(BrokerAddress sender, GPacket pkt, ClusterNotifyPartitionArrivalInfo npa) {
        Long xid = ClusterNotifyPartitionArrivalInfo.getReplyPacketXid(pkt);
        if (!this.takeoverMEReplyTracker.notifyReply(xid, sender, pkt)) {
            Object[] args = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(76), xid.toString(), sender};
            logger.log(16, br.getKString("B2114", args));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(PacketReference pkt, Collection<Consumer> targets, boolean sendMsgDeliveredAck) {
        Object baddr;
        HashMap<Object, ArrayList[]> m = new HashMap<Object, ArrayList[]>();
        if (DEBUG) {
            logger.log(2, "MessageBus: sending message {0} to {1} targets.", (Object)pkt.getSysMessageID(), (Object)Integer.toString(targets.size()));
        }
        StringBuilder debugString = new StringBuilder("\n");
        boolean redeliverFlag = false;
        for (Consumer target : targets) {
            ArrayList[] v;
            ConsumerUID intid = target.getConsumerUID();
            ConsumerUID storedid = target.getStoredConsumerUID();
            boolean rflag = pkt.getRedeliverFlag(storedid);
            int dct = pkt.getRedeliverCount(storedid);
            try {
                pkt.delivered(intid, storedid, intid.isUnsafeAck(), true);
            }
            catch (Exception ex) {
                logger.logStack(16, "B3100", (Object)("saving redeliver flag for " + pkt.getSysMessageID() + " to " + intid), (Throwable)ex);
            }
            if (rflag) {
                redeliverFlag = true;
                if (dct < 1) {
                    dct = 1;
                }
            }
            if ((v = (ArrayList[])m.get(baddr = target.getConsumerUID().getBrokerAddress())) == null) {
                v = new ArrayList[]{new ArrayList(), new ArrayList()};
                m.put(baddr, v);
            }
            v[0].add(target);
            v[1].add(dct);
            debugString.append('\t').append(target.toString()).append("#" + dct).append('\n');
        }
        if (DEBUG) {
            logger.log(1, "MessageBus: Local Targets = {0}", (Object)debugString);
        }
        Iterator brokers = m.entrySet().iterator();
        Map.Entry entry = null;
        while (brokers.hasNext()) {
            entry = brokers.next();
            BrokerAddress b = (BrokerAddress)entry.getKey();
            ArrayList[] v = (ArrayList[])entry.getValue();
            ClusterMessageInfo cmi = ClusterMessageInfo.newInstance(pkt, v[0], v[1], redeliverFlag, sendMsgDeliveredAck, this.c);
            try {
                baddr = this.brokerList;
                synchronized (baddr) {
                    BrokerInfoEx be = (BrokerInfoEx)this.brokerList.get(b);
                    if (be == null) {
                        throw new BrokerException("NOTFOUND: Could not deliver message " + cmi.toString() + " to " + b);
                    }
                    if (be.sentGoodbye()) {
                        throw new BrokerException("GOODBYE: Could not deliver message " + cmi.toString() + " to " + b);
                    }
                }
                this.c.unicast(b, cmi.getGPacket(), true);
                if (!DEBUG) continue;
                logger.log(1, "MessageBus: Broker {0} Targets = {1}", (Object)b, (Object)(debugString + cmi.toString()));
            }
            catch (Exception e) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("MSG_NOT_SENT_TO_REMOTE", "true");
                for (int i = 0; i < v[0].size(); ++i) {
                    ConsumerUID intid = ((Consumer)v[0].get(i)).getConsumerUID();
                    try {
                        this.cb.processRemoteAck(pkt.getSysMessageID(), intid, 1, map);
                        continue;
                    }
                    catch (BrokerException ex) {
                        logger.log(16, ex.getMessage(), (Throwable)ex);
                    }
                }
                if (!DEBUG) continue;
                logger.log(1, "RaptorProtocol: Could not deliver message to broker {0}", (Object)b);
            }
        }
    }

    @Override
    public void sendMessageAck(BrokerAddress msgHome, SysMessageID sysid, ConsumerUID cuid, int ackType, Map optionalProps, boolean ackack) throws BrokerException {
        block6: {
            SysMessageID[] sysids = new SysMessageID[]{sysid};
            ConsumerUID[] cuids = new ConsumerUID[]{cuid};
            if (ackack) {
                this.sendMessageAcks(msgHome, sysids, cuids, ackType, optionalProps, null, null, ackack, false, false);
                return;
            }
            try {
                this.sendMessageAcks(msgHome, sysids, cuids, ackType, optionalProps, null, null, ackack, false, false);
            }
            catch (BrokerException e) {
                Object[] args = new Object[]{ClusterGlobals.getAckTypeString(ackType) + (String)(optionalProps == null ? "" : "[" + optionalProps + "]"), msgHome, "[" + sysid + ", " + cuid + "]"};
                String emsg = br.getKString("B3192", args);
                boolean logstack = true;
                if (e instanceof BrokerDownException || e.getStatusCode() == 410 || e.getStatusCode() == 408) {
                    logstack = false;
                }
                boolean dolog = true;
                if (ackType == 1 && optionalProps == null) {
                    boolean bl = dolog = DEBUG_CLUSTER_MSG;
                }
                if (!dolog) break block6;
                if (logstack) {
                    logger.logStack(16, emsg, (Throwable)e);
                }
                logger.log(16, emsg + ": " + e.getMessage());
            }
        }
    }

    @Override
    public void sendMessageAck2P(BrokerAddress msgHome, SysMessageID[] sysids, ConsumerUID[] cuids, int ackType, Map optionalProps, Long txnID, UID txnStoreSession, boolean ackack, boolean async) throws BrokerException {
        this.sendMessageAcks(msgHome, sysids, cuids, ackType, optionalProps, txnID, txnStoreSession, ackack, async, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessageAcks(BrokerAddress msgHome, SysMessageID[] sysids, ConsumerUID[] cuids, int ackType, Map optionalProps, Long txnID, UID txnStoreSession, boolean ackack, boolean async, boolean twophase) throws BrokerException {
        block45: {
            if (this.fi.FAULT_INJECTION) {
                FaultInjection faultInjection;
                if (ackType == 1 && optionalProps != null) {
                    faultInjection = this.fi;
                    synchronized (faultInjection) {
                        if (this.fi.checkFault("msg.remote_ack.p.ackignore.1.exception", null)) {
                            this.fi.unsetFault("msg.remote_ack.p.ackignore.1.exception");
                            throw new BrokerDownException("FAULT: unreachable message home broker" + msgHome);
                        }
                    }
                }
                if (ackType == 10) {
                    faultInjection = this.fi;
                    synchronized (faultInjection) {
                        if (this.fi.checkFault("msg.remote_ack.p.txnrollback.1.exception", null)) {
                            this.fi.unsetFault("msg.remote_ack.p.txnrollback.1.exception");
                            throw new BrokerException("FAULT: unreachable message home broker " + msgHome);
                        }
                    }
                }
                ClusterMessageAckInfo.CHECKFAULT(this.ackCounts, ackType, txnID, "msg.remote_ack.p.", "1");
            }
            Long xid = null;
            if (ackack) {
                xid = this.ackackTracker.addWaiter(new MessageAckReplyWaiter(msgHome));
            }
            ClusterMessageAckInfo cai = ClusterMessageAckInfo.newInstance(sysids, cuids, ackType, xid, async, optionalProps, txnID, txnStoreSession, msgHome, this.c, twophase);
            if (DEBUG || DEBUG_CLUSTER_TXN) {
                logger.log(8, "MessageBus: Sending message ack: " + cai.toString());
            }
            try {
                Map map = this.brokerList;
                synchronized (map) {
                    BrokerInfoEx be = (BrokerInfoEx)this.brokerList.get(msgHome);
                    if (be == null && msgHome != Globals.getMyAddress()) {
                        BrokerDownException e = new BrokerDownException(br.getKString("B4249", cai.toString(), msgHome), 410);
                        e.setRemote(true);
                        e.setRemoteBrokerAddress(msgHome);
                        throw e;
                    }
                    if (be != null && (be.sentGoodbye() || be.gotGoodbye())) {
                        BrokerDownException e = new BrokerDownException(br.getKString("B4247", cai.toString(), msgHome), 410);
                        e.setRemote(true);
                        e.setRemoteBrokerAddress(msgHome);
                        throw e;
                    }
                    if (this.isTakeoverTarget(msgHome)) {
                        BrokerDownException e = new BrokerDownException(br.getKString("B4244", cai.toString(), msgHome), 410);
                        e.setRemote(true);
                        e.setRemoteBrokerAddress(msgHome);
                        throw e;
                    }
                    this.c.unicast(msgHome, cai.getGPacket());
                    if (this.fi.FAULT_INJECTION) {
                        ClusterMessageAckInfo.CHECKFAULT(this.ackCounts, ackType, txnID, "msg.remote_ack.p.", "2");
                    }
                }
                if (!ackack || async) break block45;
                ReplyStatus reply = null;
                try {
                    reply = this.ackackTracker.waitForReply(xid, ProtocolGlobals.getAckTimeout());
                }
                catch (BrokerException e) {
                    if (e.getStatusCode() == 410) {
                        BrokerDownException e1 = new BrokerDownException(br.getKString("B4245", cai.toString(), msgHome), 410);
                        e1.setRemote(true);
                        e1.setRemoteBrokerAddress(msgHome);
                        throw e1;
                    }
                    if (e.getStatusCode() == 408) {
                        BrokerDownException e1 = new BrokerDownException(br.getKString("B4285", cai.toString(), msgHome), 410);
                        e1.setRemote(true);
                        e1.setRemoteBrokerAddress(msgHome);
                        throw e1;
                    }
                    throw e;
                }
                if (reply.getStatus() != 200) {
                    logger.log(16, br.getKString("B2117", msgHome, ClusterMessageAckInfo.toString(reply.getReply())));
                    AckEntryNotFoundException aee = ClusterMessageAckInfo.getAckEntryNotFoundException(reply.getReply());
                    if (aee != null) {
                        throw aee;
                    }
                    throw new BrokerException(reply.getReason(), reply.getStatus());
                }
                if (!this.fi.FAULT_INJECTION) break block45;
                if (ackType == 9) {
                    FaultInjection faultInjection = this.fi;
                    synchronized (faultInjection) {
                        if (this.fi.checkFault("msg.remote_ack.p.txnprepare.3_1", null)) {
                            this.fi.unsetFault("msg.remote_ack.p.txnprepare.3_1");
                            BrokerDownException e1 = new BrokerDownException(br.getKString("B4285", cai.toString(), msgHome), 410);
                            e1.setRemote(true);
                            e1.setRemoteBrokerAddress(msgHome);
                            throw e1;
                        }
                    }
                }
                ClusterMessageAckInfo.CHECKFAULT(this.ackCounts, ackType, txnID, "msg.remote_ack.p.", "3");
            }
            catch (Exception e) {
                if (e instanceof BrokerDownException) {
                    throw (BrokerException)e;
                }
                Map map = this.brokerList;
                synchronized (map) {
                    BrokerInfoEx be = (BrokerInfoEx)this.brokerList.get(msgHome);
                    if (be == null && msgHome != Globals.getMyAddress()) {
                        BrokerDownException e1 = new BrokerDownException(br.getKString("B4249", cai.toString(), msgHome), 410);
                        e1.setRemote(true);
                        e1.setRemoteBrokerAddress(msgHome);
                        throw e1;
                    }
                    if (be != null && (be.sentGoodbye() || be.gotGoodbye())) {
                        BrokerDownException e1 = new BrokerDownException(br.getKString("B4247", cai.toString(), msgHome), 410);
                        e1.setRemote(true);
                        e1.setRemoteBrokerAddress(msgHome);
                        throw e1;
                    }
                    if (this.isTakeoverTarget(msgHome)) {
                        BrokerDownException e1 = new BrokerDownException(br.getKString("B4244", cai.toString(), msgHome), 410);
                        e1.setRemote(true);
                        e1.setRemoteBrokerAddress(msgHome);
                        throw e1;
                    }
                }
                if (e instanceof BrokerException) {
                    throw (BrokerException)e;
                }
                throw new BrokerException(e.getMessage(), e, 500);
            }
            finally {
                if (ackack) {
                    this.ackackTracker.removeWaiter(xid);
                }
            }
        }
    }

    public void receivedMessageAckReply(BrokerAddress sender, GPacket ackack) {
        Long xid = ClusterMessageAckInfo.getAckAckXid(ackack);
        if (xid == null) {
            try {
                if (Globals.getClusterBroadcast().getClusterVersion() < 410) {
                    logger.log(16, "B3100", (Object)("Received message ack reply without correlation ID from " + sender + " : " + ClusterMessageAckInfo.toString(ackack)));
                } else {
                    logger.log(32, "B3100", (Object)("Received message ack reply without correlation ID from " + sender + " : " + ClusterMessageAckInfo.toString(ackack)));
                }
            }
            catch (Exception e) {
                logger.log(16, "XXXI18n-Unable to get cluster version to process message ack reply" + ClusterMessageAckInfo.toString(ackack) + ": " + e.getMessage() + " from " + sender);
            }
            return;
        }
        if (!this.ackackTracker.notifyReply(xid, sender, ackack)) {
            Object[] args = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(4), "[" + ClusterMessageAckInfo.toString(ackack) + "]", sender};
            logger.log(16, br.getKString("B2114", args));
        }
    }

    public static byte[] prepareResetPersistenceRecord() {
        if (DEBUG) {
            Globals.getLogger().log(4, "RaptorProtocol.prepareResetPersistenceRecord");
        }
        GPacket gp = GPacket.getInstance();
        gp.setType((short)31);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            gp.write((OutputStream)bos);
            bos.flush();
            return bos.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    private void sendNewInterestUpdate(Consumer interest) {
        if (DEBUG) {
            logger.log(8, "RaptorProtocol.sendNewInterestUpdate : " + interest.toString());
        }
        ClusterConsumerInfo cci = ClusterConsumerInfo.newInstance(interest, this.c);
        try {
            this.c.broadcast(cci.getGPacket((short)5));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendNewInterestUpdate(BrokerAddress to, Collection consumers) {
        if (DEBUG) {
            logger.log(8, "RaptorProtocol.sendNewInterestUpdate to " + to);
        }
        ClusterConsumerInfo cci = ClusterConsumerInfo.newInstance(consumers, this.c);
        try {
            this.c.unicast(to, cci.getGPacket((short)5));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendAttachDurable(BrokerAddress to, Subscription sub, Consumer interest) {
        if (DEBUG) {
            logger.log(8, "RaptorProtocol.sendAttachDurable(" + to + ", " + Subscription.getDSubLogString(sub.getClientID(), sub.getDurableName()) + ") ," + interest);
        }
        ClusterSubscriptionInfo csi = ClusterSubscriptionInfo.newInstance(sub, interest, this.c);
        try {
            if (to == null) {
                this.c.broadcast(csi.getGPacket((short)35));
            } else {
                this.c.unicast(to, csi.getGPacket((short)35));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendRemDurableUpdate(Consumer interest) {
        if (DEBUG) {
            logger.log(8, "RaptorProtocol.sendRemDurableUpdate : " + interest);
        }
        Subscription sub = null;
        sub = interest instanceof Subscription ? (Subscription)interest : interest.getSubscription();
        ClusterSubscriptionInfo csi = ClusterSubscriptionInfo.newInstance(sub);
        try {
            this.c.broadcast(csi.getGPacket((short)7, false));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendInterestUpdate(Consumer interest, int type) {
        this.sendInterestUpdate(interest, type, null, false);
    }

    private void sendInterestUpdate(Consumer interest, int type, Map pendingMsgs, boolean cleanup) {
        ClusterConsumerInfo cci = ClusterConsumerInfo.newInstance(interest, pendingMsgs, cleanup, this.c);
        Object[] bas = this.getBrokerList();
        if (DEBUG) {
            logger.log(8, "RaptorProtocol.sendInterestUpdate. consumer=" + interest + ", cleanup=" + cleanup + ", subtype=" + ProtocolGlobals.getInterestUpdateSubTypeString(type) + ", pendingmsgs=" + pendingMsgs + " to brokers " + Arrays.toString(bas));
        }
        for (int i = 0; i < bas.length; ++i) {
            try {
                this.c.unicast((BrokerAddress)bas[i], cci.getGPacket((short)9, type, (BrokerAddress)bas[i]));
                continue;
            }
            catch (IOException e) {
                logger.logStack(16, br.getKString("B2110", ProtocolGlobals.getPacketTypeDisplayString(9) + "[" + ProtocolGlobals.getInterestUpdateSubTypeString(type) + "]", bas[i]), (Throwable)e);
            }
        }
    }

    private void sendInterestUpdate(BrokerAddress to, Collection consumers, int type) {
        if (DEBUG) {
            logger.log(8, "RaptorProtocol.sendInterestUpdate. to = " + to);
        }
        ClusterConsumerInfo cci = ClusterConsumerInfo.newInstance(consumers, this.c);
        try {
            this.c.unicast(to, cci.getGPacket((short)9, type));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendClientClosedUpdate(ConnectionUID conid) {
        if (DEBUG) {
            logger.log(8, "RaptorProtocol.sendClientClosedUpdate. conid = " + conid);
        }
        GPacket gp = GPacket.getInstance();
        gp.setType((short)21);
        gp.putProp((Object)"I", (Object)conid.longValue());
        try {
            this.c.broadcast(gp);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void clientClosed(ConnectionUID conid, boolean notify) {
        if (DEBUG || ClusterManagerImpl.isDEBUG_CLUSTER_LOCK()) {
            logger.log(8, "RaptorProtocol.clientClosed(" + conid + ")");
        }
        this.unlockOwnedResources((Object)conid);
        if (notify) {
            this.sendClientClosedUpdate(conid);
            this.cbDispatcher.clientDown(conid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockOwnedResources(Object owner) {
        if (DEBUG || ClusterManagerImpl.isDEBUG_CLUSTER_LOCK()) {
            logger.log(8, "unlockOwnedResources(owner=" + owner + ")[" + owner.getClass().getName() + "]");
        }
        ArrayList<String> tmpList = new ArrayList<String>();
        HashMap hashMap = this.resTable;
        synchronized (hashMap) {
            Set entries = this.resTable.keySet();
            for (String resId : entries) {
                Resource res = (Resource)this.resTable.get(resId);
                Object resowner = res.getOwner();
                if (resowner == null || (resowner.getClass() != owner.getClass() || !resowner.equals(owner)) && (!(resowner instanceof List) || !((List)resowner).contains(owner))) continue;
                tmpList.add(resId);
            }
        }
        for (int i = 0; i < tmpList.size(); ++i) {
            String resId = (String)tmpList.get(i);
            this.unlockResource(resId);
        }
    }

    @Override
    public int lockSharedResource(String resId, Object owner) {
        if (DEBUG || ClusterManagerImpl.isDEBUG_CLUSTER_LOCK()) {
            logger.log(8, "RaptorProtocol.lockSharedResource(" + resId + ", owner=" + owner + ")");
        }
        return this.lockResource(resId, 0L, owner, true);
    }

    public int lockResource(String resId, Object owner) {
        if (DEBUG || ClusterManagerImpl.isDEBUG_CLUSTER_LOCK()) {
            logger.log(8, "RaptorProtocol.lockResource(" + resId + ", owner=" + owner + ")");
        }
        return this.lockResource(resId, 0L, owner);
    }

    @Override
    public int lockResource(String resId, long timestamp, Object owner) {
        if (DEBUG || ClusterManagerImpl.isDEBUG_CLUSTER_LOCK()) {
            logger.log(8, "RaptorProtocol.lockResource(" + resId + ", timestamp=" + timestamp + ", owner=" + owner + ")");
        }
        return this.lockResource(resId, timestamp, owner, false);
    }

    private int lockResource(String resId, long timestamp, Object owner, boolean shared) {
        boolean failOntimeout = resId.startsWith("destCreate:");
        int b = 1;
        int i = 0;
        while (true) {
            int ret = this.tryLockResource(resId, timestamp, owner, shared, failOntimeout);
            if (DEBUG || ClusterManagerImpl.isDEBUG_CLUSTER_LOCK()) {
                logger.log(8, "Lock resource " + resId + " returned: " + ProtocolGlobals.getLockStatusString(ret));
            }
            if (ret == 0 || ret == -1 || ret == 1) {
                return ret;
            }
            if (++i == 10) break;
            int sleep = this.random.nextInt(b *= 2);
            if (sleep == 0) {
                sleep = 1;
            }
            try {
                Thread.sleep((long)sleep * 1000L);
            }
            catch (Exception exception) {}
        }
        logger.log(16, "B2034", (Object)resId);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int tryLockResource(String resId, long timestamp, Object owner, boolean shared, boolean failOntimeout) {
        Resource res;
        Object tmp;
        if (DEBUG || DEBUG_CLUSTER_ALL || ClusterManagerImpl.isDEBUG_CLUSTER_LOCK()) {
            logger.log(8, "RaptorProtocol.tryLockResource(" + resId + ", timestamp=" + timestamp + ", owner=" + owner + ", shared=" + shared + ", failOnTimeout=" + failOntimeout + ")");
        }
        if (this.fi.FAULT_INJECTION && resId.startsWith("clientid:")) {
            HashMap<String, Object> fp = new HashMap<String, Object>();
            tmp = resId.replace("clientid:", "");
            fp.put("mqClusterLockResourceId", tmp);
            logger.log(8, "RaptorProtocol.tryLockResource(" + resId + "), checkFault for " + fp);
            FaultInjection faultInjection = this.fi;
            synchronized (faultInjection) {
                if (this.fi.checkFault("cluster.lock.timeout", fp)) {
                    this.fi.unsetFault("cluster.lock.timeout");
                    return -1;
                }
            }
        }
        tmp = this.resTable;
        synchronized (tmp) {
            res = (Resource)this.resTable.get(resId);
            if (res != null) {
                if (shared && res.getShared()) {
                    return 0;
                }
                return 1;
            }
            res = new Resource(resId, this.c);
            res.setShared(shared);
            res.setOwner(owner);
            if (timestamp != 0L) {
                res.setTimestamp(timestamp);
            }
            this.resTable.put(resId, res);
        }
        res.setLockState(0);
        block23: while (true) {
            if (DEBUG || DEBUG_CLUSTER_ALL || ClusterManagerImpl.isDEBUG_CLUSTER_LOCK()) {
                logger.log(8, "MessageBus: Trying to lock resource {0}", (Object)resId);
            }
            int status = 0;
            try {
                this.sendLockRequest(res);
            }
            catch (HandshakeInProgressException e) {
                HashMap hashMap = this.resTable;
                synchronized (hashMap) {
                    this.resTable.remove(resId);
                }
                return 2;
            }
            status = res.waitForStatusChange(ProtocolGlobals.getLockTimeout(), failOntimeout);
            if (DEBUG || DEBUG_CLUSTER_ALL || ClusterManagerImpl.isDEBUG_CLUSTER_LOCK()) {
                logger.log(8, "MessageBus: Lock attempt status = {0} for resource {1}", (Object)Integer.toString(status), (Object)resId);
            }
            switch (status) {
                case 0: {
                    res.setLockState(1);
                    return status;
                }
                case 1: 
                case 2: {
                    HashMap e = this.resTable;
                    synchronized (e) {
                        this.resTable.remove(resId);
                    }
                    return status;
                }
                case -1: {
                    String shows = res.showRecipients((PingHandler)this.handlers[33], this.c);
                    Object[] args = new String[]{res.getResId(), shows};
                    logger.log(16, br.getKTString("B2062", args));
                    HashMap hashMap = this.resTable;
                    synchronized (hashMap) {
                        this.resTable.remove(resId);
                    }
                    return status;
                }
                case 3: {
                    if (!DEBUG && !DEBUG_CLUSTER_ALL && !ClusterManagerImpl.isDEBUG_CLUSTER_LOCK()) continue block23;
                    logger.log(8, "Active brokerlist changed. Restarting Lock election for " + res.getResId());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockResource(String resId) {
        if (DEBUG || ClusterManagerImpl.isDEBUG_CLUSTER_LOCK()) {
            logger.log(8, "RaptorProtocol.unlockResource(" + resId + ")");
        }
        HashMap hashMap = this.resTable;
        synchronized (hashMap) {
            Resource res = (Resource)this.resTable.remove(resId);
            if (res != null) {
                res.impliedFailure();
            }
        }
    }

    private void sendLockRequest(Resource res) throws HandshakeInProgressException {
        block5: {
            if (DEBUG || ClusterManagerImpl.isDEBUG_CLUSTER_LOCK()) {
                logger.log(8, "RaptorProtocol.sendLockRequest(" + res + ")");
            }
            this.c.waitClusterInit();
            long xid = System.currentTimeMillis();
            BrokerAddress[] recipients = this.getBrokerList();
            if (DEBUG || ClusterManagerImpl.isDEBUG_CLUSTER_LOCK()) {
                StringBuilder debugstr = new StringBuilder();
                for (BrokerAddress recipient : recipients) {
                    debugstr.append("\n\t").append(recipient);
                }
                logger.log(8, "Sending resource lock request for : " + res.getResId() + "\nExpecting responses from : " + debugstr.toString());
            }
            res.prepareLockRequest(recipients, xid);
            GPacket gp = GPacket.getInstance();
            gp.setType((short)11);
            gp.putProp((Object)"I", (Object)res.getResId());
            gp.putProp((Object)"TS", (Object)res.getTimestamp());
            gp.putProp((Object)"X", (Object)xid);
            gp.putProp((Object)"SH", (Object)res.getShared());
            try {
                Map<BrokerAddress, Object> m = this.c.broadcastUrgent(gp);
                res.updateRecipients(m);
            }
            catch (Exception e) {
                logger.log(16, br.getKString("B2270", ProtocolGlobals.getPacketTypeDisplayString(gp.getType()) + "[" + res.getResId() + "]", e.getMessage()), (Throwable)e);
                if (!(e instanceof HandshakeInProgressException)) break block5;
                throw (HandshakeInProgressException)e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveLockRequest(BrokerAddress sender, String resId, long timestamp, long xid, boolean shared) {
        int response;
        if (DEBUG || ClusterManagerImpl.isDEBUG_CLUSTER_LOCK()) {
            logger.log(8, "Received lock request(" + resId + ", timestamp=" + timestamp + ", xid=" + xid + ", shared=" + shared + ") from " + sender);
        }
        Resource res = null;
        HashMap hashMap = this.resTable;
        synchronized (hashMap) {
            res = (Resource)this.resTable.get(resId);
        }
        if (res == null || shared && res.getShared()) {
            response = 0;
        } else if (res.getLockState() == 1) {
            response = 1;
        } else if (timestamp < res.getTimestamp()) {
            res.impliedFailure();
            response = 0;
        } else {
            response = timestamp > res.getTimestamp() ? 1 : 2;
        }
        this.sendLockResponse(sender, resId, xid, response);
    }

    private void sendLockResponse(BrokerAddress to, String resId, long xid, int response) {
        if (DEBUG || DEBUG_CLUSTER_ALL || ClusterManagerImpl.isDEBUG_CLUSTER_LOCK()) {
            logger.log(8, "sendLockResponse(" + resId + ", xid=" + xid + ", response=" + response + ") to " + to);
        }
        GPacket gp = GPacket.getInstance();
        gp.setType((short)12);
        gp.putProp((Object)"I", (Object)resId);
        gp.putProp((Object)"X", (Object)xid);
        gp.putProp((Object)"S", (Object)response);
        try {
            this.c.unicastUrgent(to, gp);
        }
        catch (Exception e) {
            logger.log(16, br.getString("B2101", resId, to.toString()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveLockResponse(BrokerAddress sender, String resId, long xid, int response) {
        if (DEBUG || ClusterManagerImpl.isDEBUG_CLUSTER_LOCK()) {
            logger.log(8, "Received lock response(" + resId + ", xid=" + xid + ", response=" + ProtocolGlobals.lockResponseStrings[response] + ") from " + sender);
        }
        Resource res = null;
        HashMap hashMap = this.resTable;
        synchronized (hashMap) {
            res = (Resource)this.resTable.get(resId);
        }
        if (res == null) {
            return;
        }
        if ((DEBUG || ClusterManagerImpl.isDEBUG_CLUSTER_LOCK()) && res.getXid() == xid) {
            logger.log(8, "Found waiting xid for received lock response(" + resId + ", xid=" + xid + ", response=" + ProtocolGlobals.lockResponseStrings[response] + ") from " + sender);
        }
        res.consumeResponse(xid, sender, response);
    }

    @Override
    public void recordUpdateDestination(Destination d) throws BrokerException {
        ClusterDestInfo cdi;
        int ret;
        if (DEBUG) {
            logger.log(8, "RaptorProtocol.recordUpdateDestination: " + d);
        }
        if ((ret = this.recordConfigChangeEvent((cdi = ClusterDestInfo.newInstance(d)).getGPacket((short)13, true))) != 1) {
            throw new BrokerException(br.getKString("B3224", "UPDATE_DESTINATION[" + d.getDestinationName() + "]"));
        }
    }

    @Override
    public void recordRemoveDestination(Destination d) throws BrokerException {
        ClusterDestInfo cdi;
        int ret;
        if (DEBUG) {
            logger.log(8, "RaptorProtocol.recordRemoveDestination");
        }
        if ((ret = this.recordConfigChangeEvent((cdi = ClusterDestInfo.newInstance(d)).getGPacket((short)15, true))) != 1) {
            throw new BrokerException(br.getKString("B3224", "REM_DESTINATION[" + d.getDestinationName() + "]"), ret);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int recordConfigChangeEvent(GPacket event) throws BrokerException {
        BrokerAddress configserv;
        if (DEBUG) {
            logger.log(8, "RaptorProtocol.recordConfigChangeEvent");
        }
        if (DEBUG) {
            logger.log(1, "Event = " + event.toLongString());
        }
        if ((configserv = this.c.getConfigServer()) == null) {
            return 1;
        }
        Long xid = UniqueID.generateID((short)UID.getPrefix());
        EventLogWaiter waiter = new EventLogWaiter(0);
        this.eventLogWaiters.put(xid, waiter);
        try {
            EventLogWaiter eventLogWaiter = waiter;
            synchronized (eventLogWaiter) {
                this.sendConfigChangeEvent(xid, event);
                while (waiter.getStatus() == 0) {
                    try {
                        logger.log(8, br.getKString("B1265", "[" + Thread.currentThread().toString() + "]" + xid, configserv.toString()));
                        waiter.wait(60000L);
                    }
                    catch (Exception exception) {}
                }
                if (waiter.getStatus() == 1) {
                    // empty if block
                }
                return waiter.getStatus();
            }
        }
        catch (BrokerException e) {
            this.eventLogWaiters.remove(xid);
            if (DEBUG) {
                logger.logStack(16, e.getMessage() + ": " + event.toLongString(), (Throwable)e);
            }
            throw e;
        }
    }

    private void sendConfigChangeEvent(Long eventLogXid, GPacket event) throws BrokerException {
        if (DEBUG) {
            logger.log(8, "RaptorProtocol.sendConfigChangeEvent. xid = " + eventLogXid);
        }
        BrokerAddress configServer = this.c.getConfigServer();
        GPacket gp = GPacket.getInstance();
        gp.setType((short)17);
        gp.putProp((Object)"X", (Object)eventLogXid);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            event.write((OutputStream)bos);
            bos.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] buf = bos.toByteArray();
        gp.setPayload(ByteBuffer.wrap(buf));
        try {
            this.c.unicast(configServer, gp);
        }
        catch (Exception e) {
            throw new BrokerException(br.getKString("B4094"), "B4094", null, 403);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveConfigChangeEvent(BrokerAddress sender, Long xidProp, byte[] eventData) {
        if (DEBUG) {
            logger.log(8, "RaptorProtocol.receiveConfigChangeEvent(xid=" + xidProp + ") from " + sender);
        }
        int status = 1;
        String reason = null;
        boolean nologstack = false;
        try {
            this.setConfigOpInProgressIfNotBlocked();
            try {
                Object[] args;
                Map<String, ChangeRecord> map;
                BrokerAddress configServer = this.c.getConfigServer();
                if (configServer == null) {
                    throw new BrokerException("Unexpected: there is no master broker");
                }
                if (!configServer.equals(this.selfAddress)) {
                    Object[] args2 = new String[]{ProtocolGlobals.getPacketTypeDisplayString(17), sender.toString(), configServer.toString()};
                    throw new BrokerException(br.getKString("B4344", args2), 412);
                }
                ChangeRecord cr = ChangeRecord.makeChangeRecord(eventData);
                if (Globals.nowaitForMasterBroker() && cr.getOperation() == 15 && DestType.isQueue((int)((DestinationUpdateChangeRecord)cr).getType())) {
                    HashSet<BrokerMQAddress> bmas = new HashSet<BrokerMQAddress>();
                    map = this.brokerList;
                    synchronized (map) {
                        Iterator itr = this.brokerList.keySet().iterator();
                        while (itr.hasNext()) {
                            BrokerMQAddress bma = ((BrokerAddress)itr.next()).getMQAddress();
                            bmas.add(bma);
                        }
                    }
                    Iterator itr = Globals.getClusterManager().getConfigBrokers();
                    ClusteredBroker cb = null;
                    while (itr.hasNext()) {
                        cb = (ClusteredBroker)itr.next();
                        if (bmas.contains(cb.getBrokerURL()) || cb.isLocalBroker()) continue;
                        args = new String[]{((DestinationUpdateChangeRecord)cr).getName(), sender.toString(), ServiceRestriction.NO_SYNC_WITH_MASTERBROKER.toString(), cb.getBrokerURL().toString()};
                        nologstack = true;
                        throw new BrokerException(br.getKString("B4289", args));
                    }
                }
                if (cr.getOperation() == 7) {
                    this.inDSubToBrokerMap.remove(cr.getUniqueKey());
                } else if (cr.getOperation() == 5) {
                    Subscription sub = Subscription.findDurableSubscription(((InterestUpdateChangeRecord)cr).getSubscriptionKey());
                    if (sub != null) {
                        this.inDSubToBrokerMap.remove(cr.getUniqueKey());
                        String emsg = br.getKString("B1483", "[" + cr.getUniqueKey() + "]" + sub.getDSubLongLogString(), sender);
                        logger.log(8, emsg);
                        if (sub.getShared() != ((InterestUpdateChangeRecord)cr).getShared().booleanValue() || sub.getJMSShared() != ((InterestUpdateChangeRecord)cr).getJMSShared().booleanValue()) {
                            throw new BrokerException(emsg);
                        }
                    } else {
                        map = this.inDSubToBrokerMap;
                        synchronized (map) {
                            InterestUpdateChangeRecord existcr = (InterestUpdateChangeRecord)this.inDSubToBrokerMap.get(cr.getUniqueKey());
                            if (existcr != null) {
                                args = new Object[]{"[" + cr.getUniqueKey() + "]", existcr.getBroker(), sender};
                                String emsg = br.getKString("B1484", args) + "[" + existcr.getFlagString() + "]";
                                logger.log(8, emsg);
                                if (((InterestUpdateChangeRecord)cr).getShared() != existcr.getShared() || ((InterestUpdateChangeRecord)cr).getJMSShared() != existcr.getJMSShared()) {
                                    throw new BrokerException(emsg);
                                }
                            } else {
                                ((InterestUpdateChangeRecord)cr).setBroker(sender);
                                this.inDSubToBrokerMap.put(cr.getUniqueKey(), cr);
                            }
                        }
                    }
                }
                try {
                    this.store.storeConfigChangeRecord(System.currentTimeMillis(), eventData, false);
                }
                catch (Exception e) {
                    this.inDSubToBrokerMap.remove(cr.getUniqueKey());
                    throw e;
                }
            }
            finally {
                this.setConfigOpInProgress(false);
            }
        }
        catch (Exception e) {
            reason = e.getMessage();
            status = 2;
            if (e instanceof BrokerException) {
                status = ((BrokerException)e).getStatusCode();
            }
            if (nologstack) {
                logger.log(32, e.getMessage(), (Throwable)e);
            }
            logger.logStack(32, e.getMessage(), (Throwable)e);
        }
        this.sendConfigChangeEventAck(sender, xidProp, status, reason);
    }

    private void sendConfigChangeEventAck(BrokerAddress to, Long xidProp, int status, String reason) {
        if (DEBUG) {
            logger.log(8, "RaptorProtocol.sendConfigChangeEventAck(" + to + ", " + xidProp + ", " + status + ", " + reason + ")");
        }
        GPacket gp = GPacket.getInstance();
        gp.setType((short)18);
        gp.putProp((Object)"X", (Object)xidProp);
        gp.putProp((Object)"S", (Object)status);
        if (reason != null) {
            gp.putProp((Object)"reason", (Object)reason);
        }
        try {
            this.c.unicast(to, gp);
        }
        catch (Exception e) {
            logger.log(1, "Unable to unicast message ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveConfigChangeEventReply(BrokerAddress sender, Long xid, int status, String reason) {
        EventLogWaiter waiter;
        if (DEBUG) {
            logger.log(8, "RaptorProtocol.receiveConfigChangeEventAck(" + sender + ", " + xid + ", " + status + ", " + reason + ")");
        }
        if ((waiter = (EventLogWaiter)this.eventLogWaiters.remove(xid)) == null) {
            Object[] args = new String[]{String.valueOf(xid), String.valueOf(status)};
            logger.log(16, "B2107", args);
            return;
        }
        EventLogWaiter eventLogWaiter = waiter;
        synchronized (eventLogWaiter) {
            waiter.setStatus(status);
            waiter.setReason(reason);
            waiter.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendConfigChangesRequest(BrokerAddress to, long timestamp) {
        if (DEBUG) {
            logger.log(8, "RaptorProtocol.sendConfigChangesRequest. timestamp = " + timestamp + ", to " + to);
        }
        GPacket gp = GPacket.getInstance();
        gp.setType((short)19);
        gp.putProp((Object)"TS", (Object)timestamp);
        Object object = this.cfgSrvWaitObject;
        synchronized (object) {
            try {
                this.c.unicast(to, gp);
                ++this.cfgSrvRequestCount;
                this.cfgSrvRequestErr = false;
            }
            catch (Exception e) {
                this.cfgSrvRequestCount = 0;
                this.cfgSrvRequestErr = true;
                this.cfgSrvWaitObject.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveConfigChangesRequest(BrokerAddress sender, long timestamp) {
        if (DEBUG) {
            logger.log(8, "RaptorProtocol.receiveConfigChangesRequest. from = " + sender + ", timestamp=" + timestamp);
        }
        String emsg = null;
        List<ChangeRecordInfo> records = null;
        try {
            this.setConfigOpInProgressIfNotBlocked();
            try {
                BrokerAddress configServer = this.c.getConfigServer();
                if (configServer == null) {
                    throw new BrokerException("Unexpected: there is no master broker");
                }
                if (!configServer.equals(this.selfAddress)) {
                    Object[] args = new String[]{ProtocolGlobals.getPacketTypeDisplayString(19), sender.toString(), configServer.toString()};
                    throw new BrokerException(br.getKString("B4344", args));
                }
                records = this.store.getConfigChangeRecordsSince(timestamp);
            }
            finally {
                this.setConfigOpInProgress(false);
            }
        }
        catch (Exception e) {
            emsg = e.getMessage();
            Object[] args = new String[]{ProtocolGlobals.getPacketTypeDisplayString(19), sender.toString(), e.getMessage()};
            logger.logStack(32, br.getKString("B3269", args), (Throwable)e);
        }
        long now = System.currentTimeMillis();
        this.sendConfigChangesResponse(sender, now, records, emsg);
    }

    private void sendConfigChangesResponse(BrokerAddress to, long currentTime, List<ChangeRecordInfo> records, String emsg) {
        if (DEBUG) {
            logger.log(8, "RaptorProtocol.sendConfigChangesResponse. to = " + to);
        }
        GPacket gp = GPacket.getInstance();
        gp.setType((short)20);
        gp.putProp((Object)"TS", (Object)currentTime);
        if (records == null) {
            gp.putProp((Object)"S", (Object)500);
            if (emsg != null) {
                gp.putProp((Object)"reason", (Object)emsg);
            }
        } else {
            gp.putProp((Object)"S", (Object)200);
            gp.putProp((Object)"C", (Object)records.size());
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                for (int i = 0; i < records.size(); ++i) {
                    byte[] rec = records.get(i).getRecord();
                    bos.write(rec, 0, rec.length);
                }
                bos.flush();
            }
            catch (Exception i) {
                // empty catch block
            }
            byte[] buf = bos.toByteArray();
            gp.setPayload(ByteBuffer.wrap(buf));
        }
        try {
            this.c.unicast(to, gp);
        }
        catch (Exception e) {
            logger.log(1, "Exception in unicast ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveConfigChangesReply(BrokerAddress sender, long refreshTime, int count, byte[] buf, String emsg) {
        logger.log(8, br.getKString("B1383", "(" + count + ", " + refreshTime + ")", sender.toString()));
        if (DEBUG) {
            logger.log(8, "RaptorProtocol.receiveConfigChangesResponse from " + sender + ", record count=" + count);
        }
        if (emsg != null) {
            Object[] args = new String[]{emsg, ProtocolGlobals.getPacketTypeDisplayString(19), sender.toString()};
            String logmsg = br.getKString("B3270", args);
            logger.log(32, logmsg);
            logger.log(16, br.getKString("B2126", sender, logmsg));
            this.c.closeLink(sender, true);
        }
        Object object = this.newMasterBrokerLock;
        synchronized (object) {
            BrokerAddress configServer = null;
            try {
                configServer = this.c.getConfigServer();
            }
            catch (Exception e) {
                logger.log(16, br.getKString("B2126", sender, br.getString("B0086") + "[" + e.getMessage() + "]"));
                this.c.closeLink(sender, true);
            }
            if (!configServer.getMQAddress().equals((Object)sender.getMQAddress())) {
                logger.log(16, br.getKString("B2126", sender, br.getString("B0085") + "[" + sender + ", " + configServer + "]"));
                this.c.closeLink(sender, true);
            }
            boolean resetRequired = false;
            BrokerAddress lastConfigServer = this.getLastConfigServer();
            if (lastConfigServer != null && !lastConfigServer.equals(sender)) {
                resetRequired = true;
                if (count == 0) {
                    logger.log(32, "B3095");
                    Broker.getBroker().exit(1, br.getString("B3095"), BrokerEvent.Type.FATAL_ERROR);
                }
            }
            DataInputStream dis = null;
            if (buf != null) {
                ByteArrayInputStream bis = new ByteArrayInputStream(buf);
                dis = new DataInputStream(bis);
            }
            try {
                boolean resetFlag = false;
                ArrayList<GPacket> l = null;
                for (int i = 0; i < count; ++i) {
                    GPacket gp = GPacket.getInstance();
                    gp.read((InputStream)dis);
                    if (i == 0) {
                        if (gp.getType() == 31) {
                            resetFlag = true;
                            l = new ArrayList<GPacket>();
                        }
                        if (resetRequired && !resetFlag) {
                            logger.log(32, "B3095");
                            Broker.getBroker().exit(1, br.getString("B3095"), BrokerEvent.Type.FATAL_ERROR);
                        }
                    }
                    if (resetFlag) {
                        l.add(gp);
                        continue;
                    }
                    this.receiveBroadcast(sender, gp);
                }
                if (resetFlag) {
                    this.applyPersistentStateChanges(sender, l);
                }
                if (!this.configSyncComplete) {
                    this.configSyncComplete = true;
                    this.sendGetInterestUpdate(sender);
                    this.cbDispatcher.configSyncComplete();
                    logger.log(64, "B1075");
                }
                Object object2 = this.cfgSrvWaitObject;
                synchronized (object2) {
                    --this.cfgSrvRequestCount;
                    if (this.cfgSrvRequestCount == 0) {
                        this.cfgSrvWaitObject.notifyAll();
                    }
                }
                this.storeLastRefreshTime(refreshTime - 120000L);
                this.storeLastConfigServer(sender);
            }
            catch (Exception e) {
                logger.logStack(16, "B3100", (Object)"Error while applying the config changes...", (Throwable)e);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitConfigChangesResponse() {
        if (DEBUG) {
            logger.log(8, "RaptorProtocol.waitConfigChangesResponse.");
        }
        Object object = this.cfgSrvWaitObject;
        synchronized (object) {
            while (this.cfgSrvRequestCount > 0) {
                try {
                    this.cfgSrvWaitObject.wait();
                }
                catch (Exception exception) {}
            }
            if (DEBUG) {
                logger.log(8, "RaptorProtocol.waitConfigChangesResponse returning :" + !this.cfgSrvRequestErr);
            }
            return !this.cfgSrvRequestErr;
        }
    }

    public void applyPersistentStateChanges(BrokerAddress sender, ArrayList list) throws Exception {
        if (DEBUG) {
            logger.log(8, "RaptorProtocol.applyPersistentStateChanges.");
        }
        HashMap<String, ConsumerUID> oldInts = new HashMap<String, ConsumerUID>();
        HashMap<DestinationUID, Destination> oldDests = new HashMap<DestinationUID, Destination>();
        Set ints = Subscription.getAllSubscriptions(null);
        for (Subscription sub : ints) {
            ConsumerUID intid = sub.getConsumerUID();
            String key = Subscription.getDSubKey(sub.getClientID(), sub.getDurableName());
            oldInts.put(key, intid);
        }
        Iterator[] itrs = DestinationList.getAllDestinations(null);
        Iterator<Object> itr = itrs[0];
        while (itr.hasNext()) {
            Destination d = (Destination)itr.next();
            if (d.isAutoCreated() || d.isInternal() || d.isTemporary() || d.isDMQ()) continue;
            oldDests.put(d.getDestinationUID(), d);
        }
        for (int i = 0; i < list.size(); ++i) {
            GPacket gp = (GPacket)list.get(i);
            if (gp.getType() == 31) {
                if (!DEBUG) continue;
                logger.log(8, "applyPersistentStateChanges : RESET_PERSISTENCE");
                continue;
            }
            if (gp.getType() == 5 || gp.getType() == 7) {
                this.handlers[gp.getType()].handle(this.cb, sender, gp);
                ClusterSubscriptionInfo csi = ClusterSubscriptionInfo.newInstance(gp);
                String key = Subscription.getDSubKey(csi.getClientID(), csi.getDurableName());
                oldInts.remove(key);
                if (!DEBUG) continue;
                if (gp.getType() == 5) {
                    logger.log(8, "Added subscription : " + key);
                    continue;
                }
                logger.log(8, "Remove subscription : " + key);
                continue;
            }
            if (gp.getType() != 13 && gp.getType() != 15) continue;
            ClusterDestInfo cdi = ClusterDestInfo.newInstance(gp);
            String dname = cdi.getDestName();
            int dtype = cdi.getDestType();
            DestinationUID key = DestinationUID.getUID(dname, DestType.isQueue((int)dtype));
            Destination old = (Destination)oldDests.get(key);
            if (gp.getType() == 13 && old != null && old.getType() != dtype) {
                DestinationUID duid = DestinationUID.getUID(old.getDestinationName(), DestType.isQueue((int)old.getType()));
                this.cb.notifyDestroyDestination(duid);
            }
            this.handlers[gp.getType()].handle(this.cb, sender, gp);
            oldDests.remove(key);
            if (!DEBUG) continue;
            if (gp.getType() == 13) {
                logger.log(8, "Updated destination : " + key);
                continue;
            }
            logger.log(8, "Removed destination : " + key);
        }
        for (ConsumerUID intid : oldInts.values()) {
            Consumer c = Consumer.getConsumer(intid);
            if (c == null) continue;
            this.cb.interestRemoved(c, null, false);
            if (c instanceof Subscription) {
                this.cb.unsubscribe((Subscription)c);
            }
            if (!DEBUG) continue;
            logger.log(8, "Removed stale subscription : " + c);
        }
        for (DestinationUID duid : oldDests.keySet()) {
            this.cb.notifyDestroyDestination(duid);
            if (!DEBUG) continue;
            logger.log(8, "Removed stale destination : " + duid);
        }
    }

    @Override
    public void sendNewDestination(Destination d) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "Sending New Destination " + d);
        }
        this.sendUpdateDestination(null, d);
    }

    @Override
    public void sendUpdateDestination(Destination d) throws BrokerException {
        this.sendUpdateDestination(null, d);
    }

    private void sendUpdateDestination(BrokerAddress to, Destination d) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "Sending Update Destination " + d + (String)(to == null ? "" : " to " + to));
        }
        ClusterDestInfo cdi = ClusterDestInfo.newInstance(d);
        try {
            if (to == null) {
                this.c.broadcast(cdi.getGPacket((short)13, false));
            } else {
                this.c.unicast(to, cdi.getGPacket((short)13, false));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void sendRemovedDestination(Destination d) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "Sending New Destination " + d);
        }
        ClusterDestInfo cdi = ClusterDestInfo.newInstance(d);
        try {
            this.c.broadcast(cdi.getGPacket((short)15, false));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void recordCreateSubscription(Subscription sub) throws BrokerException {
        ClusterSubscriptionInfo csi;
        int ret;
        if (DEBUG) {
            logger.log(8, "RaptorProtocol.recordCreateSubscription");
        }
        if ((ret = this.recordConfigChangeEvent((csi = ClusterSubscriptionInfo.newInstance(sub)).getGPacket((short)5, true))) != 1) {
            throw new BrokerException(br.getKString("B3224", "NEW_INTEREST" + Subscription.getDSubLogString(sub.getClientID(), sub.getDurableName())), ret);
        }
    }

    @Override
    public void recordUnsubscribe(Subscription sub) throws BrokerException {
        ClusterSubscriptionInfo csi;
        int ret;
        if (DEBUG) {
            logger.log(8, "RaptorProtocol.recordUnsubscribe");
        }
        if ((ret = this.recordConfigChangeEvent((csi = ClusterSubscriptionInfo.newInstance(sub)).getGPacket((short)7, true))) != 1) {
            throw new BrokerException(br.getKString("B3224", "REMOVE_DURABLE" + Subscription.getDSubLogString(sub.getClientID(), sub.getDurableName())));
        }
    }

    @Override
    public void sendNewSubscription(Subscription sub, Consumer cons, boolean active) throws BrokerException {
        if (DEBUG) {
            logger.log(8, "RaptorProtocol.sendNewSubscription");
        }
        this.sendNewInterestUpdate(sub);
        this.sendAttachDurable(null, sub, cons);
        if (active) {
            this.sendInterestUpdate(cons, 4);
        }
    }

    @Override
    public void sendNewConsumer(Consumer c, boolean active) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.sendNewConsumer");
        }
        this.sendNewInterestUpdate(c);
        if (active) {
            this.sendInterestUpdate(c, 4);
        }
    }

    @Override
    public void sendRemovedConsumer(Consumer c, Map pendingMsgs, boolean cleanup) throws BrokerException {
        if (DEBUG) {
            logger.log(8, "RaptorProtocol.sendRemovedConsumer(" + c + ", pending=" + pendingMsgs + ", cleanup=" + cleanup + ")");
        }
        this.unlockOwnedResources(c.getConsumerUID());
        if (c instanceof Subscription) {
            this.sendRemDurableUpdate(c);
        } else if (c.getSubscription() != null) {
            this.sendInterestUpdate(c, 3, pendingMsgs, cleanup);
        } else {
            this.sendInterestUpdate(c, 2, pendingMsgs, cleanup);
        }
    }

    private void sendGetInterestUpdate(BrokerAddress broker) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.sendGetInterestUpdate");
        }
        GPacket gp = GPacket.getInstance();
        gp.setType((short)29);
        try {
            this.c.unicast(broker, gp);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void receiveGetInterestUpdate(BrokerAddress sender) {
        if (DEBUG) {
            logger.log(4, "MessageBus: Received request for a full interest update from {0}.", (Object)sender);
        }
        this.forwardLocalInterests(sender);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int addBrokerInfo(BrokerInfo brokerInfo) {
        BrokerAddress configServer;
        block36: {
            BrokerAddress r;
            if (DEBUG) {
                logger.log(8, "RaptorProtocol.addBrokerInfo(" + brokerInfo + ")");
            }
            if (brokerInfo.getClusterProtocolVersion() == null) {
                logger.log(16, "B2086", (Object)brokerInfo.getBrokerAddr());
                return 2;
            }
            if (brokerInfo.getClusterProtocolVersion() == 400) {
                logger.log(16, "XXXI18N - Reject no cluster support broker version 400:" + brokerInfo.getBrokerAddr());
                return 2;
            }
            if (brokerInfo.getClusterProtocolVersion() >= 400) {
                try {
                    this.checkUIDPrefixClash(brokerInfo);
                }
                catch (Exception e) {
                    return 2;
                }
            }
            if (brokerInfo.getClusterProtocolVersion() < 400 && Globals.getHAEnabled()) {
                logger.log(16, br.getKString("B2118", brokerInfo.getBrokerAddr()));
                return 2;
            }
            if (brokerInfo.getBrokerAddr().getHAEnabled() != Globals.getHAEnabled()) {
                logger.log(16, "HA mode not match with remote broker " + brokerInfo.getBrokerAddr());
                return 2;
            }
            if (Globals.getBDBREPEnabled() && (r = brokerInfo.getBrokerAddr()).getInstanceName().equals(Globals.getConfigName())) {
                logger.log(16, br.getKString("B3300", r.getInstanceName(), r));
                return 2;
            }
            configServer = null;
            try {
                configServer = this.c.getConfigServer();
            }
            catch (Exception e) {
                logger.log(16, "Master broker not resolved yet, ask remote broker " + brokerInfo.getBrokerAddr() + " retry later");
                return 1;
            }
            Map e = this.brokerList;
            synchronized (e) {
                if (this.shutdown) {
                    return 2;
                }
                if (this.isTakeoverTarget(brokerInfo.getBrokerAddr())) {
                    logger.log(16, br.getKString("B2119", brokerInfo));
                    this.forwardTakeoverBrokers(brokerInfo.getBrokerAddr(), false);
                    return 1;
                }
                Object old = this.brokerList.get(brokerInfo.getBrokerAddr());
                if (old != null) {
                    logger.log(16, br.getKString("B2120", brokerInfo));
                    return 1;
                }
                BrokerInfoEx brokerInfoEx = new BrokerInfoEx(brokerInfo);
                this.brokerList.put(brokerInfo.getBrokerAddr(), brokerInfoEx);
                if (DEBUG) {
                    logger.log(8, "RaptorProtocol.addBrokerInfo(): added BrokerInfoEx@" + brokerInfoEx.hashCode() + " for broker " + brokerInfo.getBrokerAddr());
                }
            }
            if (!this.configSyncComplete) {
                try {
                    if (configServer != null && configServer.equals(brokerInfo.getBrokerAddr())) {
                        long timestamp = -1L;
                        timestamp = this.getLastRefreshTime();
                        BrokerAddress lastConfigServer = this.getLastConfigServer();
                        if (lastConfigServer == null || !lastConfigServer.equals(configServer)) {
                            timestamp = -1L;
                        }
                        this.sendConfigChangesRequest(configServer, timestamp);
                        if (DEBUG_CLUSTER_ALL || DEBUG_CLUSTER_CONN) {
                            logger.log(8, "B1070");
                        }
                        break block36;
                    }
                    if (DEBUG) {
                        logger.log(4, "Config sync not complete. Rejecting addBrokerInfo : " + brokerInfo);
                    }
                    this.brokerList.remove(brokerInfo.getBrokerAddr());
                    return 1;
                }
                catch (Exception timestamp) {
                    // empty catch block
                }
            }
        }
        if (DEBUG) {
            logger.log(4, "MessageBus: New Broker : {0}", (Object)brokerInfo);
        }
        try {
            if (brokerInfo.getStoreDirtyFlag() && configServer != null && !configServer.equals(brokerInfo.getBrokerAddr())) {
                long timestamp = -1L;
                timestamp = this.getLastRefreshTime();
                this.sendConfigChangesRequest(configServer, timestamp);
                if (!this.waitConfigChangesResponse()) {
                    this.brokerList.remove(brokerInfo.getBrokerAddr());
                    return 2;
                }
            }
        }
        catch (Exception timestamp) {
            // empty catch block
        }
        try {
            if (brokerInfo.getBrokerAddr().getHAEnabled()) {
                Globals.getClusterManager().activateBroker(brokerInfo.getBrokerAddr().getBrokerID(), brokerInfo.getBrokerAddr().getBrokerSessionUID(), brokerInfo.getBrokerAddr().getInstanceName(), (Object)brokerInfo);
            }
            Globals.getClusterManager().activateBroker(brokerInfo.getBrokerAddr().getMQAddress(), brokerInfo.getBrokerAddr().getBrokerSessionUID(), brokerInfo.getBrokerAddr().getInstanceName(), (Object)brokerInfo);
        }
        catch (Exception e) {
            logger.logStack(32, br.getKString("B2115", brokerInfo, e.getMessage()), (Throwable)e);
            this.brokerList.remove(brokerInfo.getBrokerAddr());
            return 1;
        }
        logger.log(8, br.getKString("B1179", brokerInfo));
        if (Globals.getHAEnabled()) {
            this.forwardTakeoverBrokers(brokerInfo.getBrokerAddr(), true);
        }
        if (this.flowStopped) {
            this.sendFlowControlUpdate(brokerInfo.getBrokerAddr());
        }
        this.forwardLocalInterests(brokerInfo.getBrokerAddr());
        this.sendTransactionInquiries(brokerInfo.getBrokerAddr(), null);
        this.restartElections(brokerInfo.getBrokerAddr());
        if (Globals.getBDBREPEnabled()) {
            this.sendMyReplicationGroupInfo(brokerInfo.getBrokerAddr());
        }
        logger.log(64, "B1071", (Object)(brokerInfo.getBrokerAddr().toString() + (String)(brokerInfo.getRealRemoteString() == null ? "" : "[" + brokerInfo.getRealRemoteString() + "]")));
        return 0;
    }

    private void forwardLocalInterests(BrokerAddress broker) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.forwardLocalInterests to : " + broker);
        }
        Iterator[] itrs = DestinationList.getTempDestinations(null, this.selfAddress);
        Iterator itr = itrs[0];
        while (itr.hasNext()) {
            Destination d = (Destination)itr.next();
            try {
                this.sendUpdateDestination(broker, d);
            }
            catch (BrokerException e) {
                logger.logStack(8, e.getMessage(), (Throwable)e);
            }
        }
        HashSet<Consumer> localActiveInterests = new HashSet<Consumer>();
        HashSet<Consumer> primaryInterests = new HashSet<Consumer>();
        HashSet<Consumer> attachedSubs = new HashSet<Consumer>();
        HashSet<Subscription> subscriptions = new HashSet<Subscription>();
        itr = Consumer.getAllConsumers(false);
        while (itr.hasNext()) {
            Consumer c = (Consumer)itr.next();
            Destination d = c.getFirstDestination();
            if (d != null && d.getIsLocal()) continue;
            if (!c.isValid()) {
                logger.log(8, br.getKString("B1313", c.toString()));
                continue;
            }
            if (c instanceof Subscription) continue;
            ConsumerUID uid = c.getConsumerUID();
            if (this.selfAddress == uid.getBrokerAddress()) {
                if (c.getSubscription() != null) {
                    Subscription s = c.getSubscription();
                    attachedSubs.add(c);
                    if (!c.getSubscription().isDurable()) {
                        subscriptions.add(s);
                    } else {
                        subscriptions.add(s);
                    }
                } else {
                    localActiveInterests.add(c);
                }
            }
            if (!c.getIsActiveConsumer() || d == null || d.getMaxActiveConsumers() != 1) continue;
            primaryInterests.add(c);
        }
        if (!attachedSubs.isEmpty()) {
            if (DEBUG) {
                logger.log(8, "forward local subscriptions " + subscriptions.size() + " to " + broker);
            }
            this.sendNewInterestUpdate(broker, subscriptions);
            for (Consumer cons : attachedSubs) {
                Subscription sub = cons.getSubscription();
                if (DEBUG) {
                    logger.log(8, "forward local attached consumer  " + cons + " to " + broker);
                }
                this.sendAttachDurable(broker, sub, cons);
            }
        }
        if (!localActiveInterests.isEmpty()) {
            if (DEBUG) {
                logger.log(8, "forward local activeInterest " + localActiveInterests.size() + " to " + broker);
            }
            this.sendNewInterestUpdate(broker, localActiveInterests);
        }
        if (!primaryInterests.isEmpty()) {
            this.sendInterestUpdate(broker, primaryInterests, 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restartElections(BrokerAddress broker) {
        if (DEBUG || ClusterManagerImpl.isDEBUG_CLUSTER_LOCK()) {
            logger.log(8, "RaptorProtocol.restartElections(" + broker + ")");
        }
        HashMap hashMap = this.resTable;
        synchronized (hashMap) {
            Set entries = this.resTable.keySet();
            for (String resId : entries) {
                Resource res = (Resource)this.resTable.get(resId);
                res.brokerAdded(broker);
            }
        }
    }

    @Override
    public int getClusterAckWaitTimeout() {
        return ProtocolGlobals.getAckTimeout();
    }

    @Override
    public void sendTransactionInquiry(TransactionUID tid, BrokerAddress broker) {
        TransactionBroker tb = new TransactionBroker(broker);
        BrokerAddress to = tb.getCurrentBrokerAddress();
        ClusterTxnInquiryInfo cii = ClusterTxnInquiryInfo.newInstance(tid.longValue(), to, null);
        if (DEBUG_CLUSTER_TXN) {
            logger.log(8, "Sending transaction inquiry: " + cii + " to " + to + "[" + broker + "]");
        }
        try {
            this.c.unicast(to, cii.getGPacket());
        }
        catch (Exception e) {
            logger.log(16, "Sending transaction inquiry " + cii + " to " + to + "[" + broker + "] failed");
        }
    }

    private void sendTransactionInquiries(BrokerAddress broker, UID partitionID) {
        this.sendPreparedTransactionInquiries(null, broker, partitionID);
    }

    @Override
    public void sendPreparedTransactionInquiries(List<TransactionUID> tidsonly, BrokerAddress broker) {
        this.sendPreparedTransactionInquiries(tidsonly, broker, null);
    }

    private void sendPreparedTransactionInquiries(List<TransactionUID> tidsonly, BrokerAddress broker, UID partitionID) {
        Globals.getDestinationList();
        TransactionList[] tls = DestinationList.getTransactionList(null);
        TransactionList tl = null;
        ArrayList tids = null;
        TransactionUID tid2 = null;
        ClusterTxnInquiryInfo cii = null;
        TransactionBroker txnhome = null;
        UID txnhomess = null;
        for (int i = 0; i < tls.length; ++i) {
            tl = tls[i];
            if (tl == null) continue;
            tids = tl.getPreparedRemoteTransactions(null);
            for (TransactionUID tid2 : tids) {
                if (tidsonly != null && !tidsonly.contains(tid2)) continue;
                txnhome = tl.getRemoteTransactionHomeBroker(tid2);
                if (broker == null && txnhome == null) continue;
                txnhomess = null;
                if (txnhome != null) {
                    txnhomess = txnhome.getBrokerAddress().getStoreSessionUID();
                }
                if (partitionID != null && txnhomess != null && !txnhomess.equals((Object)partitionID)) continue;
                cii = ClusterTxnInquiryInfo.newInstance(tid2.longValue(), txnhome == null ? null : txnhome.getCurrentBrokerAddress(), null);
                if (DEBUG_CLUSTER_TXN) {
                    logger.log(8, "Sending transaction inquiry: " + cii + " to " + broker);
                }
                BrokerAddress tobroker = broker == null ? txnhome.getCurrentBrokerAddress() : broker;
                try {
                    this.c.unicast(tobroker, cii.getGPacket());
                }
                catch (Exception e) {
                    logger.log(16, "Sending transaction inquiry " + cii + " to " + tobroker + " failed");
                }
            }
        }
    }

    public void receivedTransactionInquiry(GPacket pkt, BrokerAddress from) {
        BrokerAddress currba;
        ClusterTxnInquiryInfo cii = ClusterTxnInquiryInfo.newInstance(pkt);
        if (DEBUG_CLUSTER_TXN) {
            logger.log(8, "Received transaction inquiry " + cii.toString() + " from " + from);
        }
        TransactionUID tid = new TransactionUID(cii.getTransactionID());
        BrokerAddress txnHomeBroker = cii.getTransactionHome();
        TransactionBroker thb = null;
        if (txnHomeBroker != null) {
            thb = new TransactionBroker(txnHomeBroker);
        }
        Object[] oo = TransactionList.getTransListAndState(tid, null, true, false);
        TransactionState ts = null;
        if (oo != null) {
            ts = (TransactionState)oo[1];
        }
        if (ts == null && DEBUG_CLUSTER_TXN) {
            logger.log(8, "Transaction " + tid + " not found in local transactions");
        }
        if (ts != null) {
            BrokerAddress currba2;
            BrokerAddress brokerAddress = currba2 = thb == null ? null : thb.getCurrentBrokerAddress();
            if (currba2 != null && !currba2.equals(Globals.getMyAddress())) {
                logger.log(8, "Transaction " + tid + " home broker current address " + currba2 + ", old address " + txnHomeBroker + " inquired from " + from);
            }
            this.sendClusterTransactionInfo(tid, from, cii.getXid());
            return;
        }
        if (thb != null && (currba = thb.getCurrentBrokerAddress()) != null && Globals.getMyAddress().equals(currba)) {
            this.sendClusterTransactionInfo(tid, from, cii.getXid());
            return;
        }
        this.sendRemoteTransactionInfo(tid, from, cii.getXid(), false);
    }

    private void sendRemoteTransactionInfo(TransactionUID tid, BrokerAddress to, Long xid, boolean ownerWaitingFor) {
        List<Object[]> list = TransactionList.getTransListsAndRemoteTranStates(tid);
        TransactionList tl = null;
        TransactionState ts = null;
        Object[] oo = null;
        if (list != null) {
            oo = list.get(0);
            tl = (TransactionList)oo[0];
            ts = (TransactionState)oo[1];
        }
        if (ts == null && !ownerWaitingFor) {
            if (DEBUG_CLUSTER_TXN) {
                logger.log(8, "Remote transaction " + tid + " not found");
            }
            return;
        }
        UID tlss = null;
        Globals.getDestinationList();
        boolean partitionmode = DestinationList.isPartitionMode();
        int loop = list == null ? 1 : list.size();
        for (int i = 0; i < loop; ++i) {
            if (list != null) {
                oo = list.get(i);
                tl = (TransactionList)oo[0];
                ts = (TransactionState)oo[1];
            }
            if (ts != null && ts.getState() != 7 && ts.getState() != 6) continue;
            tlss = null;
            if (tl != null && partitionmode) {
                tlss = tl.getPartitionedStore().getPartitionID();
            }
            int s = ts == null ? -1 : ts.getState();
            TransactionBroker txnhome = null;
            if ((s == 7 || s == 6) && tl != null) {
                txnhome = tl.getRemoteTransactionHomeBroker(tid);
            }
            ClusterTxnInfoInfo ii = ClusterTxnInfoInfo.newInstance(tid.longValue(), s, null, null, txnhome == null ? null : txnhome.getBrokerAddress(), false, tlss, this.c, xid);
            if (DEBUG_CLUSTER_TXN) {
                logger.log(8, Globals.getBrokerResources().getKString("B1328", to, ii.toString()));
            }
            try {
                this.c.unicast(to, ii.getGPacket());
                continue;
            }
            catch (Exception e) {
                Object[] args = new String[]{ii.toString(), to.toString(), e.getMessage()};
                logger.log(16, Globals.getBrokerResources().getString("B2222", args));
            }
        }
    }

    @Override
    public void sendClusterTransactionInfo(long tid, BrokerAddress to) {
        this.sendClusterTransactionInfo(new TransactionUID(tid), to, null);
    }

    private void sendClusterTransactionInfo(TransactionUID tid, BrokerAddress to, Long xid) {
        TransactionList tl = null;
        TransactionState ts = null;
        Object[] oo = TransactionList.getTransListAndState(tid, null, true, false);
        if (oo != null) {
            tl = (TransactionList)oo[0];
            ts = (TransactionState)oo[1];
        }
        BrokerAddress[] parties = null;
        BrokerAddress[] waitfor = null;
        TransactionBroker[] brokers = null;
        if (ts != null) {
            try {
                brokers = tl.getClusterTransactionBrokers(tid);
            }
            catch (Exception e) {
                logger.log(16, "Can't retrieve cluster transaction brokers:" + e.getMessage());
            }
            if (brokers == null) {
                logger.log(16, "No cluster transaction brokers information for TID=" + tid);
            } else {
                parties = new BrokerAddress[brokers.length];
                ArrayList<BrokerAddress> waits = new ArrayList<BrokerAddress>();
                for (int i = 0; i < brokers.length; ++i) {
                    parties[i] = brokers[i].getBrokerAddress();
                    if (brokers[i].isCompleted()) continue;
                    waits.add(brokers[i].getBrokerAddress());
                }
                if (waits.size() > 0) {
                    waitfor = waits.toArray(new BrokerAddress[waits.size()]);
                }
            }
        }
        UID tranpid = null;
        if (tl != null) {
            Globals.getDestinationList();
            if (DestinationList.isPartitionMode()) {
                tranpid = tl.getPartitionedStore().getPartitionID();
            }
        }
        ClusterTxnInfoInfo ii = ClusterTxnInfoInfo.newInstance(tid.longValue(), ts == null ? -1 : ts.getState(), parties, waitfor, Globals.getMyAddress(), true, tranpid, this.c, xid);
        if (DEBUG_CLUSTER_TXN) {
            logger.log(8, Globals.getBrokerResources().getKString("B1325", to.toString(), ii.toString()));
        }
        try {
            this.c.unicast(to, ii.getGPacket());
        }
        catch (Exception e) {
            Object[] args = new String[]{ii.toString(), to.toString(), e.getMessage()};
            logger.log(16, Globals.getBrokerResources().getKString("B2223", args));
        }
    }

    /*
     * Unable to fully structure code
     */
    public void receivedTransactionInfo(GPacket pkt, BrokerAddress sender, MessageBusCallback cb) {
        ii = ClusterTxnInfoInfo.newInstance(pkt, this.c);
        from = sender;
        msgss = ii.getMessageStoreSessionUID();
        if (msgss != null) {
            from = (BrokerAddress)sender.clone();
            from.setStoreSessionUID(msgss);
        }
        if (RaptorProtocol.DEBUG_CLUSTER_TXN) {
            RaptorProtocol.logger.log(8, Globals.getBrokerResources().getString("B1326", from.toString(), ii.toString()));
        }
        tid = ii.getTransactionID();
        tuid = new TransactionUID(tid);
        s = ii.getTransactionState();
        tl = null;
        mystate = null;
        oo = TransactionList.getTransListAndState(tuid, null, true, false);
        if (oo != null) {
            tl = (TransactionList)oo[0];
            mystate = (TransactionState)oo[1];
        }
        if ((!ii.isOwner() || ii.isOwner() && from.equals(this.selfAddress)) && mystate != null && mystate.getState() == 6) {
            if (tl.getClusterTransactionBroker(tuid, from) != null) {
                if (s == 6 || !ii.isOwner() && s == -1) {
                    if (RaptorProtocol.DEBUG_CLUSTER_TXN) {
                        RaptorProtocol.logger.log(8, "Update broker " + from + " for committed cluster transaction " + tuid);
                    }
                    try {
                        tl.completeClusterTransactionBrokerState(tuid, 6, from, true);
                        if (ii.isOwner() || s == -1) ** GOTO lbl39
                        this.sendClusterTransactionInfo(tuid, from, null);
                    }
                    catch (Exception e) {
                        RaptorProtocol.logger.logStack(16, "Unable to update transaction broker state for " + from + ", TUID=" + tuid, (Throwable)e);
                        if (ii.isOwner()) ** GOTO lbl39
                        return;
                    }
                }
            } else if (RaptorProtocol.DEBUG_CLUSTER_TXN) {
                RaptorProtocol.logger.log(8, "Broker " + from + " is not a transaction broker for TUID=" + tuid);
            }
lbl39:
            // 7 sources

            if (!ii.isOwner()) {
                return;
            }
        }
        if (s == -1 && !ii.isOwner()) {
            return;
        }
        list = TransactionList.getTransListsAndRemoteTranStates(tuid);
        if (list == null && !ii.isOwner()) {
            return;
        }
        if (list == null && ii.isOwner()) {
            try {
                if (ii.getWaitfor() != null && ii.isWaitedfor(this.selfAddress)) {
                    this.sendRemoteTransactionInfo(tuid, from, null, true);
                    return;
                }
            }
            catch (Exception e) {
                RaptorProtocol.logger.logStack(16, e.getMessage(), (Throwable)e);
                return;
            }
            if (s != -1) {
                return;
            }
        }
        type = -1;
        switch (s) {
            case 2: 
            case 7: {
                type = 10;
                break;
            }
            case -1: {
                RaptorProtocol.logger.log(8, Globals.getBrokerResources().getKString("B1311", tuid, from));
                type = 10;
                break;
            }
            case 6: {
                type = 3;
                break;
            }
            default: {
                return;
            }
        }
        try {
            cb.processRemoteAck2P(null, null, type, null, tid, from);
            if (s == 6 && ii.isOwner()) {
                brokers = ii.getBrokers();
                waitfor = ii.getWaitfor();
                if (brokers == null && waitfor == null) {
                    return;
                }
                if (waitfor != null) {
                    this.sendRemoteTransactionInfo(tuid, from, null, true);
                }
            }
        }
        catch (Exception e) {
            if (RaptorProtocol.DEBUG_CLUSTER_TXN) {
                RaptorProtocol.logger.logStack(16, e.getMessage(), (Throwable)e);
            }
            RaptorProtocol.logger.log(16, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeBrokerInfo(BrokerAddress broker, boolean broken) {
        Object waiter;
        BrokerInfoEx brokerInfoEx;
        block31: {
            if (DEBUG) {
                logger.log(4, "RaptorProtocol.removeBrokerInfo. broker : " + broker);
            }
            brokerInfoEx = null;
            brokerInfoEx = (BrokerInfoEx)this.brokerList.remove(broker);
            if (DEBUG) {
                logger.log(4, "Broker down " + broker);
            }
            try {
                if (!this.c.getConfigServer().equals(broker)) break block31;
                Long xid = null;
                waiter = null;
                Set s = this.eventLogWaiters.keySet();
                Object object = this.eventLogWaiters;
                synchronized (object) {
                    Iterator itr = s.iterator();
                    while (itr.hasNext()) {
                        xid = (Long)itr.next();
                        waiter = (EventLogWaiter)this.eventLogWaiters.get(xid);
                        itr.remove();
                        EventLogWaiter eventLogWaiter = waiter;
                        synchronized (eventLogWaiter) {
                            if (((EventLogWaiter)waiter).getStatus() == 0) {
                                ((EventLogWaiter)waiter).setStatus(2);
                            }
                            waiter.notifyAll();
                        }
                    }
                }
                object = this.cfgSrvWaitObject;
                synchronized (object) {
                    if (this.cfgSrvRequestCount > 0) {
                        this.cfgSrvRequestCount = 0;
                        this.cfgSrvRequestErr = true;
                        this.cfgSrvWaitObject.notifyAll();
                    }
                }
            }
            catch (Exception xid) {
                // empty catch block
            }
        }
        logger.log(64, "B1072", (Object)broker.toString());
        this.cbDispatcher.brokerDown(broker);
        boolean goodbyed = false;
        if (brokerInfoEx != null) {
            goodbyed = brokerInfoEx.goodbyeDone();
        }
        this.ackackTracker.removeBroker(broker, goodbyed, this.shutdown);
        this.takeoverPendingReplyTracker.removeBroker(broker, goodbyed, this.shutdown);
        this.newMasterBrokerReplyTracker.removeBroker(broker, goodbyed, this.shutdown);
        this.takeoverMEReplyTracker.removeBroker(broker, goodbyed, this.shutdown);
        this.broadcastAnyOKReplyTracker.removeBroker(broker, goodbyed, this.shutdown);
        waiter = this.resTable;
        synchronized (waiter) {
            Set entries = this.resTable.keySet();
            for (String resId : entries) {
                Resource res = (Resource)this.resTable.get(resId);
                res.brokerRemoved(broker);
            }
        }
        if (brokerInfoEx == null) {
            return;
        }
        BrokerInfo brokerInfo = brokerInfoEx.getBrokerInfo();
        try {
            if (brokerInfoEx.getBrokerInfo().getBrokerAddr().getHAEnabled()) {
                Globals.getClusterManager().deactivateBroker(brokerInfo.getBrokerAddr().getBrokerID(), (Object)brokerInfo.getBrokerAddr().getBrokerSessionUID());
            } else {
                Globals.getClusterManager().deactivateBroker(brokerInfo.getBrokerAddr().getMQAddress(), (Object)brokerInfo.getBrokerAddr().getBrokerSessionUID());
            }
            logger.log(8, br.getKString("B1180", brokerInfo));
            if (Globals.getSFSHAEnabled()) {
                ClusterManager cm = Globals.getClusterManager();
                HAClusteredBroker cb = (HAClusteredBroker)cm.getBroker(brokerInfo.getBrokerAddr().getBrokerID());
                ClusterGoodbyeInfo cgi = brokerInfoEx.getGoodbyeInfo();
                if (!goodbyed || cgi != null && cgi.getRequestTakeover()) {
                    cb.setBrokerInDoubt(true, brokerInfo.getBrokerAddr().getBrokerSessionUID());
                } else {
                    ((HeartbeatService)Globals.getHeartbeatService()).removeHeartbeatEndpoint(cb, brokerInfo.getBrokerAddr().getBrokerSessionUID());
                }
            }
        }
        catch (NoSuchElementException e) {
            if (DEBUG) {
                logger.logStack(8, "Unable to deactivate " + brokerInfo, (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.logStack(16, br.getKString("B2116", brokerInfo, e.getMessage()), (Throwable)e);
        }
        brokerInfoEx.deactivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configServerBackup(String fileName) {
        if (DEBUG) {
            logger.log(8, "ConfigServerBackup. fileName : " + fileName);
        }
        BrokerAddress configServer = null;
        try {
            configServer = this.c.getConfigServer();
        }
        catch (Exception e) {
            logger.log(16, "B2054");
            return;
        }
        if (configServer == null || !configServer.equals(this.selfAddress)) {
            logger.log(16, "B2054");
            return;
        }
        try {
            this.masterBrokerBlockWait(ProtocolGlobals.getWaitReplyTimeout(), "[BACKUP]");
            try {
                List<ChangeRecordInfo> records = this.store.getAllConfigRecords();
                ChangeRecord.backupRecords(records, fileName, false);
            }
            finally {
                this.masterBrokerUnBlock();
            }
        }
        catch (Exception e) {
            logger.logStack(16, "B2056", (Throwable)e);
        }
        if (DEBUG) {
            logger.log(8, "ConfigServerBackup complete.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configServerRestore(String fileName) {
        if (DEBUG) {
            logger.log(8, "RaptorProtocol.configServerRestore. fileName = " + fileName);
        }
        try {
            File f = new File(fileName);
            if (!f.exists()) {
                logger.log(16, "B2057", (Object)fileName);
                return;
            }
            this.masterBrokerBlockWait(ProtocolGlobals.getWaitReplyTimeout(), "[RESTORE]");
            try {
                List<ChangeRecordInfo> records = ChangeRecord.prepareRestoreRecords(fileName);
                this.store.clearAllConfigChangeRecords(false);
                Iterator<ChangeRecordInfo> itr = records.iterator();
                ChangeRecordInfo cri = null;
                long startime = System.currentTimeMillis();
                while (itr.hasNext()) {
                    long l;
                    cri = itr.next();
                    if (Globals.isBDBStore()) {
                        long l2 = startime;
                        l = l2;
                        startime = l2 + 1L;
                    } else {
                        l = System.currentTimeMillis();
                    }
                    this.store.storeConfigChangeRecord(l, cri.getRecord(), false);
                }
                logger.log(8, "B1347", (Object)fileName);
            }
            finally {
                this.masterBrokerUnBlock();
            }
        }
        catch (Exception e) {
            logger.logStack(16, "B2060", (Throwable)e);
            return;
        }
        if (DEBUG) {
            logger.log(8, "RaptorProtocol.configServerRestore complete.");
        }
    }

    private void storeLastConfigServer(BrokerAddress baddr) throws BrokerException {
        this.store.updateProperty("MessageBus.lastConfigServer", baddr, false);
    }

    private BrokerAddress getLastConfigServer() {
        BrokerAddress baddr = null;
        try {
            baddr = (BrokerAddress)this.store.getProperty("MessageBus.lastConfigServer");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return baddr;
    }

    private void storeLastRefreshTime(long timestamp) throws BrokerException {
        Long t = timestamp;
        this.store.updateProperty("MessageBus.lastRefreshTime", t, false);
    }

    private long getLastRefreshTime() {
        Long t = null;
        try {
            t = (Long)this.store.getProperty("MessageBus.lastRefreshTime");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (t == null) {
            return -1L;
        }
        return t;
    }

    public boolean getConfigSyncComplete() {
        return this.configSyncComplete;
    }

    private static byte[] getEventData(GPacket event) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            event.write((OutputStream)bos);
            bos.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bos.toByteArray();
    }

    public static byte[] generateAddDurableRecord(Subscription sub) {
        try {
            ClusterSubscriptionInfo csi = ClusterSubscriptionInfo.newInstance(sub);
            return RaptorProtocol.getEventData(csi.getGPacket((short)5, true));
        }
        catch (Exception e) {
            Globals.getLogger().logStack(8, "Internal Error: generateAddDurableRecord failed.", (Throwable)e);
            return null;
        }
    }

    public static byte[] generateRemDurableRecord(Subscription sub) {
        try {
            ClusterSubscriptionInfo csi = ClusterSubscriptionInfo.newInstance(sub);
            return RaptorProtocol.getEventData(csi.getGPacket((short)7, true));
        }
        catch (Exception e) {
            Globals.getLogger().logStack(16, "generateRemDurableRecord failed.", (Throwable)e);
            return null;
        }
    }

    public static byte[] generateAddDestinationRecord(Destination d) {
        try {
            ClusterDestInfo cdi = ClusterDestInfo.newInstance(d);
            GPacket gp = cdi.getGPacket((short)13, true);
            return RaptorProtocol.getEventData(gp);
        }
        catch (Exception e) {
            Globals.getLogger().logStack(16, "generateRemDestinationRecord failed.", (Throwable)e);
            return null;
        }
    }

    public static byte[] generateRemDestinationRecord(Destination d) {
        try {
            ClusterDestInfo cdi = ClusterDestInfo.newInstance(d);
            GPacket gp = cdi.getGPacket((short)15, true);
            return RaptorProtocol.getEventData(gp);
        }
        catch (Exception e) {
            Globals.getLogger().logStack(8, "generateRemDestinationRecord failed.", (Throwable)e);
            return null;
        }
    }

    private static class EventLogWaiter {
        private int status = 2;

        public EventLogWaiter(int s) {
            this.status = s;
        }

        public synchronized int getStatus() {
            return this.status;
        }

        public synchronized void setStatus(int s) {
            this.status = s;
        }

        public synchronized void setReason(String r) {
        }
    }

    private static class BrokerInfoEx {
        private int GOODBYE_SENT = 1;
        private int GOODBYE_RECEIVED = 2;
        private int GOODBYE_REPLY_SENT = 4;
        private int GOODBYE_REPLY_RECEIVED = 8;
        private int finStatus = 0;
        private BrokerInfo info = null;
        private ClusterGoodbyeInfo cgi = null;
        private boolean deactivated = false;

        public BrokerInfoEx(BrokerInfo info) {
            this.info = info;
        }

        public synchronized boolean deactivated() {
            return this.deactivated;
        }

        public synchronized void deactivate() {
            this.deactivated = true;
            this.notifyAll();
        }

        public synchronized void setGoodbyeInfo(ClusterGoodbyeInfo cgi) {
            this.cgi = cgi;
        }

        public synchronized ClusterGoodbyeInfo getGoodbyeInfo() {
            return this.cgi;
        }

        public BrokerInfo getBrokerInfo() {
            return this.info;
        }

        public synchronized boolean goodbyeDone() {
            return this.sentGoodbyeReply() && this.gotGoodbyeReply();
        }

        public synchronized void goodbyeSent() {
            this.finStatus |= this.GOODBYE_SENT;
        }

        public synchronized void goodbyeReceived() {
            this.finStatus |= this.GOODBYE_RECEIVED;
        }

        public synchronized void goodbyeReplySent() {
            this.finStatus |= this.GOODBYE_REPLY_SENT;
        }

        public synchronized void goodbyeReplyReceived() {
            this.finStatus |= this.GOODBYE_REPLY_RECEIVED;
        }

        public synchronized boolean gotGoodbye() {
            return this.cgi != null && (this.finStatus & this.GOODBYE_RECEIVED) == this.GOODBYE_RECEIVED;
        }

        public synchronized boolean sentGoodbye() {
            return (this.finStatus & this.GOODBYE_SENT) == this.GOODBYE_SENT;
        }

        public synchronized boolean gotGoodbyeReply() {
            return (this.finStatus & this.GOODBYE_REPLY_RECEIVED) == this.GOODBYE_REPLY_RECEIVED;
        }

        public synchronized boolean sentGoodbyeReply() {
            return (this.finStatus & this.GOODBYE_REPLY_SENT) == this.GOODBYE_REPLY_SENT;
        }
    }
}

