/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.io.FilteringObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;

public class GetMessagesHandler
extends AdminCmdHandler {
    private static boolean DEBUG = GetMessagesHandler.getDEBUG();

    public GetMessagesHandler(AdminDataHandler parent) {
        super(parent);
    }

    @Override
    public boolean handle(IMQConnection con, Packet cmd_msg, Hashtable cmd_props) {
        Object errMsg;
        int status;
        Vector<HashMap> v;
        block16: {
            if (DEBUG) {
                this.logger.log(4, this.getClass().getName() + ": Getting messages: " + cmd_props);
            }
            v = new Vector<HashMap>();
            status = 200;
            errMsg = null;
            String destination = (String)cmd_props.get("JMQDestination");
            Integer destType = (Integer)cmd_props.get("JMQDestType");
            Long startIndex = (Long)cmd_props.get("JMQStartMessageIndex");
            Long maxNumMsgs = (Long)cmd_props.get("JMQMaxNumMsgsRetrieved");
            Boolean getBody = (Boolean)cmd_props.get("JMQGetMessageBody");
            String msgID = (String)cmd_props.get("JMQMessageID");
            HashMap destNameType = new HashMap();
            if (destination == null || destType == null) {
                errMsg = "Destination name and type not specified";
                this.logger.log(32, (String)errMsg);
                status = 500;
            }
            if (getBody == null) {
                getBody = Boolean.FALSE;
            }
            if (destination != null) {
                try {
                    Destination[] ds = DestinationList.getDestination(null, destination, DestType.isQueue((int)destType));
                    Destination d = ds[0];
                    if (d != null) {
                        if (DEBUG) {
                            d.debug();
                        }
                        if (msgID != null) {
                            d.load();
                            SysMessageID sysMsgID = SysMessageID.get((String)msgID);
                            PacketReference pr = GetMessagesHandler.getPacketReference(sysMsgID);
                            if (pr != null) {
                                HashMap h = this.constructMessageInfo(sysMsgID, getBody, destNameType);
                                if (h == null) {
                                    pr = null;
                                } else {
                                    v.add(h);
                                }
                            }
                            if (pr == null) {
                                errMsg = "Could not locate message " + msgID + " in destination " + destination;
                                status = 404;
                            }
                        } else {
                            SysMessageID[] sysMsgIDs = d.getSysMessageIDs(startIndex, maxNumMsgs);
                            for (int i = 0; i < sysMsgIDs.length; ++i) {
                                HashMap h = this.constructMessageInfo(sysMsgIDs[i], getBody, destNameType);
                                if (h == null) continue;
                                v.add(h);
                            }
                        }
                    } else {
                        errMsg = this.rb.getString("B4017", destination);
                        status = 404;
                    }
                }
                catch (Exception ex) {
                    this.logger.logStack(32, ex.getMessage(), (Throwable)ex);
                    ex.printStackTrace();
                    status = 500;
                    if ($assertionsDisabled) break block16;
                    throw new AssertionError();
                }
            }
        }
        Packet reply = new Packet(con.useDirectBuffers());
        reply.setPacketType(5);
        GetMessagesHandler.setProperties(reply, 87, status, (String)errMsg);
        this.setBodyObject(reply, v);
        this.parent.sendReply(con, cmd_msg, reply);
        return true;
    }

    public HashMap constructMessageInfo(SysMessageID sysMsgID, boolean getBody, HashMap destNameType) {
        ByteBuffer bb;
        Hashtable msgProps;
        Object errMsg;
        HashMap<String, Object> h = new HashMap<String, Object>();
        PacketReference pr = GetMessagesHandler.getPacketReference(sysMsgID);
        if (pr == null) {
            return null;
        }
        Packet pkt = pr.getPacket();
        if (pkt == null) {
            return null;
        }
        HashMap msgHeaders = pr.getHeaders();
        String corrID = pkt.getCorrelationID();
        int typeMask = 1;
        byte[] b = null;
        h.put("CorrelationID", corrID);
        if (corrID != null) {
            try {
                b = corrID.getBytes("UTF8");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        h.put("CorrelationIDAsBytes", b);
        h.put("DeliveryMode", pkt.getPersistent() ? Integer.valueOf(2) : Integer.valueOf(1));
        h.put("DestinationName", pkt.getDestination());
        typeMask = pkt.getIsQueue() ? 1 : 2;
        h.put("DestinationType", typeMask);
        h.put("Expiration", pkt.getExpiration());
        h.put("MessageID", msgHeaders.get("JMSMessageID"));
        h.put("Priority", pkt.getPriority());
        h.put("Redelivered", pkt.getRedelivered());
        String replyToDestName = pkt.getReplyTo();
        if (replyToDestName != null) {
            Boolean isQ;
            boolean destFound = false;
            boolean isQueue = true;
            if (destNameType != null && (isQ = (Boolean)destNameType.get(replyToDestName)) != null) {
                isQueue = isQ;
                destFound = true;
            }
            if (!destFound) {
                try {
                    Destination[] ds = DestinationList.findDestination(null, replyToDestName, true);
                    Destination queue = ds[0];
                    ds = DestinationList.findDestination(null, replyToDestName, false);
                    Destination topic = ds[0];
                    if (queue != null && topic != null) {
                        errMsg = "Cannot determine type of ReplyTo destination. There is a topic and queue with the name: " + replyToDestName;
                        this.logger.log(16, (String)errMsg);
                    } else if (queue != null) {
                        destFound = true;
                        isQueue = true;
                    } else if (topic != null) {
                        destFound = true;
                        isQueue = false;
                    }
                    if (destFound) {
                        destNameType.put(replyToDestName, isQueue);
                    }
                }
                catch (Exception e) {
                    errMsg = "Caught exception while determining ReplyTo destination type";
                    this.logger.log(16, (String)errMsg, (Throwable)e);
                }
            }
            h.put("ReplyToDestinationName", replyToDestName);
            if (destFound) {
                typeMask = isQueue ? 1 : 2;
                h.put("ReplyToDestinationType", typeMask);
            }
        }
        h.put("Timestamp", pkt.getTimestamp());
        h.put("Type", pkt.getMessageType());
        try {
            msgProps = pr.getProperties();
        }
        catch (Exception e) {
            msgProps = null;
        }
        h.put("MessageProperties", msgProps);
        int packetType = pr.getPacket().getPacketType();
        h.put("MessageBodyType", packetType);
        byte[] msgBody = null;
        if (getBody && (bb = pr.getPacket().getMessageBodyByteBuffer()) != null && bb.hasArray()) {
            msgBody = bb.array();
        }
        if (msgBody != null) {
            switch (packetType) {
                case 1: {
                    try {
                        String textMsg = new String(msgBody, "UTF8");
                        h.put("MessageBody", textMsg);
                    }
                    catch (Exception e) {
                        errMsg = "Caught exception while creating text message body";
                        this.logger.log(32, (String)errMsg, (Throwable)e);
                    }
                    break;
                }
                case 2: 
                case 4: {
                    h.put("MessageBody", msgBody);
                    break;
                }
                case 3: {
                    FilteringObjectInputStream objectInputStream;
                    ByteArrayInputStream byteArrayInputStream;
                    try {
                        byteArrayInputStream = new ByteArrayInputStream(msgBody);
                        objectInputStream = new FilteringObjectInputStream((InputStream)byteArrayInputStream);
                        HashMap mapMsg = (HashMap)objectInputStream.readObject();
                        h.put("MessageBody", mapMsg);
                    }
                    catch (Exception e) {
                        errMsg = "Caught exception while creating map message body";
                        this.logger.log(32, (String)errMsg, (Throwable)e);
                    }
                    break;
                }
                case 5: {
                    FilteringObjectInputStream objectInputStream;
                    ByteArrayInputStream byteArrayInputStream;
                    try {
                        byteArrayInputStream = new ByteArrayInputStream(msgBody);
                        objectInputStream = new FilteringObjectInputStream((InputStream)byteArrayInputStream);
                        Object objMsg = objectInputStream.readObject();
                        h.put("MessageBody", objMsg);
                    }
                    catch (Exception e) {
                        errMsg = "Caught exception while creating object message body";
                        this.logger.log(32, (String)errMsg, (Throwable)e);
                    }
                    break;
                }
                default: {
                    errMsg = "Unsupported message type for GET_MESSAGES handler: " + packetType;
                    this.logger.log(32, (String)errMsg);
                }
            }
        }
        return h;
    }

    public static PacketReference getPacketReference(SysMessageID sysMsgID) {
        Globals.getDestinationList();
        return DestinationList.get(null, sysMsgID);
    }
}

