/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.cluster.router;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterBroadcast;
import com.sun.messaging.jmq.jmsserver.cluster.router.BrokerConsumers;
import com.sun.messaging.jmq.jmsserver.cluster.router.ClusterRouter;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.multibroker.Protocol;
import com.sun.messaging.jmq.jmsserver.persist.api.PartitionedStore;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MultibrokerRouter
implements ClusterRouter {
    private static boolean DEBUG = false;
    private static boolean DEBUG_CLUSTER_TXN = Globals.getConfig().getBooleanProperty("imq.cluster.debug.txn");
    private static boolean DEBUG_CLUSTER_MSG = Globals.getConfig().getBooleanProperty("imq.cluster.debug.msg");
    private static Logger logger = Globals.getLogger();
    private static final String ENFORCE_REMOTE_DEST_LIMIT_PROP = "imq.cluster.enforceRemoteDestinationLimit";
    private static boolean ENFORCE_REMOTE_DEST_LIMIT = Globals.getConfig().getBooleanProperty("imq.cluster.enforceRemoteDestinationLimit", false);
    private ArrayList loggedFullDestsOnHandleJMSMsg = new ArrayList();
    ClusterBroadcast cb = null;
    Protocol p = null;
    BrokerConsumers bc = null;
    DestinationList DL = Globals.getDestinationList();

    protected static boolean getDEBUG() {
        return DEBUG || DEBUG_CLUSTER_TXN || DEBUG_CLUSTER_MSG;
    }

    public MultibrokerRouter(ClusterBroadcast cb) {
        this.cb = cb;
        this.p = (Protocol)cb.getProtocol();
        this.bc = new BrokerConsumers(this.p);
    }

    public static String msgToString(int id) {
        switch (id) {
            case 0: {
                return "MSG_DELIVERED";
            }
            case 1: {
                return "MSG_ACKNOWLEDGED";
            }
            case 8: {
                return "MSG_PREPARE";
            }
            case 9: {
                return "MSG_ROLLEDBACK";
            }
            case 5: {
                return "MSG_IGNORED";
            }
            case 6: {
                return "MSG_UNDELIVERABLE";
            }
            case 7: {
                return "MSG_DEAD";
            }
        }
        return "UNKNOWN";
    }

    @Override
    public void addConsumer(Consumer c) throws BrokerException, IOException, SelectorFormatException {
        this.bc.addConsumer(c);
    }

    @Override
    public void removeConsumer(ConsumerUID c, Map<TransactionUID, LinkedHashMap<SysMessageID, Integer>> pendingMsgs, boolean cleanup) throws BrokerException, IOException {
        this.bc.removeConsumer(c, pendingMsgs, cleanup);
    }

    @Override
    public void removeConsumers(ConnectionUID uid) throws BrokerException, IOException {
        this.bc.removeConsumers(uid);
    }

    @Override
    public void brokerDown(BrokerAddress ba) throws BrokerException, IOException {
        this.bc.brokerDown(ba);
    }

    @Override
    public void forwardMessage(PacketReference ref, Collection consumers) {
        this.bc.forwardMessageToRemote(ref, consumers);
    }

    @Override
    public void shutdown() {
        this.bc.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleJMSMsg(Packet p, Map<ConsumerUID, Integer> consumers, BrokerAddress sender, boolean sendMsgDeliveredAck) throws BrokerException {
        ArrayList<DestinationUID> dsts;
        PacketReference ref;
        PartitionedStore pstore;
        ArrayList<Serializable> ignoreVector;
        ArrayList<Consumer> targetVector;
        block52: {
            BrokerAddress addr;
            Map<ConsumerUID, Integer> deliveryCnts = consumers;
            boolean hasflowcontrol = true;
            targetVector = new ArrayList<Consumer>();
            ignoreVector = new ArrayList<Serializable>();
            pstore = Globals.getStore().getPrimaryPartition();
            Iterator<Map.Entry<ConsumerUID, Integer>> itr = consumers.entrySet().iterator();
            Map.Entry<ConsumerUID, Integer> entry = null;
            while (itr.hasNext()) {
                entry = itr.next();
                ConsumerUID uid = entry.getKey();
                Consumer interest = Consumer.getConsumer(uid);
                if (interest != null && interest.isValid()) {
                    targetVector.add(interest);
                    ConsumerUID suid = interest.getStoredConsumerUID();
                    if (suid != null && !suid.equals(uid) || interest.getSubscription() != null) continue;
                    hasflowcontrol = false;
                    continue;
                }
                ignoreVector.add(uid);
            }
            if (targetVector.isEmpty()) {
                this.sendIgnoreAck(p.getSysMessageID(), null, sender, ignoreVector);
                return;
            }
            boolean exists = false;
            ref = DestinationList.get(null, p.getSysMessageID());
            if (!(ref == null || (addr = ref.getBrokerAddress()) != null && addr.equals(sender))) {
                if (DEBUG) {
                    logger.log(8, "Remote message " + ref.getSysMessageID() + " home broker " + addr + " changed to " + sender);
                }
                DestinationList.remoteCheckMessageHomeChange(ref, sender);
                if (addr == null) {
                    Object[] args = new Object[]{ref.getSysMessageID(), sender, targetVector};
                    logger.log(16, Globals.getBrokerResources().getKString("B2275", args));
                    ignoreVector.addAll(targetVector);
                    targetVector.clear();
                    this.sendIgnoreAck(p.getSysMessageID(), ref, sender, ignoreVector);
                    return;
                }
            }
            dsts = null;
            ref = DestinationList.get(null, p.getSysMessageID());
            boolean acquiredWriteLock = false;
            try {
                if (ref != null) {
                    ref.acquireDestroyRemoteWriteLock();
                    acquiredWriteLock = true;
                    if (ref.isInvalid() || ref.isDestroyed()) {
                        ref.clearDestroyRemoteWriteLock();
                        acquiredWriteLock = false;
                        ref = DestinationList.get(null, p.getSysMessageID());
                        if (ref != null) {
                            ref.acquireDestroyRemoteWriteLock();
                            acquiredWriteLock = true;
                        }
                    }
                }
                if (ref != null) {
                    if (ref.getBrokerAddress() == null) {
                        ref.clearDestroyRemoteWriteLock();
                        acquiredWriteLock = false;
                        Object[] args = new Object[]{ref.getSysMessageID(), sender, targetVector};
                        logger.log(16, Globals.getBrokerResources().getKString("B2275", args));
                        ignoreVector.addAll(targetVector);
                        targetVector.clear();
                        this.sendIgnoreAck(p.getSysMessageID(), ref, sender, ignoreVector);
                        return;
                    }
                    exists = true;
                    ref.setBrokerAddress(sender);
                    if (p.getRedelivered()) {
                        ref.overrideRedeliver();
                    }
                } else {
                    ref = PacketReference.createReference(pstore, p, null);
                    ref.setBrokerAddress(sender);
                }
                if (sendMsgDeliveredAck) {
                    for (int i = 0; i < targetVector.size(); ++i) {
                        Consumer c = (Consumer)targetVector.get(i);
                        ref.addMessageDeliveredAck(c.getConsumerUID());
                    }
                }
                try {
                    if (ref.getDestinationUID().isWildcard()) {
                        List[] dss = DestinationList.findMatchingIDs(pstore, ref.getDestinationUID());
                        dsts = dss[0];
                    } else {
                        Destination[] ds = DestinationList.getDestination(pstore, ref.getDestinationUID().getName(), ref.getDestinationUID().isQueue() ? 1 : 2, true, true);
                        Destination d = ds[0];
                        if (d != null) {
                            dsts = new ArrayList<DestinationUID>();
                            dsts.add(d.getDestinationUID());
                        }
                    }
                    if (dsts == null || dsts.isEmpty()) {
                        ignoreVector.addAll(targetVector);
                        targetVector.clear();
                        break block52;
                    }
                    if (!exists && !targetVector.isEmpty()) {
                        ref.setNeverStore(true);
                        ref.storeRemoteInterests(targetVector, deliveryCnts);
                        for (DestinationUID did : dsts) {
                            Destination[] ds = DestinationList.getDestination(pstore, did);
                            Destination d = ds[0];
                            if (DEBUG) {
                                logger.log(8, "Route remote message " + ref + " sent from " + sender + " to destination(s) " + did + " for consumer(s) " + targetVector + " hasflowcontrol=" + hasflowcontrol + ", enforcelimit=" + ENFORCE_REMOTE_DEST_LIMIT);
                            }
                            d.acquireQueueRemoteLock();
                            try {
                                PacketReference newref = d.getMessage(p.getSysMessageID());
                                if (newref != null) {
                                    ignoreVector.addAll(targetVector);
                                    targetVector.clear();
                                    Object[] args = new Object[]{p.getSysMessageID(), "" + d.getDestinationUID(), sender, newref + "[" + newref.getBrokerAddress() + "]"};
                                    logger.log(8, Globals.getBrokerResources().getKString("B1470", args));
                                    break block52;
                                }
                                d.queueMessage(ref, false, ENFORCE_REMOTE_DEST_LIMIT);
                            }
                            finally {
                                d.clearQueueRemoteLock();
                            }
                        }
                        break block52;
                    }
                    if (exists) {
                        ref.addRemoteInterests(targetVector);
                    }
                }
                catch (Exception ex) {
                    Object[] args = new Object[]{"" + ref, sender, targetVector};
                    String emsg = Globals.getBrokerResources().getKString("B2256", args);
                    if (!(ex instanceof BrokerException)) {
                        logger.logStack(16, emsg, (Throwable)ex);
                        break block52;
                    }
                    BrokerException be = (BrokerException)ex;
                    int status = be.getStatusCode();
                    if (status != 414 && status != 423) {
                        logger.logStack(16, emsg, (Throwable)ex);
                        break block52;
                    }
                    Object[] args1 = new Object[]{sender, targetVector};
                    emsg = Globals.getBrokerResources().getKString("B2257", args1);
                    int level = 4;
                    if (ref == null || !this.loggedFullDestsOnHandleJMSMsg.contains(ref.getDestinationUID())) {
                        level = 16;
                        this.loggedFullDestsOnHandleJMSMsg.add(ref.getDestinationUID());
                    }
                    logger.log(level, emsg + (String)(level == 4 ? ": " + ex.getMessage() : ""));
                }
            }
            finally {
                if (ref != null && acquiredWriteLock) {
                    ref.clearDestroyRemoteWriteLock();
                }
            }
        }
        StringBuilder debugString = new StringBuilder();
        debugString.append('\n');
        for (int i = 0; i < targetVector.size(); ++i) {
            Consumer interest;
            block53: {
                interest = targetVector.get(i);
                if (!interest.routeMessage(ref, false)) {
                    try {
                        if (!ref.acknowledged(interest.getConsumerUID(), interest.getStoredConsumerUID(), true, false)) break block53;
                        try {
                            if (dsts == null) continue;
                            for (DestinationUID did : dsts) {
                                Destination[] ds = DestinationList.getDestination(pstore, did);
                                Destination d = ds[0];
                                d.removeRemoteMessage(ref.getSysMessageID(), RemoveReason.ACKNOWLEDGED, ref);
                            }
                        }
                        finally {
                            ref.postAcknowledgedRemoval();
                        }
                    }
                    catch (Exception ex) {
                        logger.log(8, "Internal error processing ack", (Throwable)ex);
                    }
                    finally {
                        ref.removeRemoteConsumerUID(interest.getStoredConsumerUID(), interest.getConsumerUID());
                    }
                }
            }
            if (!DEBUG) continue;
            debugString.append("\t" + interest.getConsumerUID() + "\n");
        }
        if (DEBUG) {
            logger.log(1, "MessageBus: Delivering message to : {0}", (Object)debugString.toString());
        }
        this.sendIgnoreAck(p.getSysMessageID(), ref, sender, ignoreVector);
    }

    private void sendIgnoreAck(SysMessageID sysid, PacketReference ref, BrokerAddress sender, List ignoredConsumers) {
        List ignoreVector = ignoredConsumers;
        StringBuilder debugString = new StringBuilder();
        debugString.append('\n');
        Object o = null;
        ConsumerUID cuid = null;
        for (int i = 0; i < ignoreVector.size(); ++i) {
            try {
                o = ignoreVector.get(i);
                cuid = o instanceof Consumer ? ((Consumer)o).getConsumerUID() : (ConsumerUID)o;
                this.cb.acknowledgeMessage(sender, ref == null ? sysid : ref.getSysMessageID(), cuid, 5, null, false);
            }
            catch (Exception e) {
                logger.logStack(16, "sendMessageAck IGNORE failed to " + sender, (Throwable)e);
            }
            if (!DEBUG) continue;
            debugString.append("\t" + ignoreVector.get(i) + "\n");
        }
        if (DEBUG && ignoreVector.size() > 0) {
            logger.log(1, "MessageBus: Invalid targets : {0}", (Object)debugString.toString());
        }
    }

    @Override
    public void handleAck(int type, SysMessageID sysid, ConsumerUID cuid, Map optionalProps) throws BrokerException {
        this.bc.acknowledgeMessageFromRemote(type, sysid, cuid, optionalProps);
    }

    @Override
    public void handleAck2P(int type, SysMessageID[] sysids, ConsumerUID[] cuids, Map optionalProps, Long txnID, BrokerAddress txnHomeBroker) throws BrokerException {
        this.bc.acknowledgeMessageFromRemote2P(type, sysids, cuids, optionalProps, txnID, txnHomeBroker);
    }

    @Override
    public void handleCtrlMsg(int type, HashMap props) throws BrokerException {
    }

    @Override
    public Hashtable getDebugState() {
        return this.bc.getDebugState();
    }
}

