/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.BaseTransaction;
import com.sun.messaging.jmq.jmsserver.data.RemoteTransaction;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.BaseTransactionManager;
import com.sun.messaging.jmq.jmsserver.persist.file.RemoteTransaction2PCompleteEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.RemoteTransaction2PPrepareEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.RemoteTransactionEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.TransactionEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.TransactionLogManager;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;
import java.util.HashSet;

public class RemoteTransactionManager
extends BaseTransactionManager {
    RemoteTransactionManager(TransactionLogManager transactionLogManager) {
        super(transactionLogManager);
    }

    @Override
    void processStoredTxnOnStartup(BaseTransaction baseTxn) {
        int state;
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " processStoredTxnOnStartup " + baseTxn;
            logger.log(4, msg);
        }
        if ((state = baseTxn.getState()) == 6 || state == 7) {
            this.addToCompleteStored(baseTxn);
        } else if (state == 5) {
            this.addToIncompleteStored(baseTxn);
        }
    }

    @Override
    TransactionEvent generateEvent(BaseTransaction baseTxn, boolean completion) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            Globals.getLogger().log(4, this.getPrefix() + " generateEvent ");
        }
        RemoteTransactionEvent result = null;
        if (completion) {
            result = new RemoteTransaction2PCompleteEvent();
        } else if (baseTxn.getState() == 5) {
            result = new RemoteTransaction2PPrepareEvent();
        } else {
            throw new UnsupportedOperationException();
        }
        result.remoteTransaction = (RemoteTransaction)baseTxn;
        return result;
    }

    @Override
    void processTxn(BaseTransaction baseTxn) throws IOException, BrokerException {
        int state;
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " processTxn " + baseTxn;
            logger.log(4, msg);
        }
        if ((state = baseTxn.getState()) != 5) {
            throw new UnsupportedOperationException();
        }
        this.addToIncompleteUnstored(baseTxn);
    }

    @Override
    BaseTransaction processTxnCompletion(TransactionUID tid, int state) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            Globals.getLogger().log(4, this.getPrefix() + " processTxnCompletion " + tid);
        }
        boolean removeFromStore = true;
        return this.processTxnCompletion(tid, state, removeFromStore);
    }

    @Override
    void replayTransactionEvent(TransactionEvent txnEvent, HashSet dstLoadedSet) throws BrokerException, IOException {
        if (Store.getDEBUG()) {
            Globals.getLogger().log(4, this.getPrefix() + " replayTransactionEvent");
        }
        RemoteTransactionEvent remoteTxnEvent = (RemoteTransactionEvent)txnEvent;
        RemoteTransaction remoteTxn = remoteTxnEvent.remoteTransaction;
        int state = remoteTxn.getState();
        TransactionUID tid = remoteTxn.getTid();
        if (remoteTxnEvent.getSubType() == 1) {
            if (this.incompleteStored.containsKey(tid)) {
                if (Store.getDEBUG()) {
                    String msg = this.getPrefix() + " found matching txn in prepared store on replay " + remoteTxn;
                    Globals.getLogger().log(4, msg);
                }
            } else {
                this.addToIncompleteUnstored(remoteTxn);
            }
        } else if (remoteTxnEvent.getSubType() == 2) {
            BaseTransaction existingWork = null;
            if (this.incompleteUnstored.containsKey(tid)) {
                existingWork = this.removeFromIncompleteUnstored(tid);
            } else if (this.incompleteStored.containsKey(tid)) {
                existingWork = this.removeFromIncompleteStored(tid);
                this.updateStoredState(tid, state);
                this.addToCompleteStored(existingWork);
            } else if (this.completeStored.containsKey(tid)) {
                existingWork = (BaseTransaction)this.completeStored.get(tid);
            }
            if (existingWork != null) {
                RemoteTransaction remoteTransaction = (RemoteTransaction)existingWork;
                if (state == 6) {
                    TransactionAcknowledgement[] txnAcks = remoteTransaction.getTxnAcks();
                    DestinationUID[] destIds = remoteTransaction.getDestIds();
                    this.transactionLogManager.transactionLogReplayer.replayRemoteAcks(txnAcks, destIds, tid, dstLoadedSet);
                }
            } else {
                logger.log(32, "Could not find prepared work for completing two-phase transaction " + remoteTxn.getTid());
            }
        }
    }

    @Override
    String getPrefix() {
        return "RemoteTransactionManager: " + Thread.currentThread().getName();
    }
}

