/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.util;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class TypeUtil {
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static Hashtable primitiveClasses_ = new Hashtable();
    private static final byte[] charval;

    public static int intGetChars(int src, char[] buf, int offset) {
        int power = 1000000000;
        boolean have_emitted = false;
        int init_offset = offset;
        if (src == 0) {
            buf[offset] = digits[0];
            return 1;
        }
        if (src < 0) {
            if (src == Integer.MIN_VALUE) {
                throw new IllegalArgumentException();
            }
            buf[offset++] = 45;
            src = Math.abs(src);
        }
        while (power > 0) {
            int this_digit = src / power;
            if (this_digit != 0 || have_emitted) {
                have_emitted = true;
                buf[offset++] = digits[this_digit];
            }
            src %= power;
            power /= 10;
        }
        return offset - init_offset;
    }

    public static int intGetBytes(int src, byte[] buf, int offset) {
        int power = 1000000000;
        boolean have_emitted = false;
        int init_offset = offset;
        if (src == 0) {
            buf[offset] = charval[0];
            return 1;
        }
        if (src < 0) {
            if (src == Integer.MIN_VALUE) {
                throw new IllegalArgumentException();
            }
            buf[offset++] = 45;
            src = Math.abs(src);
        }
        while (power > 0) {
            int this_digit = src / power;
            if (this_digit != 0 || have_emitted) {
                have_emitted = true;
                buf[offset++] = charval[this_digit];
            }
            src %= power;
            power /= 10;
        }
        return offset - init_offset;
    }

    public static int hashCode(String s) {
        int length = s.length();
        int h = 1;
        for (int i = 0; i < length; ++i) {
            h = h * 37 + s.charAt(i);
        }
        return h;
    }

    public static String[] wordWrap(String msg, int widthInChars) {
        int length;
        int width = widthInChars;
        int nextBreak = 0;
        int lastBreak = 0;
        int lengthLeft = length = msg.length();
        boolean breakFound = true;
        Vector<String> v = new Vector<String>();
        int nextNewline = msg.indexOf("\n");
        while (lengthLeft > width || nextNewline != -1) {
            nextBreak = nextNewline;
            if (nextBreak == -1 || nextBreak <= lastBreak || nextBreak > lastBreak + width) {
                nextBreak = msg.lastIndexOf(" ", lastBreak + width);
            }
            if (nextBreak == -1 || nextBreak <= lastBreak) {
                nextBreak = lastBreak + width - 1;
                breakFound = false;
                if (nextBreak > length) break;
            }
            String substr = msg.substring(lastBreak, nextBreak);
            v.addElement(substr);
            lengthLeft -= substr.length();
            lastBreak = nextBreak;
            if (breakFound) {
                ++lastBreak;
            }
            breakFound = true;
            nextNewline = msg.indexOf("\n", lastBreak);
        }
        v.addElement(msg.substring(lastBreak));
        Object[] lines = new String[v.size()];
        v.copyInto(lines);
        return lines;
    }

    public static String arrayToString(String[] from, String separator) {
        StringBuffer sb = new StringBuffer(100);
        String sep = "";
        for (String element : from) {
            sb.append(sep);
            sb.append(element);
            sep = separator;
        }
        return sb.toString();
    }

    public static String[] stringToArray(String from, String separator) {
        if (from == null) {
            return null;
        }
        if (separator == null) {
            separator = " ";
        }
        StringTokenizer toks = new StringTokenizer(from, separator);
        String[] result = new String[toks.countTokens()];
        int i = 0;
        while (toks.hasMoreTokens()) {
            result[i++] = toks.nextToken().trim();
        }
        return result;
    }

    public static String truncateFloat(float f, int digits) {
        double factor = Math.pow(10.0, digits);
        f = (float)((double)Math.round((double)f * factor) / factor);
        return Float.toString(f);
    }

    @Deprecated
    public static String addCommas(float f) {
        String floatStr = TypeUtil.truncateFloat(f, 0);
        return TypeUtil.addCommas(floatStr);
    }

    @Deprecated
    public static String addCommas(String numStr) {
        String n;
        int dotIndex = numStr.lastIndexOf(46);
        String fraction = "";
        if (dotIndex >= 0) {
            fraction = numStr.substring(dotIndex);
            n = numStr.substring(0, dotIndex);
        } else {
            n = numStr;
        }
        Object val = "";
        int lastIndex = 0;
        for (int i = n.length(); i > 0; i -= 3) {
            String comma = i > 3 ? "," : "";
            int start = Math.max(i - 3, 0);
            val = comma + n.substring(start, i) + (String)val;
            lastIndex = start;
        }
        val = n.substring(0, lastIndex) + (String)val + fraction;
        return val;
    }

    @Deprecated
    public static boolean isSubclassOf(Class sub, Class sup) {
        Class superclass;
        if (sub == sup) {
            return true;
        }
        for (superclass = sub.getSuperclass(); superclass != null && superclass != sup; superclass = superclass.getSuperclass()) {
        }
        return superclass != null;
    }

    public static Set getSuperInterfaces(ClassLoader cl, String className, String baseClassName) throws ClassNotFoundException {
        HashSet<String> allSuper = new HashSet<String>();
        if (!className.equals(baseClassName)) {
            Class<?>[] superInterfaces;
            Class<?> theClass = cl.loadClass(className);
            for (Class<?> currentClass : superInterfaces = theClass.getInterfaces()) {
                String currentClassName = currentClass.getName();
                if (currentClassName.equals(baseClassName)) continue;
                allSuper.add(currentClassName);
                allSuper.addAll(TypeUtil.getSuperInterfaces(cl, currentClassName, baseClassName));
            }
        }
        return allSuper;
    }

    public static Method getMethod(Class declaringClass, ClassLoader loader, String name, String[] paramClassNames) throws Exception {
        Class[] parameterTypes = null;
        if (paramClassNames != null) {
            parameterTypes = new Class[paramClassNames.length];
            for (int pIndex = 0; pIndex < parameterTypes.length; ++pIndex) {
                String next = paramClassNames[pIndex];
                parameterTypes[pIndex] = primitiveClasses_.containsKey(next) ? (Class)primitiveClasses_.get(next) : Class.forName(next, true, loader);
            }
        }
        return declaringClass.getMethod(name, parameterTypes);
    }

    public static Method getDeclaredMethod(Class declaringClass, ClassLoader loader, String name, String[] paramClassNames) throws Exception {
        Class[] parameterTypes = null;
        if (paramClassNames != null) {
            parameterTypes = new Class[paramClassNames.length];
            for (int pIndex = 0; pIndex < parameterTypes.length; ++pIndex) {
                String next = paramClassNames[pIndex];
                parameterTypes[pIndex] = primitiveClasses_.containsKey(next) ? (Class)primitiveClasses_.get(next) : Class.forName(next, true, loader);
            }
        }
        return declaringClass.getDeclaredMethod(name, parameterTypes);
    }

    public static boolean sameParamTypes(Method m1, Method m2) {
        Type[] gpm2;
        boolean same = false;
        Type[] gpm1 = m1.getGenericParameterTypes();
        if (gpm1.length == (gpm2 = m2.getGenericParameterTypes()).length) {
            same = true;
            for (int i = 0; i < gpm1.length; ++i) {
                if (gpm1[i].equals(gpm2[i]) || gpm1[i] instanceof TypeVariable || gpm2[i] instanceof TypeVariable) continue;
                if (gpm1[i] instanceof ParameterizedType || gpm2[i] instanceof ParameterizedType) {
                    same = m1.getParameterTypes()[i].equals(m2.getParameterTypes()[i]);
                    if (same) continue;
                    break;
                }
                same = false;
                break;
            }
        }
        return same;
    }

    public static boolean sameMethodSignature(Method m1, Method m2) {
        boolean same = false;
        if (m1.getName().equals(m2.getName())) {
            same = TypeUtil.sameParamTypes(m1, m2) && TypeUtil.sameReturnTypes(m1, m2);
        }
        return same;
    }

    private static boolean sameReturnTypes(Method m1, Method m2) {
        Type grt2;
        if (m1.getReturnType().equals(m2.getReturnType())) {
            return true;
        }
        Type grt1 = m1.getGenericReturnType();
        if (grt1.equals(grt2 = m2.getGenericReturnType())) {
            return true;
        }
        return grt1 instanceof TypeVariable || grt2 instanceof TypeVariable;
    }

    public static String setterMethodToPropertyName(String setterMethodName) {
        if (setterMethodName == null || setterMethodName.length() <= 3 || !setterMethodName.startsWith("set")) {
            throw new IllegalArgumentException("Invalid setter method name " + setterMethodName);
        }
        return setterMethodName.substring(3, 4).toLowerCase(Locale.ENGLISH) + setterMethodName.substring(4);
    }

    public static String propertyNameToSetterMethod(String propertyName) {
        if (propertyName == null || propertyName.length() == 0) {
            throw new IllegalArgumentException("Invalid property name " + propertyName);
        }
        return "set" + propertyName.substring(0, 1).toUpperCase(Locale.ENGLISH) + propertyName.substring(1);
    }

    public static Class[] paramClassNamesToTypes(String[] paramClassNames, ClassLoader loader) throws Exception {
        Class[] parameterTypes = null;
        if (paramClassNames != null) {
            parameterTypes = new Class[paramClassNames.length];
            for (int pIndex = 0; pIndex < parameterTypes.length; ++pIndex) {
                String next = paramClassNames[pIndex];
                parameterTypes[pIndex] = primitiveClasses_.containsKey(next) ? (Class)primitiveClasses_.get(next) : Class.forName(next, true, loader);
            }
        }
        return parameterTypes;
    }

    static {
        primitiveClasses_.put(Character.TYPE.getName(), Character.TYPE);
        primitiveClasses_.put(Boolean.TYPE.getName(), Boolean.TYPE);
        primitiveClasses_.put(Byte.TYPE.getName(), Byte.TYPE);
        primitiveClasses_.put(Integer.TYPE.getName(), Integer.TYPE);
        primitiveClasses_.put(Long.TYPE.getName(), Long.TYPE);
        primitiveClasses_.put(Short.TYPE.getName(), Short.TYPE);
        primitiveClasses_.put(Float.TYPE.getName(), Float.TYPE);
        primitiveClasses_.put(Double.TYPE.getName(), Double.TYPE);
        charval = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    }
}

