/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated.enhanced.jlr;

import jakarta.enterprise.inject.spi.AnnotatedMethod;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.MethodSignature;
import org.jboss.weld.util.reflection.Reflections;

public class MethodSignatureImpl
implements MethodSignature {
    private static final long serialVersionUID = 870948075030895317L;
    private final String methodName;
    private final String[] parameterTypes;

    public static MethodSignature of(AnnotatedMethod<?> method) {
        if (method instanceof EnhancedAnnotatedMethod) {
            return ((EnhancedAnnotatedMethod)Reflections.cast(method)).getSignature();
        }
        return new MethodSignatureImpl(method);
    }

    public MethodSignatureImpl(AnnotatedMethod<?> method) {
        this.methodName = method.getJavaMember().getName();
        this.parameterTypes = new String[method.getParameters().size()];
        for (int i = 0; i < method.getParameters().size(); ++i) {
            this.parameterTypes[i] = Reflections.getRawType(method.getParameters().get(i).getBaseType()).getName();
        }
    }

    public MethodSignatureImpl(Method method) {
        this.methodName = method.getName();
        this.parameterTypes = new String[method.getParameterTypes().length];
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            this.parameterTypes[i] = method.getParameterTypes()[i].getName();
        }
    }

    public MethodSignatureImpl(String methodName, String ... parameterTypes) {
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.methodName.hashCode();
        result = 31 * result + Arrays.hashCode(this.parameterTypes);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MethodSignatureImpl)) {
            return false;
        }
        MethodSignatureImpl other = (MethodSignatureImpl)obj;
        if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
            return false;
        }
        return Arrays.equals(this.parameterTypes, other.parameterTypes);
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public String[] getParameterTypes() {
        return Arrays.copyOf(this.parameterTypes, this.parameterTypes.length);
    }

    public String toString() {
        return new StringBuffer().append("method ").append(this.getMethodName()).append(Arrays.toString(this.parameterTypes).replace('[', '(').replace(']', ')')).toString();
    }

    @Override
    public boolean matches(Method method) {
        if (!this.methodName.equals(method.getName())) {
            return false;
        }
        Class<?>[] methodParameterTypes = method.getParameterTypes();
        if (methodParameterTypes.length != this.parameterTypes.length) {
            return false;
        }
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            if (this.parameterTypes[i].equals(methodParameterTypes[i].getName())) continue;
            return false;
        }
        return true;
    }
}

