/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss;

import com.sun.xml.wss.SecurityEnvironment;
import com.sun.xml.wss.SecurityProcessingContext;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.MessageLayout;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.StaticPolicyContext;
import jakarta.xml.soap.SOAPMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.security.auth.callback.CallbackHandler;

public class ProcessingContext
implements SecurityProcessingContext {
    String messageIdentifier;
    StaticPolicyContext context;
    SecurityPolicy securityPolicy;
    boolean inBoundMessage = false;
    CallbackHandler callbackHandler = null;
    SecurityEnvironment environmentHandler = null;
    protected SecurableSoapMessage secureMessage = null;
    protected Map properties = null;
    int configType = 0;
    protected MessageLayout securityHeaderLayout = MessageLayout.Lax;
    public static final String OPERATION_RESOLVER = "OperationResolver";
    private boolean retainSecHeader = false;
    private boolean resetMU = false;
    private boolean isClient = false;
    private boolean isExpired = false;

    public ProcessingContext() {
    }

    public ProcessingContext(StaticPolicyContext context, SecurityPolicy securityPolicy, SOAPMessage message) throws XWSSecurityException {
        this.generateMessageId();
        this.setPolicyContext(context);
        this.setSecurityPolicy(securityPolicy);
        this.setSOAPMessage(message);
    }

    public void resetMustUnderstand(boolean b) {
        this.resetMU = b;
    }

    public boolean resetMustUnderstand() {
        return this.resetMU;
    }

    @Override
    public void setSecurityPolicy(SecurityPolicy securityPolicy) throws XWSSecurityException {
        this.securityPolicy = securityPolicy;
    }

    @Override
    public SecurityPolicy getSecurityPolicy() {
        return this.securityPolicy;
    }

    @Override
    public void setPolicyContext(StaticPolicyContext context) {
        this.context = context;
    }

    @Override
    public StaticPolicyContext getPolicyContext() {
        return this.context;
    }

    @Override
    public void setSOAPMessage(SOAPMessage message) throws XWSSecurityException {
        this.secureMessage = new SecurableSoapMessage();
        this.secureMessage.setSOAPMessage(message);
        this.setOptimized();
    }

    @Override
    public SOAPMessage getSOAPMessage() {
        return this.secureMessage.getSOAPMessage();
    }

    @Override
    public void setHandler(CallbackHandler handler) {
        this.callbackHandler = handler;
        this.environmentHandler = new DefaultSecurityEnvironmentImpl(handler);
    }

    @Override
    public void setSecurityEnvironment(SecurityEnvironment handler) {
        this.environmentHandler = handler;
    }

    @Override
    public CallbackHandler getHandler() {
        return this.callbackHandler;
    }

    @Override
    public SecurityEnvironment getSecurityEnvironment() {
        return this.environmentHandler;
    }

    @Override
    public Map getExtraneousProperties() {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        return this.properties;
    }

    @Override
    public void isInboundMessage(boolean inBound) {
        this.inBoundMessage = inBound;
    }

    @Override
    public boolean isInboundMessage() {
        return this.inBoundMessage;
    }

    @Override
    public void setMessageIdentifier(String identifier) {
        this.messageIdentifier = identifier;
    }

    @Override
    public String getMessageIdentifier() {
        return this.messageIdentifier;
    }

    @Override
    public void setExtraneousProperty(String name, Object value) {
        this.getExtraneousProperties().put(name, value);
    }

    @Override
    public Object getExtraneousProperty(String name) {
        return this.getExtraneousProperties().get(name);
    }

    @Override
    public void removeExtraneousProperty(String name) {
        this.getExtraneousProperties().remove(name);
    }

    public static void copy(Map p1, Map p2) {
        p1.putAll(p2);
    }

    public void copy(ProcessingContext ctx1, ProcessingContext ctx2) throws XWSSecurityException {
        if (ctx2 == null) {
            return;
        }
        ctx1.setHandler(ctx2.getHandler());
        ctx1.setSecurityEnvironment(ctx2.getSecurityEnvironment());
        ctx1.setMessageIdentifier(ctx2.getMessageIdentifier());
        if (ctx2.getSecurityPolicy() != null) {
            ctx1.setSecurityPolicy(ctx2.getSecurityPolicy());
        }
        ctx1.isInboundMessage(ctx2.isInboundMessage());
        ctx1.setSecureMessage(ctx2.getSecureMessage());
        this.properties = ctx2.getExtraneousProperties();
        ctx1.setPolicyContext(ctx2.getPolicyContext());
        ctx1.setConfigType(ctx2.getConfigType());
        ctx1.retainSecurityHeader(ctx2.retainSecurityHeader());
        ctx1.resetMustUnderstand(ctx2.resetMustUnderstand());
        ctx1.isClient(ctx2.isClient());
        ctx1.isExpired(ctx2.isExpired());
    }

    private void generateMessageId() {
        Random rnd = new Random();
        long longRandom = rnd.nextLong();
        this.messageIdentifier = String.valueOf(longRandom);
    }

    @Override
    public void reset() {
    }

    @Override
    public int getConfigType() {
        return this.configType;
    }

    @Override
    public void setConfigType(int type) {
        this.configType = type;
        this.setOptimized();
    }

    protected SecurableSoapMessage getSecureMessage() {
        return this.secureMessage;
    }

    protected void setSecureMessage(SecurableSoapMessage msg) {
        this.secureMessage = msg;
    }

    private void setOptimized() {
        if (this.secureMessage != null) {
            if (this.configType == 0) {
                this.secureMessage.setOptimized(false);
            } else {
                this.secureMessage.setOptimized(true);
            }
        }
    }

    @Override
    public void copy(SecurityProcessingContext ctx1, SecurityProcessingContext ctx2) throws XWSSecurityException {
        throw new UnsupportedOperationException("Not yet supported");
    }

    public void setSecurityHeaderLayout(MessageLayout layout) {
        this.securityHeaderLayout = layout;
    }

    public MessageLayout getSecurityHeaderLayout() {
        return this.securityHeaderLayout;
    }

    public boolean retainSecurityHeader() {
        return this.retainSecHeader;
    }

    public void retainSecurityHeader(boolean arg) {
        this.retainSecHeader = arg;
    }

    public void isClient(boolean isClient) {
        this.isClient = isClient;
    }

    public boolean isClient() {
        return this.isClient;
    }

    public boolean isExpired() {
        return this.isExpired;
    }

    public void isExpired(boolean value) {
        this.isExpired = value;
    }
}

