/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms;

import com.sun.messaging.bridge.api.BridgeException;
import com.sun.messaging.bridge.api.FaultInjection;
import com.sun.messaging.bridge.api.MessageTransformer;
import com.sun.messaging.bridge.service.jms.AutoDestination;
import com.sun.messaging.bridge.service.jms.DMQ;
import com.sun.messaging.bridge.service.jms.EventListener;
import com.sun.messaging.bridge.service.jms.EventNotifier;
import com.sun.messaging.bridge.service.jms.JMSBridge;
import com.sun.messaging.bridge.service.jms.MessageHeaders;
import com.sun.messaging.bridge.service.jms.PooledConnection;
import com.sun.messaging.bridge.service.jms.Refable;
import com.sun.messaging.bridge.service.jms.SharedConnection;
import com.sun.messaging.bridge.service.jms.XAResourceImpl;
import com.sun.messaging.bridge.service.jms.resources.JMSBridgeResources;
import com.sun.messaging.jmq.jmsclient.MessageProducerImpl;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.XAConnection;
import jakarta.jms.XAConnectionFactory;
import jakarta.jms.XASession;
import jakarta.transaction.RollbackException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAResource;

public class Link
implements Runnable {
    private static JMSBridgeResources _jbr = JMSBridge.getJMSBridgeResources();
    private Logger _logger = null;
    private TransactionManager _tm = null;
    private Object _sourceCF = null;
    private Object _targetCF = null;
    private Object _sourceDest = null;
    private Object _targetDest = null;
    private MessageConsumer _consumer = null;
    private MessageProducer _producer = null;
    private Session _sourceSession = null;
    private Session _targetSession = null;
    private Connection _sourceConn = null;
    private Connection _targetConn = null;
    private String _name = null;
    private Properties _linkAttrs = null;
    private Properties _srcAttrs = null;
    private Properties _tgtAttrs = null;
    private Properties _tgtProps = null;
    private JMSBridge _parent = null;
    private Properties _msgTransformerProps = null;
    private LinkState _state = LinkState.UNINITIALIZED;
    private Thread _thread = null;
    private boolean _targetStayConnected = false;
    private boolean _sourceConnException = false;
    private boolean _targetConnException = false;
    private String _sourceProviderName = null;
    private String _targetProviderName = null;
    private String _sourceDestName = null;
    private String _targetDestName = null;
    private EventNotifier _notifier = null;
    private static final int MIN_TRANSACTION_TIMEOUT = 60;
    private boolean _enabled = true;
    private boolean _isTransacted = true;
    private MessageTransformer<Message, Message> _msgTransformer = null;
    private boolean _consumeOnTransformError = false;
    private boolean _retainReplyTo = false;
    private FaultInjection _fi = FaultInjection.getInjection();
    private String _targetConnType = null;
    private String _sourceConnType = null;
    private MessageProducer _branchProducer = null;
    private String _targetCurrentDestinationName = null;
    private boolean _unidentifiedProducer = false;
    private boolean _firstTransformerBranchTo = true;
    private boolean _firstTransformerNoTransfer = true;
    private int _sourceAttemptInterval = 5;
    private int _targetAttemptInterval = 5;
    private static final int MAX_CONSECUTIVE_THROWABLES = 5;

    public synchronized void init(Properties linkAttrs, Properties srcAttrs, Properties tgtAttrs, Properties tgtProps, JMSBridge parent) throws Exception {
        this._linkAttrs = linkAttrs;
        this._srcAttrs = srcAttrs;
        this._tgtAttrs = tgtAttrs;
        this._tgtProps = tgtProps;
        this._parent = parent;
        this._notifier = parent._notifier;
        this._msgTransformerProps = this._tgtProps == null ? new Properties() : new Properties(this._tgtProps);
        this._msgTransformerProps.setProperty("JMS_SUN_JMSBRIDGE_NAME", this._parent.getBridgeName());
        if (this._sourceDest == null || this._targetDest == null || this._sourceCF == null || this._targetCF == null) {
            throw new IllegalStateException(_jbr.getKString("BSJ4021", this._sourceCF == null ? _jbr.getString("BSJ0003") : _jbr.getString("BSJ0004"), this._name));
        }
        if (this._logger == null) {
            throw new IllegalStateException("No logger set for " + this);
        }
        this._enabled = Boolean.valueOf(this._linkAttrs.getProperty("enabled", "true"));
        this._isTransacted = Boolean.valueOf(this._linkAttrs.getProperty("transacted", "true"));
        if (this._isTransacted && !(this._sourceCF instanceof XAConnectionFactory)) {
            Object[] objectArray = new String[3];
            objectArray[0] = "XAConnectionFactory";
            objectArray[1] = _jbr.getString("BSJ0005");
            objectArray[2] = this.toString();
            Object[] eparam = objectArray;
            throw new IllegalArgumentException(_jbr.getKString("BSJ4022", eparam));
        }
        if (!this._isTransacted && this._sourceCF instanceof XAConnectionFactory) {
            Object[] objectArray = new String[3];
            objectArray[0] = "ConnectionFactory";
            objectArray[1] = _jbr.getString("BSJ0006");
            objectArray[2] = this.toString();
            Object[] eparam = objectArray;
            throw new IllegalArgumentException(_jbr.getKString("BSJ4022", eparam));
        }
        String cn = this._tgtAttrs.getProperty("message-transformer-class");
        if (cn != null) {
            this._msgTransformer = (MessageTransformer)Class.forName(cn).newInstance();
        }
        this._consumeOnTransformError = Boolean.valueOf(this._tgtAttrs.getProperty("consume-no-transfer-on-transform-error", "false"));
        this._retainReplyTo = Boolean.valueOf(this._tgtAttrs.getProperty("retain-replyto", "false"));
        String val = this._parent.getCFAttributes(this._sourceCF).getProperty("connect-attempt-interval-in-seconds", "5");
        if (val != null) {
            this._sourceAttemptInterval = Integer.parseInt(val);
        }
        if ((val = this._parent.getCFAttributes(this._targetCF).getProperty("connect-attempt-interval-in-seconds", "5")) != null) {
            this._targetAttemptInterval = Integer.parseInt(val);
        }
        if (this._sourceCF instanceof XAConnectionFactory) {
            this._tm = this._parent.getTransactionManager();
            if (this._tm == null) {
                throw new IllegalStateException("No transaction manager for XA in " + this);
            }
            if (this._parent.supportTransactionTimeout()) {
                if (this._parent.getTransactionTimeout() < 60) {
                    throw new IllegalArgumentException("Transaction timeout " + this._parent.getTransactionTimeout() + " is too small");
                }
                this._logger.log(Level.INFO, "Link " + this + " uses TM " + this._tm.getClass().toString() + ", transaction timeout " + this._parent.getTransactionTimeout() + " seconds");
            } else {
                this._logger.log(Level.INFO, _jbr.getString("BSJ1026", this.toString(), this._tm.getClass().toString()));
            }
        }
        Object[] param = new String[]{this.toString(), this._linkAttrs == null ? "null" : this._linkAttrs.toString(), this._srcAttrs == null ? "null" : this._srcAttrs.toString(), this._tgtAttrs == null ? "null" : this._tgtAttrs.toString(), this._tgtProps == null ? "null" : this._tgtProps.toString()};
        this._logger.log(Level.INFO, _jbr.getString("BSJ1064", param));
        this._state = LinkState.STOPPED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerXAResources() throws Exception {
        if (!(this._sourceCF instanceof XAConnectionFactory)) {
            return;
        }
        XAResourceHandle srh = new XAResourceHandle(false);
        XAResourceHandle trh = new XAResourceHandle(true);
        Transaction tx = null;
        try {
            this._logger.log(Level.INFO, _jbr.getString("BSJ1027", this.toString()));
            this.initSource(false, false);
            this.initTarget(false, false, false);
            srh.xar = ((XASession)this._sourceSession).getXAResource();
            if (((Refable)this._targetCF).isEmbeded() && ((Refable)this._sourceCF).isEmbeded()) {
                trh.xar = srh.xar;
            } else {
                trh.xar = ((XASession)this._targetSession).getXAResource();
                if (trh.xar.getClass().getName().equals(srh.xar.getClass().getName())) {
                    trh.xar = new XAResourceImpl(trh.xar);
                    this._logger.log(Level.INFO, _jbr.getString("BSJ1028", trh.xar.getClass().getName()));
                }
            }
            this._tm.begin();
            tx = this._tm.getTransaction();
            if (!this.doEnlistAndRollbackOnError(tx, this._tm, srh)) {
                throw srh.ex;
            }
            if (srh.xar != trh.xar && !this.doEnlistAndRollbackOnError(this._tm.getTransaction(), this._tm, trh)) {
                throw trh.ex;
            }
            this.doFinally(tx, this._tm, srh, trh);
            this.closeSource();
            this.closeTarget();
        }
        catch (Throwable throwable) {
            this.doFinally(tx, this._tm, srh, trh);
            this.closeSource();
            this.closeTarget();
            throw throwable;
        }
        this._logger.log(Level.INFO, _jbr.getString("BSJ1029", this.toString()));
    }

    public boolean isEnabled() {
        if (this._state == LinkState.UNINITIALIZED) {
            throw new IllegalStateException("Link is not initialized");
        }
        return this._enabled;
    }

    public boolean isTransacted() {
        if (this._state == LinkState.UNINITIALIZED) {
            throw new IllegalStateException("Link is not initialized");
        }
        return this._isTransacted;
    }

    public void enable() throws Exception {
        if (this.isEnabled()) {
            this._logger.log(Level.INFO, this + " is already enabled");
            return;
        }
        this._enabled = true;
    }

    public synchronized void start(boolean doReconnect) throws Exception {
        if (this._state == LinkState.UNINITIALIZED) {
            throw new IllegalStateException("Link not initialized !");
        }
        if (this._state == LinkState.STARTED) {
            this._logger.log(Level.INFO, _jbr.getString("BSJ1030", this.toString()));
            return;
        }
        this._state = LinkState.STARTING;
        try {
            this.initSource(doReconnect, true);
            this.initTarget(true, doReconnect, true);
            this._thread = new Thread(this);
            this._thread.setDaemon(true);
            this._thread.setName(this.toString());
            this._thread.start();
        }
        catch (Throwable t) {
            this._logger.log(Level.SEVERE, _jbr.getKString("BSJ3010", this.toString(), t.getMessage()), t);
            try {
                this.stop(!doReconnect);
            }
            catch (Throwable t1) {
                this._logger.log(Level.WARNING, _jbr.getKString("BSJ3011", this.toString()), t1);
            }
            throw new Exception(t);
        }
    }

    public synchronized void postStart() throws Exception {
        if (this._state == LinkState.STARTED) {
            return;
        }
        if (this._state != LinkState.STARTING) {
            throw new IllegalStateException(_jbr.getKString("BSJ4023", this.toString(), this._state.toString()));
        }
        try {
            this.resume(false);
            this._state = LinkState.STARTED;
        }
        catch (Exception e) {
            try {
                this.stop();
            }
            catch (Throwable t) {
                this._logger.log(Level.WARNING, _jbr.getKString("BSJ3012", this.toString()), t);
            }
            throw e;
        }
    }

    public synchronized void pause() throws Exception {
        if (this._sourceConn == null) {
            throw new IllegalStateException("Source connection not created");
        }
        if (this._state == LinkState.UNINITIALIZED || this._state == LinkState.STOPPED || this._state == LinkState.STOPPING) {
            throw new IllegalStateException(_jbr.getKString("BSJ4024", this.toString(), this._state.toString()));
        }
        if (this._state == LinkState.PAUSED || this._state == LinkState.PAUSING) {
            this._logger.log(Level.INFO, _jbr.getString("BSJ1031", this.toString()));
            return;
        }
        this._state = LinkState.PAUSING;
        try {
            this._sourceConn.stop();
        }
        catch (Exception e) {
            this._logger.log(Level.SEVERE, _jbr.getKString("BSJ3013", this.toString()), e);
            try {
                this.stop();
            }
            catch (Exception e1) {
                this._logger.log(Level.SEVERE, _jbr.getString("BSJ3014", this.toString()), e);
            }
            throw e;
        }
        this._state = LinkState.PAUSED;
    }

    public synchronized void resume(boolean resume) throws Exception {
        if (this._sourceConn == null) {
            throw new IllegalStateException("Source connection not created");
        }
        if (this._state == LinkState.UNINITIALIZED || this._state == LinkState.STOPPED || this._state == LinkState.STOPPING) {
            Object[] objectArray = new String[3];
            objectArray[0] = resume ? _jbr.getString("BSJ0007") : _jbr.getString("BSJ0008");
            objectArray[1] = this.toString();
            objectArray[2] = this._state.toString();
            Object[] eparam = objectArray;
            throw new IllegalStateException(_jbr.getKString("BSJ4025", eparam));
        }
        if (resume) {
            if (this._state == LinkState.STARTING || this._state == LinkState.STARTED) {
                this._logger.log(Level.INFO, _jbr.getString("BSJ1032", this.toString()));
                return;
            }
        } else if (this._state == LinkState.PAUSING || this._state == LinkState.PAUSED) {
            this._logger.log(Level.INFO, _jbr.getString("BSJ1033", this.toString(), this._state.toString()));
            return;
        }
        try {
            this._sourceConn.start();
        }
        catch (Exception e) {
            if (resume) {
                this._logger.log(Level.SEVERE, _jbr.getKString("BSJ3015", this.toString()), e);
            } else {
                this._logger.log(Level.SEVERE, _jbr.getKString("BSJ3017", this.toString()), e);
            }
            try {
                this.stop();
            }
            catch (Exception e1) {
                this._logger.log(Level.SEVERE, _jbr.getKString("BSJ3016", this.toString(), resume ? _jbr.getString("BSJ0009") : _jbr.getString("BSJ0010")), e);
            }
            throw e;
        }
        this._state = LinkState.STARTED;
    }

    public void stop() throws Exception {
        this.stop(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean waitExit) throws Exception {
        this._notifier.notifyEvent(EventListener.EventType.LINK_STOP, this);
        Thread thr = null;
        Throwable t = null;
        Link link = this;
        synchronized (link) {
            block18: {
                this._state = LinkState.STOPPING;
                thr = this._thread;
                this._logger.log(Level.INFO, _jbr.getString("BSJ1034", this.toString()));
                if (this._thread != null && Thread.currentThread() != this._thread) {
                    this._thread.interrupt();
                }
                try {
                    if (this._sourceConn != null) {
                        this._sourceConn.close();
                    }
                }
                catch (Throwable t0) {
                    t = t0;
                }
                try {
                    this.closeTarget();
                }
                catch (Throwable t1) {
                    if (t != null) break block18;
                    t = t1;
                }
            }
            if (t == null) {
                this._state = LinkState.STOPPED;
                this.notifyAll();
                this._thread = null;
            }
        }
        if (thr != null && Thread.currentThread() != thr) {
            thr.interrupt();
            if (!waitExit) {
                thr.join(30000L);
            } else {
                while (true) {
                    try {
                        while (true) {
                            thr.join(60000L);
                            this._logger.log(Level.INFO, "BSJ1077", this.toString());
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }
        if (t != null) {
            throw new Exception(t);
        }
    }

    private void initSource() throws Exception {
        this.initSource(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initSource(boolean doReconnect, boolean checkState) throws Exception {
        if (checkState && (this._state == LinkState.STOPPING || this._state == LinkState.STOPPED)) {
            throw new JMSException(_jbr.getKString("BSJ4026", this.toString()));
        }
        this._sourceConnException = false;
        String val = this._srcAttrs.getProperty("clientid");
        this._sourceConnType = "D";
        this._logger.log(Level.INFO, _jbr.getString("BSJ1035", val == null ? "" : "[ClientID=" + val + "]", this.toString()));
        EventListener l = new EventListener(this);
        try {
            this._notifier.addEventListener(EventListener.EventType.LINK_STOP, l);
            this._notifier.addEventListener(EventListener.EventType.BRIDGE_STOP, l);
            this._sourceConn = JMSBridge.openConnection(this._sourceCF, this._parent.getCFAttributes(this._sourceCF), _jbr.getString("BSJ0001"), this, l, this._logger, doReconnect);
        }
        finally {
            this._notifier.removeEventListener(l);
        }
        if (val != null) {
            try {
                this._sourceConn.setClientID(val);
            }
            catch (JMSException e) {
                this._logger.log(Level.WARNING, "Set client id " + val + " to source connection failed in " + this + ", try again ...", e);
                if (Thread.currentThread().isInterrupted()) {
                    throw e;
                }
                Thread.sleep(this._sourceAttemptInterval);
                this._sourceConn.setClientID(val);
            }
        }
        this._sourceConn.stop();
        this._sourceConn.setExceptionListener(new ExceptionListener(){

            public void onException(JMSException exception) {
                Link.this._logger.log(Level.WARNING, _jbr.getKString("BSJ2015", _jbr.getString("BSJ0003"), this.toString()), exception);
                if (Link.this._targetConn instanceof PooledConnection) {
                    ((PooledConnection)Link.this._targetConn).invalid();
                } else if (Link.this._targetConn instanceof SharedConnection) {
                    ((SharedConnection)Link.this._targetConn).invalid();
                }
                Link.this._sourceConnException = true;
            }
        });
        try {
            ConnectionMetaData md = this._sourceConn.getMetaData();
            this._sourceProviderName = md.getJMSProviderName();
        }
        catch (Exception e) {
            this._sourceProviderName = null;
            this._logger.log(Level.WARNING, "Unable to get source JMSProvider from conn " + this._sourceConn + " in " + this + ": " + e.getMessage());
        }
        if (this._sourceConn instanceof XAConnection) {
            this._sourceSession = ((XAConnection)this._sourceConn).createXASession();
            XAResource xar = ((XASession)this._sourceSession).getXAResource();
            String rm = ((Refable)this._sourceCF).getRef();
            try {
                this._logger.log(Level.INFO, _jbr.getString("BSJ1025", rm, xar.toString()));
                this._parent.getTransactionManagerAdapter().registerRM(rm, xar);
            }
            catch (Exception e) {
                Object[] eparam = new String[]{xar.toString(), rm, this.toString()};
                this._logger.log(Level.WARNING, _jbr.getKString("BSJ2016", eparam), e);
                throw e;
            }
        } else {
            this._sourceSession = this._sourceConn.createSession(false, 2);
        }
        String selector = this._srcAttrs.getProperty("selector");
        Object dest = this._sourceDest;
        if (this._sourceDest instanceof AutoDestination) {
            AutoDestination ad = (AutoDestination)this._sourceDest;
            dest = ad.isQueue() ? this._sourceSession.createQueue(ad.getName()) : this._sourceSession.createTopic(ad.getName());
        }
        if (dest instanceof Topic) {
            String duraname = this._srcAttrs.getProperty("durable-sub");
            this._consumer = duraname != null ? this._sourceSession.createDurableSubscriber((Topic)dest, duraname, selector, true) : this._sourceSession.createConsumer((Destination)((Topic)dest), selector, true);
        } else if (dest instanceof Queue) {
            this._consumer = this._sourceSession.createConsumer((Destination)((Queue)dest), selector);
        } else {
            throw new IllegalArgumentException("Unknown source destination type: " + dest.getClass().getName() + " in " + this);
        }
    }

    private void initTarget() throws Exception {
        this.initTarget(false, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initTarget(boolean start, boolean doReconnect, boolean checkState) throws Exception {
        if (checkState && (this._state == LinkState.STOPPING || this._state == LinkState.STOPPED)) {
            throw new JMSException("Link " + this + " is stopped");
        }
        this._targetConnException = false;
        String val = this._tgtAttrs.getProperty("stay-connected", "true");
        this._targetStayConnected = Boolean.valueOf(val);
        val = this._tgtAttrs.getProperty("clientid");
        if (val != null || this._targetStayConnected) {
            this._targetConnType = "D";
            this._logger.log(Level.INFO, _jbr.getString("BSJ1036", val == null ? "" : "[ClientID=" + val + "]", this.toString()));
            EventListener l = new EventListener(this);
            try {
                this._notifier.addEventListener(EventListener.EventType.LINK_STOP, l);
                this._notifier.addEventListener(EventListener.EventType.BRIDGE_STOP, l);
                this._targetConn = JMSBridge.openConnection(this._targetCF, this._parent.getCFAttributes(this._targetCF), _jbr.getString("BSJ0002"), this, l, this._logger, doReconnect);
            }
            finally {
                this._notifier.removeEventListener(l);
            }
            if (val != null) {
                try {
                    this._targetConn.setClientID(val);
                }
                catch (JMSException e) {
                    this._logger.log(Level.WARNING, "Set client id " + val + " to target connection failed in " + this + ", try again ...", e);
                    if (Thread.currentThread().isInterrupted()) {
                        throw e;
                    }
                    Thread.sleep(this._targetAttemptInterval);
                    this._targetConn.setClientID(val);
                }
            }
        } else if (!start) {
            this._logger.log(Level.INFO, _jbr.getString("BSJ1037", this.toString()));
            this._targetConn = this._parent.obtainConnection(this._targetCF, _jbr.getString("BSJ0002"), this, start);
        } else {
            this._logger.log(Level.INFO, _jbr.getString("BSJ1038", this.toString()));
            return;
        }
        if (this._targetConn instanceof PooledConnection) {
            this._targetConnType = "P";
        } else if (this._targetConn instanceof SharedConnection) {
            this._targetConnType = "S";
        }
        this._targetConn.setExceptionListener(new ExceptionListener(){

            public void onException(JMSException exception) {
                Link.this._logger.log(Level.WARNING, _jbr.getKString("BSJ2015", _jbr.getString("BSJ0004"), this.toString()), exception);
                if (Link.this._targetConn instanceof PooledConnection) {
                    ((PooledConnection)Link.this._targetConn).invalid();
                } else if (Link.this._targetConn instanceof SharedConnection) {
                    ((SharedConnection)Link.this._targetConn).invalid();
                }
                Link.this._targetConnException = true;
            }
        });
        try {
            ConnectionMetaData md = this._targetConn.getMetaData();
            this._targetProviderName = md.getJMSProviderName();
        }
        catch (Exception e) {
            this._targetProviderName = null;
            this._logger.log(Level.WARNING, "Unable to get target JMSProvider from conn " + this._targetConn + " in " + this + ": " + e.getMessage());
        }
        if (this._targetConn instanceof XAConnection) {
            this._targetSession = ((XAConnection)this._targetConn).createXASession();
            XAResource xar = ((XASession)this._targetSession).getXAResource();
            String rm = ((Refable)this._targetCF).getRef();
            try {
                this._logger.log(Level.INFO, _jbr.getString("BSJ1025", rm, xar.toString()));
                this._parent.getTransactionManagerAdapter().registerRM(rm, xar);
            }
            catch (Exception e) {
                Object[] eparam = new String[]{xar.toString(), rm, this.toString()};
                this._logger.log(Level.WARNING, _jbr.getKString("BSJ2017", eparam), e);
                throw e;
            }
        } else {
            this._targetSession = this._targetConn.createSession(false, 2);
        }
        if (this._targetDest instanceof Destination) {
            this._producer = this._targetSession.createProducer((Destination)this._targetDest);
        } else if (this._targetDest instanceof AutoDestination) {
            AutoDestination ad = (AutoDestination)this._targetDest;
            this._producer = ad.isQueue() ? this._targetSession.createProducer((Destination)this._targetSession.createQueue(ad.getName())) : this._targetSession.createProducer((Destination)this._targetSession.createTopic(ad.getName()));
        } else if (this._targetDest.equals("AS_SOURCE")) {
            this._unidentifiedProducer = true;
            this._producer = null;
        } else {
            throw new IllegalArgumentException("Unknown target destination type: " + this._targetDest.getClass().getName() + " in " + this);
        }
        if (this._producer != null && this._producer instanceof MessageProducerImpl) {
            ((MessageProducerImpl)this._producer)._setForJMSBridge();
        }
    }

    private MessageProducer createProducer(Object d, String mid, boolean targetd) throws Exception {
        MessageProducer p = null;
        Object dest = d;
        if (d instanceof String) {
            dest = this._parent.createDestination((String)d);
        }
        if (dest instanceof Destination) {
            Destination td = null;
            if (targetd) {
                td = (Destination)dest;
            } else if (dest instanceof Queue) {
                td = this._targetSession.createQueue(((Queue)dest).getQueueName());
            } else if (dest instanceof Topic) {
                td = this._targetSession.createTopic(((Topic)dest).getTopicName());
            } else {
                throw new JMSException("Unsupported JMS Destination type: " + d);
            }
            p = this._targetSession.createProducer(td);
        } else if (dest instanceof AutoDestination) {
            AutoDestination ad = (AutoDestination)dest;
            p = ad.isQueue() ? this._targetSession.createProducer((Destination)this._targetSession.createQueue(ad.getName())) : this._targetSession.createProducer((Destination)this._targetSession.createTopic(ad.getName()));
        } else {
            throw new IllegalArgumentException("Unsupported destination type: " + dest.getClass().getName() + " to create target producer for message " + mid + " in " + this);
        }
        if (p != null && p instanceof MessageProducerImpl) {
            ((MessageProducerImpl)p)._setForJMSBridge();
        }
        return p;
    }

    private synchronized void closeTarget() {
        this._targetConnException = false;
        if (this._targetConn != null) {
            if (this._targetConn instanceof SharedConnection || this._targetConn instanceof PooledConnection) {
                try {
                    this._targetSession.close();
                }
                catch (Throwable t) {
                    this._logger.log(Level.WARNING, "Unable to close target Session in " + this, t);
                }
                finally {
                    try {
                        this._parent.returnConnection(this._targetConn, this._targetCF);
                    }
                    catch (Throwable t) {
                        this._logger.log(Level.WARNING, "Unable to return target connection " + this._targetConn + " in " + this, t);
                    }
                }
            } else {
                try {
                    this._logger.log(Level.INFO, _jbr.getString("BSJ1074", this._targetConn.getClass().getName() + "@" + Integer.toHexString(this._targetConn.hashCode()), this.toString()));
                    this._targetConn.close();
                }
                catch (Throwable t) {
                    this._logger.log(Level.WARNING, "Unable to close target connection " + this._targetConn + " in " + this, t);
                }
            }
            this._targetConn = null;
        }
    }

    private synchronized void closeSource() {
        this._sourceConnException = false;
        if (this._sourceConn != null) {
            if (this._sourceConn instanceof SharedConnection || this._sourceConn instanceof PooledConnection) {
                try {
                    this._sourceSession.close();
                }
                catch (Throwable t) {
                    this._logger.log(Level.WARNING, "Unable to close source Session in " + this, t);
                }
                finally {
                    try {
                        this._parent.returnConnection(this._sourceConn, this._sourceCF);
                    }
                    catch (Throwable t) {
                        this.logWarning("Unable to return source connection " + this._sourceConn + " in " + this, t);
                    }
                }
            } else {
                try {
                    this._logger.log(Level.INFO, _jbr.getString("BSJ1073", this._sourceConn.getClass().getName() + "@" + Integer.toHexString(this._sourceConn.hashCode()), this.toString()));
                    this._sourceConn.close();
                }
                catch (Throwable t) {
                    this.logWarning("Unable to close source connection " + this._sourceConn + " in " + this, t);
                }
            }
            this._sourceConn = null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("link(").append(this.getName()).append(")[");
        sb.append(this.getSourceString());
        sb.append("-->");
        sb.append(this.getTargetString());
        sb.append(']');
        return sb.toString();
    }

    public String getSourceString() {
        if (this._state == LinkState.UNINITIALIZED) {
            return "";
        }
        return ((Refable)this._sourceCF).getRef() + ":" + (this._sourceConnType == null ? "" : this._sourceConnType) + ":" + this.getSourceDestinationName();
    }

    public String getTargetString() {
        if (this._state == LinkState.UNINITIALIZED) {
            return "";
        }
        return ((Refable)this._targetCF).getRef() + ":" + (this._targetConnType == null ? "" : this._targetConnType) + ":" + this.getTargetDestinationName();
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getSourceProviderName() {
        String pn = this._sourceProviderName;
        if (pn != null) {
            return pn;
        }
        return ((Refable)this._sourceCF).getRefed().getClass().getName();
    }

    public String getTargetProviderName() {
        String pn = this._targetProviderName;
        if (pn != null) {
            return pn;
        }
        return ((Refable)this._targetCF).getRefed().getClass().getName();
    }

    public String getSourceDestinationName() {
        if (this._sourceDestName != null) {
            return this._sourceDestName;
        }
        Object dest = this._sourceDest;
        try {
            if (dest instanceof Queue) {
                this._sourceDestName = "queue:" + ((Queue)dest).getQueueName();
                return this._sourceDestName;
            }
            if (dest instanceof Topic) {
                this._sourceDestName = "topic:" + ((Topic)dest).getTopicName();
                return this._sourceDestName;
            }
            this._sourceDestName = dest.toString();
            return this._sourceDestName;
        }
        catch (Throwable t) {
            this._logger.log(Level.WARNING, "Unable to get source destination name in " + this, t);
            this._sourceDestName = dest.toString();
            return this._sourceDestName;
        }
    }

    public String getTargetDestinationName() {
        if (this._targetDestName == null) {
            this._targetDestName = this.toDestinationName(this._targetDest);
        }
        return this._targetDestName;
    }

    private String toDestinationName(Object d) {
        Object dest = d;
        try {
            if (dest instanceof Queue) {
                return "queue:" + ((Queue)dest).getQueueName();
            }
            if (d instanceof Topic) {
                return "topic:" + ((Topic)dest).getTopicName();
            }
            return dest.toString();
        }
        catch (Throwable t) {
            this._logger.log(Level.WARNING, "Unable to get destination from object " + d + " in " + this, t);
            return dest.toString();
        }
    }

    public String getTargetCurrentDestinationName() {
        if (this._targetCurrentDestinationName == null) {
            return this.getTargetDestinationName();
        }
        return this._targetCurrentDestinationName;
    }

    public void setSourceConnectionFactory(Object cf) {
        this._sourceCF = cf;
    }

    public void setTargetConnectionFactory(Object cf) {
        this._targetCF = cf;
    }

    public void setSourceDestination(Object dest) {
        this._sourceDest = dest;
    }

    public void setTargetDestination(Object dest) {
        this._targetDest = dest;
    }

    public Object getSourceDestination() {
        return this._sourceDest;
    }

    public Object getTargetDestination() {
        return this._targetDest;
    }

    public void setLogger(Logger l) {
        this._logger = l;
    }

    @Override
    public void run() {
        try {
            if (this._sourceConn instanceof XAConnection) {
                this._logger.log(Level.INFO, _jbr.getString("BSJ1039", this.toString()));
                this.runTransacted();
            } else {
                this._logger.log(Level.INFO, _jbr.getString("BSJ1040", this.toString()));
                this.runNonTransacted();
            }
        }
        catch (Throwable t) {
            Level l = Level.WARNING;
            if (this._state != LinkState.STOPPING && this._state != LinkState.STOPPED) {
                l = Level.SEVERE;
            }
            if (t instanceof InterruptedException) {
                this._logger.log(l, "Link thread is interrupted in " + this);
            } else {
                this._logger.log(l, "Runtime exception in " + this, t);
            }
        }
        finally {
            this.closeSource();
            this.closeTarget();
        }
        if (this._state != LinkState.STOPPING && this._state != LinkState.STOPPED) {
            try {
                this.stop();
            }
            catch (Throwable t) {
                this._logger.log(Level.WARNING, "Exception in stopping link " + this + ": " + t.getMessage());
            }
        }
        this._logger.log(Level.INFO, _jbr.getString("BSJ1041", this.toString()));
    }

    /*
     * Exception decompiling
     */
    private void runTransacted() throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void logWarning(String msg, Throwable t) {
        if (this._state == LinkState.STOPPING || this._state == LinkState.STOPPED) {
            this._logger.log(Level.WARNING, msg + ": " + t.getMessage());
        } else {
            this._logger.log(Level.WARNING, msg, t);
        }
    }

    private void sendToDMQ(Message m, String mid, DMQ.DMQReason reason, Throwable t) throws Throwable {
        try {
            this._parent.toDMQ(m, mid, reason, t, this);
        }
        catch (Throwable t1) {
            this._logger.log(Level.SEVERE, "Failed to send " + reason + " message " + mid + " to DMQ in " + this, t1);
            throw t1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleExpiredMessage(Message m, String mid, Transaction tx, TransactionManager tm, XAResourceHandle sourceRH) throws Throwable {
        Object[] param = new String[]{mid, sourceRH.toString(), tx.toString(), this.toString()};
        this._logger.log(Level.INFO, _jbr.getString("BSJ1042", param));
        try {
            this.sendToDMQ(m, mid, DMQ.DMQReason.MESSAGE_EXPIRED, null);
        }
        finally {
            try {
                tm.rollback();
            }
            catch (Throwable t1) {
                this._logger.log(Level.WARNING, "Unable to rollback transaction " + tx + " for expired message " + mid + " in " + this, t1);
            }
        }
    }

    private boolean doEnlistAndRollbackOnError(Transaction tx, TransactionManager tm, XAResourceHandle rh) {
        try {
            rh.enlisted = tx.enlistResource(rh.xar);
        }
        catch (RollbackException e) {
            this._logger.log(Level.SEVERE, "The transaction " + tx + " is marked rollback only by " + rh + " in " + this, e);
            try {
                tm.rollback();
            }
            catch (Throwable t) {
                this._logger.log(Level.SEVERE, "Exception in rollback transacion " + tx + " after enlist returned rollback-only in " + this, t);
            }
            rh.ex = new RuntimeException("The transaction " + tx + " is marked rollback only by " + rh + " in " + this, e);
            return false;
        }
        catch (Throwable t) {
            this._logger.log(Level.SEVERE, "Exception to enlist " + rh + " to transaction " + tx + " in " + this, t);
            try {
                tm.rollback();
            }
            catch (Throwable t1) {
                this._logger.log(Level.SEVERE, "Exception in rollback transacion " + tx + " after enlist " + rh + " failure in " + this, t1);
            }
            rh.ex = new RuntimeException("Exception to enlist " + rh + " to transaction " + tx + " in " + this, t);
            return false;
        }
        if (!rh.enlisted) {
            this._logger.log(Level.SEVERE, rh + " was not enlisted to transaction " + tx + " successfully in " + this);
            try {
                tm.rollback();
            }
            catch (Throwable t) {
                this._logger.log(Level.SEVERE, "Exception in rollback transacion " + tx + " after enlist " + rh + " failure in " + this, t);
            }
            rh.ex = new RuntimeException(rh + " was not enlisted to transaction " + tx + " successfully in " + this);
            return false;
        }
        return true;
    }

    private boolean doDelistAndRollbackOnError(Transaction tx, TransactionManager tm, XAResourceHandle rh) {
        try {
            rh.delisted = tx.delistResource(rh.xar, 0x4000000);
        }
        catch (Throwable t) {
            this._logger.log(Level.WARNING, "Unable delist " + rh + " from transaction " + tx + " in " + this, t);
            try {
                tm.rollback();
            }
            catch (Throwable t1) {
                this._logger.log(Level.WARNING, "Unable to rollback transaction " + tx + " after delist " + rh + " failure in " + this, t1);
            }
            rh.ex = new RuntimeException("Unable delist " + rh + " from transaction " + tx + " in " + this, t);
            return false;
        }
        if (!rh.delisted) {
            this._logger.log(Level.SEVERE, rh + " was not delisted from transaction " + tx + " successfully in " + this);
            try {
                tm.rollback();
            }
            catch (Exception e) {
                this._logger.log(Level.SEVERE, "Exception in rollback transacion " + tx + " in " + this, e);
            }
            rh.ex = new RuntimeException(rh + " was not delisted from transaction " + tx + " successfully in " + this);
            return false;
        }
        return true;
    }

    private void doFinally(Transaction tx, TransactionManager tm, XAResourceHandle sourceRH, XAResourceHandle targetRH) {
        if (tx != null) {
            int status = 0;
            try {
                status = tx.getStatus();
            }
            catch (Throwable t) {
                this._logger.log(Level.WARNING, "Unable to get transaction " + tx + " status in " + this, t);
            }
            if (status != 6) {
                if (sourceRH.enlisted && !sourceRH.delisted) {
                    try {
                        tx.delistResource(sourceRH.xar, 0x20000000);
                    }
                    catch (Throwable t) {
                        this._logger.log(Level.WARNING, "Unable to delist " + sourceRH + " in transaction " + tx + " " + this + ": " + t.getMessage());
                    }
                }
                if (targetRH != null && targetRH.xar != sourceRH.xar && targetRH.enlisted && !targetRH.delisted) {
                    try {
                        tx.delistResource(targetRH.xar, 0x20000000);
                    }
                    catch (Throwable t) {
                        this._logger.log(Level.WARNING, "Unable to delist " + targetRH + " in transaction " + tx + " " + this + ": " + t.getMessage());
                    }
                }
                this._sourceConnException = true;
                this._targetConnException = true;
            }
            try {
                status = tx.getStatus();
            }
            catch (Throwable t) {
                this._logger.log(Level.WARNING, "Unable to get transaction " + tx + " status in " + this, t);
            }
            if (status != 6 && status != 3 && status != 8 && status != 4 && status != 9 && status != 5 && status != 1) {
                this._logger.log(Level.WARNING, "Rolling back transaction (status=" + status + ")" + tx + " in " + this);
                try {
                    tm.rollback();
                }
                catch (Throwable t) {
                    this._logger.log(Level.WARNING, "Exception to rollback transaction " + tx + " in " + this, t);
                }
            }
        }
        if (!this._targetStayConnected) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "Close target in " + this);
            }
            this.closeTarget();
        }
    }

    private boolean isTransactionActive(Transaction tx, TransactionManager tm) {
        boolean rollback = false;
        int status = 0;
        try {
            status = tx.getStatus();
        }
        catch (Throwable t) {
            this._logger.log(Level.SEVERE, "Unable to get transaction " + tx + " status in " + this, t);
            rollback = true;
        }
        if (!rollback) {
            switch (status) {
                case 0: {
                    return true;
                }
                case 3: {
                    this._logger.log(Level.WARNING, "Unexpected STATUS_COMMITTED for transaction " + tx + " in " + this);
                    return false;
                }
                case 8: {
                    this._logger.log(Level.WARNING, "Unexpected STATUS_COMMITTED for transaction " + tx + " in " + this);
                    return false;
                }
                case 1: {
                    this._logger.log(Level.WARNING, "Transaction " + tx + " marked rollback, rolling back ... in " + this);
                    rollback = true;
                    break;
                }
                case 6: {
                    this._logger.log(Level.WARNING, "Transaction " + tx + " has STATUS_NO_TRANSACTION");
                    return false;
                }
                case 2: {
                    this._logger.log(Level.WARNING, "Unexpected STATUS_PREPARED for transaction " + tx + ", rolling back ... in " + this);
                    rollback = true;
                    break;
                }
                case 7: {
                    this._logger.log(Level.WARNING, "Unexpected STATUS_PREPARING for transaction " + tx + ", set rollback only ... in " + this);
                    try {
                        tx.setRollbackOnly();
                    }
                    catch (Throwable t) {
                        this._logger.log(Level.WARNING, "Unable to set transaction " + tx + " rollback only in " + this);
                    }
                    rollback = true;
                }
                case 4: {
                    this._logger.log(Level.WARNING, "Transaction " + tx + " has STATUS_ROLLEDBACK in " + this);
                    return false;
                }
                case 9: {
                    this._logger.log(Level.WARNING, "Transaction " + tx + " has STATUS_ROLLING_BACK in " + this);
                    return false;
                }
                case 5: {
                    this._logger.log(Level.WARNING, "Unexpected STATUS_UNKNOWN for transaction " + tx + ", rolling back ... in " + this);
                    rollback = true;
                    break;
                }
                default: {
                    this._logger.log(Level.WARNING, "Unexpected status " + status + " for transaction " + tx + ", rolling back ... in " + this);
                    rollback = true;
                }
            }
        }
        try {
            tm.rollback();
        }
        catch (Throwable t) {
            this._logger.log(Level.WARNING, "Exception in rollback transacion " + tx + " in " + this, t);
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private void runNonTransacted() throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message handleMessageTransformer(Message m, MessageHeaders srcmhs) throws Throwable {
        Message msgToSend = m;
        String mid = srcmhs.mid;
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "Retain JMSReplyTo " + this._retainReplyTo + " for message " + mid + " in " + this);
        }
        if (!this._retainReplyTo) {
            try {
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.FINE, "Setting JMSReplyTo null for message " + mid + " in " + this);
                }
                msgToSend.setJMSReplyTo((Destination)null);
            }
            catch (Throwable t) {
                this._logger.log(Level.WARNING, "setJMSReplyTo(null) failed: " + t.getMessage() + " in " + this, t);
            }
        }
        boolean transformed = false;
        Destination asSourceDest = m.getJMSDestination();
        if (this._msgTransformer != null) {
            this._msgTransformer.init(this._targetSession, "JMS");
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "Transforming message " + mid + " using " + this._msgTransformer.getClass().getName() + " in " + this);
            }
            try {
                try {
                    msgToSend = this._msgTransformer.transform(m, true, null, this.getSourceProviderName(), this.getTargetProviderName(), this._msgTransformerProps);
                    transformed = true;
                    if (msgToSend == null) {
                        throw new BridgeException(_jbr.getKString("BSJ4034", this._msgTransformer.getClass().getName() + ".transform()", mid));
                    }
                }
                finally {
                    MessageHeaders.resetMessageHeaders(m, srcmhs);
                }
                if (this._fi.FAULT_INJECTION) {
                    this._fi.setLogger(this._logger);
                    this._fi.checkFaultAndThrowException("transform.2", null, "jakarta.jms.JMSException", true);
                }
                if (this._msgTransformer.isNoTransfer()) {
                    Object[] param = new String[]{"MessageTransformer.transform()", mid, this.toString()};
                    this._logger.log(Level.INFO, _jbr.getString("BSJ1065", param));
                    if (this._firstTransformerNoTransfer) {
                        this.sendToDMQ(m, mid, DMQ.DMQReason.FIRST_TRANSFORMER_NOTRANSFER, null);
                        this._firstTransformerNoTransfer = false;
                    }
                    return null;
                }
            }
            catch (Throwable t) {
                if (this._consumeOnTransformError && (!transformed || msgToSend == null)) {
                    this._logger.log(Level.WARNING, "Exception from message transformer: " + t.getMessage() + " for message " + m + " in " + this, t);
                    this.sendToDMQ(m, mid, DMQ.DMQReason.TRANSFORMER_FAILURE, t);
                    return null;
                }
                throw t;
            }
            if (this._logger.isLoggable(Level.FINE)) {
                StringBuilder buf = new StringBuilder();
                buf.append("Transformed message " + mid);
                try {
                    buf.append(" to " + msgToSend + " in " + this);
                }
                catch (Throwable t) {
                    buf.append(" in " + this);
                }
                this._logger.log(Level.FINE, buf.toString());
            }
        }
        this.handleBranchTo(m, mid, transformed, asSourceDest);
        return msgToSend;
    }

    private void handleBranchTo(Message oldm, String mid, boolean transformed, Destination asSourceDest) throws Throwable {
        this._branchProducer = null;
        if (!transformed) {
            if (this._unidentifiedProducer) {
                this._targetCurrentDestinationName = this.toDestinationName(asSourceDest);
                this._branchProducer = this.createProducer(asSourceDest, mid, false);
                Object[] param = new String[]{mid, "Message.getJMSDestination:" + this.getTargetCurrentDestinationName(), this.toString()};
                this._logger.log(Level.INFO, _jbr.getString("BSJ1066", param));
            }
            return;
        }
        Object d = this._msgTransformer.getBranchTo();
        if (d == null) {
            if (this._unidentifiedProducer) {
                this._targetCurrentDestinationName = this.toDestinationName(asSourceDest);
                this._branchProducer = this.createProducer(asSourceDest, mid, false);
                Object[] param = new String[]{mid, "Message.getJMSDestination:" + this.getTargetCurrentDestinationName(), this.toString()};
                this._logger.log(Level.INFO, _jbr.getString("BSJ1067", param));
            }
            return;
        }
        this._branchProducer = this.createProducer(d, mid, true);
        this._targetCurrentDestinationName = this.toDestinationName(this._branchProducer.getDestination());
        Object[] param = new String[]{mid, (String)(d instanceof String ? "[destination-ref:" + d + "]" : "") + this.getTargetCurrentDestinationName(), this.toString()};
        this._logger.log(Level.INFO, _jbr.getString("BSJ1069", param));
        if (this._firstTransformerBranchTo) {
            this.sendToDMQ(oldm, mid, DMQ.DMQReason.FIRST_TRANSFORMER_BRANCHTO, null);
            this._firstTransformerBranchTo = false;
        }
    }

    public LinkState getState() {
        return this._state;
    }

    static class XAResourceHandle {
        XAResource xar = null;
        boolean enlisted = false;
        boolean delisted = true;
        boolean istarget = false;
        RuntimeException ex = null;

        public XAResourceHandle(boolean target) {
            this.istarget = target;
        }

        public String toString() {
            return "[" + (this.istarget ? _jbr.getString("BSJ0002") : _jbr.getString("BSJ0001")) + "]" + this.xar;
        }
    }

    public static enum LinkState {
        UNINITIALIZED{

            @Override
            public String toString(ResourceBundle rb) {
                return rb.getString("BS1500");
            }
        }
        ,
        STARTING{

            @Override
            public String toString(ResourceBundle rb) {
                return rb.getString("BS1501");
            }
        }
        ,
        STARTED{

            @Override
            public String toString(ResourceBundle rb) {
                return rb.getString("BS1502");
            }
        }
        ,
        STOPPING{

            @Override
            public String toString(ResourceBundle rb) {
                return rb.getString("BS1503");
            }
        }
        ,
        STOPPED{

            @Override
            public String toString(ResourceBundle rb) {
                return rb.getString("BS1504");
            }
        }
        ,
        PAUSING{

            @Override
            public String toString(ResourceBundle rb) {
                return rb.getString("BS1505");
            }
        }
        ,
        PAUSED{

            @Override
            public String toString(ResourceBundle rb) {
                return rb.getString("BS1506");
            }
        };


        public abstract String toString(ResourceBundle var1);

        public String toString() {
            return this.toString(_jbr);
        }
    }
}

