/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.ejbqlc;

import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.collections.AST;
import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.EJBQLAST;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.EJBQLASTFactory;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.EJBQLException;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.EJBQLLexer;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.EJBQLParser;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.ErrorMsg;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.JDOQLCodeGeneration;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.JDOQLElements;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.LogHelperQueryCompilerEJB;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.ParameterSupport;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.Semantic;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.TypeSupport;
import com.sun.jdo.spi.persistence.support.ejb.model.util.NameMapper;
import com.sun.jdo.spi.persistence.utility.generator.JavaClassWriterHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import org.glassfish.persistence.common.I18NHelper;

public class EJBQLC {
    protected Model model;
    protected NameMapper nameMapper;
    protected EJBQLAST ast;
    private static Logger logger = LogHelperQueryCompilerEJB.getLogger();
    protected static final ResourceBundle msgs = I18NHelper.loadBundle(EJBQLC.class);
    public static final String SIGNATURE = "$RCSfile: EJBQLC.java,v $ $Revision: 1.3 $";

    public EJBQLC(Model model, NameMapper nameMapper) {
        this.model = model;
        this.nameMapper = nameMapper;
    }

    public JDOQLElements compile(String ejbqlQuery, Method method, int resultTypeMapping, boolean finderNotSelector, String ejbName) throws EJBQLException {
        boolean finer = logger.isLoggable(400);
        boolean finest = logger.isLoggable(300);
        if (method == null) {
            ErrorMsg.fatal(I18NHelper.getMessage((ResourceBundle)msgs, (String)"ERR_MissingMethodInstance"));
        }
        if (ejbqlQuery == null || ejbqlQuery.trim().length() == 0) {
            ErrorMsg.error(I18NHelper.getMessage((ResourceBundle)msgs, (String)"EXC_MissingEjbqlQueryText", (String)ejbName, (String)this.getMethodSignature(method)));
        }
        if (finer) {
            logger.finer("LOG_EJBQLCCompile", (Object)ejbName, (Object)this.getMethodSignature(method), (Object)ejbqlQuery);
        }
        JDOQLElements result = null;
        TypeSupport typeSupport = new TypeSupport(this.model, this.nameMapper);
        ParameterSupport paramSupport = new ParameterSupport(method);
        String pass = null;
        try {
            pass = "syntax analysis";
            if (finer) {
                logger.finer("LOG_EJBQLCStartPass", (Object)pass);
            }
            EJBQLParser parser = this.createStringParser(ejbqlQuery);
            parser.query();
            this.ast = (EJBQLAST)parser.getAST();
            if (finest) {
                logger.finest("LOG_EJBQLCDumpTree", (Object)this.ast.getTreeRepr("(AST)"));
            }
            pass = "semantic analysis";
            if (finer) {
                logger.finer("LOG_EJBQLCStartPass", (Object)pass);
            }
            Semantic semantic = new Semantic();
            semantic.init(typeSupport, paramSupport, method, resultTypeMapping, finderNotSelector, ejbName);
            semantic.setASTFactory(EJBQLASTFactory.getInstance());
            semantic.query((AST)this.ast);
            this.ast = (EJBQLAST)semantic.getAST();
            if (finest) {
                logger.finest("LOG_EJBQLCDumpTree", (Object)this.ast.getTreeRepr("(typed AST)"));
            }
            pass = "code generation";
            if (finer) {
                logger.finer("LOG_EJBQLCStartPass", (Object)pass);
            }
            JDOQLCodeGeneration codeGen = new JDOQLCodeGeneration();
            codeGen.init(typeSupport, paramSupport);
            codeGen.setASTFactory(EJBQLASTFactory.getInstance());
            codeGen.query((AST)this.ast);
            result = codeGen.getJDOQLElements();
            if (finer) {
                logger.finer("LOG_EJBQLCResult", (Object)result.toString());
            }
        }
        catch (EJBQLException ex) {
            Object[] msgArgs = new Object[]{ejbName, this.getMethodSignature(method), ejbqlQuery, ex.getMessage()};
            ErrorMsg.error(I18NHelper.getMessage((ResourceBundle)msgs, (String)"EXC_InvalidEJBQLQuery", (Object[])msgArgs));
        }
        catch (Throwable t) {
            Object[] msgArgs = new Object[]{ejbName, this.getMethodSignature(method), ejbqlQuery, t.toString()};
            ErrorMsg.log(1000, I18NHelper.getMessage((ResourceBundle)msgs, (String)"EXC_EJBQLQueryInternalError", (Object[])msgArgs), t);
        }
        return result;
    }

    private EJBQLParser createStringParser(String text) {
        StringReader in = new StringReader(text);
        EJBQLLexer lexer = new EJBQLLexer(in);
        TokenBuffer buffer = new TokenBuffer((TokenStream)lexer);
        EJBQLParser parser = new EJBQLParser(buffer);
        parser.setASTFactory(EJBQLASTFactory.getInstance());
        return parser;
    }

    private String getMethodSignature(Method m) {
        if (m == null) {
            return "";
        }
        return m.getReturnType().getName() + " " + m.getName() + "(" + JavaClassWriterHelper.getParameterTypesList((Method)m) + ")";
    }
}

