/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.core;

import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.mvc.Models;
import jakarta.mvc.MvcContext;
import jakarta.mvc.engine.ViewEngine;
import jakarta.mvc.engine.ViewEngineContext;
import jakarta.mvc.engine.ViewEngineException;
import jakarta.mvc.event.MvcEvent;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.ServerErrorException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import org.eclipse.krazo.core.Messages;
import org.eclipse.krazo.engine.ViewEngineContextImpl;
import org.eclipse.krazo.engine.ViewEngineFinder;
import org.eclipse.krazo.engine.Viewable;
import org.eclipse.krazo.lifecycle.EventDispatcher;
import org.eclipse.krazo.util.HttpUtil;

@Produces(value={"*/*"})
public class ViewableWriter
implements MessageBodyWriter<Viewable> {
    @Inject
    private Instance<Models> modelsInstance;
    @Context
    private HttpServletRequest injectedRequest;
    @Context
    private HttpServletResponse injectedResponse;
    @Context
    private UriInfo uriInfo;
    @Context
    private ResourceInfo resourceInfo;
    @Inject
    private ViewEngineFinder engineFinder;
    @Context
    private Configuration config;
    @Inject
    private Messages messages;
    @Inject
    private Event<MvcEvent> dispatcher;
    @Inject
    private MvcContext mvc;
    @Inject
    private EventDispatcher eventDispatcher;

    public boolean isWriteable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return aClass == Viewable.class;
    }

    public long getSize(Viewable viewable, Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(Viewable viewable, Class<?> aClass, Type type, Annotation[] annotations, MediaType resolvedMediaType, MultivaluedMap<String, Object> headers, OutputStream out) throws IOException, WebApplicationException {
        ViewEngine engine = this.engineFinder.find(viewable);
        if (engine == null) {
            throw new ServerErrorException(this.messages.get("NoViewEngine", viewable), Response.Status.INTERNAL_SERVER_ERROR);
        }
        MediaType mediaType = ViewableWriter.buildMediaTypeWithCharset(resolvedMediaType);
        headers.putSingle((Object)"Content-Type", (Object)mediaType);
        HttpServletRequest request = HttpUtil.unwrapOriginalRequest(this.injectedRequest);
        HttpServletResponse response = HttpUtil.unwrapOriginalResponse(this.injectedResponse);
        DelegatingServletOutputStream responseStream = new DelegatingServletOutputStream(out);
        MvcHttpServletResponse responseWrapper = new MvcHttpServletResponse(response, responseStream, mediaType, headers);
        try {
            Models models = viewable.getModels();
            if (models == null) {
                models = (Models)this.modelsInstance.get();
            }
            models.put("mvc", (Object)this.mvc);
            this.eventDispatcher.fireBeforeProcessViewEvent(engine, viewable);
            try {
                engine.processView((ViewEngineContext)new ViewEngineContextImpl(viewable.getView(), models, request, (Object)responseWrapper, headers, (OutputStream)((Object)responseStream), mediaType, this.uriInfo, this.resourceInfo, this.config, this.mvc.getLocale()));
            }
            finally {
                this.eventDispatcher.fireAfterProcessViewEvent(engine, viewable);
            }
        }
        catch (ViewEngineException e) {
            throw new ServerErrorException(Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        finally {
            responseWrapper.getWriter().flush();
        }
    }

    private static MediaType buildMediaTypeWithCharset(MediaType mediaType) {
        if (mediaType != null) {
            return mediaType.getParameters().get("charset") == null ? mediaType.withCharset(StandardCharsets.UTF_8.name()) : mediaType;
        }
        return MediaType.TEXT_HTML_TYPE.withCharset(StandardCharsets.UTF_8.name());
    }

    private static class DelegatingServletOutputStream
    extends ServletOutputStream {
        private final OutputStream out;

        public DelegatingServletOutputStream(OutputStream out) {
            this.out = out;
        }

        public void write(int b) throws IOException {
            this.out.write(b);
        }

        public boolean isReady() {
            return false;
        }

        public void setWriteListener(WriteListener writeListener) {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    private static class MvcHttpServletResponse
    extends HttpServletResponseWrapper {
        private final ServletOutputStream responseStream;
        private final MultivaluedMap<String, Object> responseHeaders;
        private PrintWriter responseWriter;

        public MvcHttpServletResponse(HttpServletResponse response, ServletOutputStream responseStream, MediaType mediaType, MultivaluedMap<String, Object> responseHeaders) {
            super(response);
            this.responseStream = responseStream;
            this.responseHeaders = responseHeaders;
            super.setContentType(mediaType.toString());
        }

        public ServletOutputStream getOutputStream() {
            if (this.responseWriter != null) {
                throw new IllegalStateException("Calling getOutputStream() after getWriter() is not allowed. ");
            }
            return this.responseStream;
        }

        public void setContentType(String type) {
            super.setContentType(type);
            String charset = (String)MediaType.valueOf((String)type).getParameters().get("charset");
            if (charset != null) {
                this.syncCharsetToHeaderMap(charset);
            }
        }

        public void setCharacterEncoding(String charset) {
            super.setCharacterEncoding(charset);
            this.syncCharsetToHeaderMap(charset);
        }

        private void syncCharsetToHeaderMap(String charset) {
            MediaType mediaType = (MediaType)this.responseHeaders.getFirst((Object)"Content-Type");
            if (mediaType == null) {
                mediaType = MediaType.TEXT_HTML_TYPE;
            }
            this.responseHeaders.putSingle((Object)"Content-Type", (Object)mediaType.withCharset(charset));
        }

        public PrintWriter getWriter() throws IOException {
            if (this.responseWriter == null) {
                String characterEncoding = this.getCharacterEncoding();
                this.responseWriter = new PrintWriter(new OutputStreamWriter((OutputStream)this.responseStream, characterEncoding));
            }
            return this.responseWriter;
        }
    }
}

