/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo;

import jakarta.inject.Inject;
import jakarta.mvc.security.Csrf;
import jakarta.ws.rs.core.Configuration;
import org.eclipse.krazo.jaxrs.JaxRsContext;
import org.eclipse.krazo.security.CsrfTokenStrategy;
import org.eclipse.krazo.security.SessionCsrfTokenStrategy;

public class KrazoConfig {
    @Inject
    @JaxRsContext
    private Configuration config;

    public Csrf.CsrfOptions getCsrfOptions() {
        Object value = this.config.getProperty("jakarta.mvc.security.CsrfProtection");
        if (value instanceof Csrf.CsrfOptions) {
            return (Csrf.CsrfOptions)value;
        }
        return Csrf.CsrfOptions.EXPLICIT;
    }

    public CsrfTokenStrategy getCsrfTokenStrategy() {
        Object value = this.config.getProperty("org.eclipse.krazo.csrfTokenStrategy");
        if (value instanceof CsrfTokenStrategy) {
            return (CsrfTokenStrategy)value;
        }
        return new SessionCsrfTokenStrategy.Builder().headerName(this.getCsrfHeaderName()).build();
    }

    public String getDefaultViewFileExtension() {
        Object value = this.config.getProperty("org.eclipse.krazo.defaultViewFileExtension");
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public String getCsrfHeaderName() {
        Object value = this.config.getProperty("jakarta.mvc.security.CsrfHeaderName");
        if (value != null) {
            return value.toString();
        }
        return "X-CSRF-TOKEN";
    }

    public String getRedirectScopeCookieName() {
        Object value = this.config.getProperty("org.eclipse.krazo.redirectScopeCookieName");
        if (value instanceof String) {
            return (String)value;
        }
        return "org.eclipse.krazo.redirect.Cookie";
    }

    public String getRedirectScopeAttributeName() {
        Object value = this.config.getProperty("org.eclipse.krazo.redirectScopeQueryParamName");
        if (value instanceof String) {
            return (String)value;
        }
        return "org.eclipse.krazo.redirect.param.ScopeId";
    }

    public boolean isHiddenMethodFilterActive() {
        Object value = this.config.getProperty("org.eclipse.krazo.hiddenMethodFilterActive");
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }
}

