/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.tree;

import java.util.Hashtable;
import org.glassfish.rmic.tools.asm.Assembler;
import org.glassfish.rmic.tools.asm.Label;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.java.Type;
import org.glassfish.rmic.tools.tree.BinaryExpression;
import org.glassfish.rmic.tools.tree.BooleanExpression;
import org.glassfish.rmic.tools.tree.ConditionVars;
import org.glassfish.rmic.tools.tree.Context;
import org.glassfish.rmic.tools.tree.EqualExpression;
import org.glassfish.rmic.tools.tree.Expression;
import org.glassfish.rmic.tools.tree.GreaterExpression;
import org.glassfish.rmic.tools.tree.GreaterOrEqualExpression;
import org.glassfish.rmic.tools.tree.LessExpression;
import org.glassfish.rmic.tools.tree.LessOrEqualExpression;
import org.glassfish.rmic.tools.tree.NotEqualExpression;
import org.glassfish.rmic.tools.tree.UnaryExpression;
import org.glassfish.rmic.tools.tree.Vset;

public class NotExpression
extends UnaryExpression {
    public NotExpression(long where, Expression right) {
        super(37, where, Type.tBoolean, right);
    }

    @Override
    void selectType(Environment env, Context ctx, int tm) {
        this.right = this.convert(env, ctx, Type.tBoolean, this.right);
    }

    @Override
    public void checkCondition(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp, ConditionVars cvars) {
        this.right.checkCondition(env, ctx, vset, exp, cvars);
        this.right = this.convert(env, ctx, Type.tBoolean, this.right);
        Vset temp = cvars.vsFalse;
        cvars.vsFalse = cvars.vsTrue;
        cvars.vsTrue = temp;
    }

    @Override
    Expression eval(boolean a) {
        return new BooleanExpression(this.where, !a);
    }

    @Override
    Expression simplify() {
        switch (this.right.op) {
            case 37: {
                return ((NotExpression)this.right).right;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            default: {
                return this;
            }
        }
        BinaryExpression bin = (BinaryExpression)this.right;
        if (bin.left.type.inMask(192)) {
            return this;
        }
        switch (this.right.op) {
            case 20: {
                return new NotEqualExpression(this.where, bin.left, bin.right);
            }
            case 19: {
                return new EqualExpression(this.where, bin.left, bin.right);
            }
            case 24: {
                return new GreaterOrEqualExpression(this.where, bin.left, bin.right);
            }
            case 23: {
                return new GreaterExpression(this.where, bin.left, bin.right);
            }
            case 22: {
                return new LessOrEqualExpression(this.where, bin.left, bin.right);
            }
            case 21: {
                return new LessExpression(this.where, bin.left, bin.right);
            }
        }
        return this;
    }

    @Override
    void codeBranch(Environment env, Context ctx, Assembler asm, Label lbl, boolean whenTrue) {
        this.right.codeBranch(env, ctx, asm, lbl, !whenTrue);
    }

    @Override
    public void codeValue(Environment env, Context ctx, Assembler asm) {
        this.right.codeValue(env, ctx, asm);
        asm.add(this.where, 18, 1);
        asm.add(this.where, 130);
    }
}

