/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.common;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;

public class ClassPathUtils {
    private static final Function<Path, URL> TO_URL = p -> {
        try {
            return p.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Could not convert path to url: " + p, e);
        }
    };
    private static final Function<Path, Path> TO_REAL_PATH = p -> {
        try {
            return p.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not resolve real path of: " + p, e);
        }
    };

    public static String getMainClass(File clientJarFile) {
        String string;
        JarFile jarFile = new JarFile(clientJarFile);
        try {
            Manifest manifest = jarFile.getManifest();
            Attributes mainAttributes = manifest.getMainAttributes();
            string = mainAttributes.getValue("Main-Class");
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not detect the main class from the manifest of " + clientJarFile, e);
            }
        }
        jarFile.close();
        return string;
    }

    public static URL[] getJavaClassPathForAppClient() {
        Path gfClientJar = TO_REAL_PATH.apply(ClassPathUtils.getGFClientJarPath());
        List<Path> paths = ClassPathUtils.convertClassPathToPaths(System.getProperty("java.class.path"));
        ArrayList<URL> result = new ArrayList<URL>();
        for (Path path : paths) {
            if (TO_REAL_PATH.apply(path).equals(gfClientJar)) continue;
            result.add(TO_URL.apply(path));
        }
        result.addAll(ClassPathUtils.convertClassPathToURLs(System.getenv("APPCPATH")));
        return result.toArray(new URL[result.size()]);
    }

    public static URL getGFClientJarURL() {
        return TO_URL.apply(ClassPathUtils.getGFClientJarPath());
    }

    public static Path getGFClientJarPath() {
        try {
            Class<?> clazz = Class.forName("org.glassfish.appclient.client.acc.agent.AppClientContainerAgent");
            CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
            if (codeSource == null || codeSource.getLocation() == null) {
                throw new IllegalStateException("Unable to detect the gf-client.jar location, because the getCodeSource() or getLocation() method returned null. That can happen ie. when you use the boot classloader or a classloader which doesn't use locations.");
            }
            return Path.of(codeSource.getLocation().toURI());
        }
        catch (ClassNotFoundException | URISyntaxException e) {
            throw new IllegalStateException("Could not detect the GlassFish lib directory.", e);
        }
    }

    public static List<URL> convertClassPathToURLs(String classPath) {
        return ClassPathUtils.convertClassPathToPaths(classPath).stream().map(TO_URL).collect(Collectors.toList());
    }

    public static List<Path> convertClassPathToPaths(String classPath) {
        if (classPath == null || classPath.isBlank()) {
            return Collections.emptyList();
        }
        ArrayList<Path> result = new ArrayList<Path>();
        try {
            for (String classPathElement : classPath.split(File.pathSeparator)) {
                result.add(new File(classPathElement).toPath());
            }
            return result;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not parse the classpath: " + classPath, e);
        }
    }

    public static String convertToString(URL url) {
        try {
            return Path.of(url.toURI()).toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Cannot convert to URI string: " + url, e);
        }
    }
}

