/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.ComplexComponent;
import com.sun.webui.jsf.component.Field;
import com.sun.webui.jsf.component.Icon;
import com.sun.webui.jsf.component.TextArea;
import com.sun.webui.jsf.component.Upload;
import com.sun.webui.jsf.renderkit.html.HiddenFieldRenderer;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.MessageUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.render.Renderer;
import java.io.IOException;

public class FieldRenderer
extends Renderer {
    public static final String[] STRING_ATTRIBUTES = new String[]{"onBlur", "onChange", "onClick", "onDblClick", "onFocus", "onMouseDown", "onMouseUp", "onMouseOver", "onMouseMove", "onMouseOut", "onKeyDown", "onKeyPress", "onKeyUp", "onSelect"};
    public static final String SPACER_ID = "_spacer";
    private static final boolean DEBUG = false;

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!(component instanceof Field)) {
            Object[] params = new Object[]{component.toString(), ((Object)((Object)this)).getClass().getName(), Field.class.getName()};
            String message = MessageUtil.getMessage("com.sun.webui.jsf.resources.LogMessages", "Renderer.component", params);
            throw new FacesException(message);
        }
        this.renderField(context, (Field)component, "text", this.getStyles(context));
    }

    public boolean renderField(FacesContext context, Field component, String type, String[] styles) throws IOException {
        String id = component.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        UIComponent label = component.getLabelComponent(context, styles[3]);
        boolean spanRendered = false;
        if (label != null) {
            this.renderOpeningSpan(component, id, styles[2], writer);
            spanRendered = true;
            writer.writeText((Object)"\n", null);
            RenderingUtilities.renderComponent(label, context);
            writer.writeText((Object)"\n", null);
            Theme theme = ThemeUtilities.getTheme(context);
            Icon icon = ThemeUtilities.getIcon(theme, "DOT");
            icon.setId(component.getId().concat(SPACER_ID));
            icon.setHeight(1);
            icon.setWidth(10);
            RenderingUtilities.renderComponent((UIComponent)icon, context);
            writer.writeText((Object)"\n", null);
            id = component instanceof Upload ? ((Upload)component).getLabeledElementId(context) : (component instanceof ComplexComponent ? component.getLabeledElementId(context) : component.getClientId(context));
        }
        if (component.isReadOnly()) {
            UIComponent text = component.getReadOnlyComponent(context);
            if (label == null) {
                text.getAttributes().put("style", component.getStyle());
                text.getAttributes().put("styleClass", component.getStyleClass());
            }
            RenderingUtilities.renderComponent(text, context);
        } else {
            this.renderInput(component, type, id, label == null, styles, context, writer);
        }
        if (label != null) {
            writer.writeText((Object)"\n", null);
            writer.endElement("span");
        }
        return spanRendered;
    }

    protected void renderInput(Field component, String type, String id, boolean renderUserStyles, String[] styles, FacesContext context, ResponseWriter writer) throws IOException {
        int tabIndex;
        String toolTip;
        int maxlength;
        if (component instanceof TextArea) {
            int columns;
            writer.startElement("textarea", (UIComponent)component);
            int rows = ((TextArea)component).getRows();
            if (rows > 0) {
                writer.writeAttribute("rows", (Object)String.valueOf(rows), "rows");
            }
            if ((columns = component.getColumns()) > 0) {
                writer.writeAttribute("cols", (Object)String.valueOf(columns), "columns");
            }
        } else {
            writer.startElement("input", (UIComponent)component);
            writer.writeAttribute("type", (Object)type, null);
            int columns = component.getColumns();
            if (columns > 0) {
                writer.writeAttribute("size", (Object)String.valueOf(columns), "columns");
            }
        }
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        if (component.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if ((maxlength = component.getMaxLength()) > 0) {
            writer.writeAttribute("maxlength", (Object)String.valueOf(maxlength), "maxLength");
        }
        if ((toolTip = component.getToolTip()) != null && toolTip.length() > 0) {
            writer.writeAttribute("title", (Object)toolTip, "toolTip");
        }
        if ((tabIndex = component.getTabIndex()) > 0) {
            writer.writeAttribute("tabindex", (Object)String.valueOf(tabIndex), "tabIndex");
        }
        RenderingUtilities.writeStringAttributes((UIComponent)component, writer, STRING_ATTRIBUTES);
        String styleClass = component.isDisabled() ? styles[1] : styles[0];
        String style = null;
        if (renderUserStyles) {
            String compStyleClass = this.getStyleClass(component, styles[2]);
            if (compStyleClass != null) {
                styleClass = compStyleClass + " " + styleClass;
            }
            if ((style = component.getStyle()) != null && style.length() == 0) {
                style = null;
            }
        }
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (component.getSubmittedValue() == null) {
            ConversionUtilities.setRenderedValue((UIComponent)component, component.getValue());
        }
        String value = component.getValueAsString(context);
        if (component instanceof TextArea) {
            writer.writeText((Object)value, "value");
            writer.endElement("textarea");
        } else {
            if (value != null) {
                writer.writeAttribute("value", (Object)value, "value");
            }
            writer.endElement("input");
        }
    }

    protected String getStyleClass(Field component, String hiddenStyle) {
        String style = component.getStyleClass();
        if (style != null && style.length() == 0) {
            style = null;
        }
        if (!component.isVisible()) {
            style = style == null ? hiddenStyle : style + " " + hiddenStyle;
        }
        return style;
    }

    public void decode(FacesContext context, UIComponent component) {
        HiddenFieldRenderer.decodeInput(context, component);
    }

    public void encodeChildren(FacesContext context, UIComponent component) {
    }

    public void encodeBegin(FacesContext context, UIComponent component) {
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected String[] getStyles(FacesContext context) {
        Theme theme = ThemeUtilities.getTheme(context);
        String[] styles = new String[]{theme.getStyleClass("TEXT_FIELD"), theme.getStyleClass("TEXT_FIELD_DISABLED"), theme.getStyleClass("HIDDEN"), ""};
        return styles;
    }

    private void renderOpeningSpan(Field component, String id, String hiddenStyle, ResponseWriter writer) throws IOException {
        writer.startElement("span", (UIComponent)component);
        writer.writeAttribute("id", (Object)id, "id");
        String style = component.getStyle();
        if (style != null && style.length() > 0) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if ((style = this.getStyleClass(component, hiddenStyle)) != null) {
            writer.writeAttribute("class", (Object)style, "class");
        }
    }
}

